/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp;

import com.kingdee.bos.ctrl.kdf.util.render.icon.Icon;
import java.awt.Graphics;

public class TreeIcon
implements Icon {
    private int iconSize;
    private int margin;

    public TreeIcon() {
        this(9);
    }

    public TreeIcon(int iconSize) {
        this.iconSize = iconSize;
        this.margin = 2;
    }

    public int getWidth() {
        return this.iconSize;
    }

    public int getHeight() {
        return this.iconSize;
    }

    public void paint(Object value, Graphics g, int x, int y) {
        if (value instanceof Integer) {
            int type = (Integer)value;
            if (type == 0) {
                this.drawLeaf(g, x, y);
            } else if (type == 1) {
                this.drawCollapsed(g, x, y);
            } else {
                this.drawExpanded(g, x, y);
            }
        }
    }

    protected void drawLeaf(Graphics g, int x, int y) {
        int lineSize = this.iconSize - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
    }

    protected void drawExpanded(Graphics g, int x, int y) {
        g.drawRect(x, y, this.iconSize, this.iconSize);
        int lineSize = this.iconSize - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
    }

    protected void drawCollapsed(Graphics g, int x, int y) {
        g.drawRect(x, y, this.iconSize, this.iconSize);
        int lineSize = this.iconSize - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
        g.drawLine(x + 1 + this.iconSize / 2, y + this.margin, x + 1 + this.iconSize / 2, y + this.margin + lineSize);
    }
}

