/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.contract.ContractException;
import com.kingdee.eas.hr.emp.ContractTypeCollection;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IContractType;
import com.kingdee.eas.hr.emp.app.AbstractContractTypeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;

public class ContractTypeControllerBean
extends AbstractContractTypeControllerBean {
    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ContractTypeInfo info = this.getContractTypeInfo(ctx, pk);
        if (info.getName() != null) {
            return info.getName();
        }
        return "";
    }

    protected IObjectPK _addnew(Context arg0, IObjectValue arg1) throws BOSException, EASBizException {
        this.updateHisNumber(arg0);
        return super._addnew(arg0, arg1);
    }

    private void updateHisNumber(Context ctx) throws BOSException, EASBizException, ORMCoreException {
        if (this._isCanUpdateHis(ctx)) {
            String updateSql = "update T_HR_ContractType set flongnumber=fnumber,fparentid=null where fparentid in (select fid from  (select fparentid fid from T_HR_ContractType a where fparentid is not null) b where b.fid not in (select fid from T_HR_ContractType))";
            DbUtil.execute((Context)ctx, (String)updateSql);
            IContractType iContractType = ContractTypeFactory.getLocalInstance(ctx);
            ContractTypeCollection contractColl = iContractType.getContractTypeCollection();
            if (contractColl.size() > 0) {
                int contractCollCount = contractColl.size();
                for (int i = 0; i < contractCollCount; ++i) {
                    ContractTypeInfo contractTInfo = contractColl.get(i);
                    contractTInfo.setNumber(String.valueOf(i));
                    iContractType.update((IObjectPK)new ObjectUuidPK(contractTInfo.getId()), (CoreBaseInfo)contractTInfo);
                }
            }
            IHRInit iHR = HRInitFactory.getLocalInstance((Context)ctx);
            HRInitInfo info = new HRInitInfo();
            info.put("IS_CU_FILTER", (Object)Boolean.TRUE);
            info.setKey("PCTYPE_UPDATE");
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setValue("PCTYPE_UPDATE");
            iHR.addnew((CoreBaseInfo)info);
        }
    }

    protected boolean _isCanUpdateHis(Context ctx) throws BOSException, EASBizException {
        String sql = "select fvalue from t_hr_hrinit where fkey = 'PCTYPE_UPDATE'";
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql);
        return rows.size() <= 0;
    }

    @Override
    protected void _checkContractType(Context ctx, String parentTypeID, IObjectValue contractType, String typeId) throws BOSException, EASBizException {
        ContractTypeInfo ctInfo = (ContractTypeInfo)contractType;
        FilterInfo filterName = new FilterInfo();
        FilterInfo filterNumber = new FilterInfo();
        FilterItemInfo filterItemName = new FilterItemInfo("name", (Object)ctInfo.getName(), CompareType.EQUALS);
        FilterItemInfo filterItemNumber = new FilterItemInfo("number", (Object)ctInfo.getNumber(), CompareType.EQUALS);
        filterName.getFilterItems().add(filterItemName);
        filterNumber.getFilterItems().add(filterItemNumber);
        if (typeId != null) {
            FilterItemInfo filterItem = new FilterItemInfo("id", (Object)typeId, CompareType.NOTEQUALS);
            filterName.getFilterItems().add(filterItem);
            filterNumber.getFilterItems().add(filterItem);
        }
        if (super._exists(ctx, filterNumber)) {
            throw new ContractException(ContractException.CONNUMBER_EXIST);
        }
        if (super._exists(ctx, filterName)) {
            throw new EmployeeException(EmployeeException.EMPLOYEECONTRACT_TYPENAME_DUP);
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        return filter;
    }
}

