/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.hraux.BirthFactory;
import com.kingdee.eas.basedata.hraux.FolkCollection;
import com.kingdee.eas.basedata.hraux.FolkFactory;
import com.kingdee.eas.basedata.hraux.HealthFactory;
import com.kingdee.eas.basedata.hraux.IBirth;
import com.kingdee.eas.basedata.hraux.IFolk;
import com.kingdee.eas.basedata.hraux.IHealth;
import com.kingdee.eas.basedata.hraux.IPoliticalFace;
import com.kingdee.eas.basedata.hraux.IStanding;
import com.kingdee.eas.basedata.hraux.IWed;
import com.kingdee.eas.basedata.hraux.PoliticalFaceFactory;
import com.kingdee.eas.basedata.hraux.StandingFactory;
import com.kingdee.eas.basedata.hraux.WedFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.BloodType;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.EnrollSourceCollection;
import com.kingdee.eas.hr.base.EnrollSourceFactory;
import com.kingdee.eas.hr.base.HROrgContextManagerFacadeFactory;
import com.kingdee.eas.hr.base.IEnrollSource;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.benefit.util.HrLocaleUtil;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.IPersonContactMethod;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonContactMethodCollection;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpBaseInfoImportData
extends AbstractDataTransmission {
    public boolean isFirst = true;
    private static final int NATIVEADDRESS_MAX_LENGTH = 255;
    private static final int HJADDRESS_MAX_LENGTH = 80;
    private static final int IDCARDADRESS_MAX_LENGTH = 120;
    private static final int HOMEADDRESS_MAX_LENGTH = 80;
    private static final int HOMEPLACE_MAX_LENGTH = 80;
    private static final int ADDRESS_MAX_LENGTH = 80;
    private static final String YES = "Y";
    private static final String NO = "N";
    public static final String bcResource = "com.kingdee.eas.hr.benefit.BenefitCommonResource";
    private String strResourceURL = "com.kingdee.eas.hr.emp.EmployeeInputResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.EmpBaseInfoImportData");

    protected ICoreBase getController(Context arg0) throws TaskExternalException {
        try {
            return PersonFactory.getLocalInstance((Context)arg0);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PersonInfo personInfo;
        block73: {
            personInfo = null;
            String str = null;
            Locale locale = null;
            try {
                PersonContactMethodInfo pcInfo;
                FolkCollection fInfos;
                locale = ctx.getOriginLocale();
                str = (String)((DataToken)hsData.get((Object)"FEmployeeNumber")).data;
                if (StringUtils.isEmpty((String)str)) {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_NULL", (Locale)locale));
                }
                if (str.length() >= 80) {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER_ERROR", (Locale)locale));
                }
                personInfo = this.getPersonInfoByNumber(ctx, str);
                if (personInfo == null) {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + str + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                }
                IObjectPK userPk = ctx.getCaller();
                PersonPositionCollection personPostionCol = PersonPositionFactory.getLocalInstance(ctx).getPersonPositionCollection("where person ='" + personInfo.getId().toString() + "'");
                if (personPostionCol.size() == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"223_EmpBaseInfoImportData", (Locale)ctx.getOriginLocale()) + str + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"224_EmpBaseInfoImportData", (Locale)ctx.getOriginLocale()));
                }
                OrgUnitRelationCollection orgUnitRelationCol = null;
                try {
                    orgUnitRelationCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection("where fromUnit ='" + personPostionCol.get(0).getPersonDep().getId().toString() + "' and typeRelation='00000000-0000-0000-0000-0000000000100FE9F8B5'");
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"223_EmpBaseInfoImportData", (Locale)ctx.getOriginLocale()) + str + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"225_EmpBaseInfoImportData", (Locale)ctx.getOriginLocale()));
                }
                if (orgUnitRelationCol.size() == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"223_EmpBaseInfoImportData", (Locale)ctx.getOriginLocale()) + str + ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"225_EmpBaseInfoImportData", (Locale)ctx.getOriginLocale()));
                }
                personInfo.put("FROM_IMPORT_SYSTEM", (Object)"TRUE");
                str = (String)((DataToken)hsData.get((Object)"FOldName")).data;
                if (!StringUtils.isEmpty((String)str)) {
                    personInfo.setOldName(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FBirthday")).data))) {
                    personInfo.setBirthday(DateTimeUtils.parseDate((String)str));
                }
                str = (String)((DataToken)hsData.get((Object)"FName_L1")).data;
                personInfo.setName(str, LocaleUtils.locale_l1);
                str = (String)((DataToken)hsData.get((Object)"FName_L2")).data;
                personInfo.setName(str, LocaleUtils.locale_l2);
                str = (String)((DataToken)hsData.get((Object)"FName_L3")).data;
                personInfo.setName(str, LocaleUtils.locale_l3);
                str = (String)((DataToken)hsData.get((Object)"FGender")).data;
                if (!StringUtils.isEmpty((String)str)) {
                    if (str.trim().equals(ResourceBase.getString((String)this.strResourceURL, (String)"EMPBASE_MEN", (Locale)locale))) {
                        personInfo.setGender(Genders.Male);
                    } else if (str.trim().equals(ResourceBase.getString((String)this.strResourceURL, (String)"EMPBASE_WOMEN", (Locale)locale))) {
                        personInfo.setGender(Genders.Female);
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_GENDER", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                    }
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FFolkID")).data))) {
                    IFolk iFolk = FolkFactory.getLocalInstance((Context)ctx);
                    fInfos = iFolk.getFolkCollection("Select * Where name='" + str + "'");
                    if (fInfos.size() > 0) {
                        personInfo.setFolk(fInfos.get(0));
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_FOLK", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                    }
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FWedID")).data))) {
                    IWed iWed = WedFactory.getLocalInstance((Context)ctx);
                    fInfos = iWed.getWedCollection("Select * Where name='" + str + "'");
                    if (fInfos.size() > 0) {
                        personInfo.setWed(fInfos.get(0));
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_WED", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                    }
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FBirthID")).data))) {
                    IBirth iBirth = BirthFactory.getLocalInstance((Context)ctx);
                    fInfos = iBirth.getBirthCollection("Select * Where name='" + str + "'");
                    if (fInfos.size() > 0) {
                        personInfo.setBirth(fInfos.get(0));
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_BIRTH", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                    }
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FStandingID")).data))) {
                    IStanding iStand = StandingFactory.getLocalInstance((Context)ctx);
                    fInfos = iStand.getStandingCollection("Select * Where name='" + str + "'");
                    if (fInfos.size() > 0) {
                        personInfo.setStanding(fInfos.get(0));
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_STANDING", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                    }
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FHeight")).data))) {
                    try {
                        personInfo.setHeight(Integer.parseInt(str));
                    }
                    catch (NumberFormatException ex) {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"HEIGHT_ERROR!", (Locale)locale), (Throwable)ex);
                    }
                }
                if (!StringUtils.isEmpty((String)(str = ((DataToken)hsData.get((Object)"FBloodType")).data.toString()))) {
                    if (str.trim().equals(ResourceBase.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_A", (Locale)locale))) {
                        personInfo.setBloodType(BloodType.A);
                    } else if (str.trim().equals(ResourceBase.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_B", (Locale)locale))) {
                        personInfo.setBloodType(BloodType.B);
                    } else if (str.trim().equals(ResourceBase.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_O", (Locale)locale))) {
                        personInfo.setBloodType(BloodType.O);
                    } else if (str.trim().equals(ResourceBase.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_AB", (Locale)locale))) {
                        personInfo.setBloodType(BloodType.AB);
                    } else if (str.trim().equals(ResourceBase.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_OTHER", (Locale)locale))) {
                        personInfo.setBloodType(BloodType.Other);
                    } else if (str.trim().equals(BloodType.Unknown.toString())) {
                        personInfo.setBloodType(BloodType.Unknown);
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"226_EmpBaseInfoImportData", (Locale)ctx.getOriginLocale()));
                    }
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FHealthID")).data))) {
                    IHealth iHealth = HealthFactory.getLocalInstance((Context)ctx);
                    fInfos = iHealth.getHealthCollection("Select * Where name='" + str + "'");
                    if (fInfos.size() > 0) {
                        personInfo.setHealth(fInfos.get(0));
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_HEALTH", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                    }
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FPoliticalFaceID")).data))) {
                    IPoliticalFace iPoliticalFace = PoliticalFaceFactory.getLocalInstance((Context)ctx);
                    fInfos = iPoliticalFace.getPoliticalFaceCollection("Select * Where name='" + str + "'");
                    if (fInfos.size() > 0) {
                        personInfo.setPoliticalFace(fInfos.get(0));
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_POLITICALFACE", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                    }
                }
                if ((pcInfo = this.getPersonContactMethodInfo(ctx, personInfo)) == null) {
                    pcInfo = new PersonContactMethodInfo();
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"Faddress")).data))) {
                    this.judgeLength(str, 80, "ADDRESS_ERROR", locale);
                    pcInfo.setAddressTX(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FHomePhone")).data))) {
                    pcInfo.setHomePhone(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FIDCardAdress")).data))) {
                    this.judgeLength(str, 120, "IDCARDADRESS_ERROR", locale);
                    pcInfo.setIdCardAddress(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FNativeAddress")).data))) {
                    this.judgeLength(str, 255, "NATIVEADDRESS_ERROR", locale);
                    personInfo.setNativePlace(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FHomeplace")).data))) {
                    this.judgeLength(str, 80, "HOMEPLACE_ERROR", locale);
                    pcInfo.setHomeplace(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FHomeAddress")).data))) {
                    this.judgeLength(str, 80, "HOMEADDRESS_ERROR", locale);
                    pcInfo.setHomeAddress(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FPostalcode")).data))) {
                    pcInfo.setPostalcode(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FEmail")).data))) {
                    pcInfo.setEmail(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FHJAddress")).data))) {
                    this.judgeLength(str, 80, "HJADDRESS_ERROR", locale);
                    pcInfo.setHjAddress(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FMobile")).data))) {
                    pcInfo.setMobile(str);
                }
                if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FIsStandbyCadre")).data)) && str.equalsIgnoreCase(YES)) {
                    personInfo.setIsStandbyCadre(true);
                } else {
                    personInfo.setIsStandbyCadre(false);
                }
                pcInfo.setPerson(personInfo);
                pcInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                pcInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                personInfo.put("methodInfo", (Object)pcInfo);
                PersonPositionInfo ppInfo = this.getPersonPositionInfo(ctx, personInfo);
                if (ppInfo == null) {
                    ppInfo = new PersonPositionInfo();
                }
                str = null;
                if (hsData.get("FEnrollSourceID") != null) {
                    str = (String)((DataToken)hsData.get((Object)"FEnrollSourceID")).data;
                }
                if (!StringUtils.isEmpty((String)str)) {
                    IEnrollSource iEnrollSrc = EnrollSourceFactory.getLocalInstance((Context)ctx);
                    EnrollSourceCollection esInfos = iEnrollSrc.getEnrollSourceCollection("Select * Where name='" + str + "'");
                    if (esInfos.size() > 0) {
                        ppInfo.setEnrollSource(esInfos.get(0));
                    } else {
                        throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_ENROLLSRC", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                    }
                }
                ppInfo.setPerson(personInfo);
                personInfo.put("positionInfo", (Object)ppInfo);
                personInfo.put("EmployeeMainListUI", this.getContextParameter().get("from"));
                if (StringUtils.isEmpty((String)personInfo.getIdCardNO()) || personInfo.getGender() == null) break block73;
                IDCardCommonUtil idcard = null;
                boolean isIDCardVerify = false;
                try {
                    HROrgUnitInfo hrOrgUnit = HROrgContextManagerFacadeFactory.getLocalInstance((Context)ctx).getHROByPerson(personInfo.getId().toString());
                    String paramNum = "IS_IDCARD_VERIFY";
                    String hrOrgId = null;
                    if (hrOrgUnit != null) {
                        hrOrgId = hrOrgUnit.getId().toString();
                        isIDCardVerify = HRParamUtil.getParamOfHR((Context)ctx, (String)paramNum, (String)hrOrgId);
                    }
                    idcard = new IDCardCommonUtil(personInfo.getIdCardNO(), isIDCardVerify);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                if (isIDCardVerify && idcard != null && idcard.getGenders() != null && !idcard.getGenders().equals((Object)personInfo.getGender())) {
                    throw new TaskExternalException(new EmployeeException(EmployeeException.GENDER_ERROR).getMessage());
                }
            }
            catch (BOSException bose) {
                throw new TaskExternalException("", (Throwable)bose);
            }
            catch (ParseException e) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"DATE_ERROR", (Locale)locale), (Throwable)e);
            }
        }
        return personInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            PersonInfo personInfo = null;
            if (coreBaseInfo != null) {
                personInfo = (PersonInfo)coreBaseInfo;
            }
            if ((Integer)this.getContextParameter().get("DATATASKMODE") == 8) {
                this.insertData(ctx, personInfo);
            }
            if ((Integer)this.getContextParameter().get("DATATASKMODE") == 16 || (Integer)this.getContextParameter().get("DATATASKMODE") == 128) {
                this.insertData(ctx, personInfo);
            }
            this.isFirst = false;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void insertData(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException, TaskExternalException {
        PersonFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(personInfo.getId()), (CoreBaseInfo)personInfo);
        if (personInfo.get("methodInfo") != null) {
            PersonContactMethodInfo meInfo = (PersonContactMethodInfo)personInfo.get("methodInfo");
            if (meInfo.getId() != null) {
                PersonContactMethodFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(meInfo.getId()), meInfo);
            } else {
                PersonContactMethodFactory.getLocalInstance(ctx).addnew(meInfo);
            }
        }
        if (personInfo.get("positionInfo") != null) {
            PersonPositionInfo ppInfo = (PersonPositionInfo)personInfo.get("positionInfo");
            if (ppInfo.getId() != null) {
                PersonPositionFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(ppInfo.getId()), ppInfo);
            } else {
                PersonPositionFactory.getLocalInstance(ctx).addnew(ppInfo);
            }
        }
    }

    PersonContactMethodInfo getPersonContactMethodInfo(Context ctx, PersonInfo pInfo) throws BOSException {
        if (pInfo.getId() == null) {
            return null;
        }
        IPersonContactMethod iExt = PersonContactMethodFactory.getLocalInstance(ctx);
        PersonContactMethodCollection extInfos = iExt.getPersonContactMethodCollection("Select * Where person.id='" + pInfo.getId().toString() + "'");
        if (extInfos.size() > 0) {
            return extInfos.get(0);
        }
        return null;
    }

    PersonPositionInfo getPersonPositionInfo(Context ctx, PersonInfo pInfo) throws BOSException {
        if (pInfo.getId() == null) {
            return null;
        }
        IPersonPosition ipposition = PersonPositionFactory.getLocalInstance(ctx);
        PersonPositionCollection ppositionInfos = ipposition.getPersonPositionCollection("Select * Where person.id='" + pInfo.getId().toString() + "'");
        if (ppositionInfos.size() > 0) {
            return ppositionInfos.get(0);
        }
        return null;
    }

    PersonInfo getPersonInfoByNumber(Context ctx, String strNumber) throws BOSException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection pInfos = iPerson.getPersonCollection("where number = '" + strNumber.trim() + "'");
        if (pInfos.size() > 0) {
            return pInfos.get(0);
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"number", "name", "oldName", "birthday", "gender", "folk.name", "wed.name", "birth.name", "stand.name", "height", "bloodType", "health.name", "face.name", "nativePlace", "addressTX", "homePhone", "contact.idCardAddress", "contact.homeplace", "contact.homeAddress", "contact.postalcode", "contact.email", "contact.mobile", "contact.hjAddress", "enrollSource.name", "isStandbyCadre", "createTime", "creator.number"});
        exportMap.put("excelFiled", new String[]{"FEmployeeNumber", "FName" + HrLocaleUtil.getLocal((Context)ctx), "FOldName", "FBirthday", "FGender", "FFolkID", "FWedID", "FBirthID", "FStandingID", "FHeight", "FBloodType", "FHealthID", "FPoliticalFaceID", "FNativeAddress", "Faddress", "FHomePhone", "FIDCardAdress", "FHomeplace", "FHomeAddress", "FPostalcode", "FEmail", "FMobile", "FHJAddress", "FEnrollSourceID", "FIsStandbyCadre", "FCreateTime", "FCreatorNumber"});
        exportMap.put("FiledType", new String[0]);
        return this.transeExport(rs, exportMap);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.basedata.person.app.EmpBaseExportQuery";
    }

    private void judgeLength(String field, int maxlength, String reason, Locale locale) throws TaskExternalException {
        if (field.length() >= maxlength) {
            throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)reason, (Locale)locale) + maxlength);
        }
    }

    private Hashtable transeExport(IRowSet rs, Map map) throws TaskExternalException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] queryFiled = (String[])map.get("queryFiled");
        String[] excelFiled = (String[])map.get("excelFiled");
        try {
            int size = queryFiled.length;
            for (int i = 0; i < size; ++i) {
                int bt;
                if ("isPrimary".equals(queryFiled[i])) {
                    hashtable.put(excelFiled[i], YES);
                    continue;
                }
                if (rs.getString(queryFiled[i]) == null) continue;
                if ("false".equals(rs.getString(queryFiled[i])) || "true".equals(rs.getString(queryFiled[i]))) {
                    if ("false".equals(rs.getString(queryFiled[i]))) {
                        hashtable.put(excelFiled[i], NO);
                        continue;
                    }
                    hashtable.put(excelFiled[i], YES);
                    continue;
                }
                if ("gender".equals(queryFiled[i])) {
                    if (rs.getInt(queryFiled[i]) == Genders.Male.getValue()) {
                        hashtable.put(excelFiled[i], Genders.Male.getAlias());
                        continue;
                    }
                    hashtable.put(excelFiled[i], Genders.Female.getAlias());
                    continue;
                }
                if ("bloodType".equals(queryFiled[i])) {
                    bt = rs.getInt(queryFiled[i]);
                    switch (bt) {
                        case 10: {
                            hashtable.put(excelFiled[i], EASResource.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_A"));
                            break;
                        }
                        case 20: {
                            hashtable.put(excelFiled[i], EASResource.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_B"));
                            break;
                        }
                        case 30: {
                            hashtable.put(excelFiled[i], EASResource.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_AB"));
                            break;
                        }
                        case 40: {
                            hashtable.put(excelFiled[i], EASResource.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_O"));
                            break;
                        }
                        case 90: {
                            hashtable.put(excelFiled[i], EASResource.getString((String)this.strResourceURL, (String)"EMPBASE_BLOODTYPE_OTHER"));
                            break;
                        }
                        default: {
                            hashtable.put(excelFiled[i], "");
                            break;
                        }
                    }
                    continue;
                }
                if ("accountDetail.payState".equals(queryFiled[i])) {
                    bt = rs.getInt(queryFiled[i]);
                    switch (bt) {
                        case 10: {
                            hashtable.put(excelFiled[i], EASResource.getString((String)bcResource, (String)"NORMALPAY"));
                            break;
                        }
                        case 30: {
                            hashtable.put(excelFiled[i], EASResource.getString((String)bcResource, (String)"SEALPAY"));
                            break;
                        }
                        case 20: {
                            hashtable.put(excelFiled[i], EASResource.getString((String)bcResource, (String)"STOPPAY"));
                            break;
                        }
                        default: {
                            hashtable.put(excelFiled[i], "");
                            break;
                        }
                    }
                    continue;
                }
                hashtable.put(excelFiled[i], rs.getString(queryFiled[i]));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return hashtable;
    }
}

