/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.DegreeCollection;
import com.kingdee.eas.basedata.hraux.DegreeFactory;
import com.kingdee.eas.basedata.hraux.DiplomaCollection;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IDegree;
import com.kingdee.eas.basedata.hraux.IDiploma;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.GraduateTypeCollection;
import com.kingdee.eas.hr.base.GraduateTypeFactory;
import com.kingdee.eas.hr.base.IGraduateType;
import com.kingdee.eas.hr.base.ISpecialtyType;
import com.kingdee.eas.hr.base.SpecialtyTypeCollection;
import com.kingdee.eas.hr.base.SpecialtyTypeFactory;
import com.kingdee.eas.hr.benefit.util.ExportUtil;
import com.kingdee.eas.hr.benefit.util.HrLocaleUtil;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class EmpDegreeImportData
extends AbstractDataTransmission {
    private static final int MAX_DEGREENUMBER = 80;
    private static final int MAX_DEGREEUNIT = 80;
    private String strResourceURL = "com.kingdee.eas.hr.emp.EmployeeInputResource";

    protected ICoreBase getController(Context arg0) throws TaskExternalException {
        try {
            return PersonDegreeFactory.getLocalInstance(arg0);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PersonDegreeInfo info = new PersonDegreeInfo();
        String str = null;
        Locale locale = null;
        String dateString = null;
        try {
            locale = ctx.getOriginLocale();
            str = (String)((DataToken)hsData.get((Object)"FEmployeeNumber")).data;
            if (StringUtils.isEmpty((String)str)) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + str + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_NULL", (Locale)locale));
            }
            if (str.length() >= 80) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER_ERROR", (Locale)locale));
            }
            PersonInfo personInfo = this.getPersonInfoByNumber(ctx, str);
            if (personInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_NUMBER", (Locale)locale) + str + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
            }
            info.setPerson(personInfo);
            info.put("FROM_IMPORT_SYSTEM", "TRUE");
            str = (String)((DataToken)hsData.get((Object)"FDiploma")).data;
            String tempDegreeStr = (String)((DataToken)hsData.get((Object)"FDegree")).data;
            if (StringUtils.isEmpty((String)str) && StringUtils.isEmpty((String)tempDegreeStr)) {
                throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"DEGREE_DIPLOMA_BOTH", (Locale)locale) + str + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_NULL", (Locale)locale));
            }
            if (!StringUtils.isEmpty((String)str)) {
                IDiploma iDip = DiplomaFactory.getLocalInstance((Context)ctx);
                DiplomaCollection dipInfos = iDip.getDiplomaCollection("Select * Where Name='" + str + "'");
                if (dipInfos.size() <= 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"DEGREE_DIPLOMA", (Locale)locale) + str + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                }
                info.setDiploma(dipInfos.get(0));
                if ((Integer)this.getContextParameter().get("DATATASKMODE") == 16 && !StringUtils.isEmpty((String)(str = this.getPersonDegreeID(ctx, personInfo, dipInfos.get(0))))) {
                    info.setId(BOSUuid.read((String)str));
                }
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FIsHighest")).data)) && (str.trim().equals(ResourceBase.getString((String)this.strResourceURL, (String)"DEGREE_TRUE", (Locale)locale)) || str.equalsIgnoreCase("Y"))) {
                info.setIsHighest(true);
            } else {
                info.setIsHighest(false);
            }
            str = (String)((DataToken)hsData.get((Object)"FDegree")).data;
            if (!StringUtils.isEmpty((String)str)) {
                IDegree iDegree = DegreeFactory.getLocalInstance((Context)ctx);
                DegreeCollection degreeInfos = iDegree.getDegreeCollection("Select * Where Name='" + str + "'");
                if (degreeInfos.size() > 0) {
                    info.setDegree(degreeInfos.get(0));
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_DEGREE", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                }
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FGraduateSchool")).data))) {
                info.setGraduateSchool(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FEnrollDate")).data))) {
                dateString = "ENROLLDATE";
                info.setEnrollDate(DateTimeUtils.parseDate((String)str));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FGraduateDate")).data))) {
                dateString = "GRADUATEDATE";
                info.setGraduateDate(DateTimeUtils.parseDate((String)str));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FSpecialty")).data))) {
                info.setSpecialty(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FDegreeNumber")).data))) {
                this.judgeLength(str, 80, "DEGREENUMBER_ERROR", locale);
                info.setDegreeNumber(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FSpecialtyType")).data))) {
                ISpecialtyType iSpeType = SpecialtyTypeFactory.getLocalInstance((Context)ctx);
                SpecialtyTypeCollection speInfos = iSpeType.getSpecialtyTypeCollection("Select * Where Name='" + str + "'");
                if (speInfos.size() > 0) {
                    info.setSpecialtyType(speInfos.get(0));
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_SPECIALTYTYPE", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                }
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FStudyPattern")).data))) {
                info.setStudyPattern(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FStudyLength")).data))) {
                try {
                    info.setStudyLength(new BigDecimal(str));
                }
                catch (Exception ee) {
                    info.setStudyLength(new BigDecimal(0));
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"STUDYLENGTH", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"STUDYLENGTH_ERROR", (Locale)locale));
                }
            }
            str = (String)((DataToken)hsData.get((Object)"FDegreeCountry")).data;
            info.setDegreeCountry(str);
            str = (String)((DataToken)hsData.get((Object)"FDegreeUnit")).data;
            if (!StringUtils.isEmpty((String)str)) {
                this.judgeLength(str, 80, "DEGREEUNIT_ERROR", locale);
                info.setDegreeUnit(str);
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FDegreeDate")).data))) {
                dateString = "DEGREEDATE";
                info.setDegreeDate(DateTimeUtils.parseDate((String)str));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FAlterationDate")).data))) {
                dateString = "ALTERATIONDATE";
                info.setAlterationDate(DateTimeUtils.parseDate((String)str));
            }
            if (!StringUtils.isEmpty((String)(str = (String)((DataToken)hsData.get((Object)"FGraduateType")).data))) {
                IGraduateType iGraduateType = GraduateTypeFactory.getLocalInstance((Context)ctx);
                GraduateTypeCollection gCol = iGraduateType.getGraduateTypeCollection("Select id Where name='" + str + "'");
                if (gCol.size() > 0) {
                    info.setGraduateType(gCol.get(0));
                } else {
                    throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)"EMP_GRADEATETYPE", (Locale)locale) + "  " + str + "  " + ResourceBase.getString((String)this.strResourceURL, (String)"NOT_FOUND", (Locale)locale));
                }
            }
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            personInfo.put("EmployeeMainListUI", this.getContextParameter().get("from"));
        }
        catch (BOSException bose) {
            throw new TaskExternalException("", (Throwable)bose);
        }
        catch (ParseException e) {
            throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, dateString, (Locale)locale) + "  " + str + " " + ResourceBase.getString((String)this.strResourceURL, (String)"DATE_PARSE_ERROR", (Locale)locale), (Throwable)e);
        }
        return info;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            PersonDegreeInfo degreeInfo = null;
            if (coreBaseInfo != null) {
                degreeInfo = (PersonDegreeInfo)coreBaseInfo;
                if (degreeInfo.getId() == null || (Integer)this.getContextParameter().get("DATATASKMODE") == 8) {
                    PersonDegreeFactory.getLocalInstance(ctx).addnew(degreeInfo);
                }
                if ((Integer)this.getContextParameter().get("DATATASKMODE") == 16) {
                    PersonDegreeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(degreeInfo.getId()), degreeInfo);
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    PersonInfo getPersonInfoByNumber(Context ctx, String strNumber) throws BOSException {
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection pInfos = iPerson.getPersonCollection("Select * Where number='" + strNumber + "'");
        if (pInfos.size() > 0) {
            return pInfos.get(0);
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        HashMap<String, String[]> exportMap = new HashMap<String, String[]>();
        exportMap.put("queryFiled", new String[]{"person.number", "person.name", "graduateDate", "specialty", "degreeUnit", "studyPattern", "degreeCountry.name", "specialtyType.name", "degree.name", "studyLength", "degreeDate", "diploma.name", "enrollDate", "isHighest", "graduateSchool", "degreeNumber", "graduateType.name", "alterationDate", "creator.number", "alterationDate"});
        exportMap.put("excelFiled", new String[]{"FEmployeeNumber", "FName" + HrLocaleUtil.getLocal((Context)ctx), "FGraduateDate", "FSpecialty", "FDegreeUnit", "FStudyPattern", "FDegreeCountry", "FSpecialtyType", "FDegree", "FStudyLength", "FDegreeDate", "FDiploma", "FEnrollDate", "FIsHighest", "FGraduateSchool", "FDegreeNumber", "FGraduateType", "FAlterationDate", "FCreatorNumber", "FCreateTime"});
        exportMap.put("FiledType", new String[0]);
        return ExportUtil.transeExport((IRowSet)rs, exportMap);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        return filterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.emp.app.EmpDegreeExportQuery";
    }

    private String getPersonDegreeID(Context ctx, PersonInfo pInfo, DiplomaInfo dInfo) throws TaskExternalException {
        try {
            String sql = "SELECT FID FROM T_HR_PersonDegree WHERE FPersonID=? AND FDiploma=?";
            Object[] param = new Object[]{pInfo.getId().toString(), dInfo.getId().toString()};
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
            if (rows.next()) {
                return rows.getString("FID");
            }
            return null;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void judgeLength(String field, int maxlength, String reason, Locale locale) throws TaskExternalException {
        if (field.length() >= maxlength) {
            throw new TaskExternalException(ResourceBase.getString((String)this.strResourceURL, (String)reason, (Locale)locale) + maxlength);
        }
    }
}

