/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.emp.FamilyEviteCollection;
import com.kingdee.eas.hr.emp.FamilyEviteInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.app.AbstractFamilyEviteControllerBean;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class FamilyEviteControllerBean
extends AbstractFamilyEviteControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.app.FamilyEviteControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FamilyEviteInfo info = (FamilyEviteInfo)model;
        String number = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).getNumberFromCodingRule(model, null, info.getNumber());
        if (number != null) {
            info.setNumber(number);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (this._exists(ctx, "select fid, number where number = '" + number + "'")) {
            throw new EASBizException(EASBizException.CHECKNUMDUP);
        }
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("relation.id"));
        sic.add(new SelectorItemInfo("relation2.id"));
        sic.add(new SelectorItemInfo("personNumber2"));
        sic.add(new SelectorItemInfo("personNumber"));
        FamilyEviteInfo info = this.getFamilyEviteInfo(ctx, pk, sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("relation.id", (Object)info.getRelation2().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("relation2.id", (Object)info.getRelation().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("personNumber", (Object)info.getPersonNumber2()));
        filterInfo.getFilterItems().add(new FilterItemInfo("personNumber2", (Object)info.getPersonNumber()));
        this._delete(ctx, filterInfo);
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, pk, model);
        this._checkNumberDup(ctx, pk, model);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("relation.id"));
        sic.add(new SelectorItemInfo("relation2.id"));
        sic.add(new SelectorItemInfo("personNumber2"));
        sic.add(new SelectorItemInfo("personNumber"));
        sic.add(new SelectorItemInfo("relationType.id"));
        sic.add(new SelectorItemInfo("person2.id"));
        FamilyEviteInfo oldinfo = this.getFamilyEviteInfo(ctx, pk, sic);
        FamilyEviteInfo newInfo = (FamilyEviteInfo)model;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("personNumber", (Object)oldinfo.getPersonNumber2()));
        filterInfo.getFilterItems().add(new FilterItemInfo("personNumber2", (Object)oldinfo.getPersonNumber()));
        filterInfo.getFilterItems().add(new FilterItemInfo("relation.id", (Object)oldinfo.getRelation2().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("relation2.id", (Object)oldinfo.getRelation().getId().toString()));
        if (oldinfo.getPerson2().getId().equals((Object)newInfo.getPerson2().getId())) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(sic);
            FamilyEviteCollection familyEviteCollection = this.getFamilyEviteCollection(ctx, viewInfo);
            if (familyEviteCollection != null && familyEviteCollection.size() > 0) {
                FamilyEviteInfo eviteInfo = familyEviteCollection.get(0);
                eviteInfo.setRelation(newInfo.getRelation2());
                eviteInfo.setRelation2(newInfo.getRelation());
                eviteInfo.setRelationType(newInfo.getRelationType());
                eviteInfo.setPersonNumber(newInfo.getPersonNumber2());
                eviteInfo.setPersonNumber2(newInfo.getPersonNumber());
                this.updatePartial(ctx, (CoreBaseInfo)eviteInfo, sic);
            }
        } else {
            this._delete(ctx, filterInfo);
            FamilyEviteInfo feinfo = new FamilyEviteInfo();
            feinfo.setNumber(newInfo.getNumber() + "- OPP");
            SelectorItemCollection sic2 = new SelectorItemCollection();
            sic2.add(new SelectorItemInfo("person.id"));
            sic2.add(new SelectorItemInfo("person.Birthday"));
            sic2.add(new SelectorItemInfo("person.EmployeeType.id"));
            sic2.add(new SelectorItemInfo("EnterDate"));
            sic2.add(new SelectorItemInfo("primaryPosition.id"));
            sic2.add(new SelectorItemInfo("personDep.id"));
            FilterInfo filterInfo2 = new FilterInfo();
            filterInfo2.getFilterItems().add(new FilterItemInfo("person.id", (Object)newInfo.getPerson2().getId().toString()));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo2);
            entityViewInfo.setSelector(sic2);
            PersonPositionCollection personpositionCollection = PersonPositionFactory.getLocalInstance(ctx).getPersonPositionCollection(entityViewInfo);
            if (personpositionCollection != null && personpositionCollection.size() > 0) {
                feinfo.setBirthday(personpositionCollection.get(0).getPerson().getBirthday());
                feinfo.setPersonStatus(personpositionCollection.get(0).getPerson().getEmployeeType());
                feinfo.setPosition(personpositionCollection.get(0).getPrimaryPosition());
                feinfo.setDept(personpositionCollection.get(0).getPersonDep());
                feinfo.setEnrollDate(personpositionCollection.get(0).getEnterDate());
            }
            feinfo.setPerson(newInfo.getPerson2());
            feinfo.setPersonNumber(newInfo.getPersonNumber2());
            feinfo.setPerson2(newInfo.getPerson());
            feinfo.setPersonNumber2(newInfo.getPersonNumber());
            feinfo.setRelationType(newInfo.getRelationType());
            feinfo.setRelation(newInfo.getRelation2());
            feinfo.setRelation2(newInfo.getRelation());
            Timestamp createtime = this.getTime();
            feinfo.setCreateTime(createtime);
            feinfo.setLastUpdateTime(createtime);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            feinfo.setCreator(userInfo);
            feinfo.setLastUpdateUser(userInfo);
            this._addnew(ctx, (IObjectValue)feinfo);
        }
        super._update(ctx, pk, model);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        FamilyEviteInfo info = (FamilyEviteInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }
}

