/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.emp.EmployeeManageFacadeFactory;
import com.kingdee.eas.hr.emp.PersonCertificationCollection;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.emp.app.AbstractPersonCertificationControllerBean;
import com.kingdee.eas.hr.emp.app.EmployeeManageUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;

public class PersonCertificationControllerBean
extends AbstractPersonCertificationControllerBean {
    private IObjectPK[] addAndUpdate(Context ctx, PersonCertificationCollection cerColl) throws EASBizException, BOSException {
        ArrayList<IObjectPK> idList = new ArrayList<IObjectPK>();
        for (int i = 0; i < cerColl.size(); ++i) {
            if (cerColl.get(i).getId() == null) {
                idList.add(this._addnew(ctx, (IObjectValue)cerColl.get(i)));
                continue;
            }
            this._update(ctx, (IObjectPK)new ObjectUuidPK(cerColl.get(i).getId()), (IObjectValue)cerColl.get(i));
        }
        ObjectUuidPK[] newList = new ObjectUuidPK[idList.size()];
        for (int i = 0; i < idList.size(); ++i) {
            newList[i] = (IObjectPK)idList.get(i);
        }
        return newList;
    }

    public IObjectPK addnew(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        PersonCertificationInfo linkmanInfo = (PersonCertificationInfo)model;
        if (linkmanInfo.getPerson() != null && (linkmanInfo.getPerson().getName() == null || linkmanInfo.getPerson().getNumber() == null)) {
            ObjectUuidPK pk = new ObjectUuidPK(linkmanInfo.getPerson().getId());
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)pk);
            linkmanInfo.setPerson(personInfo);
        }
        return super.addnew(ctx, (EmpInfoMultiPageInfo)linkmanInfo);
    }

    private void deleteList(Context ctx, IObjectPK[] deleteList) throws EASBizException, BOSException {
        if (deleteList == null || deleteList.length == 0) {
            return;
        }
        HashSet<IObjectPK> set = new HashSet<IObjectPK>();
        for (int i = 0; i < deleteList.length; ++i) {
            set.add(deleteList[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        this._delete(ctx, filter);
    }

    @Override
    protected IObjectPK[] _saveAll(Context ctx, IObjectCollection cerColl, IObjectPK[] deleteList) throws BOSException, EASBizException {
        this.deleteList(ctx, deleteList);
        return this.addAndUpdate(ctx, (PersonCertificationCollection)cerColl);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonCertificationInfo info = (PersonCertificationInfo)model;
        if (info.getHrOrgUnit() == null) {
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        }
        if (info.getCertificateNumber() == null) {
            info.setCertificateNumber("");
        }
        if (info.getCertificateName() == null) {
            info.setCertificateName("");
        }
        String personID = info.getPerson().getId().toString();
        IObjectPK pk = super._addnew(ctx, model);
        this._setVIPItem(ctx, pk.toString(), personID);
        return pk;
    }

    @Override
    protected void _setVIPItem(Context ctx, String id, String personID) throws BOSException, EASBizException {
        String notVipOther = "UPDATE T_HR_PersonCertify SET FVIP = 0 WHERE FID <> ? AND FPersonID = ?";
        String vip = "UPDATE T_HR_PersonCertify SET FVIP = 1 WHERE FID = ? AND FPersonID = ?";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(notVipOther);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)personID);
            pstmt.execute();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(vip);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)personID);
            pstmt.execute();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException(ex.getMessage(), ex.getCause());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonCertificationInfo info = (PersonCertificationInfo)model;
        super._update(ctx, pk, model);
        if (info.getPerson() != null) {
            EmployeeManageFacadeFactory.getLocalInstance(ctx).updateEmpVipInfo("T_HR_PersonCertify", "FVIP", "FPersonID", info.getPerson().getId().toString());
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        PersonCertificationCollection col = this.getPersonCertificationCollection(ctx, viewInfo);
        IObjectPK[] pks = super._delete(ctx, filter);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PersonCertificationInfo info = col.get(i);
                if (info.getPerson() == null) continue;
                personSet.add(info.getPerson().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance(ctx).batchUpdateEmpVipInfo("T_HR_PersonCertify", "FVIP", "FPersonID", personSet, true);
        }
        return pks;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        PersonCertificationInfo info = (PersonCertificationInfo)this._getValue(ctx, pk, selector);
        super._delete(ctx, pk);
        if (info.getPerson() != null) {
            EmployeeManageFacadeFactory.getLocalInstance(ctx).updateEmpVipInfo("T_HR_PersonCertify", "FVIP", "FPersonID", info.getPerson().getId().toString());
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)EmployeeManageUtil.convertPKToSet(arrayPK), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        PersonCertificationCollection col = this.getPersonCertificationCollection(ctx, viewInfo);
        super._delete(ctx, arrayPK);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PersonCertificationInfo info = col.get(i);
                if (info.getPerson() == null) continue;
                personSet.add(info.getPerson().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance(ctx).batchUpdateEmpVipInfo("T_HR_PersonCertify", "FVIP", "FPersonID", personSet, true);
        }
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        PersonCertificationCollection col = this.getPersonCertificationCollection(ctx, oql);
        IObjectPK[] pks = super._delete(ctx, oql);
        if (col != null && col.size() > 0) {
            HashSet<String> personSet = new HashSet<String>();
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                PersonCertificationInfo info = col.get(i);
                if (info.getPerson() == null) continue;
                personSet.add(info.getPerson().getId().toString());
            }
            EmployeeManageFacadeFactory.getLocalInstance(ctx).batchUpdateEmpVipInfo("T_HR_PersonCertify", "FVIP", "FPersonID", personSet, true);
        }
        return pks;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.number"));
        selector.add(new SelectorItemInfo("person.name"));
        PersonCertificationInfo info = (PersonCertificationInfo)this.getValue(ctx, pk, selector);
        return info.getPerson().getNumber() + info.getPerson().getName();
    }
}

