/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.app.util.CoreBaseObjectUtil;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.emp.EmployeeAuditEntryCollection;
import com.kingdee.eas.hr.emp.EmployeeAuditEntryInfo;
import com.kingdee.eas.hr.emp.EmployeeAuditFactory;
import com.kingdee.eas.hr.emp.EmployeeAuditInfo;
import com.kingdee.eas.hr.emp.app.util.EmployeePageAuditServerUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class EmployeeAuditUtil {
    public static CoreBaseInfo convertObjectValue(Context ctx, EmployeeAuditInfo auditInfo) throws BOSException {
        CoreBaseInfo objectValue = null;
        try {
            Class clazz = MetaDataServerUtil.getObjectValueClass((Context)ctx, (String)auditInfo.getEntity());
            objectValue = (CoreBaseInfo)clazz.newInstance();
            objectValue.setId(auditInfo.getPk());
            EmployeeAuditEntryCollection entrys = auditInfo.getEntrys();
            EmployeeAuditEntryInfo entryInfo = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entrys.get(i);
                EmployeeAuditUtil.setModelField(ctx, objectValue, entryInfo, auditInfo.getEntity());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return objectValue;
    }

    public static CoreBaseInfo convertObjectValueForMulti(Context ctx, EmployeeAuditInfo auditInfo) throws BOSException {
        CoreBaseInfo objectValue = null;
        try {
            ICoreBase iCoreBase = MetaDataServerUtil.getBizInterface((Context)ctx, (String)auditInfo.getEntity());
            if (iCoreBase.exists((IObjectPK)new ObjectUuidPK(auditInfo.getPk()))) {
                objectValue = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(auditInfo.getPk()));
            } else {
                Class clazz = MetaDataServerUtil.getObjectValueClass((Context)ctx, (String)auditInfo.getEntity());
                objectValue = (CoreBaseInfo)clazz.newInstance();
                objectValue.setId(auditInfo.getPk());
            }
            EmployeeAuditEntryCollection entrys = auditInfo.getEntrys();
            EmployeeAuditEntryInfo entryInfo = null;
            int size = entrys.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entrys.get(i);
                EmployeeAuditUtil.setModelField(ctx, objectValue, entryInfo, auditInfo.getEntity());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return objectValue;
    }

    public static void setModelField(Context ctx, CoreBaseInfo objectValue, EmployeeAuditEntryInfo entryInfo, String entityName) throws InstantiationException, IllegalAccessException, ClassNotFoundException, BOSException, UuidException, EASBizException {
        String fieldName = entryInfo.getFieldName();
        if (StringUtils.isEmpty((String)entityName)) {
            entityName = entryInfo.getParent().getEntity();
        }
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK(entityName));
        PropertyInfo property = entityInfo.getPropertyByName(fieldName);
        Object value = null;
        if (property instanceof OwnPropertyInfo) {
            String valueString;
            Date valueDate;
            DataType dataType = ((OwnPropertyInfo)property).getDataType();
            BigDecimal valueNumber = entryInfo.getValueNumber();
            if (valueNumber != null) {
                if (DataType.SHORT.equals((Object)dataType)) {
                    value = new Short(valueNumber.shortValue());
                } else if (DataType.INTEGER.equals((Object)dataType)) {
                    value = new Integer(valueNumber.intValue());
                } else if (DataType.FLOAT.equals((Object)dataType)) {
                    value = new Float(valueNumber.floatValue());
                } else if (DataType.LONG.equals((Object)dataType)) {
                    value = new Long(valueNumber.longValue());
                } else if (DataType.DOUBLE.equals((Object)dataType)) {
                    value = new Double(valueNumber.doubleValue());
                } else if (DataType.DECIMAL.equals((Object)dataType)) {
                    value = valueNumber;
                } else if (DataType.BOOLEAN.equals((Object)dataType)) {
                    value = valueNumber.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
                } else if (DataType.ENUM.equals((Object)dataType)) {
                    value = valueNumber;
                }
            }
            if ((valueDate = entryInfo.getValueDate()) != null) {
                if (DataType.DATE.equals((Object)dataType)) {
                    value = valueDate;
                } else if (DataType.TIME.equals((Object)dataType)) {
                    value = new Time(valueDate.getTime());
                } else if (DataType.TIMESTAMP.equals((Object)dataType)) {
                    value = new Timestamp(valueDate.getTime());
                }
            }
            if (!StringUtils.isEmpty((String)(valueString = entryInfo.getValueString()))) {
                if (DataType.STRING.equals((Object)dataType)) {
                    value = valueString;
                } else if (DataType.OBJECTPK.equals((Object)dataType)) {
                    value = new ObjectUuidPK(valueString);
                } else if (DataType.BOSUUID.equals((Object)dataType)) {
                    value = BOSUuid.read((String)valueString);
                } else if (DataType.UUID.equals((Object)dataType)) {
                    value = Uuid.read((String)valueString);
                } else if (DataType.ENUM.equals((Object)dataType)) {
                    value = valueString;
                } else if (entryInfo.getValueNumber() == null && !StringUtils.isEmpty((String)valueString) && DataType.INTEGER.equals((Object)dataType)) {
                    value = Integer.valueOf(valueString);
                } else if (entryInfo.getValueNumber() == null && !StringUtils.isEmpty((String)valueString) && DataType.DECIMAL.equals((Object)dataType)) {
                    value = new BigDecimal(valueString);
                }
            }
        } else if (property instanceof LinkPropertyInfo) {
            String valueString = entryInfo.getValueString();
            value = EmployeePageAuditServerUtil.getValue(ctx, valueString);
        } else {
            EntityObjectInfo extentityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.emp.app.PersonOtherInfo"));
            PropertyInfo extproperty = extentityInfo.getPropertyByName(fieldName.substring(4));
            if (extproperty instanceof OwnPropertyInfo) {
                DataType dataType = ((OwnPropertyInfo)extproperty).getDataType();
                BigDecimal valueNumber = entryInfo.getValueNumber();
                if (valueNumber != null) {
                    if (DataType.SHORT.equals((Object)dataType)) {
                        value = new Short(valueNumber.shortValue());
                    } else if (DataType.INTEGER.equals((Object)dataType)) {
                        value = new Integer(valueNumber.intValue());
                    } else if (DataType.FLOAT.equals((Object)dataType)) {
                        value = new Float(valueNumber.floatValue());
                    } else if (DataType.LONG.equals((Object)dataType)) {
                        value = new Long(valueNumber.longValue());
                    } else if (DataType.DOUBLE.equals((Object)dataType)) {
                        value = new Double(valueNumber.doubleValue());
                    } else if (DataType.DECIMAL.equals((Object)dataType)) {
                        value = valueNumber;
                    } else if (DataType.BOOLEAN.equals((Object)dataType)) {
                        value = valueNumber.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
                    } else if (DataType.ENUM.equals((Object)dataType)) {
                        value = valueNumber;
                    }
                }
            }
            if (value == null) {
                value = entryInfo.getValueString();
            }
            if (value != null && StringUtils.isEmpty((String)value.toString())) {
                value = null;
            }
        }
        CoreBaseObjectUtil.setValue((Context)ctx, (CoreBaseInfo)objectValue, (String)fieldName, (Object)value);
    }

    public static SelectorItemCollection getSelectors(EmployeeAuditInfo info) {
        SelectorItemCollection sic = new SelectorItemCollection();
        EmployeeAuditEntryCollection entrys = info.getEntrys();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            sic.add(new SelectorItemInfo(entrys.get(i).getFieldName()));
        }
        return sic;
    }

    public static EntityViewInfo getEntityView(String personId) {
        EntityViewInfo auditViewInfo = new EntityViewInfo();
        SelectorItemCollection auditSelector = new SelectorItemCollection();
        auditSelector.add(new SelectorItemInfo("pk"));
        auditSelector.add(new SelectorItemInfo("name"));
        auditSelector.add(new SelectorItemInfo("entity"));
        auditSelector.add(new SelectorItemInfo("status"));
        auditSelector.add(new SelectorItemInfo("reason"));
        auditSelector.add(new SelectorItemInfo("descAfter"));
        auditSelector.add(new SelectorItemInfo("operateType"));
        auditSelector.add(new SelectorItemInfo("auditor.id"));
        auditSelector.add(new SelectorItemInfo("auditor.name"));
        auditSelector.add(new SelectorItemInfo("category.id"));
        auditSelector.add(new SelectorItemInfo("category.name"));
        auditSelector.add(new SelectorItemInfo("category.entityInfoSet"));
        auditSelector.add(new SelectorItemInfo("category.entityInfoSet.multiRow"));
        FilterInfo auditFilter = new FilterInfo();
        auditFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        auditFilter.getFilterItems().add(new FilterItemInfo("status", (Object)3));
        auditFilter.getFilterItems().add(new FilterItemInfo("confirmStatus", (Object)false, CompareType.EQUALS));
        auditFilter.setMaskString("#0 and (#1 or (#2 and #3))");
        auditViewInfo.setFilter(auditFilter);
        auditViewInfo.setSelector(auditSelector);
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("createTime"));
        auditViewInfo.setSorter(sorters);
        return auditViewInfo;
    }

    public static void updateEmployeeAuditStatus(Context ctx, EmployeeAuditInfo auditInfo) throws BOSException, EASBizException {
        if (auditInfo.getId() == null || StringUtils.isEmpty((String)auditInfo.getId().toString())) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("status"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("auditor"));
        EmployeeAuditFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)auditInfo, selector);
    }
}

