/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.emp.CompleteStateEnum;
import com.kingdee.eas.hr.emp.EmpBatchAffairBizException;
import com.kingdee.eas.hr.emp.FluctuationInOutCollection;
import com.kingdee.eas.hr.emp.FluctuationInOutFactory;
import com.kingdee.eas.hr.emp.FluctuationInOutInfo;
import com.kingdee.eas.hr.emp.IFluctuationInOut;
import java.util.HashSet;
import java.util.Set;

public class FluctuationInOutUtil {
    public static FluctuationInOutInfo getPersonFluctuationInOutInfo(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("completeState", (Object)1, CompareType.NOTEQUALS));
        view.setFilter(filter);
        FluctuationInOutCollection coll = FluctuationInOutFactory.getLocalInstance(ctx).getFluctuationInOutCollection(view);
        FluctuationInOutInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static FluctuationInOutInfo getFluctuationInOutInfoByEntryId(Context ctx, String entryId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("outEntryId", (Object)entryId));
        filter.getFilterItems().add(new FilterItemInfo("inEntryId", (Object)entryId));
        filter.setMaskString("(#0 or #1)");
        view.setFilter(filter);
        FluctuationInOutCollection coll = FluctuationInOutFactory.getLocalInstance(ctx).getFluctuationInOutCollection(view);
        FluctuationInOutInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static FluctuationInOutInfo getFluctuationInOutInfoByOutBill(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("flucOutBill", (Object)billId));
        view.setFilter(filter);
        FluctuationInOutCollection coll = FluctuationInOutFactory.getLocalInstance(ctx).getFluctuationInOutCollection(view);
        FluctuationInOutInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static FluctuationInOutCollection getPersonLoanFluctuationInOutInfo(Context ctx, String personId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("completeState", (Object)0));
        view.setFilter(filter);
        FluctuationInOutCollection coll = FluctuationInOutFactory.getLocalInstance(ctx).getFluctuationInOutCollection(view);
        return coll;
    }

    public static FluctuationInOutInfo getFluctuationInOutInfoByInBill(Context ctx, String billId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("flucInBill", (Object)billId));
        view.setFilter(filter);
        FluctuationInOutCollection coll = FluctuationInOutFactory.getLocalInstance(ctx).getFluctuationInOutCollection(view);
        FluctuationInOutInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    public static Set getFluctuationInOutPersonIdSet() throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        FluctuationInOutCollection fColl = FluctuationInOutUtil.getFluctuationInOutColl();
        for (int i = 0; i < fColl.size(); ++i) {
            FluctuationInOutInfo fInfo = fColl.get(i);
            idSet.add(fInfo.getPerson().getId().toString());
        }
        return idSet;
    }

    public static FluctuationInOutCollection getFluctuationInOutColl() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("completeState", (Object)1, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("actionDef.number", (Object)"SHR35"));
        filter.getFilterItems().add(new FilterItemInfo("isLoanBill", (Object)false));
        view.setFilter(filter);
        FluctuationInOutCollection fColl = FluctuationInOutFactory.getRemoteInstance().getFluctuationInOutCollection(view);
        return fColl;
    }

    public static void updateFluctuationInOutData(Context ctx, HRAffairBizBillEntryInfo entry) throws BOSException, EASBizException {
        IFluctuationInOut iFIO = FluctuationInOutFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String personId = entry.getPerson().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("completeState", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("completeState", (Object)2));
        filter.setMaskString("(#0 and( #1 or #2))");
        view.setFilter(filter);
        FluctuationInOutCollection col = new FluctuationInOutCollection();
        col = iFIO.getFluctuationInOutCollection(view);
        if (col.size() > 0) {
            FluctuationInOutInfo info = col.get(0);
            info.setEFFECT(entry.getBizDate());
            info.setNewAdmin(entry.getAdminOrg());
            info.setNewPosition(entry.getPosition());
            info.setNewLaborRelState(entry.getEmpType());
            info.setCompleteState(CompleteStateEnum.COMPLETED);
            info.setEmpID(FluctuationInOutUtil.getEmpIDByPersonID(ctx, personId));
            info.setInEntryId(entry.getId().toString());
            iFIO.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), info);
        }
    }

    private static String getEmpIDByPersonID(Context ctx, String personId) throws BOSException {
        String empID = "";
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection col = new EmpPosOrgRelationCollection();
        col = helper.getCurrntEmpOrgRelation(ctx, personId);
        if (col.size() == 0) {
            throw new BOSException((Throwable)((Object)new EmpBatchAffairBizException(EmpBatchAffairBizException.THIS_PERSON_NO_EXPIR)));
        }
        empID = col.get(0).getId().toString();
        return empID;
    }

    public static FluctuationInOutInfo getPersonFlucInOutInfoNotCompleted(Context ctx, String personId, boolean isLoan) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("completeState", (Object)1, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLoanBill", (Object)isLoan));
        view.setFilter(filter);
        FluctuationInOutCollection coll = FluctuationInOutFactory.getLocalInstance(ctx).getFluctuationInOutCollection(view);
        FluctuationInOutInfo info = null;
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }
}

