/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.affair.FluctuationBizBillInfo;
import com.kingdee.eas.hr.affair.HRAffairBizBillEntryInfo;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.HRBizDefineInfo;
import com.kingdee.eas.hr.base.HRBizDefineTypeEnum;
import com.kingdee.eas.hr.base.VariationReasonCollection;
import com.kingdee.eas.hr.base.VariationReasonFactory;
import com.kingdee.eas.hr.base.VariationReasonInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.IPrePerson;
import com.kingdee.eas.hr.emp.PrePersonCollection;
import com.kingdee.eas.hr.emp.PrePersonFactory;
import com.kingdee.eas.hr.emp.PrePersonInfo;
import com.kingdee.shr.base.bizmanage.util.BatchPromptsInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecEntryServiceUtil {
    private static Logger logger = Logger.getLogger(RecEntryServiceUtil.class);

    public static void undoWithResumeInfo(Context ctx, boolean falg, String entryID) throws EASBizException, BOSException {
        String entryState = "";
        entryState = falg ? "preEntey" : "waitEntry";
        if (!StringUtils.isEmpty((String)entryID)) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "unRecEntryService");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("entryID", entryID);
            param.put("entryState", entryState);
            imsf.process(ctx, param);
        }
    }

    public static void unRecPreEntryService(Context ctx, PrePersonInfo prePerson) throws EASBizException, BOSException {
        if (null != prePerson) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "unRecPreEntryService");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("idcardNo", null != prePerson.getIdCardNo() ? prePerson.getIdCardNo().toString() : "");
            param.put("passportNo", null != prePerson.getIdentity() ? prePerson.getIdentity().toString() : "");
            imsf.process(ctx, param);
        }
    }

    public static List<BatchPromptsInfo> checkPersonCanDeleteForRecService(Context ctx, String personId) throws EASBizException, BOSException {
        ArrayList<BatchPromptsInfo> res = new ArrayList<BatchPromptsInfo>();
        Map resultMap = new HashMap();
        if (null != personId) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "checkPersonCanDeleteForRecService");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("personId", personId);
            resultMap = (Map)imsf.process(ctx, param);
            if (null != resultMap && "false".equals(resultMap.get("canDelete").toString())) {
                List msglist = (List)resultMap.get("msgList");
                if (null != msglist) {
                    for (Map map : msglist) {
                        BatchPromptsInfo batchPromptsInfo = new BatchPromptsInfo();
                        batchPromptsInfo.setPersonId(personId);
                        batchPromptsInfo.setDomain(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"recruit", (Context)ctx));
                        batchPromptsInfo.setModules(null != map.get("function") ? ((String)map.get("function")).toString() : "");
                        batchPromptsInfo.setOperation(null != map.get("path") ? ((String)map.get("path")).toString() : "");
                        batchPromptsInfo.setDesc(null != map.get("msg") ? ((String)map.get("msg")).toString() : "");
                        res.add(batchPromptsInfo);
                    }
                }
            } else {
                return null;
            }
        }
        return res;
    }

    public static BatchPromptsInfo checkPersonCanDeleteForPerfService(Context ctx, String personId) throws EASBizException, BOSException {
        BatchPromptsInfo batchPromptsInfo = new BatchPromptsInfo();
        Map resultMap = new HashMap();
        if (null != personId) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "CheckPersonCanDeleteForPerfService");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("personId", personId.toString());
            resultMap = (Map)imsf.process(ctx, param);
            if (null != resultMap && "false".equals(resultMap.get("canDelete").toString())) {
                batchPromptsInfo.setPersonId(personId);
                batchPromptsInfo.setDomain(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"perf", (Context)ctx));
                batchPromptsInfo.setModules(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"perfrelation", (Context)ctx));
                batchPromptsInfo.setOperation("");
                batchPromptsInfo.setDesc(resultMap.get("msg").toString());
            } else {
                return null;
            }
        }
        return batchPromptsInfo;
    }

    public static void deletePersonForRecService(Context ctx, String personId) throws EASBizException, BOSException {
        if (null != personId) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "deletePersonForRecService");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("personId", personId);
            imsf.process(ctx, param);
        }
    }

    public static void recTransferService(Context ctx, FluctuationBizBillInfo bill, int state) throws EASBizException, BOSException {
        try {
            logger.error((Object)"recTransferService start =======");
            if (null != bill && state != 0) {
                logger.error((Object)("recTransferService param :{oper :" + state + ",number :" + null != bill.getNumber() ? bill.getNumber().toString() : "}"));
                IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "recTransferService");
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("oper", state);
                param.put("number", null != bill.getNumber() ? bill.getNumber().toString() : "");
                imsf.process(ctx, param);
            }
            logger.error((Object)"recTransferService end =======");
        }
        catch (Exception e) {
            logger.error((Object)("recTransferService error " + e.getMessage()), (Throwable)e);
        }
    }

    public static PrePersonCollection getPrePersonInfoByEnrolledPersonId(Context ctx, PersonInfo personInfo) throws BOSException {
        String idcardno = personInfo.getIdCardNO();
        String passportno = personInfo.getPassportNO();
        PrePersonCollection ppCol = new PrePersonCollection();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(RecEntryServiceUtil.getPrePersonSelector(true));
        FilterInfo filterInfo = new FilterInfo();
        IPrePerson ipp = PrePersonFactory.getLocalInstance(ctx);
        if (!StringUtils.isEmpty((String)idcardno)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("idCardNo", (Object)idcardno));
            view.setFilter(filterInfo);
            ppCol.addCollection(ipp.getPrePersonCollection(view));
        }
        if (!StringUtils.isEmpty((String)passportno)) {
            filterInfo.appendFilterItem("passportno", (Object)passportno);
            view.setFilter(filterInfo);
            ppCol.addCollection(ipp.getPrePersonCollection(view));
        }
        return ppCol;
    }

    private static SelectorItemCollection getPrePersonSelector(boolean isPrePerson) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (isPrePerson) {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("idCardNo"));
            sic.add(new SelectorItemInfo("passportNO"));
            sic.add(new SelectorItemInfo("curEnterDate"));
            sic.add(new SelectorItemInfo("curAdminOrg"));
            sic.add(new SelectorItemInfo("checkInState"));
            sic.add(new SelectorItemInfo("curPosition"));
            sic.add(new SelectorItemInfo("isEnrolled"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
        } else {
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("employee.id"));
            sic.add(new SelectorItemInfo("employee.isInCount"));
        }
        return sic;
    }

    public static void syncEmployeeStateChange(Context ctx, String personId, HRBizDefineInfo bizDefine, HRAffairBizBillEntryInfo entry) throws EASBizException, BOSException {
        String bizDefineId = bizDefine.getId().toString();
        HRBizDefineInfo bizDefineInfo = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineInfo((IObjectPK)new ObjectUuidPK(bizDefineId));
        HRBizDefineTypeEnum bizDefineType = bizDefineInfo.getBizDefineType();
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "EmployeeChangeSyncRecOSF");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("personId", personId);
        param.put("bizDate", entry.getBizDate().toString());
        if (HRBizDefineTypeEnum.EMPHIRE.equals((Object)bizDefineType)) {
            param.put("type", "1");
            logger.error((Object)("RecEntryServiceUtil.syncEmployeeStateChange-param: " + param));
            imsf.process(ctx, param);
        } else if (HRBizDefineTypeEnum.RESIGN.equals((Object)bizDefineType)) {
            param.put("type", "3");
            VariationReasonInfo reason = entry.getVariationReason();
            if (reason != null) {
                String reasonId = reason.getId().toString();
                String oql = "select name where id = '" + reasonId + "'";
                VariationReasonCollection reasonInfoColl = VariationReasonFactory.getLocalInstance((Context)ctx).getVariationReasonCollection(oql);
                if (reasonInfoColl.size() > 0) {
                    param.put("detail", reasonInfoColl.get(0).getName());
                }
            }
            logger.error((Object)("RecEntryServiceUtil.syncEmployeeStateChange-param: " + param));
            imsf.process(ctx, param);
        }
    }

    public static void doWithResumeInfo(Context ctx, PersonInfo pInfo) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)pInfo.getIdCardNO()) || !StringUtils.isEmpty((String)pInfo.getPassportNO())) {
            IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "recEntryService");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("entryDate", HRUtilExtend.getDateStringWithoutMininute((Date)pInfo.getEFFDT()));
            if (!StringUtils.isEmpty((String)pInfo.getIdCardNO())) {
                param.put("idcardNo", pInfo.getIdCardNO());
            }
            if (!StringUtils.isEmpty((String)pInfo.getPassportNO())) {
                param.put("passportNo", pInfo.getPassportNO());
            }
            param.put("entryID", pInfo.getId().toString());
            param.put("affairId", pInfo.getString("entryid"));
            imsf.process(ctx, param);
        }
    }
}

