/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.util;

import com.kingdee.eas.hr.emp.EmployeeBizException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleCalendar {
    private static Pattern pattern = Pattern.compile("^(\\d{2})(\\d{2})([\\s\\*])(.+)$");
    private static Pattern pattern2 = Pattern.compile("^(\\d{2})(.{2})([\\s\\*])(.+)$");
    long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 21844L, 22191L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 53845L, 46415L, 54944L, 44450L, 38320L, 18807L, 18815L, 42160L, 46261L, 27216L, 27968L, 43860L, 11119L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 27285L, 23263L, 11104L, 34531L, 37615L, 51415L, 51551L, 54432L, 55462L, 46431L, 22176L, 42420L, 9695L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 21333L, 19887L, 42416L, 17779L, 21183L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46752L, 38310L, 38335L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 23232L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 20854L, 21183L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19195L, 19152L, 42192L, 53430L, 53855L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 45653L, 27951L, 44448L, 19299L, 37759L, 18936L, 18800L, 25776L, 26790L, 59999L, 27424L, 42692L, 43759L, 37600L, 53987L, 51552L, 54615L, 54432L, 55888L, 23893L, 22176L, 42704L, 21972L, 21200L, 43448L, 43344L, 46240L, 46758L, 44368L, 21920L, 43940L, 42416L, 21168L, 45683L, 26928L, 29495L, 27296L, 44368L, 19285L, 19311L, 42352L, 21732L, 53856L, 59752L, 54560L, 55968L, 27302L, 22239L, 19168L, 43476L, 42192L, 53584L, 62034L, 54560L};
    List<Element> elements = new ArrayList<Element>();
    public static Map<String, SimpleCalendar> cache = new HashMap<String, SimpleCalendar>();
    long[] solarMonth = new long[]{31L, 28L, 31L, 30L, 31L, 30L, 31L, 31L, 30L, 31L, 30L, 31L};
    static String[] Gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    static String[] Zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    static String[] Animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    static String[] solarTerm = new String[]{"\u5c0f\u5bd2", "\u5927\u5bd2", "\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3"};
    int[] sTermInfo = new int[]{0, 21208, 42467, 63836, 85337, 107014, 128867, 150921, 173149, 195551, 218072, 240693, 263343, 285989, 308563, 331033, 353350, 375494, 397447, 419210, 440795, 462224, 483532, 504758};
    char[] nStr1 = new char[]{'\u65e5', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341'};
    String[] nStr2 = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345", " "};
    static String[] monthChinese = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    static String[] dayChinese = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c", "\u5341\u4e09", "\u5341\u56db", "\u5341\u4e94", "\u5341\u516d", "\u5341\u4e03", "\u5341\u516b", "\u5341\u4e5d", "\u4e8c\u5341", "\u4e8c\u5341\u4e00", "\u4e8c\u5341\u4e8c", "\u4e8c\u5341\u4e09", "\u4e8c\u5341\u56db", "\u4e8c\u5341\u4e94", "\u4e8c\u5341\u516d", "\u4e8c\u5341\u4e03", "\u4e8c\u5341\u516b", "\u4e8c\u5341\u4e5d", "\u4e09\u5341", "\u4e09\u5341\u4e00"};
    char[] jcName0 = new char[]{'\u5efa', '\u9664', '\u6ee1', '\u5e73', '\u5b9a', '\u6267', '\u7834', '\u5371', '\u6210', '\u6536', '\u5f00', '\u95ed'};
    char[] jcName1 = new char[]{'\u95ed', '\u5efa', '\u9664', '\u6ee1', '\u5e73', '\u5b9a', '\u6267', '\u7834', '\u5371', '\u6210', '\u6536', '\u5f00'};
    char[] jcName2 = new char[]{'\u5f00', '\u95ed', '\u5efa', '\u9664', '\u6ee1', '\u5e73', '\u5b9a', '\u6267', '\u7834', '\u5371', '\u6210', '\u6536'};
    char[] jcName3 = new char[]{'\u6536', '\u5f00', '\u95ed', '\u5efa', '\u9664', '\u6ee1', '\u5e73', '\u5b9a', '\u6267', '\u7834', '\u5371', '\u6210'};
    char[] jcName4 = new char[]{'\u6210', '\u6536', '\u5f00', '\u95ed', '\u5efa', '\u9664', '\u6ee1', '\u5e73', '\u5b9a', '\u6267', '\u7834', '\u5371'};
    char[] jcName5 = new char[]{'\u5371', '\u6210', '\u6536', '\u5f00', '\u95ed', '\u5efa', '\u9664', '\u6ee1', '\u5e73', '\u5b9a', '\u6267', '\u7834'};
    char[] jcName6 = new char[]{'\u7834', '\u5371', '\u6210', '\u6536', '\u5f00', '\u95ed', '\u5efa', '\u9664', '\u6ee1', '\u5e73', '\u5b9a', '\u6267'};
    char[] jcName7 = new char[]{'\u6267', '\u7834', '\u5371', '\u6210', '\u6536', '\u5f00', '\u95ed', '\u5efa', '\u9664', '\u6ee1', '\u5e73', '\u5b9a'};
    char[] jcName8 = new char[]{'\u5b9a', '\u6267', '\u7834', '\u5371', '\u6210', '\u6536', '\u5f00', '\u95ed', '\u5efa', '\u9664', '\u6ee1', '\u5e73'};
    char[] jcName9 = new char[]{'\u5e73', '\u5b9a', '\u6267', '\u7834', '\u5371', '\u6210', '\u6536', '\u5f00', '\u95ed', '\u5efa', '\u9664', '\u6ee1'};
    char[] jcName10 = new char[]{'\u6ee1', '\u5e73', '\u5b9a', '\u6267', '\u7834', '\u5371', '\u6210', '\u6536', '\u5f00', '\u95ed', '\u5efa', '\u9664'};
    char[] jcName11 = new char[]{'\u9664', '\u6ee1', '\u5e73', '\u5b9a', '\u6267', '\u7834', '\u5371', '\u6210', '\u6536', '\u5f00', '\u95ed', '\u5efa'};
    String[] sFtv = new String[]{"0101*\u5143\u65e6", "0106  \u4e2d\u56fd13\u4ebf\u4eba\u53e3\u65e5", "0110  \u4e2d\u56fd110\u5ba3\u4f20\u65e5", "0202  \u4e16\u754c\u6e7f\u5730\u65e5", "0204  \u4e16\u754c\u6297\u764c\u75c7\u65e5", "0210  \u4e16\u754c\u6c14\u8c61\u65e5", "0214  \u60c5\u4eba\u8282", "0221  \u56fd\u9645\u6bcd\u8bed\u65e5", "0207  \u56fd\u9645\u58f0\u63f4\u5357\u975e\u65e5", "0303  \u5168\u56fd\u7231\u8033\u65e5", "0308  \u5987\u5973\u8282", "0312  \u690d\u6811\u8282 \u5b59\u4e2d\u5c71\u901d\u4e16\u7eaa\u5ff5\u65e5", "0315  \u6d88\u8d39\u8005\u6743\u76ca\u4fdd\u62a4\u65e5", "0321  \u4e16\u754c\u68ee\u6797\u65e5", "0322  \u4e16\u754c\u6c34\u65e5", "0323  \u4e16\u754c\u6c14\u8c61\u65e5", "0324  \u4e16\u754c\u9632\u6cbb\u7ed3\u6838\u75c5\u65e5", "0401  \u611a\u4eba\u8282", "0407  \u4e16\u754c\u536b\u751f\u65e5", "0422  \u4e16\u754c\u5730\u7403\u65e5", "0501*\u56fd\u9645\u52b3\u52a8\u8282", "0504  \u4e2d\u56fd\u9752\u5e74\u8282", "0505  \u5168\u56fd\u7898\u7f3a\u4e4f\u75c5\u65e5", "0508  \u4e16\u754c\u7ea2\u5341\u5b57\u65e5", "0512  \u56fd\u9645\u62a4\u58eb\u8282", "0515  \u56fd\u9645\u5bb6\u5ead\u65e5", "0517  \u4e16\u754c\u7535\u4fe1\u65e5", "0518  \u56fd\u9645\u535a\u7269\u9986\u65e5", "0519  \u4e2d\u56fd\u6c76\u5ddd\u5730\u9707\u54c0\u60bc\u65e5 \u5168\u56fd\u52a9\u6b8b\u65e5", "0520  \u5168\u56fd\u5b66\u751f\u8425\u517b\u65e5", "0522  \u56fd\u9645\u751f\u7269\u591a\u6837\u6027\u65e5", "0523  \u56fd\u9645\u725b\u5976\u65e5", "0531  \u4e16\u754c\u65e0\u70df\u65e5", "0601  \u56fd\u9645\u513f\u7ae5\u8282", "0605  \u4e16\u754c\u73af\u5883\u65e5", "0606  \u5168\u56fd\u7231\u773c\u65e5", "0617  \u9632\u6cbb\u8352\u6f20\u5316\u548c\u5e72\u65f1\u65e5", "0623  \u56fd\u9645\u5965\u6797\u5339\u514b\u65e5", "0625  \u5168\u56fd\u571f\u5730\u65e5", "0626  \u56fd\u9645\u53cd\u6bd2\u54c1\u65e5", "0701  \u5efa\u515a\u8282 \u9999\u6e2f\u56de\u5f52\u7eaa\u5ff5\u65e5", "0707  \u6297\u65e5\u6218\u4e89\u7eaa\u5ff5\u65e5", "0711  \u4e16\u754c\u4eba\u53e3\u65e5", "0801  \u516b\u4e00\u5efa\u519b\u8282", "0815  \u65e5\u672c\u6b63\u5f0f\u5ba3\u5e03\u65e0\u6761\u4ef6\u6295\u964d\u65e5", "0908  \u56fd\u9645\u626b\u76f2\u65e5", "0909  **\u901d\u4e16\u7eaa\u5ff5\u65e5", "0910  \u6559\u5e08\u8282", "0916  \u56fd\u9645\u81ed\u6c27\u5c42\u4fdd\u62a4\u65e5", "0917  \u56fd\u9645\u548c\u5e73\u65e5", "0918  \u4e5d\u00b7\u4e00\u516b\u4e8b\u53d8\u7eaa\u5ff5\u65e5", "0920  \u56fd\u9645\u7231\u7259\u65e5", "0927  \u4e16\u754c\u65c5\u6e38\u65e5", "0928  \u5b54\u5b50\u8bde\u8fb0", "1001*\u56fd\u5e86\u8282 \u56fd\u9645\u97f3\u4e50\u8282 \u56fd\u9645\u8001\u4eba\u8282", "1002  \u56fd\u9645\u51cf\u8f7b\u81ea\u7136\u707e\u5bb3\u65e5", "1004  \u4e16\u754c\u52a8\u7269\u65e5", "1007  \u56fd\u9645\u4f4f\u623f\u65e5", "1008  \u4e16\u754c\u89c6\u89c9\u65e5 \u5168\u56fd\u9ad8\u8840\u538b\u65e5", "1009  \u4e16\u754c\u90ae\u653f\u65e5", "1010  \u8f9b\u4ea5\u9769\u547d\u7eaa\u5ff5\u65e5 \u4e16\u754c\u7cbe\u795e\u536b\u751f\u65e5", "1015  \u56fd\u9645\u76f2\u4eba\u8282", "1016  \u4e16\u754c\u7cae\u98df\u8282", "1017  \u4e16\u754c\u6d88\u9664\u8d2b\u56f0\u65e5", "1022  \u4e16\u754c\u4f20\u7edf\u533b\u836f\u65e5", "1024  \u8054\u5408\u56fd\u65e5", "1025  \u4eba\u7c7b\u5929\u82b1\u7edd\u8ff9\u65e5", "1026  \u8db3\u7403\u8bde\u751f\u65e5", "1031  \u4e07\u5723\u8282", "1107  \u5341\u6708\u793e\u4f1a\u4e3b\u4e49\u9769\u547d\u7eaa\u5ff5\u65e5", "1108  \u4e2d\u56fd\u8bb0\u8005\u65e5", "1109  \u6d88\u9632\u5ba3\u4f20\u65e5", "1110  \u4e16\u754c\u9752\u5e74\u8282", "1112  \u5b59\u4e2d\u5c71\u8bde\u8fb0", "1114  \u4e16\u754c\u7cd6\u5c3f\u75c5\u65e5", "1117  \u56fd\u9645\u5927\u5b66\u751f\u8282", "1201  \u4e16\u754c\u827e\u6ecb\u75c5\u65e5", "1203  \u4e16\u754c\u6b8b\u75be\u4eba\u65e5", "1209  \u4e16\u754c\u8db3\u7403\u65e5", "1210  \u4e16\u754c\u4eba\u6743\u65e5", "1212  \u897f\u5b89\u4e8b\u53d8\u7eaa\u5ff5\u65e5", "1213  \u5357\u4eac\u5927\u5c60\u6740", "1220  \u6fb3\u95e8\u56de\u5f52\u7eaa\u5ff5\u65e5", "1221  \u56fd\u9645\u7bee\u7403\u65e5", "1224  \u5e73\u5b89\u591c", "1225  \u5723\u8bde\u8282 \u4e16\u754c\u5f3a\u5316\u514d\u75ab\u65e5", "1226  **\u8bde\u8fb0"};
    String[] lFtv = new String[]{"0101*\u6625\u8282", "0102*\u5927\u5e74\u521d\u4e8c", "0103*\u5927\u5e74\u521d\u4e09", "0104*\u5927\u5e74\u521d\u56db", "0105*\u5927\u5e74\u521d\u4e94", "0106*\u5927\u5e74\u521d\u516d", "0107*\u5927\u5e74\u521d\u4e03", "0105  \u8def\u795e\u751f\u65e5", "0115  \u5143\u5bb5\u8282", "0202  \u9f99\u62ac\u5934", "0219  \u89c2\u4e16\u97f3\u5723\u8bde", "0404  \u5bd2\u98df\u8282", "0408  \u4f5b\u8bde\u8282 ", "0505*\u7aef\u5348\u8282", "0606  \u5929\u8d36\u8282 \u59d1\u59d1\u8282", "0624  \u5f5d\u65cf\u706b\u628a\u8282", "0707  \u4e03\u5915\u60c5\u4eba\u8282", "0714  \u9b3c\u8282(\u5357\u65b9)", "0715  \u76c2\u5170\u8282", "0730  \u5730\u85cf\u8282", "0815*\u4e2d\u79cb\u8282", "0909  \u91cd\u9633\u8282", "1001  \u796d\u7956\u8282", "1117  \u963f\u5f25\u9640\u4f5b\u5723\u8bde", "1208  \u814a\u516b\u8282 \u91ca\u8fe6\u5982\u6765\u6210\u9053\u65e5", "1223  \u8fc7\u5c0f\u5e74", "1229*\u814a\u6708\u4e8c\u5341\u4e5d", "0100*\u9664\u5915"};
    String[] wFtv = new String[]{"0110  \u9ed1\u4eba\u8282", "0150  \u4e16\u754c\u9ebb\u98ce\u65e5", "0121  \u65e5\u672c\u6210\u4eba\u8282", "0520  \u6bcd\u4eb2\u8282", "0530  \u5168\u56fd\u52a9\u6b8b\u65e5", "0630  \u7236\u4eb2\u8282", "0716  \u5408\u4f5c\u8282", "0730  \u88ab\u5974\u5f79\u56fd\u5bb6\u5468", "0932  \u56fd\u9645\u548c\u5e73\u65e5", "0940  \u56fd\u9645\u804b\u4eba\u8282 \u4e16\u754c\u513f\u7ae5\u65e5", "1011  \u56fd\u9645\u4f4f\u623f\u65e5", "1144  \u611f\u6069\u8282"};
    private Long length;
    private int firstWeek;

    public static Element getCalendarDetail(Date date) throws ParseException, EmployeeBizException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        String cacheKey = year + "-" + month;
        SimpleCalendar lunarCalendarUtil = null;
        lunarCalendarUtil = new SimpleCalendar();
        lunarCalendarUtil.calendar(year, month, day);
        cache.put(cacheKey, lunarCalendarUtil);
        return lunarCalendarUtil.getElements().get(cal.get(5) - 1);
    }

    public static Element getCalendarDetail(String date, String pattern) throws ParseException, EmployeeBizException {
        SimpleDateFormat df2 = new SimpleDateFormat(pattern);
        return SimpleCalendar.getCalendarDetail(df2.parse(date));
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public void calendar(int y, int m, int d) throws ParseException, EmployeeBizException {
        Date sDObj = null;
        Lunar lDObj = null;
        Boolean lL = null;
        Long lD2 = null;
        Integer lY = null;
        Integer lM = null;
        Integer lD = 1;
        Integer lX = 0;
        Integer lY2 = null;
        Integer cs1 = null;
        Integer[] lDPOS = new Integer[3];
        Integer n = 0;
        Integer firstLM = 0;
        String dateString = y + "-" + (m + 1) + "-" + 1;
        sDObj = new SimpleDateFormat("yyyy-MM-dd").parse(dateString);
        this.length = this.solarDays(y, m);
        this.firstWeek = sDObj.getDay();
        String cY = m < 2 ? this.cyclical(y - 1900 + 36 - 1) : this.cyclical(y - 1900 + 36);
        int term2 = this.sTerm(y, 2);
        int firstNode = this.sTerm(y, m * 2);
        String cM = this.cyclical((y - 1900) * 12 + m + 12);
        Integer lM2 = (y - 1900) * 12 + m + 12;
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        df2.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = df2.parse("" + y + "-" + (m + 1) + "-" + 1 + " 00:00:00");
        long dayCyclical = date.getTime() / 86400000L + 25567L + 10L;
        SimpleDateFormat df3 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        int i = 0;
        while ((long)i < this.length) {
            if (i == 18) {
                int n2 = 5;
            }
            if (lD > lX) {
                sDObj = df3.parse("" + y + "-" + (m + 1) + "-" + (i + 1) + " 00:00:00");
                lDObj = new Lunar(sDObj);
                lY = lDObj.year;
                lM = lDObj.month;
                lD = lDObj.day;
                lL = lDObj.isLeap;
                lX = lL != false ? this.leapDays(lY) : this.monthDays(lY, lM);
                if (n == 0) {
                    firstLM = lM;
                }
                Integer n3 = n;
                Integer n4 = n = Integer.valueOf(n + 1);
                lDPOS[n3.intValue()] = i - lD + 1;
            }
            if (m == 1 && i + 1 == term2) {
                cY = this.cyclical(y - 1900 + 36);
                lY2 = y - 1900 + 36;
            }
            if (i + 1 == firstNode) {
                cM = this.cyclical((y - 1900) * 12 + m + 13);
                lM2 = (y - 1900) * 12 + m + 13;
            }
            String cD = this.cyclical(dayCyclical + (long)i);
            lD2 = dayCyclical + (long)i;
            String zodiac = this.animalsYmd(lY);
            Integer n5 = lD;
            Integer n6 = lD = Integer.valueOf(lD + 1);
            Element element = new Element(y, m + 1, i + 1, this.nStr1[(i + this.firstWeek) % 7], lY, lM, n5, lL, cY, cM, cD, zodiac);
            element.setcDay(this.cDay(element.getlDay()));
            int paramterLy2 = lY2 == null ? -1 : lY2 % 12;
            int paramterLm2 = lM2 == null ? -1 : lM2 % 12;
            long paramterLd2 = lD2 == null ? -1L : lD2 % 12L;
            int paramterLy2b = lY2 == null ? -1 : lY2 % 10;
            int paramterLy2c = (int)(lD2 == null ? -1L : lD2 % 10L);
            int paramterLld = lD == null ? -1 : lD - 1;
            element.setSgz5(this.CalConv2(paramterLy2, paramterLm2, (int)paramterLd2, paramterLy2b, paramterLy2c, lM, paramterLld, m + 1, cs1 == null ? -1 : cs1));
            element.setSgz3(this.cyclical6(lM2 % 12, (int)(lD2 % 12L)));
            this.elements.add(element);
            ++i;
        }
        Integer tmp1 = this.sTerm(y, m * 2) - 1;
        Integer tmp2 = this.sTerm(y, m * 2 + 1) - 1;
        this.elements.get((int)tmp1.intValue()).solarTerms = solarTerm[m * 2];
        this.elements.get((int)tmp2.intValue()).solarTerms = solarTerm[m * 2 + 1];
        if (m == 3) {
            this.elements.get((int)tmp1.intValue()).color = "red";
        }
        for (String i2 : this.sFtv) {
            Matcher matcher = pattern.matcher(i2);
            if (!matcher.matches()) continue;
            if (i2.equals("1212  \u897f\u5b89\u4e8b\u53d8\u7eaa\u5ff5\u65e5")) {
                int n7 = 2;
            }
            if (Integer.valueOf(matcher.group(1)) != m + 1) continue;
            this.elements.get((int)(Integer.valueOf((String)matcher.group((int)2)).intValue() - 1)).solarFestival = this.elements.get((int)(Integer.valueOf((String)matcher.group((int)2)).intValue() - 1)).solarFestival + matcher.group(4) + "";
            if (!matcher.group(3).equals(Character.valueOf('*'))) continue;
            this.elements.get((int)(Integer.valueOf((String)matcher.group((int)0)).intValue() - 1)).color = "red";
        }
        for (String i3 : this.lFtv) {
            Matcher matcher = pattern2.matcher(i3);
            if (!matcher.matches()) continue;
            tmp1 = Integer.valueOf(matcher.group(1)) - firstLM;
            if (tmp1 == -11) {
                tmp1 = 1;
            }
            if (tmp1 < 0 || tmp1 >= n || (tmp2 = Integer.valueOf(lDPOS[tmp1] + Integer.valueOf(matcher.group(2)) - 1)) < 0 || (long)tmp2.intValue() >= this.length) continue;
            this.elements.get((int)tmp2.intValue()).lunarFestival = this.elements.get((int)tmp2.intValue()).lunarFestival + matcher.group(4);
            if (!matcher.group(3).equals("*")) continue;
            this.elements.get((int)tmp2.intValue()).color = "red";
        }
        if (m == 2 || m == 3) {
            Easter estDay = new Easter(y);
            if (m == estDay.m) {
                this.elements.get((int)(estDay.d - 1)).solarFestival = this.elements.get((int)(estDay.d - 1)).solarFestival + " \u590d\u6d3b\u8282(Easter Sunday)";
            }
        }
        if ((this.firstWeek + 12) % 7 == 5) {
            this.elements.get((int)12).solarFestival = this.elements.get((int)12).solarFestival + "\u9ed1\u8272\u661f\u671f\u4e94";
        }
    }

    public long solarDays(int y, int m) {
        if (m == 1) {
            return y % 4 == 0 && y % 100 != 0 || y % 400 == 0 ? 29 : 28;
        }
        return this.solarMonth[m];
    }

    public char cyclical6(int num, int num2) {
        if (num == 0) {
            return this.jcName0[num2];
        }
        if (num == 1) {
            return this.jcName1[num2];
        }
        if (num == 2) {
            return this.jcName2[num2];
        }
        if (num == 3) {
            return this.jcName3[num2];
        }
        if (num == 4) {
            return this.jcName4[num2];
        }
        if (num == 5) {
            return this.jcName5[num2];
        }
        if (num == 6) {
            return this.jcName6[num2];
        }
        if (num == 7) {
            return this.jcName7[num2];
        }
        if (num == 8) {
            return this.jcName8[num2];
        }
        if (num == 9) {
            return this.jcName9[num2];
        }
        if (num == 10) {
            return this.jcName10[num2];
        }
        if (num == 11) {
            return this.jcName11[num2];
        }
        return '0';
    }

    public String CalConv2(int yy, int mm, int dd, int y, int d, int m, int dt, int nm, int nd) {
        int dy = d + dd;
        if (yy == 0 && dd == 6 || yy == 6 && dd == 0 || yy == 1 && dd == 7 || yy == 7 && dd == 1 || yy == 2 && dd == 8 || yy == 8 && dd == 2 || yy == 3 && dd == 9 || yy == 9 && dd == 3 || yy == 4 && dd == 10 || yy == 10 && dd == 4 || yy == 5 && dd == 11 || yy == 11 && dd == 5) {
            return "<FONT color=#0000A0>\u65e5\u503c\u5c81\u7834 \u5927\u4e8b\u4e0d\u5b9c</font>";
        }
        if (mm == 0 && dd == 6 || mm == 6 && dd == 0 || mm == 1 && dd == 7 || mm == 7 && dd == 1 || mm == 2 && dd == 8 || mm == 8 && dd == 2 || mm == 3 && dd == 9 || mm == 9 && dd == 3 || mm == 4 && dd == 10 || mm == 10 && dd == 4 || mm == 5 && dd == 11 || mm == 11 && dd == 5) {
            return "<FONT color=#0000A0>\u65e5\u503c\u6708\u7834 \u5927\u4e8b\u4e0d\u5b9c</font>";
        }
        if (y == 0 && dy == 911 || y == 1 && dy == 55 || y == 2 && dy == 111 || y == 3 && dy == 75 || y == 4 && dy == 311 || y == 5 && dy == 9 || y == 6 && dy == 511 || y == 7 && dy == 15 || y == 8 && dy == 711 || y == 9 && dy == 35) {
            return "<FONT color=#0000A0>\u65e5\u503c\u4e0a\u6714 \u5927\u4e8b\u4e0d\u5b9c</font>";
        }
        if (m == 1 && dt == 13 || m == 2 && dt == 11 || m == 3 && dt == 9 || m == 4 && dt == 7 || m == 5 && dt == 5 || m == 6 && dt == 3 || m == 7 && dt == 1 || m == 7 && dt == 29 || m == 8 && dt == 27 || m == 9 && dt == 25 || m == 10 && dt == 23 || m == 11 && dt == 21 || m == 12 && dt == 19) {
            return "<FONT color=#0000A0>\u65e5\u503c\u6768\u516c\u5341\u4e09\u5fcc \u5927\u4e8b\u4e0d\u5b9c</font>";
        }
        return "0";
    }

    public String cyclical(long num) {
        return Gan[(int)(num % 10L)] + Zhi[(int)(num % 12L)];
    }

    public String cDay(int d) {
        String s;
        switch (d) {
            case 10: {
                s = "\u521d\u5341";
                break;
            }
            case 20: {
                s = "\u4e8c\u5341";
                break;
            }
            case 30: {
                s = "\u4e09\u5341";
                break;
            }
            default: {
                s = this.nStr2[Double.valueOf(Math.floor(d / 10)).intValue()];
                s = s + this.nStr1[d % 10];
            }
        }
        return s;
    }

    public int sTerm(int y, int n) throws ParseException {
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df2.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = df2.parse("1900-01-06 02:05:00");
        Long utcTime2 = date.getTime();
        BigDecimal time2 = BigDecimal.valueOf(3.15569259747E10).multiply(new BigDecimal(y - 1900)).add(new BigDecimal(this.sTermInfo[n]).multiply(BigDecimal.valueOf(60000L)));
        BigDecimal time = time2.add(BigDecimal.valueOf(utcTime2));
        Date offDate = new Date(time.longValue());
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(offDate);
        int utcDate = cal.get(5);
        return utcDate;
    }

    public Long leapMonth(int y) {
        long lm = this.lunarInfo[y - 1900] & 0xFL;
        return lm == 15L ? 0L : lm;
    }

    public Long lYearDays(int y) {
        long sum = 348L;
        for (long i = 32768L; i > 8L; i >>= 1) {
            sum += (this.lunarInfo[y - 1900] & i) != 0L ? 1L : 0L;
        }
        return sum + (long)this.leapDays(y);
    }

    public int leapDays(int y) {
        if (this.leapMonth(y) != 0L) {
            return (this.lunarInfo[y - 1899] & 0xFL) == 15L ? 30 : 29;
        }
        return 0;
    }

    private int monthDays(int y, int m) {
        return (this.lunarInfo[y - 1900] & (long)(65536 >> m)) != 0L ? 30 : 29;
    }

    public String animalsYmd(int lY) {
        return Animals[(lY - 4) % 12];
    }

    public static class Element {
        public int sYear;
        public int sMonth;
        public int sDay;
        public char week;
        public int lYear;
        public int lMonth;
        public String lMonthChinese;
        public String lDayChinese;
        public int lDay;
        public boolean isLeap;
        public String cYear;
        public String cMonth;
        public String cDay;
        public String color;
        public boolean isToday = false;
        public String lunarFestival;
        public String solarFestival;
        public String solarTerms;
        public String sgz5;
        public char sgz3;
        public String zodiac;

        public Element(int sYear, int sMonth, int sDay, char week, int lYear, int lMonth, int lDay, boolean isLeap, String cYear, String cMonth, String cDay, String zodiac) {
            this.sYear = sYear;
            this.sMonth = sMonth;
            this.sDay = sDay;
            this.week = week;
            this.lYear = lYear;
            this.lMonth = lMonth;
            this.lDay = lDay;
            this.isLeap = isLeap;
            this.lMonthChinese = monthChinese[lMonth - 1];
            this.lDayChinese = dayChinese[lDay - 1];
            this.cYear = cYear;
            this.cMonth = cMonth;
            this.cDay = cDay;
            this.color = "";
            this.lunarFestival = "";
            this.solarFestival = "";
            this.solarTerms = "";
            this.zodiac = zodiac;
        }

        public String getSgz5() {
            return this.sgz5;
        }

        public void setSgz5(String sgz5) {
            this.sgz5 = sgz5;
        }

        public char getSgz3() {
            return this.sgz3;
        }

        public void setSgz3(char sgz3) {
            this.sgz3 = sgz3;
        }

        public int getsYear() {
            return this.sYear;
        }

        public void setsYear(int sYear) {
            this.sYear = sYear;
        }

        public int getsMonth() {
            return this.sMonth;
        }

        public void setsMonth(int sMonth) {
            this.sMonth = sMonth;
        }

        public int getsDay() {
            return this.sDay;
        }

        public void setsDay(int sDay) {
            this.sDay = sDay;
        }

        public char getWeek() {
            return this.week;
        }

        public void setWeek(char week) {
            this.week = week;
        }

        public int getlYear() {
            return this.lYear;
        }

        public void setlYear(int lYear) {
            this.lYear = lYear;
        }

        public int getlMonth() {
            return this.lMonth;
        }

        public void setlMonth(int lMonth) {
            this.lMonth = lMonth;
        }

        public int getlDay() {
            return this.lDay;
        }

        public void setlDay(int lDay) {
            this.lDay = lDay;
        }

        public boolean isLeap() {
            return this.isLeap;
        }

        public void setLeap(boolean leap) {
            this.isLeap = leap;
        }

        public String getcYear() {
            return this.cYear;
        }

        public void setcYear(String cYear) {
            this.cYear = cYear;
        }

        public String getcMonth() {
            return this.cMonth;
        }

        public void setcMonth(String cMonth) {
            this.cMonth = cMonth;
        }

        public String getcDay() {
            return this.cDay;
        }

        public void setcDay(String cDay) {
            this.cDay = cDay;
        }

        public String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        public boolean isToday() {
            return this.isToday;
        }

        public void setToday(boolean today) {
            this.isToday = today;
        }

        public String getLunarFestival() {
            return this.lunarFestival;
        }

        public void setLunarFestival(String lunarFestival) {
            this.lunarFestival = lunarFestival;
        }

        public String getSolarFestival() {
            return this.solarFestival;
        }

        public void setSolarFestival(String solarFestival) {
            this.solarFestival = solarFestival;
        }

        public String getSolarTerms() {
            return this.solarTerms;
        }

        public void setSolarTerms(String solarTerms) {
            this.solarTerms = solarTerms;
        }

        public String getlMonthChinese() {
            return this.lMonthChinese;
        }

        public void setlMonthChinese(String lMonthChinese) {
            this.lMonthChinese = lMonthChinese;
        }

        public String getlDayChinese() {
            return this.lDayChinese;
        }

        public void setlDayChinese(String lDayChinese) {
            this.lDayChinese = lDayChinese;
        }

        public String getZodiac() {
            return this.zodiac;
        }

        public void setZodiac(String zodiac) {
            this.zodiac = zodiac;
        }
    }

    public class Easter {
        public int m;
        public int d;

        public Easter(int y) throws ParseException, EmployeeBizException {
            int term2 = SimpleCalendar.this.sTerm(y, 5);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            df2.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date dayTerm2 = df2.parse("" + y + "-" + 3 + "-" + term2 + " 00:00:00");
            Lunar lDayTerm2 = new Lunar(dayTerm2);
            int lMlen = 0;
            lMlen = lDayTerm2.day < 15 ? 15 - lDayTerm2.day : (lDayTerm2.isLeap ? SimpleCalendar.this.leapDays(y) : SimpleCalendar.this.monthDays(y, lDayTerm2.month)) - lDayTerm2.day + 15;
            Date l15 = new Date(dayTerm2.getTime() + (long)(86400000 * lMlen));
            Date dayEaster = new Date(l15.getTime() + (long)(86400000 * (7 - l15.getDay())));
            this.m = dayEaster.getMonth();
            this.d = dayEaster.getDate();
        }
    }

    public class Lunar {
        private int year;
        private boolean isLeap;
        private int month;
        private int day;

        public Lunar(Date objDate) throws ParseException, EmployeeBizException {
            int i;
            int leap = 0;
            int temp = 0;
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            df2.setTimeZone(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat dtFmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date date = df2.parse(dtFmt.format(objDate));
            SimpleDateFormat df3 = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            df3.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date3 = df3.parse("1900-1-31 00:00:00");
            if (date.before(date3)) {
                throw new EmployeeBizException(EmployeeBizException.CHECK_BIRTHDAY);
            }
            long time1 = date.getTime();
            long time2 = date3.getTime();
            int offset = (int)((time1 - time2) / 86400000L);
            for (i = 1900; i < 2100 && offset > 0; offset -= temp, ++i) {
                temp = SimpleCalendar.this.lYearDays(i).intValue();
            }
            if (offset < 0) {
                offset += temp;
                --i;
            }
            this.year = i;
            leap = SimpleCalendar.this.leapMonth(i).intValue();
            this.isLeap = false;
            for (i = 1; i < 13 && offset > 0; offset -= temp, ++i) {
                if (leap > 0 && i == leap + 1 && !this.isLeap) {
                    --i;
                    this.isLeap = true;
                    temp = SimpleCalendar.this.leapDays(this.year);
                } else {
                    temp = SimpleCalendar.this.monthDays(this.year, i);
                }
                if (!this.isLeap || i != leap + 1) continue;
                this.isLeap = false;
            }
            if (offset == 0 && leap > 0 && i == leap + 1) {
                if (this.isLeap) {
                    this.isLeap = false;
                } else {
                    this.isLeap = true;
                    --i;
                }
            }
            if (offset < 0) {
                offset += temp;
                --i;
            }
            this.month = i;
            this.day = offset + 1;
        }
    }
}

