/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.workyear;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.base.RoundModeEnum;
import com.kingdee.eas.hr.emp.app.workyear.CommonUtil;
import com.kingdee.eas.hr.emp.app.workyear.IPersonPositionWorkYear;
import com.kingdee.eas.hr.emp.app.workyear.PersonWorkYear;
import com.kingdee.eas.util.app.DbUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonLeaveWorkYear
implements IPersonPositionWorkYear {
    private static final Logger logger = LoggerFactory.getLogger(PersonLeaveWorkYear.class);
    private int scale;
    private RoundModeEnum roundMode;
    private Context ctx;

    public PersonLeaveWorkYear() {
    }

    public PersonLeaveWorkYear(int scale, RoundModeEnum roundMode, Context ctx) {
        this.scale = scale;
        this.roundMode = roundMode;
        this.ctx = ctx;
    }

    @Override
    public void savePersonPositionToTemp() throws BOSException {
        PersonWorkYear pWorkYear = this.getPersonWorkYear();
        String sql = this.getInsertSql(pWorkYear);
        logger.info("cal work year PersonLeaveWorkYear-savePersonPositionToTemp sql : " + sql);
        DbUtil.execute((Context)this.ctx, (String)sql);
    }

    private PersonWorkYear getPersonWorkYear() {
        PersonWorkYear pWorkYear = new PersonWorkYear();
        String fjoingroupyears = CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(isnull(FLeftDate,getdate()))-YEAR(isnull(fjoingroupdate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(fjoingroupdate,isnull(FLeftDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftDate,getdate())) - DAYOFMONTH (isnull(fjoingroupdate,isnull(FLeftDate,getdate()))))/365.0 - isnull(FAdjustGroupVal,0.0))");
        String fJoinGroupCurYears = CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(isnull(FLeftDate,getdate()))-YEAR(isnull(FJoinGroupDateCur,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(FJoinGroupDateCur,isnull(FLeftDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftDate,getdate()))-DAYOFMONTH(isnull(FJoinGroupDateCur,isnull(FLeftDate,getdate()))))/365.0 - isnull(FAdjustGroupCurVal,0.0))");
        String fjoincompanyyears = CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(isnull(FLeftCompanyDate,getdate())) - YEAR(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))) + ((MONTH(isnull(FLeftCompanyDate,getdate()))-MONTH(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftCompanyDate,getdate())) - DAYOFMONTH (isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/365.0 - isnull(fadjustcovalue,0.0))");
        String fsysserviceyears = "YEAR(isnull(FLeftDate,getdate())) - YEAR(isnull(fjoinsystemdate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(fjoinsystemdate,isnull(FLeftDate,getdate()))))/12.0 - isnull(fadjustsysvalue,0.0))";
        String fworktime = "YEAR(isnull(FLeftDate,getdate())) - YEAR(isnull(fjobStartDate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(fjobStartDate,isnull(FLeftDate,getdate()))))/12 - isnull(fadjustworkvalue,0.0))";
        String fnewworktime = " YEAR(isnull(FLeftDate,getdate())) - YEAR(isnull(fjobStartDate,isnull(FLeftDate,getdate()))) + ((MONTH(isnull(FLeftDate,getdate()))-MONTH(isnull(fjobStartDate,isnull(FLeftDate,getdate()))))/12.0 - isnull(fadjustworkvalue,0.0)) ";
        pWorkYear.setFjoingroupyears(fjoingroupyears);
        pWorkYear.setfJoinGroupCurYears(fJoinGroupCurYears);
        pWorkYear.setFjoincompanyyears(fjoincompanyyears);
        pWorkYear.setFsysserviceyears(fsysserviceyears);
        pWorkYear.setFworktime(fworktime);
        pWorkYear.setFnewworktime(fnewworktime);
        return pWorkYear;
    }

    private String getInsertSql(PersonWorkYear pWorkYear) {
        StringBuffer sb = new StringBuffer();
        sb.append(" insert into t_hr_workyear_temp (FPersonPositionID, Fpersonid,  ");
        sb.append(" fjoingroupyears,FJoinGroupCurYears,fjoincompanyyears,fsysserviceyears,fworktime,fnewworktime ");
        sb.append(" )");
        sb.append("select t.fid,t.FPersonID, ");
        sb.append(pWorkYear.getFjoingroupyears()).append(", ");
        sb.append(pWorkYear.getfJoinGroupCurYears()).append(", ");
        sb.append(pWorkYear.getFjoincompanyyears()).append(", ");
        sb.append(pWorkYear.getFsysserviceyears()).append(", ");
        sb.append(pWorkYear.getFworktime()).append(", ");
        sb.append(pWorkYear.getFnewworktime());
        sb.append(" from  T_HR_PersonPosition t ");
        sb.append(" where ");
        sb.append("      exists (  select person.fid   ");
        sb.append("                 from  t_bd_person person  inner join t_hr_bdemployeetype emptype ");
        sb.append("                       on person.femployeetypeid = emptype.fid  ");
        sb.append("                 where  emptype.FinService = 2  ");
        sb.append("                   and  t.fpersonid = person.fid ) ");
        System.out.println("personLeave\uff0c\u8ba1\u7b97\u5de5\u4f5c\u5e74\u9650\u7684SQL=" + sb.toString());
        return sb.toString();
    }
}

