/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.app.workyear;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.base.RoundModeEnum;
import com.kingdee.eas.hr.emp.app.workyear.CommonUtil;
import com.kingdee.eas.hr.emp.app.workyear.IPersonWorkYearService;
import com.kingdee.eas.util.app.DbUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonWorkYearService
implements IPersonWorkYearService {
    private static final Logger logger = LoggerFactory.getLogger(PersonWorkYearService.class);
    private int scale;
    private RoundModeEnum roundMode;
    private Context ctx;

    public PersonWorkYearService() {
    }

    public PersonWorkYearService(int scale, RoundModeEnum roundMode, Context ctx) {
        this.scale = scale;
        this.roundMode = roundMode;
        this.ctx = ctx;
    }

    @Override
    public void updatePersonPositionWorkYear() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_HR_PersonPosition  pp  ");
        sb.append(" set  (fjoingroupyears, fJoinGroupCurYears, fjoincompanyyears,fsysserviceyears,fworktime,fnewworktime)  ");
        sb.append("\t    = (select fjoingroupyears, fJoinGroupCurYears, fjoincompanyyears,fsysserviceyears,fworktime,fnewworktime ");
        sb.append("                   from  t_hr_workyear_temp  temp where temp.FPersonPositionID  = pp.fid ");
        sb.append(" ) ");
        sb.append("  where  exists  (select 1  from  t_hr_workyear_temp  tp   where  tp.FPersonPositionID =  pp.fid ");
        sb.append(" )");
        logger.info("cal work year update sql : " + sb.toString());
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    @Override
    public void adjustWorkYear() throws BOSException {
        String sql = this.getUpdatePersonPositionSql();
        logger.info("cal work year adjustWorkYear sql : " + sql);
        DbUtil.execute((Context)this.ctx, (String)sql);
        String fixEnteryearsSql = "update T_HR_EmpLaborRelation set fenteryears = 0 where fenteryears is not null and fenteryears < 0";
        String fixEnteryearsHisSql = "update T_HR_EmpLaborRelationHis set fenteryears = 0 where fenteryears is not null and fenteryears < 0";
        DbUtil.execute((Context)this.ctx, (String)fixEnteryearsSql);
        DbUtil.execute((Context)this.ctx, (String)fixEnteryearsHisSql);
    }

    @Override
    public void updatePersonPositionHis() throws BOSException {
        String companyYearsSql = " update T_HR_PersonPositionHis set fjoincompanyyears = " + CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(isnull(FLeftCompanyDate,getdate())) - YEAR(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))) + ((MONTH(isnull(FLeftCompanyDate,getdate())) - MONTH(isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/12.0 + (DAYOFMONTH(isnull(FLeftCompanyDate,getdate())) - DAYOFMONTH (isnull(fjoindate,isnull(FLeftCompanyDate,getdate()))))/365.0 - isnull(fadjustcovalue,0.0))") + " where fpersonid in (select fid from t_bd_person where FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3')";
        logger.info("cal work year companyYearsSql sql : " + companyYearsSql);
        DbUtil.execute((Context)this.ctx, (String)companyYearsSql);
        String fixCompanyYearsHisSql = "update T_HR_PersonPositionHis set fjoincompanyyears = 0 where fjoincompanyyears is not null and fjoincompanyyears < 0";
        DbUtil.execute((Context)this.ctx, (String)fixCompanyYearsHisSql);
        StringBuffer sb = new StringBuffer();
        sb.append("  update T_HR_PersonPositionhis ppHis                                                      ");
        sb.append("  set  (fjoingroupyears,FJoinGroupCurYears,fsysserviceyears,fworktime,fnewworktime)  =     ");
        sb.append("  \t (select  fjoingroupyears,FJoinGroupCurYears,fsysserviceyears,fworktime,fnewworktime  ");
        sb.append("  \t   from   T_HR_PersonPosition pp                                                      ");
        sb.append("  \t   where  pp.fid=ppHis.FHistoryRelateID and ppHis.fleffdt={ts'2199-12-31'})           ");
        sb.append("  where ppHis.fleffdt={ts'2199-12-31'}                                                     ");
        logger.info("cal work year \u804c\u4e1a\u4fe1\u606f\u7684\u8ba1\u7b97\u7ed3\u679c  sql : " + sb.toString());
        DbUtil.execute((Context)this.ctx, (String)sb.toString());
    }

    private String getUpdatePersonPositionSql() {
        StringBuffer sb = new StringBuffer();
        sb.append(" update T_HR_PersonPosition  ");
        sb.append("     set ");
        sb.append("        fjoingroupyears = ( case  when fjoingroupyears  is null  then null  ");
        sb.append("                                  when  fjoingroupyears < 0  then 0 ");
        sb.append("                                  else  fjoingroupyears ");
        sb.append("                            end ), ");
        sb.append("        FJoinGroupCurYears =  ( case  when FJoinGroupCurYears  is null  then null  ");
        sb.append("                                     when  FJoinGroupCurYears < 0  then 0 ");
        sb.append("                                     else  FJoinGroupCurYears ");
        sb.append("                               end ), ");
        sb.append("\t\t\t\t\t\t\t    ");
        sb.append("\t   fjoincompanyyears =  ( case  when fjoincompanyyears  is null  then null  ");
        sb.append("                                     when  fjoincompanyyears < 0  then 0 ");
        sb.append("                                     else  fjoincompanyyears ");
        sb.append("                               end ),\t ");
        sb.append("       fsysserviceyears =  ( case  when fsysserviceyears  is null  then null  ");
        sb.append("                                    when  fsysserviceyears < 0  then 0 ");
        sb.append("                                     else  fsysserviceyears ");
        sb.append("                               end ),\t\t\t\t\t\t\t\t\t\t    ");
        sb.append("\t\tfworktime =  ( case  when fworktime  is null  then null  ");
        sb.append("                             when  fworktime < 0  then 0 ");
        sb.append("                             else  fworktime ");
        sb.append("                            end ),\t\t ");
        sb.append("       fnewworktime =  ( case  when fnewworktime  is null  then null  ");
        sb.append("                             when  fnewworktime < 0  then 0 ");
        sb.append("                             else  fnewworktime ");
        sb.append("                            end )\t\t\t\t\t\t\t ");
        sb.append("         ");
        sb.append("    where ( fjoingroupyears is not null   and fjoingroupyears < 0 )    ");
        sb.append("        or( FJoinGroupCurYears is not null  and FJoinGroupCurYears < 0 )  ");
        sb.append("        or( fjoincompanyyears is not null  and fjoincompanyyears < 0 ) ");
        sb.append("\t\tor( fsysserviceyears is not null and fsysserviceyears < 0 ) ");
        sb.append("\t\tor( fworktime is not null and fworktime < 0) ");
        sb.append("\t\tor( fnewworktime is not null and fnewworktime < 0 ) ");
        return sb.toString();
    }

    @Override
    public void updatePositionFromEmpOrgRelation() throws BOSException {
    }

    @Override
    public void updatePersonAge() throws BOSException {
        StringBuffer updatePersonAgeSql = new StringBuffer();
        updatePersonAgeSql.append("update T_HR_PersonOtherInfo otherInfo set ").append(" FAge=select ISNULL ( ( ( YEAR ( GETDATE ( ) ) - YEAR ( person.FBirthday ) ) - ( CASE WHEN ( MONTH ( person.FBirthday ) - MONTH ( GETDATE ( ) ) ) > 0").append(" THEN 1 WHEN ( MONTH ( person.FBirthday ) - MONTH ( GETDATE ( ) ) < 0 ) THEN 0 WHEN ( DAYOFMONTH ( person.FBirthday ) - DAYOFMONTH ( GETDATE ( ) ) ) <= 0").append(" THEN 0 ELSE 1 END ) ) , 0 ) ").append(" from t_bd_person person").append(" where person.FBirthday is not null and person.fid=otherInfo.FPersonID").append("  where FPersonId in (select fid from t_bd_person where FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3') and FDeathDate is null");
        DbUtil.execute((Context)this.ctx, (String)updatePersonAgeSql.toString());
        StringBuffer updatePersonHisAgeSql = new StringBuffer();
        updatePersonHisAgeSql.append("update T_HR_PERSONOTHERINFOHIS otherInfohis set ").append(" FAge=select ISNULL ( ( ( YEAR ( GETDATE ( ) ) - YEAR ( person.FBirthday ) ) - ( CASE WHEN ( MONTH ( person.FBirthday ) - MONTH ( GETDATE ( ) ) ) > 0").append(" THEN 1 WHEN ( MONTH ( person.FBirthday ) - MONTH ( GETDATE ( ) ) < 0 ) THEN 0 WHEN ( DAYOFMONTH ( person.FBirthday ) - DAYOFMONTH ( GETDATE ( ) ) ) <= 0").append(" THEN 0 ELSE 1 END ) ) , 0 ) ").append(" from t_bd_person person").append(" where person.FBirthday is not null and person.fid=otherInfohis.FPersonID").append("  where FPersonId in (select fid from t_bd_person where FEmployeeTypeID!='00000000-0000-0000-0000-000000000031A29E85B3') and FDeathDate is null and FLEFFDT = {ts '2199-12-31 00:00:00'}");
        DbUtil.execute((Context)this.ctx, (String)updatePersonHisAgeSql.toString());
    }

    @Override
    public void updateSocialYears() throws BOSException {
        String updateSocialServiceYearsSQL = "update T_HR_PersonOtherInfo set  fsocialServiceYears = " + CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(isnull(FRetireDate,getdate())) - YEAR(isnull(fjobStartDate,getdate())) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(fjobStartDate,getdate())))/12.0 + (DAYOFMONTH(isnull(FRetireDate,getdate()))-DAYOFMONTH(isnull(fjobStartDate,getdate())))/365.0 - isnull(fadjustSerVal,0.0))");
        DbUtil.execute((Context)this.ctx, (String)updateSocialServiceYearsSQL);
        String fixSocialServiceYearsSql = "update T_HR_PersonOtherInfo set fsocialServiceYears = 0 where fsocialServiceYears is not null and fsocialServiceYears < 0";
        DbUtil.execute((Context)this.ctx, (String)fixSocialServiceYearsSql);
        String updateSocialServiceYearsHisSQL = "update T_HR_PersonOtherInfohis set  fsocialServiceYears = " + CommonUtil.getInstance().getRoundSelector(this.scale, this.roundMode, "YEAR(isnull(FRetireDate,getdate())) - YEAR(isnull(fjobStartDate,getdate())) + ((MONTH(isnull(FRetireDate,getdate()))-MONTH(isnull(fjobStartDate,getdate())))/12.0 + (DAYOFMONTH(isnull(FRetireDate,getdate()))-DAYOFMONTH(isnull(fjobStartDate,getdate())))/365.0 - isnull(fadjustSerVal,0.0))");
        DbUtil.execute((Context)this.ctx, (String)updateSocialServiceYearsHisSQL);
        String fixSocialServiceYearsHisSql = "update T_HR_PersonOtherInfohis set fsocialServiceYears = 0 where fsocialServiceYears is not null and fsocialServiceYears < 0";
        DbUtil.execute((Context)this.ctx, (String)fixSocialServiceYearsHisSql);
    }

    @Override
    public void updateJobGrade() throws BOSException {
        StringBuffer updateJobGradeSql = new StringBuffer();
        updateJobGradeSql.append("update t_hr_emporgrelation emporg set fjobgradeid = ").append("(select top 1 pp.fjobgrade from t_hr_personpositionhis pp where pp.fpersonid = emporg.fpersonid and pp.feffdt<=emporg.feffdt and pp.fleffdt >= emporg.feffdt) where fassignType = 1");
        DbUtil.execute((Context)this.ctx, (String)updateJobGradeSql.toString());
    }

    @Override
    public void deleteWorkYearTemp() throws BOSException {
        StringBuffer dropTableSql = new StringBuffer();
        dropTableSql.append("If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='t_hr_workyear_temp') ").append(" drop table t_hr_workyear_temp");
        DbUtil.execute((Context)this.ctx, (String)dropTableSql.toString());
        String createTableSql = "If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='t_hr_workyear_temp') Create Table t_hr_workyear_temp ( FPersonPositionID VARCHAR(44) ,FPersonID VARCHAR(44),FJoinGroupYears NUMERIC(28,6), FJoinGroupCurYears NUMERIC(28,6),FJoinCompanyYears NUMERIC(28,6), FSysServiceYears NUMERIC(28,10),  FNewWorkTime NUMERIC(28,2), FWorkTime INT DEFAULT 0);";
        DbUtil.execute((Context)this.ctx, (String)createTableSql);
        StringBuffer createIndexSql = new StringBuffer();
        createIndexSql.append(" create index index_FPersonPositionID on t_hr_workyear_temp(FPersonPositionID) ");
        DbUtil.execute((Context)this.ctx, (String)createIndexSql.toString());
    }
}

