/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.classify.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.classify.AttachClassifyRelCollection;
import com.kingdee.eas.hr.emp.classify.AttachClassifyRelInfo;
import com.kingdee.eas.hr.emp.classify.AttachLabelRelCollection;
import com.kingdee.eas.hr.emp.classify.AttachLabelRelFactory;
import com.kingdee.eas.hr.emp.classify.AttachLabelRelInfo;
import com.kingdee.eas.hr.emp.classify.ClassifyFactory;
import com.kingdee.eas.hr.emp.classify.ClassifyInfo;
import com.kingdee.eas.hr.emp.classify.EntityClassifyRelCollection;
import com.kingdee.eas.hr.emp.classify.EntityClassifyRelFactory;
import com.kingdee.eas.hr.emp.classify.EntityClassifyRelInfo;
import com.kingdee.eas.hr.emp.classify.EntityLabelRelCollection;
import com.kingdee.eas.hr.emp.classify.EntityLabelRelFactory;
import com.kingdee.eas.hr.emp.classify.EntityLabelRelInfo;
import com.kingdee.eas.hr.emp.classify.LabelInfo;
import com.kingdee.eas.hr.emp.classify.app.AbstractAttachClassifyRelControllerBean;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AttachClassifyRelControllerBean
extends AbstractAttachClassifyRelControllerBean {
    private static final long serialVersionUID = 8171532068636107425L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.classify.app.AttachClassifyRelControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK objectPK = super._addnew(ctx, model);
        AttachClassifyRelInfo attachClassifyInfo = (AttachClassifyRelInfo)model;
        Boolean isManualClassify = attachClassifyInfo.isManualClassify();
        if (isManualClassify != null && !isManualClassify.booleanValue() && !StringUtils.isEmpty((CharSequence)attachClassifyInfo.getAttachExtId())) {
            this.dealLabelRule(ctx, attachClassifyInfo);
        }
        return objectPK;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AttachClassifyRelInfo attachClassifyRelInfo = super.getAttachClassifyRelInfo(ctx, pk);
        AttachLabelRelFactory.getLocalInstance(ctx).delete("where attachClassifyRel = '" + pk.toString() + "'");
        super._delete(ctx, pk);
        if (attachClassifyRelInfo.getAttachment() != null && attachClassifyRelInfo.getAttachment().getId() != null && StringUtils.isEmpty((CharSequence)attachClassifyRelInfo.getAttachExtId())) {
            ObjectUuidPK attachmentId = new ObjectUuidPK(attachClassifyRelInfo.getAttachment().getId().toString());
            AttachmentFactory.getLocalInstance((Context)ctx).delete((IObjectPK)attachmentId);
        }
    }

    protected void dealLabelRule(Context ctx, AttachClassifyRelInfo attachClassifyInfo) throws EASBizException, BOSException {
        String classifyId = attachClassifyInfo.getClassify().getId().toString();
        ClassifyInfo classifyInfo = ClassifyFactory.getLocalInstance(ctx).getClassifyInfo("where id = '" + classifyId + "'");
        FilterInfo filter = new FilterInfo();
        if (classifyInfo.getEntityClassifyRel() == null || classifyInfo.getEntityClassifyRel().getId() == null) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)classifyInfo.getEntityClassifyRel().getId().toString(), CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("availableClassifyEntity.entityNameVal"));
        view.setSelector(sic);
        EntityClassifyRelCollection entityCollection = EntityClassifyRelFactory.getLocalInstance(ctx).getEntityClassifyRelCollection(view);
        if (entityCollection.size() == 0) {
            return;
        }
        EntityClassifyRelInfo ruleInfo = entityCollection.get(0);
        ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface((Context)ctx, (String)ruleInfo.getAvailableClassifyEntity().getEntityNameVal());
        SHRAttachmentExtInfo attachExtInfo = SHRAttachmentExtFactory.getLocalInstance((Context)ctx).getSHRAttachmentExtInfo(String.format(" where id = '%s' ", attachClassifyInfo.getAttachExtId()));
        String oql = String.format(" where entityClassifyRel = '%s' and state = 1", entityCollection.get(0).getId().toString());
        EntityLabelRelCollection labelRuleColl = EntityLabelRelFactory.getLocalInstance(ctx).getEntityLabelRelCollection(oql);
        for (int j = 0; j < labelRuleColl.size(); ++j) {
            String[] arr;
            List<String> list;
            String extPropertyName;
            String propertyName;
            String conditionOql;
            EntityLabelRelInfo labelRuleInfo = labelRuleColl.get(j);
            if (!StringUtils.isEmpty((CharSequence)labelRuleInfo.getCondition()) && !iCoreBase.exists(conditionOql = String.format(" where ( %s ) and id ='%s' ", labelRuleInfo.getCondition(), attachExtInfo.getBoID())) || !StringUtils.isEmpty((CharSequence)(propertyName = labelRuleInfo.getPropertyName())) && (StringUtils.isEmpty((CharSequence)(extPropertyName = attachExtInfo.getPropertyName())) || !(list = Arrays.asList(arr = propertyName.split(","))).contains(extPropertyName))) continue;
            String labelVal = "";
            if (0 == labelRuleInfo.getLabelType().getValue()) {
                Object object;
                CoreBaseCollection coreBaseColl;
                String attributeVal = labelRuleInfo.getAttributeVal();
                if (!StringUtils.isEmpty((CharSequence)attributeVal) && attributeVal.endsWith("]") && attributeVal.indexOf("[") > -1) {
                    attributeVal = attributeVal.substring(attributeVal.lastIndexOf("[") + 1, attributeVal.lastIndexOf("]"));
                }
                PropertyInfo propertyInfo = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)ruleInfo.getAvailableClassifyEntity().getEntityNameVal(), (String)attributeVal);
                String conditionOql2 = String.format(" select %s where id ='%s' ", attributeVal, attachExtInfo.getBoID());
                if (propertyInfo instanceof LinkPropertyInfo) {
                    conditionOql2 = String.format(" select %s.name where id ='%s' ", attributeVal, attachExtInfo.getBoID());
                }
                if ((coreBaseColl = iCoreBase.getCollection(conditionOql2)).isEmpty()) continue;
                CoreBaseInfo coreBaseInfo = coreBaseColl.get(0);
                Object object2 = object = coreBaseInfo.containsKey(attributeVal) ? coreBaseInfo.get(attributeVal) : null;
                if (object == null) continue;
                if (propertyInfo instanceof LinkPropertyInfo) {
                    DataBaseInfo dataBaseInfo = (DataBaseInfo)object;
                    labelVal = dataBaseInfo.getName();
                } else if (propertyInfo instanceof OwnPropertyInfo && DataType.ENUM.equals((Object)((OwnPropertyInfo)propertyInfo).getDataType())) {
                    String metadataRef = ((OwnPropertyInfo)propertyInfo).getMetaDataRef();
                    Object objEnum = MetaDataUtil.findEnumByValue((String)metadataRef, (Object)object);
                    labelVal = String.valueOf(objEnum);
                } else if (object instanceof Boolean) {
                    String yes = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"YES", (Context)ctx);
                    String not = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"NOT", (Context)ctx);
                    labelVal = (Boolean)object != false ? yes : not;
                } else {
                    labelVal = String.valueOf(coreBaseInfo.get(attributeVal));
                }
            } else if (1 == labelRuleInfo.getLabelType().getValue()) {
                labelVal = labelRuleInfo.getFixedVal();
            }
            if (StringUtils.isEmpty((CharSequence)labelVal)) continue;
            LabelInfo labelInfo = new LabelInfo();
            labelInfo.setName(labelVal);
            AttachLabelRelFactory.getLocalInstance(ctx).batchLabelAdjustAdd(attachClassifyInfo.getId().toString(), labelInfo);
        }
        if (labelRuleColl.size() > 0) {
            this.refreshAttachClassifyRelLabel(ctx, attachClassifyInfo.getId().toString(), false);
        }
    }

    @Override
    protected void _batchClassifyAdjust(Context ctx, String attachClassifyRelIds, String newClassifyId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((CharSequence)attachClassifyRelIds)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)newClassifyId)) {
            return;
        }
        ClassifyInfo classifyInfo = new ClassifyInfo();
        classifyInfo.setId(BOSUuid.read((String)newClassifyId));
        String[] attachClassifyRelIdArray = attachClassifyRelIds.split(",");
        HashSet<String> attachClassifyRelIdSet = new HashSet<String>(Arrays.asList(attachClassifyRelIdArray));
        AttachClassifyRelCollection collection = new AttachClassifyRelCollection();
        for (String attachClassifyRelId : attachClassifyRelIdSet) {
            AttachClassifyRelInfo attachClassifyRelInfo = new AttachClassifyRelInfo();
            attachClassifyRelInfo.setId(BOSUuid.read((String)attachClassifyRelId));
            attachClassifyRelInfo.setClassify(classifyInfo);
            attachClassifyRelInfo.setManualClassify(true);
            collection.add(attachClassifyRelInfo);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("classify");
        selector.add("manualClassify");
        super._updatePartialBatchData(ctx, (IObjectCollection)collection, selector);
    }

    @Override
    protected void _refreshAttachClassifyRelLabel(Context ctx, String attachClassifyRelIds, boolean manualClassify) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((CharSequence)attachClassifyRelIds)) {
            return;
        }
        String[] attachClassifyRelIdArray = attachClassifyRelIds.split(",");
        HashSet<String> attachClassifyRelIdSet = new HashSet<String>(Arrays.asList(attachClassifyRelIdArray));
        this.refreshAttachClassifyRelLabel(ctx, attachClassifyRelIdSet, manualClassify);
    }

    protected void refreshAttachClassifyRelLabel(Context ctx, Set<String> attachClassifyRelIdSet, boolean manualClassify) throws BOSException, EASBizException {
        if (attachClassifyRelIdSet == null || attachClassifyRelIdSet.size() == 0) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("attachClassifyRel.id");
        selector.add("attachClassifyRel.label");
        selector.add("label.id");
        selector.add("label.name");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("attachClassifyRel.id", attachClassifyRelIdSet, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setSelector(selector);
        entityViewInfo.setFilter(filter);
        SorterItemInfo sorterItem = new SorterItemInfo("label.name");
        sorterItem.setSortType(SortType.ASCEND);
        entityViewInfo.getSorter().add(sorterItem);
        AttachLabelRelCollection attachLabelRelCollection = AttachLabelRelFactory.getLocalInstance(ctx).getAttachLabelRelCollection(entityViewInfo);
        HashMap<String, TreeSet<String>> attachClassifyRelToLabelMap = new HashMap<String, TreeSet<String>>();
        if (attachLabelRelCollection != null && attachLabelRelCollection.size() > 0) {
            for (int i = 0; i < attachLabelRelCollection.size(); ++i) {
                AttachLabelRelInfo attachLabelRelInfo = attachLabelRelCollection.get(i);
                AttachClassifyRelInfo attachClassifyRelInfo = attachLabelRelInfo.getAttachClassifyRel();
                String attachClassifyRelId = attachClassifyRelInfo.getId().toString();
                LabelInfo labelInfo = attachLabelRelInfo.getLabel();
                String labelName = labelInfo.getName();
                TreeSet<String> labelNameSet = (TreeSet<String>)attachClassifyRelToLabelMap.get(attachClassifyRelId);
                if (labelNameSet == null) {
                    labelNameSet = new TreeSet<String>();
                    attachClassifyRelToLabelMap.put(attachClassifyRelId, labelNameSet);
                }
                labelNameSet.add(labelName);
            }
        }
        AttachClassifyRelCollection needUpdateCollection = new AttachClassifyRelCollection();
        for (String needUpdateAttachClassifyId : attachClassifyRelIdSet) {
            String labelStr = "";
            Set labelNameSet = (Set)attachClassifyRelToLabelMap.get(needUpdateAttachClassifyId);
            if (labelNameSet != null && labelNameSet.size() > 0) {
                labelStr = "\u3010" + StringUtils.join((Iterable)labelNameSet, (String)"\u3011\u3010") + "\u3011";
            }
            AttachClassifyRelInfo attachClassifyRelInfo = new AttachClassifyRelInfo();
            attachClassifyRelInfo.setId(BOSUuid.read((String)needUpdateAttachClassifyId));
            attachClassifyRelInfo.setLabelArray(labelStr);
            attachClassifyRelInfo.setManualClassify(manualClassify);
            needUpdateCollection.add(attachClassifyRelInfo);
        }
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add("labelArray");
        updateSelector.add("manualClassify");
        this._updatePartialBatchData(ctx, (IObjectCollection)needUpdateCollection, updateSelector);
    }
}

