/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanCollection;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanFactory;
import com.kingdee.eas.hr.emp.probation.PersonProbationTrainPlanInfo;
import com.kingdee.eas.hr.emp.probation.ProbationException;
import com.kingdee.eas.hr.emp.probation.ProbationTrainMarkFactory;
import com.kingdee.eas.hr.emp.probation.ProbationTrainMarkInfo;
import com.kingdee.eas.hr.emp.probation.ProbationTrainPeriodCollection;
import com.kingdee.eas.hr.emp.probation.ProbationTrainPeriodInfo;
import com.kingdee.eas.hr.emp.probation.ProbationTrainPlanTaskFactory;
import com.kingdee.eas.hr.emp.probation.ProbationTrainProgramFactory;
import com.kingdee.eas.hr.emp.probation.ProbationTrainProgramInfo;
import com.kingdee.eas.hr.emp.probation.app.AbstractPersonProbationTrainPlanControllerBean;
import com.kingdee.eas.hr.emp.probation.app.ProbationPermanIntentionEnum;
import com.kingdee.eas.hr.emp.probation.app.ProbationTrainStateEnum;
import com.kingdee.eas.hr.emp.probation.util.ProbationTrainPlanUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.shareservice.util.JobUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonProbationTrainPlanControllerBean
extends AbstractPersonProbationTrainPlanControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(PersonProbationTrainPlanControllerBean.class);

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PersonProbationTrainPlanInfo trainPlanInfo = (PersonProbationTrainPlanInfo)model;
        trainPlanInfo.setPlanState(ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias());
        this.setTrainPlanSpecialField(ctx, trainPlanInfo);
        String personId = trainPlanInfo.getPerson().getId().toString();
        this.checkBeforeTrain(ctx, trainPlanInfo, trainPlanInfo.getCareerID());
        if (logger.isInfoEnabled()) {
            logger.info("PersonProbationTrainPlanControllerBean.Person: " + personId + ", career: " + trainPlanInfo.getCareerID());
        }
        ProbationTrainProgramInfo programInfo = null;
        if (trainPlanInfo.getTrainProgram() == null) {
            programInfo = ProbationTrainPlanUtil.getFitestProbationTrainProgram(ctx, personId);
            trainPlanInfo.setTrainProgram(programInfo);
        } else {
            BOSUuid programId = trainPlanInfo.getTrainProgram().getId();
            programInfo = ProbationTrainProgramFactory.getLocalInstance(ctx).getProbationTrainProgramInfo((IObjectPK)new ObjectUuidPK(programId));
        }
        ProbationTrainMarkInfo trainMarkInfo = programInfo.getTrainMark();
        ProbationTrainMarkInfo trainMarkInfoCopy = this.getProbationTrainMark(ctx, trainMarkInfo);
        trainPlanInfo.setTrainMarkSet(trainMarkInfoCopy);
        trainPlanInfo.setIsAbortAll(false);
        ProbationTrainMarkFactory.getLocalInstance(ctx).save((CoreBaseInfo)trainPlanInfo.getTrainMarkSet());
        IObjectPK trainPlanInfoId = super._addnew(ctx, (IObjectValue)trainPlanInfo);
        ProbationTrainPlanUtil.generateActivity(ctx, trainPlanInfo);
        return trainPlanInfoId;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonProbationTrainPlanInfo trainPlanInfo = (PersonProbationTrainPlanInfo)model;
        trainPlanInfo.remove("trainProgram");
        trainPlanInfo.remove("trainMarkSet");
        boolean isTempSave = trainPlanInfo.getBoolean("isTempSave");
        if (logger.isInfoEnabled()) {
            logger.info("PersonProbationTrainPlanControllerBean.isTempSave: " + isTempSave);
        }
        if (isTempSave) {
            super._update(ctx, pk, model);
        } else {
            this.setTrainPlanSpecialField(ctx, trainPlanInfo);
            this.checkBeforeTrain(ctx, trainPlanInfo, trainPlanInfo.getCareerID());
            String planState = trainPlanInfo.getPlanState();
            if (!(ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias().equals(planState) || ProbationTrainStateEnum.PLANSTATE_END.getAlias().equals(planState) || ProbationTrainStateEnum.PLANSTATE_ABORT.getAlias().equals(planState))) {
                boolean isLastAc = ProbationTrainPlanUtil.checkIsLastActivity(ctx, trainPlanInfo.getId().toString());
                if (logger.isInfoEnabled()) {
                    logger.info("PersonProbationTrainPlanControllerBean.isLastAc: " + isLastAc);
                }
                if (isLastAc) {
                    ProbationPermanIntentionEnum intention = trainPlanInfo.getPermanIntention();
                    int periodNum = trainPlanInfo.getPeriodNum();
                    int maxPeriod = ProbationTrainPlanUtil.getPersonProbationTrainPlanMaxPeriod(ctx, trainPlanInfo.getPerson().getId().toString());
                    if (ProbationPermanIntentionEnum.CONTINUE.equals((Object)intention) && periodNum == maxPeriod) {
                        throw new ProbationException(ProbationException.CANNOT_CONTINUE);
                    }
                }
            }
            super._update(ctx, pk, model);
            ProbationTrainPlanUtil.generateActivity(ctx, trainPlanInfo);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sicoll = new SelectorItemCollection();
        sicoll.add(new SelectorItemInfo("id"));
        sicoll.add(new SelectorItemInfo("trainMarkSet"));
        PersonProbationTrainPlanInfo planInfo = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanInfo(pk, sicoll);
        String oql = " where trainPlan = '" + pk + "'";
        ProbationTrainPlanTaskFactory.getLocalInstance(ctx).delete(oql);
        String markSetId = planInfo.getTrainMarkSet() != null ? planInfo.getTrainMarkSet().getId().toString() : "";
        String markOql = " where id = '" + markSetId + "'";
        ProbationTrainMarkFactory.getLocalInstance(ctx).delete(markOql);
        super._delete(ctx, pk);
    }

    protected PersonProbationTrainPlanInfo setTrainPlanSpecialField(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo) throws BOSException, EASBizException {
        if (trainPlanInfo.getPerson() == null) {
            throw new ProbationException(ProbationException.PERON_MUST);
        }
        String personId = trainPlanInfo.getPerson().getId().toString();
        if (trainPlanInfo.getTutor() == null) {
            PersonInfo tutor = ProbationTrainPlanUtil.getPeronTutor(ctx, personId);
            trainPlanInfo.setTutor(tutor);
        }
        String careerID = ProbationTrainPlanUtil.getPersonCareerID(ctx, personId);
        trainPlanInfo.setCareerID(careerID);
        boolean useDefault = ProbationTrainPlanUtil.getEmpHRORelationUseDefault(ctx, trainPlanInfo, 2);
        trainPlanInfo.setUseDefault(useDefault);
        return trainPlanInfo;
    }

    @Override
    protected String _createTrainPlan(Context ctx, String personId) throws BOSException, EASBizException {
        StringBuilder result = new StringBuilder();
        PersonProbationTrainPlanInfo planInfo = new PersonProbationTrainPlanInfo();
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)personId));
        planInfo.setPerson(personInfo);
        PersonInfo tutor = planInfo.getTutor();
        ProbationTrainPlanUtil.checkPeronEmpType(ctx, personInfo.getId().toString(), tutor);
        planInfo = ProbationTrainPlanUtil.updateTrainPlanToLatestInfo(ctx, planInfo);
        boolean isHaveTrain = ProbationTrainPlanUtil.checkPersonProbationTrainState(ctx, personId);
        if (isHaveTrain) {
            throw new ProbationException(ProbationException.CREATE_TRAIN_FIELD);
        }
        Date enrollDate = ProbationTrainPlanUtil.getPersonEnrollDate(ctx, personId);
        if (logger.isInfoEnabled()) {
            logger.info("PersonPro.bationTrainPlanControllerBean.enrollDate: " + enrollDate);
        }
        ProbationTrainProgramInfo programInfo = ProbationTrainPlanUtil.getFitestProbationTrainProgram(ctx, personId);
        ProbationTrainPeriodCollection trainPeriod = programInfo.getTrainPeriod();
        for (int i = 0; i < trainPeriod.size(); ++i) {
            PersonProbationTrainPlanInfo planTemp = new PersonProbationTrainPlanInfo();
            planTemp = (PersonProbationTrainPlanInfo)planInfo.clone();
            planTemp.setId(null);
            ProbationTrainPeriodInfo periodInfo = trainPeriod.get(i);
            int index = periodInfo.getIndex();
            Map<String, String> periodNameMap = ProbationTrainPlanUtil.getProbationTrainPlanName(ctx, personId, index);
            int beginDateNum = periodInfo.getBeginDateNum();
            int endateNum = periodInfo.getEndDateNum();
            Date beginDate = this.getDateByProgramDate(enrollDate, beginDateNum);
            Date endDate = this.getDateByProgramDate(enrollDate, endateNum);
            String planTempNumber = this.generateTrainPlanNumber(ctx, planTemp);
            planTemp.setBeginDate(beginDate);
            planTemp.setEndDate(endDate);
            planTemp.setName(periodNameMap.get("L1"), LocaleUtils.locale_l1);
            planTemp.setName(periodNameMap.get("L2"), LocaleUtils.locale_l2);
            planTemp.setName(periodNameMap.get("L3"), LocaleUtils.locale_l3);
            planTemp.setPeriodNum(index);
            planTemp.setNumber(planTempNumber);
            planTemp.setActivitySolution(periodInfo.getActivitySolution());
            planTemp.setPlanState(ProbationTrainStateEnum.PLANSTATE_UNSTART.getAlias());
            planTemp.setTrainProgram(programInfo);
            IObjectPK planId = this._addnew(ctx, (IObjectValue)planTemp);
            result.append(planId);
            result.append(",");
        }
        return result.toString();
    }

    public ProbationTrainMarkInfo getProbationTrainMark(Context ctx, ProbationTrainMarkInfo markSetInfo) throws EASBizException, BOSException {
        if (markSetInfo == null || StringUtils.isEmpty((String)markSetInfo.getId().toString())) {
            throw new ProbationException(ProbationException.TRAINMARK_SET);
        }
        ProbationTrainMarkInfo markInfo = ProbationTrainMarkFactory.getLocalInstance(ctx).getProbationTrainMarkInfo((IObjectPK)new ObjectUuidPK(markSetInfo.getId()));
        ProbationTrainMarkInfo markInfoCopy = (ProbationTrainMarkInfo)markInfo.clone();
        markInfoCopy.setCreateTime(new Timestamp(System.currentTimeMillis()));
        markInfoCopy.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        markInfoCopy.setId(null);
        return markInfoCopy;
    }

    public Date getDateByProgramDate(Date enrollDate, int beginDateNum) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(enrollDate);
        calendar.add(5, beginDateNum);
        return calendar.getTime();
    }

    public String generateTrainPlanNumber(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = this.getOrgIdByCU(ctx);
        String number = iCodingRuleManager.getNumber((IObjectValue)trainPlanInfo, orgId);
        while (this.exists(ctx, "where number = '" + number + "'")) {
            number = iCodingRuleManager.getNumber((IObjectValue)trainPlanInfo, orgId);
        }
        return number;
    }

    private String getOrgIdByCU(Context ctx) {
        String orgId;
        OrgUnitInfo mainOrg = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        return orgId;
    }

    public void checkPeronEmpTypeAndTrainPlans(Context ctx, String personId, String careerID) throws BOSException, ProbationException {
        String oql = " where person = '" + personId + "' and careerID = '" + careerID + "'";
        PersonProbationTrainPlanCollection coll = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanCollection(oql);
        if (coll.size() > 0) {
            throw new ProbationException(ProbationException.CREATE_TRAIN_FIELD);
        }
    }

    public void checkPlanDate(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo) throws ProbationException, BOSException {
        Date beginDate = trainPlanInfo.getBeginDate();
        Date endDate = trainPlanInfo.getEndDate();
        if (beginDate == null || endDate == null || beginDate.after(endDate)) {
            throw new ProbationException(ProbationException.PERIOD_DATE_ERROR);
        }
        String personId = trainPlanInfo.getPerson().getId().toString();
        Date enrollDate = ProbationTrainPlanUtil.getPersonEnrollDate(ctx, personId);
        if (beginDate.before(enrollDate)) {
            throw new ProbationException(ProbationException.EARLIER_THAN_ENROLLDATE);
        }
    }

    public void checkBeforeTrain(Context ctx, PersonProbationTrainPlanInfo trainPlanInfo, String careerID) throws BOSException, EASBizException {
        boolean isExist;
        PersonInfo person = trainPlanInfo.getPerson();
        if (person == null) {
            throw new ProbationException(ProbationException.PERSON_NOT_EXIST);
        }
        int nowPeriodNum = trainPlanInfo.getPeriodNum();
        String oql = "where person = '" + person.getId() + "' and periodNum = " + nowPeriodNum + " and careerID = '" + careerID + "'";
        if (trainPlanInfo.getId() != null) {
            oql = oql + " and id <> '" + trainPlanInfo.getId() + "'";
        }
        if (isExist = PersonProbationTrainPlanFactory.getLocalInstance(ctx).exists(oql)) {
            throw new ProbationException(ProbationException.ALREADY_PERIOD);
        }
        PersonInfo tutor = trainPlanInfo.getTutor();
        ProbationTrainPlanUtil.checkPeronEmpType(ctx, person.getId().toString(), tutor);
        this.checkPlanDate(ctx, trainPlanInfo);
    }

    @Override
    protected String _abortTrainPlan(Context ctx, String trainPlanId, String abortReason) throws BOSException, EASBizException {
        PersonProbationTrainPlanInfo trainPlanInfo = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanInfo((IObjectPK)new ObjectUuidPK(trainPlanId));
        ProbationTrainPlanUtil.abortPersonTrainPeriod(ctx, trainPlanInfo, abortReason, ProbationTrainStateEnum.PLANSTATE_ABORT.toString());
        Set receiver = JobUtils.getExecutor((Context)ctx, (String)trainPlanInfo.getId().toString(), (int)3);
        ProbationTrainPlanUtil.abortActivity(ctx, trainPlanInfo, abortReason);
        ProbationTrainPlanUtil.sendActivityAbortNotice(ctx, trainPlanInfo, receiver, 1);
        return trainPlanId;
    }

    @Override
    protected String _resetTrainPlan(Context ctx, String trainPlanId) throws BOSException, EASBizException {
        PersonProbationTrainPlanInfo trainPlanInfo = PersonProbationTrainPlanFactory.getLocalInstance(ctx).getPersonProbationTrainPlanInfo((IObjectPK)new ObjectUuidPK(trainPlanId));
        String abortReason = "";
        String oldPlanState = trainPlanInfo.getPlanState();
        if (!ProbationTrainStateEnum.PLANSTATE_ABORT.getAlias().equals(oldPlanState)) {
            Set receiver = JobUtils.getExecutor((Context)ctx, (String)trainPlanInfo.getId().toString(), (int)3);
            ProbationTrainPlanUtil.abortActivity(ctx, trainPlanInfo, abortReason);
            ProbationTrainPlanUtil.sendActivityAbortNotice(ctx, trainPlanInfo, receiver, 2);
        }
        trainPlanInfo = ProbationTrainPlanUtil.updateTrainPlanToLatestInfo(ctx, trainPlanInfo);
        trainPlanInfo.setAbortReason(abortReason);
        trainPlanInfo.setPlanState(ProbationTrainStateEnum.PLANSTATE_UNSTART.toString());
        trainPlanInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        trainPlanInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        PersonProbationTrainPlanFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(trainPlanId), trainPlanInfo);
        return trainPlanId;
    }
}

