/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpHRORelationHisInfo;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.app.util.EmpPostRankUtil;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.emp.probation.IProbationAppraiseBizBillEntry;
import com.kingdee.eas.hr.emp.probation.IProbationAppraiseBizBilljudges;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBilljudgesCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBilljudgesFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBilljudgesInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseContentFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseTempInfo;
import com.kingdee.eas.hr.emp.probation.ProbationException;
import com.kingdee.eas.hr.emp.probation.app.AbstractProbationAppraiseBizBillControllerBean;
import com.kingdee.eas.hr.emp.probation.app.AppraiseResult;
import com.kingdee.eas.hr.emp.probation.app.ProbationAppraiseJudgeStateEnum;
import com.kingdee.eas.hr.emp.probation.app.ProbationAppraiseStateEnum;
import com.kingdee.eas.hr.emp.probation.util.JudgeCountUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationGoalUtil;
import com.kingdee.eas.hr.emp.probation.util.ProbationMessageUtil;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.ActivitySolutionInfo;
import com.kingdee.shr.shareservice.CoActivityJobOptFacadeFactory;
import com.kingdee.shr.shareservice.util.JobUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbationAppraiseBizBillControllerBean
extends AbstractProbationAppraiseBizBillControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ProbationAppraiseBizBillControllerBean.class);

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProbationAppraiseBizBillInfo info = (ProbationAppraiseBizBillInfo)model;
        this.setRelevantFieldBeforeAddnew(ctx, info);
        IObjectPK pk = super._addnew(ctx, model);
        this.ProcessingCoactivityJob(ctx, info);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ProbationAppraiseBizBillInfo info = (ProbationAppraiseBizBillInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("judges.id"));
        selector.add(new SelectorItemInfo("judges.*"));
        ProbationAppraiseBizBillInfo oldInfo = this.getProbationAppraiseBizBillInfo(ctx, pk, selector);
        info.getJudges().clear();
        info.getJudges().addCollection(oldInfo.getJudges());
        this.setRelevantFieldBeforeUpdate(ctx, info);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _restartEvaluation(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        selector.add(new SelectorItemInfo("judges.*"));
        ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo = this.getProbationAppraiseBizBillInfo(ctx, pk, selector);
        Set userSet = JobUtils.getNotFinishExecutor((Context)ctx, (String)probationAppraiseBizBillInfo.getId().toString());
        this.restartCoactivityJob(ctx, probationAppraiseBizBillInfo.getId().toString());
        this.refreshEvaluationInformation(ctx, probationAppraiseBizBillInfo);
        this.updateJudgesInfo(ctx, probationAppraiseBizBillInfo);
        this._update(ctx, pk, (IObjectValue)probationAppraiseBizBillInfo);
        this.deleteAttachment(ctx, probationAppraiseBizBillInfo);
        this.ProcessingCoactivityJob(ctx, probationAppraiseBizBillInfo);
        this.sendMessage(ctx, probationAppraiseBizBillInfo, userSet, "restartEvaluation");
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.id"));
        selector.add(new SelectorItemInfo("entrys.name"));
        ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo = this.getProbationAppraiseBizBillInfo(ctx, pk, selector);
        Set userSet = JobUtils.getNotFinishExecutor((Context)ctx, (String)probationAppraiseBizBillInfo.getId().toString());
        this.deleteCoactivityJob(ctx, probationAppraiseBizBillInfo.getId().toString());
        ProbationAppraiseContentFactory.getLocalInstance(ctx).delete(" where billId = '" + probationAppraiseBizBillInfo.getId().toString() + "'");
        super._delete(ctx, pk);
        this.sendMessage(ctx, probationAppraiseBizBillInfo, userSet, "delete");
    }

    @Override
    protected void _saveResult(Context ctx, IObjectValue model, String jobId) throws BOSException, EASBizException {
        ProbationAppraiseBizBillInfo info = (ProbationAppraiseBizBillInfo)model;
        if (info.getEntrys().size() > 0) {
            AppraiseResult resolution;
            ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = info.getEntrys().get(0);
            this.updateResolutionInformation(ctx, probationAppraiseBizBillEntryInfo);
            if (!StringUtils.isEmpty((String)jobId) && (resolution = probationAppraiseBizBillEntryInfo.getResolution()) != null) {
                this.withdrawJudgesActivity(ctx, info, resolution);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("jobId", jobId);
                param.put("billId", info.getId().toString());
                CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).pass(param);
            }
        }
    }

    @Override
    protected void _deleteJudge(Context ctx, String billId, String personId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        viewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IProbationAppraiseBizBilljudges judgesLocalInstance = ProbationAppraiseBizBilljudgesFactory.getLocalInstance(ctx);
        ProbationAppraiseBizBilljudgesCollection probationAppraiseBizBilljudgesCollection = judgesLocalInstance.getProbationAppraiseBizBilljudgesCollection(viewInfo);
        if (probationAppraiseBizBilljudgesCollection.size() > 0) {
            ProbationAppraiseBizBilljudgesInfo probationAppraiseBizBilljudgesInfo = probationAppraiseBizBilljudgesCollection.get(0);
            BOSUuid jobId = probationAppraiseBizBilljudgesInfo.getJobId();
            if (jobId != null) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("jobId", probationAppraiseBizBilljudgesInfo.getJobId().toString());
                CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob(param);
            }
            judgesLocalInstance.delete((IObjectPK)new ObjectUuidPK(probationAppraiseBizBilljudgesInfo.getId().toString()));
            if (probationAppraiseBizBilljudgesInfo.getState() == ProbationAppraiseJudgeStateEnum.SUBMITING) {
                selector.clear();
                selector.add(new SelectorItemInfo("id"));
                selector.add(new SelectorItemInfo("entrys.name"));
                ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo = this.getProbationAppraiseBizBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), selector);
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label29", (Context)ctx);
                message = MessageFormat.format(message, probationAppraiseBizBillInfo.getEntrys().get(0).getName());
                HashMap<Locale, String> messageTitle = this.getMessageTitle(message);
                HashMap<Locale, String> messageBody = this.getMessageBody(message);
                HashSet<String> judgePersonId = new HashSet<String>();
                PersonInfo judgePersonInfo = probationAppraiseBizBilljudgesInfo.getPerson();
                if (judgePersonInfo != null) {
                    judgePersonId.add(judgePersonInfo.getId().toString());
                }
                Set<String> receivers = this.getReceivers(ctx, judgePersonId);
                ProbationMessageUtil.sendMessage(ctx, messageTitle, messageBody, "", receivers, "sys_auto_send");
            }
        }
        JudgeCountUtil.refreshCount(ctx, billId);
    }

    @Override
    protected void _returnJudge(Context ctx, String billId, String personId) throws BOSException, EASBizException {
        ProbationAppraiseBizBilljudgesInfo probationAppraiseBizBilljudgesInfo;
        BOSUuid jobId;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        viewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IProbationAppraiseBizBilljudges judgesLocalInstance = ProbationAppraiseBizBilljudgesFactory.getLocalInstance(ctx);
        ProbationAppraiseBizBilljudgesCollection probationAppraiseBizBilljudgesCollection = judgesLocalInstance.getProbationAppraiseBizBilljudgesCollection(viewInfo);
        if (probationAppraiseBizBilljudgesCollection.size() > 0 && (jobId = (probationAppraiseBizBilljudgesInfo = probationAppraiseBizBilljudgesCollection.get(0)).getJobId()) != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("jobId", probationAppraiseBizBilljudgesInfo.getJobId().toString());
            param.put("needDeleteData", false);
            CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob(param);
            param = new HashMap();
            HashSet<String> userSet = new HashSet<String>();
            UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id where person ='" + personId + "' and isDelete=0 and isForbidden=0");
            for (int i = 0; i < userColl.size(); ++i) {
                userSet.add(userColl.get(i).getId().toString());
            }
            param.put("userSet", userSet);
            param.put("judgeId", personId);
            selector.clear();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("entrys.name"));
            ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo = this.getProbationAppraiseBizBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), selector);
            String subject = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label30", (Context)ctx);
            subject = MessageFormat.format(subject, probationAppraiseBizBillInfo.getEntrys().get(0).getName());
            param.put("subject", subject);
            CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).createJobByActivity(null, "appraise_judge_score", billId, param);
        }
    }

    protected void setRelevantFieldBeforeAddnew(Context ctx, ProbationAppraiseBizBillInfo info) throws EASBizException, BOSException {
        ProbationAppraiseBizBillEntryCollection entrys = info.getEntrys();
        if (entrys.size() > 0) {
            ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = entrys.get(0);
            PersonInfo personInfo = probationAppraiseBizBillEntryInfo.getPerson();
            if (info.get("isFromImport") == null && probationAppraiseBizBillEntryInfo.getProbationAppraiseTemp() == null) {
                String rangeTempId = ProbationGoalUtil.getRangeTempId(ctx, personInfo.getId().toString(), this.isConditionAnd(ctx), 3);
                ProbationAppraiseTempInfo tempInfo = new ProbationAppraiseTempInfo();
                tempInfo.setId(BOSUuid.read((String)rangeTempId));
                probationAppraiseBizBillEntryInfo.setProbationAppraiseTemp(tempInfo);
            }
            probationAppraiseBizBillEntryInfo.setAppraiseState(ProbationAppraiseStateEnum.INPROGRESS);
            EmpHRORelationHisInfo empRelationInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, personInfo.getId().toString());
            probationAppraiseBizBillEntryInfo.setUseDefault(empRelationInfo.isUseDefault());
            probationAppraiseBizBillEntryInfo.setHrOrgUnit(info.getHrOrgUnit());
            if (info.getJudges() != null) {
                probationAppraiseBizBillEntryInfo.setUnSubmitCount(info.getJudges().size());
                probationAppraiseBizBillEntryInfo.setJudgeCount(info.getJudges().size());
            } else {
                probationAppraiseBizBillEntryInfo.setUnSubmitCount(0);
                probationAppraiseBizBillEntryInfo.setJudgeCount(0);
            }
        }
    }

    protected void setRelevantFieldBeforeUpdate(Context ctx, ProbationAppraiseBizBillInfo info) throws EASBizException, BOSException {
        ProbationAppraiseBizBillEntryCollection entrys = info.getEntrys();
        if (entrys.size() > 0) {
            ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = entrys.get(0);
            ProbationAppraiseBizBilljudgesCollection judges = info.getJudges();
            int submitCount = 0;
            for (int i = 0; i < judges.size(); ++i) {
                ProbationAppraiseBizBilljudgesInfo probationAppraiseBizBilljudgesInfo = judges.get(i);
                ProbationAppraiseJudgeStateEnum state = probationAppraiseBizBilljudgesInfo.getState();
                if (state == null || state.getValue() != 3) continue;
                ++submitCount;
            }
            probationAppraiseBizBillEntryInfo.setUnSubmitCount(judges.size() - submitCount);
            probationAppraiseBizBillEntryInfo.setJudgeCount(info.getJudges().size());
        }
    }

    public void updateResolutionInformation(Context ctx, ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        this.assembleEntryInfo(ctx, probationAppraiseBizBillEntryInfo);
        ProbationAppraiseBizBillEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(probationAppraiseBizBillEntryInfo.getId()), (CoreBaseInfo)probationAppraiseBizBillEntryInfo);
    }

    protected void assembleEntryInfo(Context ctx, ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo) throws EASBizException, BOSException {
        if (probationAppraiseBizBillEntryInfo.getId() != null) {
            ProbationAppraiseBizBillEntryInfo oldInfo = ProbationAppraiseBizBillEntryFactory.getLocalInstance(ctx).getProbationAppraiseBizBillEntryInfo((IObjectPK)new ObjectUuidPK(probationAppraiseBizBillEntryInfo.getId()));
            probationAppraiseBizBillEntryInfo.setPerson(oldInfo.getPerson());
            probationAppraiseBizBillEntryInfo.setPosition(oldInfo.getPosition());
            probationAppraiseBizBillEntryInfo.setHrOrgUnit(oldInfo.getHrOrgUnit());
            probationAppraiseBizBillEntryInfo.setAdminOrg(oldInfo.getAdminOrg());
            probationAppraiseBizBillEntryInfo.setCompany(oldInfo.getCompany());
            probationAppraiseBizBillEntryInfo.setJobLevel(oldInfo.getJobLevel());
            probationAppraiseBizBillEntryInfo.setJobGrade(oldInfo.getJobGrade());
            probationAppraiseBizBillEntryInfo.setEmployeeType(oldInfo.getEmployeeType());
            probationAppraiseBizBillEntryInfo.setEnterDate(oldInfo.getEnterDate());
            probationAppraiseBizBillEntryInfo.setPlanFormalDate(oldInfo.getPlanFormalDate());
            probationAppraiseBizBillEntryInfo.setIsOnline(oldInfo.isIsOnline());
            probationAppraiseBizBillEntryInfo.setDecisionMaker(oldInfo.getDecisionMaker());
        }
    }

    public void withdrawJudgesActivity(Context ctx, ProbationAppraiseBizBillInfo info, AppraiseResult resolution) throws BOSException, EASBizException {
        ProbationAppraiseBizBilljudgesCollection probationAppraiseBizBilljudgesCollection = this.getProbationAppraiseBizBilljudgesCollection(ctx, info);
        for (int i = 0; i < probationAppraiseBizBilljudgesCollection.size(); ++i) {
            ProbationAppraiseBizBilljudgesInfo probationAppraiseBizBilljudgesInfo = probationAppraiseBizBilljudgesCollection.get(i);
            ProbationAppraiseJudgeStateEnum state = probationAppraiseBizBilljudgesInfo.getState();
            if (state == null || state.getValue() != 2) continue;
            HashMap<String, String> param = new HashMap<String, String>();
            BOSUuid jobId = probationAppraiseBizBilljudgesInfo.getJobId();
            if (jobId != null) {
                param.put("jobId", probationAppraiseBizBilljudgesInfo.getJobId().toString());
                CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob(param);
            }
            ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = info.getEntrys().get(0);
            String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label31", (Context)ctx);
            message = MessageFormat.format(message, probationAppraiseBizBillEntryInfo.getName());
            HashMap<Locale, String> messageTitle = this.getMessageTitle(message);
            HashMap<Locale, String> messageBody = this.getMessageBody(message);
            HashSet<String> judgePersonId = new HashSet<String>();
            PersonInfo judgePersonInfo = probationAppraiseBizBilljudgesInfo.getPerson();
            if (judgePersonInfo != null) {
                judgePersonId.add(judgePersonInfo.getId().toString());
            }
            Set<String> receivers = this.getReceivers(ctx, judgePersonId);
            ProbationMessageUtil.sendMessage(ctx, messageTitle, messageBody, "", receivers, "sys_auto_send");
        }
    }

    public void refreshEvaluationInformation(Context ctx, ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo) throws BOSException, EASBizException {
        if (probationAppraiseBizBillInfo.getEntrys().size() > 0) {
            ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = probationAppraiseBizBillInfo.getEntrys().get(0);
            PersonInfo personInfo = probationAppraiseBizBillEntryInfo.getPerson();
            if (personInfo != null) {
                EmpHRORelationHisInfo empRelationInfo;
                EmpPosOrgRelationQueryHelper empPosOrgRelationQueryHelper = new EmpPosOrgRelationQueryHelper();
                EmpPosOrgRelationCollection mianCurrntEmpOrgRelation = empPosOrgRelationQueryHelper.getMianCurrntEmpOrgRelation(ctx, personInfo.getId().toString());
                if (mianCurrntEmpOrgRelation.size() > 0) {
                    EmpPostRankInfo empPostRank;
                    EmpPosOrgRelationInfo empPosOrgRelationInfo = mianCurrntEmpOrgRelation.get(0);
                    if (empPosOrgRelationInfo.getAdminOrg() != null) {
                        probationAppraiseBizBillEntryInfo.setAdminOrg(empPosOrgRelationInfo.getAdminOrg());
                        probationAppraiseBizBillEntryInfo.setCompany(empPosOrgRelationInfo.getAdminOrg().getCompany());
                    }
                    probationAppraiseBizBillEntryInfo.setPosition(empPosOrgRelationInfo.getPosition());
                    if (empPosOrgRelationInfo.getLaborRelation() != null) {
                        EmpLaborRelationInfo empLaborRelationInfo = empPosOrgRelationInfo.getLaborRelation();
                        probationAppraiseBizBillEntryInfo.setEmployeeType(empLaborRelationInfo.getLaborRelationState());
                        if (empLaborRelationInfo != null) {
                            empLaborRelationInfo = EmpLaborRelationFactory.getLocalInstance((Context)ctx).getEmpLaborRelationInfo((IObjectPK)new ObjectUuidPK(empLaborRelationInfo.getId().toString()));
                            probationAppraiseBizBillEntryInfo.setEnterDate(empLaborRelationInfo.getEnterDate());
                            probationAppraiseBizBillEntryInfo.setPlanFormalDate(empLaborRelationInfo.getPlanFormalDate());
                        }
                    }
                    if ((empPostRank = EmpPostRankUtil.getLastedEmpPostRank(ctx, personInfo.getId().toString())) != null) {
                        probationAppraiseBizBillEntryInfo.setJobLevel(empPostRank.getJobLevel());
                        probationAppraiseBizBillEntryInfo.setJobGrade(empPostRank.getJobGrade());
                    }
                }
                if ((empRelationInfo = SHREmpOptBizManageTool.getEmpHRORelationHisInfo(ctx, personInfo.getId().toString())) != null) {
                    probationAppraiseBizBillEntryInfo.setUseDefault(empRelationInfo.isUseDefault());
                    probationAppraiseBizBillEntryInfo.setHrOrgUnit(empRelationInfo.getHrOrgUnit());
                }
            }
            if (probationAppraiseBizBillInfo.getJudges().size() > 0) {
                ProbationAppraiseBizBilljudgesCollection judges = probationAppraiseBizBillInfo.getJudges();
                for (int i = 0; i < judges.size(); ++i) {
                    ProbationAppraiseBizBilljudgesInfo probationAppraiseBizBilljudgesInfo = judges.get(i);
                    probationAppraiseBizBilljudgesInfo.setScore(0.0f);
                    probationAppraiseBizBilljudgesInfo.setState(ProbationAppraiseJudgeStateEnum.NOTSUBMIT);
                    probationAppraiseBizBilljudgesInfo.put("evaluationResult", null);
                    probationAppraiseBizBilljudgesInfo.setJobId(null);
                }
            }
            probationAppraiseBizBillEntryInfo.put("resolution", null);
            probationAppraiseBizBillEntryInfo.setResPosition(null);
            probationAppraiseBizBillEntryInfo.setResJobLevel(null);
            probationAppraiseBizBillEntryInfo.setResJobGrade(null);
            probationAppraiseBizBillEntryInfo.setResolutionOpinion(null);
        }
    }

    public void updateJudgesInfo(Context ctx, ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo) throws EASBizException, BOSException {
        ProbationAppraiseBizBilljudgesCollection judges = probationAppraiseBizBillInfo.getJudges();
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        coreBaseCollection.addObjectCollection((IObjectCollection)judges);
        ProbationAppraiseBizBilljudgesFactory.getLocalInstance(ctx).saveBatchData(coreBaseCollection);
    }

    public void deleteAttachment(Context ctx, ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo) throws BOSException, EASBizException {
        ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
        IBoAttchAsso boAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
        SHRAttachmentExtCollection shrAttachmentExtColl = SHRAttachmentExtFactory.getLocalInstance((Context)ctx).getSHRAttachmentExtCollection("where boID = '" + probationAppraiseBizBillInfo.getId().toString() + "'");
        IObjectPK[] arrayExtPK = new IObjectPK[shrAttachmentExtColl.size()];
        for (int i = 0; i < shrAttachmentExtColl.size(); ++i) {
            SHRAttachmentExtInfo shrAttachmentExtInfo = shrAttachmentExtColl.get(i);
            arrayExtPK[i] = new ObjectUuidPK(shrAttachmentExtInfo.getId());
        }
        BoAttchAssoCollection boAttchAssoCollection = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection("where boID = '" + probationAppraiseBizBillInfo.getId().toString() + "'");
        IObjectPK[] arrayAssoPK = new IObjectPK[boAttchAssoCollection.size()];
        for (int i = 0; i < boAttchAssoCollection.size(); ++i) {
            BoAttchAssoInfo boAttchAssoInfo = boAttchAssoCollection.get(i);
            arrayAssoPK[i] = new ObjectUuidPK(boAttchAssoInfo.getId());
        }
        boAttchAsso.deleteBatchData(arrayAssoPK);
        shrAttchExt.deleteBatchData(arrayExtPK);
    }

    public ProbationAppraiseBizBilljudgesCollection getProbationAppraiseBizBilljudgesCollection(Context ctx, ProbationAppraiseBizBillInfo info) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill", (Object)info.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return ProbationAppraiseBizBilljudgesFactory.getLocalInstance(ctx).getProbationAppraiseBizBilljudgesCollection(viewInfo);
    }

    protected Boolean isConditionAnd(Context ctx) {
        return true;
    }

    protected void ProcessingCoactivityJob(Context ctx, ProbationAppraiseBizBillInfo info) throws EASBizException, BOSException {
        ActivitySolutionInfo activitySolutionInfo;
        ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo;
        ProbationAppraiseTempInfo probationAppraiseTempInfo;
        ProbationAppraiseBizBillEntryCollection entrys = info.getEntrys();
        if (entrys.size() > 0 && (probationAppraiseTempInfo = (probationAppraiseBizBillEntryInfo = entrys.get(0)).getProbationAppraiseTemp()) != null && (activitySolutionInfo = (probationAppraiseTempInfo = ProbationAppraiseTempFactory.getLocalInstance(ctx).getProbationAppraiseTempInfo((IObjectPK)new ObjectUuidPK(probationAppraiseTempInfo.getId()))).getActivitySolution()) != null) {
            CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).createJobBySolution(activitySolutionInfo.getId().toString(), "", info.getId().toString(), new HashMap());
        }
    }

    protected void createCoactivityJob(Context ctx, String personId, String billId, String activityNumber) throws BOSException, EASBizException {
        HashMap param = new HashMap();
        HashSet<String> userSet = new HashSet<String>();
        UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id where person ='" + personId + "' and isDelete=0 and isForbidden=0");
        for (int i = 0; i < userColl.size(); ++i) {
            userSet.add(userColl.get(i).getId().toString());
        }
        param.put("userSet", userSet);
        CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).createJobByActivity(null, activityNumber, billId, param);
    }

    protected void restartCoactivityJob(Context ctx, String billId) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("billId", billId);
        param.put("needDeleteData", false);
        CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob(param);
    }

    protected void deleteCoactivityJob(Context ctx, String billId) throws EASBizException, BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("billId", billId);
        CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob(param);
    }

    public HashMap<Locale, String> getMessageTitle(String title) {
        String title_l1 = title;
        String title_l2 = title;
        String title_l3 = title;
        return ProbationMessageUtil.getMessageTitle(title_l1, title_l2, title_l3);
    }

    public HashMap<Locale, String> getMessageBody(String body) {
        String body_l1 = body;
        String body_l2 = body;
        String body_l3 = body;
        return ProbationMessageUtil.getMessageBody(body_l1, body_l2, body_l3);
    }

    public Set<String> getReceivers(Context ctx, Set<String> personIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", personIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isDelete", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isForbidden", (Object)false));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
        HashSet<String> userIdSet = new HashSet<String>();
        for (int i = 0; i < userCollection.size(); ++i) {
            userIdSet.add(userCollection.get(i).getId().toString());
        }
        return userIdSet;
    }

    public void sendMessage(Context ctx, ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo, Set<String> receivers, String operation) {
        if (probationAppraiseBizBillInfo.getEntrys().size() > 0) {
            ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = probationAppraiseBizBillInfo.getEntrys().get(0);
            String message_l1 = "";
            String message_l2 = "";
            String message_l3 = "";
            if (operation.equals("delete")) {
                message_l1 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label27", (Locale)LocaleUtils.locale_l1), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l1));
                message_l2 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label27", (Locale)LocaleUtils.locale_l2), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l2));
                message_l3 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label27", (Locale)LocaleUtils.locale_l3), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l3));
            }
            if (operation.equals("restartEvaluation")) {
                message_l1 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label28", (Locale)LocaleUtils.locale_l1), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l1));
                message_l2 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label28", (Locale)LocaleUtils.locale_l2), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l2));
                message_l3 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label28", (Locale)LocaleUtils.locale_l3), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l3));
            }
            if (operation.equals("abort")) {
                message_l1 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label26", (Locale)LocaleUtils.locale_l1), probationAppraiseBizBillEntryInfo.getPerson().getName(LocaleUtils.locale_l1), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l1));
                message_l2 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label26", (Locale)LocaleUtils.locale_l2), probationAppraiseBizBillEntryInfo.getPerson().getName(LocaleUtils.locale_l2), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l2));
                message_l3 = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label26", (Locale)LocaleUtils.locale_l3), probationAppraiseBizBillEntryInfo.getPerson().getName(LocaleUtils.locale_l3), probationAppraiseBizBillEntryInfo.getName(LocaleUtils.locale_l3));
            }
            HashMap<Locale, String> messageTitle = ProbationMessageUtil.getMessageTitle(message_l1, message_l2, message_l3);
            HashMap<Locale, String> messageBody = ProbationMessageUtil.getMessageTitle(message_l1, message_l2, message_l3);
            ProbationMessageUtil.sendMessage(ctx, messageTitle, messageBody, "", receivers, "sys_auto_send");
        }
    }

    @Override
    protected void _savePlan(Context ctx, String billId, String appraiseDate, String judges, String jobId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        IProbationAppraiseBizBillEntry iProbationAppraiseBizBillEntry = ProbationAppraiseBizBillEntryFactory.getLocalInstance(ctx);
        ProbationAppraiseBizBillEntryCollection entryColl = iProbationAppraiseBizBillEntry.getProbationAppraiseBizBillEntryCollection("select appraiseDate,id where bill = '" + billId + "'");
        if (entryColl.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                if (!StringUtils.isEmpty((String)appraiseDate)) {
                    ProbationAppraiseBizBillEntryInfo info = entryColl.get(0);
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("appraiseDate"));
                    info.setAppraiseDate(sdf.parse(appraiseDate));
                    iProbationAppraiseBizBillEntry.updatePartial((CoreBaseInfo)info, selector);
                }
                this.addNewJudges(ctx, judges, billId);
                if (!StringUtils.isEmpty((String)jobId)) {
                    HashMap<String, String> param = new HashMap<String, String>();
                    param.put("jobId", jobId);
                    param.put("billId", billId);
                    CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).pass(param);
                }
            }
            catch (ParseException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        }
    }

    protected void addNewJudges(Context ctx, String judgesStr, String billId) throws EASBizException, BOSException {
        CoreBaseCollection judgesCollection = new CoreBaseCollection();
        String[] judges = judgesStr.split(",");
        for (int i = 0; i < judges.length; ++i) {
            if (StringUtils.isEmpty((String)judges[i].trim())) continue;
            ProbationAppraiseBizBilljudgesInfo info = new ProbationAppraiseBizBilljudgesInfo();
            ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo = new ProbationAppraiseBizBillInfo();
            probationAppraiseBizBillInfo.setId(BOSUuid.read((String)billId));
            info.setBill(probationAppraiseBizBillInfo);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)judges[i].trim()));
            info.setPerson(personInfo);
            info.setScore(0.0f);
            info.setState(ProbationAppraiseJudgeStateEnum.NOTSUBMIT);
            judgesCollection.add((CoreBaseInfo)info);
        }
        IProbationAppraiseBizBilljudges iProbationAppraiseBizBilljudges = ProbationAppraiseBizBilljudgesFactory.getLocalInstance(ctx);
        iProbationAppraiseBizBilljudges.delete("where bill = '" + billId + "'");
        iProbationAppraiseBizBilljudges.saveBatchData(judgesCollection);
        JudgeCountUtil.refreshCount(ctx, billId);
    }

    @Override
    protected boolean _multiJudes(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String appraiseBill = model.getString("appraiseBill");
        String judgesStr = model.getString("judgesStr");
        JSONArray billArray = JSONArray.parseArray((String)appraiseBill);
        HashMap<String, String> jobIdMaps = new HashMap<String, String>();
        String apprasiePerson = "";
        for (int i = 0; i < billArray.size(); ++i) {
            JSONObject bill = billArray.getJSONObject(i);
            jobIdMaps.put(bill.getString("id"), bill.getString("jobid"));
            JSONObject person = bill.getJSONObject("person");
            apprasiePerson = apprasiePerson + "\u3001" + person.getString("name") + "(" + person.getString("number") + ")";
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", jobIdMaps.keySet(), CompareType.INCLUDE));
        view.setFilter(filterInfo);
        ProbationAppraiseBizBillCollection collection = this.getProbationAppraiseBizBillCollection(ctx, view);
        ArrayList list = new ArrayList();
        for (int i = 0; i < collection.size(); ++i) {
            ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo = collection.get(i);
            probationAppraiseBizBillInfo.getEntrys().get(0).setAppraiseDate(model.getDate("appraiseDate"));
            probationAppraiseBizBillInfo.getJudges().clear();
            probationAppraiseBizBillInfo.getJudges().addCollection(this.assembleJudes(ctx, judgesStr));
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("billId", probationAppraiseBizBillInfo.getId().toString());
            param.put("jobId", (String)jobIdMaps.get(probationAppraiseBizBillInfo.getId().toString()));
            list.add(param);
        }
        this._updateBatchData(ctx, (IObjectCollection)collection);
        for (Map map : list) {
            CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).pass(map);
            JudgeCountUtil.refreshCount(ctx, (String)map.get("billId"));
        }
        this.sendJudesMessage(ctx, model, judgesStr, apprasiePerson);
        return true;
    }

    @Override
    protected void _importAppraiseBill(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProbationAppraiseBizBillInfo info = (ProbationAppraiseBizBillInfo)model;
        this.checkImportBillData(ctx, info);
        info.put("isFromImport", true);
        IObjectPK pk = this.addnew(ctx, (CoreBaseInfo)info);
        if (info.getEntrys().size() > 0) {
            String personId = info.getEntrys().get(0).getPerson().getId().toString();
            this.createCoactivityJob(ctx, personId, pk.toString(), "appraise_self_confirm");
        }
    }

    @Override
    protected void _abortBill(Context ctx, IObjectPK[] arrayPk) throws BOSException, EASBizException {
        for (IObjectPK pk : arrayPk) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entrys.id"));
            selector.add(new SelectorItemInfo("entrys.name"));
            selector.add(new SelectorItemInfo("entrys.person.name"));
            ProbationAppraiseBizBillInfo probationAppraiseBizBillInfo = this.getProbationAppraiseBizBillInfo(ctx, pk, selector);
            ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = probationAppraiseBizBillInfo.getEntrys().get(0);
            Set userSet = JobUtils.getNotFinishExecutor((Context)ctx, (String)probationAppraiseBizBillInfo.getId().toString());
            this.deleteCoactivityJob(ctx, probationAppraiseBizBillInfo.getId().toString());
            probationAppraiseBizBillInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
            probationAppraiseBizBillInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            probationAppraiseBizBillEntryInfo.setAppraiseState(ProbationAppraiseStateEnum.TERMINATED);
            probationAppraiseBizBillEntryInfo.setActivityNode(ProbationAppraiseStateEnum.TERMINATED.getAlias());
            probationAppraiseBizBillEntryInfo.setDescription(SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"PERSON_RESIGN", (Context)ctx));
            SelectorItemCollection sicoll = new SelectorItemCollection();
            sicoll.add(new SelectorItemInfo("entrys.appraiseState"));
            sicoll.add(new SelectorItemInfo("entrys.activityNode"));
            sicoll.add(new SelectorItemInfo("entrys.description"));
            sicoll.add(new SelectorItemInfo("lastUpdateTime"));
            sicoll.add(new SelectorItemInfo("lastUpdateUser"));
            this.updatePartial(ctx, (CoreBaseInfo)probationAppraiseBizBillInfo, sicoll);
            this.sendMessage(ctx, probationAppraiseBizBillInfo, userSet, "abort");
        }
    }

    protected void checkImportBillData(Context ctx, ProbationAppraiseBizBillInfo info) throws BOSException, EASBizException {
        if (info.getEntrys() != null) {
            ProbationAppraiseBizBillEntryInfo entry = info.getEntrys().get(0);
            if (entry.getEnterDate() != null && entry.getAppraiseDate() != null && DateTimeUtils.dayBefore((Date)entry.getAppraiseDate(), (Date)entry.getEnterDate())) {
                throw new ProbationException(ProbationException.APPRAISEDATE_BEFORE);
            }
            this.checkJobLevelGradeRange(ctx, info, entry);
        }
    }

    protected void checkJobLevelGradeRange(Context ctx, ProbationAppraiseBizBillInfo billInfo, ProbationAppraiseBizBillEntryInfo entryInfo) throws EASBizException, BOSException {
        boolean isRelatePositionJobRange = HRParamUtil.isRelatePositionJobRange((Context)ctx);
        JobLevelInfo jobLevel = entryInfo.getResJobLevel();
        JobGradeInfo jobGrade = entryInfo.getResJobGrade();
        if (isRelatePositionJobRange) {
            PositionInfo posInfo = entryInfo.getResPosition();
            if (posInfo == null || posInfo.getId() == null) {
                return;
            }
            EmpPostRankUtil.checkJobLevelGradeRangeInPosition(ctx, jobLevel, jobGrade, posInfo.getId().toString());
        } else {
            EmpPostRankUtil.checkJobLevelInJobGrade(ctx, jobLevel, jobGrade);
        }
    }

    protected void sendJudesMessage(Context ctx, IObjectValue model, String judgesStr, String apprasiePerson) throws BOSException, EASBizException {
        String appraiseDate = DateTimeUtils.format((Date)model.getDate("appraiseDate"), (String)"yyyy-MM-dd");
        String title = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label32", (Context)ctx);
        title = MessageFormat.format(title, appraiseDate);
        HashMap<Locale, String> messageTitle = this.getMessageTitle(title);
        if (!StringUtils.isEmpty((String)judgesStr)) {
            String[] judges = judgesStr.split(",");
            for (int j = 0; j < judges.length; ++j) {
                String judesId = judges[j];
                PersonInfo judesInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(judesId));
                String message = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label33", (Context)ctx);
                message = MessageFormat.format(message, appraiseDate, model.getString("remark"), apprasiePerson.substring(1, apprasiePerson.length()));
                HashMap<Locale, String> messageBody = this.getMessageBody(message);
                HashSet<String> judesIdSet = new HashSet<String>();
                judesIdSet.add(judesId);
                ProbationMessageUtil.sendMessage(ctx, messageTitle, messageBody, "", this.getReceivers(ctx, judesIdSet), "sys_auto_send");
            }
        }
    }

    protected ProbationAppraiseBizBilljudgesCollection assembleJudes(Context ctx, String judgesStr) {
        if (!StringUtils.isEmpty((String)judgesStr)) {
            String[] judges = judgesStr.split(",");
            ProbationAppraiseBizBilljudgesCollection coll = new ProbationAppraiseBizBilljudgesCollection();
            for (int j = 0; j < judges.length; ++j) {
                ProbationAppraiseBizBilljudgesInfo info = new ProbationAppraiseBizBilljudgesInfo();
                info.setScore(0.0f);
                info.setState(ProbationAppraiseJudgeStateEnum.NOTSUBMIT);
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)judges[j]));
                info.setPerson(personInfo);
                coll.add(info);
            }
            return coll;
        }
        return null;
    }
}

