/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.probation.ProbationException;
import com.kingdee.eas.hr.emp.probation.ProbationTrainMarkFactory;
import com.kingdee.eas.hr.emp.probation.ProbationTrainMarkInfo;
import com.kingdee.eas.hr.emp.probation.ProbationTrainPeriodCollection;
import com.kingdee.eas.hr.emp.probation.ProbationTrainProgramFactory;
import com.kingdee.eas.hr.emp.probation.ProbationTrainProgramInfo;
import com.kingdee.eas.hr.emp.probation.app.AbstractProbationTrainProgramControllerBean;
import com.kingdee.eas.hr.emp.probation.app.ProbationMarkPointEnum;
import com.kingdee.eas.hr.emp.probation.util.ProbationGoalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbationTrainProgramControllerBean
extends AbstractProbationTrainProgramControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(ProbationTrainProgramControllerBean.class);

    protected IObjectPK _save(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ProbationTrainProgramInfo info = (ProbationTrainProgramInfo)model;
        this.checkProgramName(ctx, info);
        ProbationTrainPeriodCollection periodColl = info.getTrainPeriod();
        if (periodColl.size() == 0) {
            throw new ProbationException(ProbationException.PERIOD_MUST);
        }
        ProbationTrainMarkInfo markInfo = info.getTrainMark();
        if (markInfo.isIsPoint()) {
            markInfo.setIsLevelSystem(false);
            if (ProbationMarkPointEnum.FIVE_MARK.equals((Object)markInfo.getPointType())) {
                markInfo.setLowestPoint(0.0);
                markInfo.setHighestPoint(5.0);
            } else if (ProbationMarkPointEnum.TEN_MARK.equals((Object)markInfo.getPointType())) {
                markInfo.setLowestPoint(0.0);
                markInfo.setHighestPoint(10.0);
            } else if (ProbationMarkPointEnum.HUNDRED_MARK.equals((Object)markInfo.getPointType())) {
                markInfo.setLowestPoint(0.0);
                markInfo.setHighestPoint(100.0);
            }
        }
        IObjectPK markInfoPK = ProbationTrainMarkFactory.getLocalInstance(ctx).save((CoreBaseInfo)markInfo);
        IObjectPK pk = super._save(ctx, model);
        ProbationGoalUtil.saveAdminRange(ctx, model.getString("adminRange"), model);
        return pk;
    }

    public void checkProgramName(Context ctx, ProbationTrainProgramInfo info) throws EASBizException, BOSException {
        boolean exist;
        String name = info.getName();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("(#0 and #1)");
        }
        if (exist = ProbationTrainProgramFactory.getLocalInstance(ctx).exists(filter)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, new Object[]{name});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String oql = "select trainMark where id = '" + pk + "'";
        ProbationTrainProgramInfo proInfo = ProbationTrainProgramFactory.getLocalInstance(ctx).getProbationTrainProgramInfo(oql);
        if (proInfo != null && proInfo.getTrainMark() != null) {
            String trainMarkId = proInfo.getTrainMark().getId().toString();
            String delMarkSql = " where id = '" + trainMarkId + "'";
            ProbationTrainMarkFactory.getLocalInstance(ctx).delete(delMarkSql);
        }
        super._delete(ctx, pk);
        ProbationGoalUtil.deleteAdminRange(ctx, pk);
    }
}

