/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.probation.IProbationAppraiseBizBill;
import com.kingdee.eas.hr.emp.probation.IProbationAppraiseBizBillEntry;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryCollection;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillEntryInfo;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillFactory;
import com.kingdee.eas.hr.emp.probation.ProbationAppraiseBizBillInfo;
import com.kingdee.eas.hr.emp.probation.app.ProbationAppraiseStateEnum;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.strategy.impl.CommonBillActivitySolutionOperation;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbationAppraiseSolutionOperationImpl
extends CommonBillActivitySolutionOperation {
    private static final Logger logger = LoggerFactory.getLogger(ProbationAppraiseSolutionOperationImpl.class);

    public Map<String, Object> getOrgAndPerson(Context ctx, String billId, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IProbationAppraiseBizBill iProbationAppraiseBizBill = ProbationAppraiseBizBillFactory.getLocalInstance(ctx);
        if (!iProbationAppraiseBizBill.exists((IObjectPK)new ObjectUuidPK(billId))) {
            return map;
        }
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        if ("CEF98BCF".equals(billBosType)) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("entrys.id"));
            selector.add(new SelectorItemInfo("entrys.person"));
            selector.add(new SelectorItemInfo("entrys.person.id"));
            selector.add(new SelectorItemInfo("entrys.person.name"));
            selector.add(new SelectorItemInfo("entrys.person.number"));
            selector.add(new SelectorItemInfo("entrys.adminOrg"));
            selector.add(new SelectorItemInfo("entrys.hrOrgUnit"));
            ProbationAppraiseBizBillInfo info = iProbationAppraiseBizBill.getProbationAppraiseBizBillInfo((IObjectPK)new ObjectUuidPK(billId));
            if (info.getEntrys().size() > 0) {
                ProbationAppraiseBizBillEntryInfo probationAppraiseBizBillEntryInfo = info.getEntrys().get(0);
                HROrgUnitInfo hrOrgUnit = probationAppraiseBizBillEntryInfo.getHrOrgUnit();
                AdminOrgUnitInfo adminOrgUnit = probationAppraiseBizBillEntryInfo.getAdminOrg();
                PersonInfo person = probationAppraiseBizBillEntryInfo.getPerson();
                if (person != null) {
                    person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()));
                }
                map.put("hrOrgUnit", hrOrgUnit);
                map.put("adminOrgUnit", adminOrgUnit);
                map.put("personId", person.getId());
                map.put("personName", person.getName());
            }
        }
        return map;
    }

    public Map<String, Object> getCommonParams(Context ctx, String billId, Map params) throws BOSException, EASBizException {
        HashMap<String, Object> createdMap = new HashMap<String, Object>();
        ProbationAppraiseBizBillInfo billInfo = (ProbationAppraiseBizBillInfo)params.get("model");
        if (null != billInfo) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("createTime"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.name"));
            ProbationAppraiseBizBillInfo billActure = ProbationAppraiseBizBillFactory.getLocalInstance(ctx).getProbationAppraiseBizBillInfo((IObjectPK)new ObjectUuidPK(billInfo.getId()), sic);
            createdMap.put("creator.number", billActure.getCreator().getNumber());
            createdMap.put("personId.name", billActure.getCreator().getName());
            createdMap.put("MultiApprove.createTime", billActure.getCreateTime());
        }
        return createdMap;
    }

    public void afterPass(Context ctx, String solutionId, String billId, Map params) throws BOSException, EASBizException {
        super.afterPass(ctx, solutionId, billId, params);
        IProbationAppraiseBizBillEntry iProbationAppraiseBizBillEntry = ProbationAppraiseBizBillEntryFactory.getLocalInstance(ctx);
        ProbationAppraiseBizBillEntryCollection coll = iProbationAppraiseBizBillEntry.getProbationAppraiseBizBillEntryCollection("select activityNode, appraiseState where bill ='" + billId + "'");
        if (coll.size() > 0) {
            ProbationAppraiseBizBillEntryInfo info = coll.get(0);
            String endMsg = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.probation.ProbationEmpBizResource", (String)"label39", (Context)ctx);
            info.setActivityNode(endMsg);
            info.setAppraiseState(ProbationAppraiseStateEnum.COMPLETED);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("activityNode"));
            selector.add(new SelectorItemInfo("appraiseState"));
            iProbationAppraiseBizBillEntry.updatePartial((CoreBaseInfo)info, selector);
        }
    }
}

