/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.probation.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.EmployeeBizException;
import com.kingdee.eas.hr.emp.probation.util.ProbationTrainPlanUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProbationJobUtil {
    private static final Logger logger = LoggerFactory.getLogger(ProbationTrainPlanUtil.class);

    public static void getBillActivityPersonData(Context ctx, List<Map<String, Object>> recordList) {
        if (!recordList.isEmpty() && recordList != null) {
            Map<String, Set<String>> assginMap = ProbationJobUtil.setBillActivityPersonMap(ctx, recordList);
            for (Map<String, Object> mapRecord : recordList) {
                String billId = mapRecord.get("id") != null ? mapRecord.get("id").toString() : "";
                if (assginMap.get(billId) == null) continue;
                Set<String> personNameSet = assginMap.get(billId);
                mapRecord.put("description", ProbationJobUtil.convertSetToString(personNameSet));
            }
        }
    }

    public static Map<String, Set<String>> setBillActivityPersonMap(Context ctx, List<Map<String, Object>> recordList) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Map<String, Object> mapRecord : recordList) {
            Object billId = mapRecord.get("id");
            if (null == billId) continue;
            ids.add(billId.toString());
        }
        Map<String, Set<String>> assginMap = ProbationJobUtil.getNotFinishPersonNames(ctx, ids);
        return assginMap;
    }

    public static Map<String, Set<String>> getNotFinishPersonNames(Context ctx, List<String> billIds) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try {
            String localePostfix = LocaleUtils.getShortCode((Context)ctx);
            StringBuilder jobSql = new StringBuilder();
            jobSql.append("SELECT cojob.FBILLID billid, auser.FNAME_" + localePostfix + " as username").append(" FROM T_HR_CoActivityExecutor executor").append(" LEFT JOIN T_HR_CoActivityJob cojob on cojob.FID = executor.FCOACTIVITY ").append(" LEFT JOIN T_PM_User auser on auser.FID = executor.FUSER").append(" where cojob.FJOBSTATE = 2").append(" and cojob.FBILLID in ").append(HRUtilExtend.getStrFromList(billIds));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)jobSql.toString());
            while (rowSet.next()) {
                Set<String> personNameSet;
                String billId = rowSet.getString("billid");
                String userName = rowSet.getString("username");
                if (userName == null) {
                    userName = "";
                }
                if (result.get(billId) != null) {
                    personNameSet = (Set)result.get(billId);
                    personNameSet.add(userName);
                    result.put(billId, personNameSet);
                    continue;
                }
                personNameSet = new HashSet();
                personNameSet.add(userName);
                result.put(billId, personNameSet);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static FilterInfo dealBillAuditorFilter(Context ctx, FilterInfo advanceFilter) throws EASBizException {
        if (advanceFilter == null) {
            return advanceFilter;
        }
        String keyWord = "description";
        String AND = "AND";
        String OR = "OR";
        int andLength = "AND".length();
        int orLength = "OR".length();
        String localePostfix = LocaleUtils.getShortCode((Context)ctx);
        String pattern = "id in (SELECT cojob.FBILLID FROM T_HR_CoActivityExecutor executor LEFT JOIN T_HR_CoActivityJob cojob on cojob.FID = executor.FCOACTIVITY LEFT JOIN T_PM_User auser on auser.FID = executor.FUSER where cojob.FJOBSTATE = 2 and auser.FNAME_" + localePostfix + " {0} {1})";
        String patternNULL = "id not in (SELECT cojob.FBILLID FROM T_HR_CoActivityExecutor executor LEFT JOIN T_HR_CoActivityJob cojob on cojob.FID = executor.FCOACTIVITY where cojob.FBILLID is not null and cojob.FJOBSTATE = 2)";
        StringBuilder target = new StringBuilder(advanceFilter.encode());
        StringBuilder result = new StringBuilder();
        String currentStr = "";
        String compareType = "";
        String compareValue = "";
        int startIndex = target.indexOf("description");
        int endIndex = 0;
        int andIndex = 0;
        int orIndex = 0;
        while (startIndex != -1) {
            result.append(target.substring(endIndex, startIndex));
            if (startIndex > 0 && '(' == target.charAt(startIndex - 1)) {
                endIndex = target.indexOf(")", startIndex);
            } else {
                andIndex = target.indexOf("AND", startIndex);
                orIndex = target.indexOf("OR", startIndex);
                endIndex = andIndex == -1 && orIndex == -1 ? target.length() : (andIndex == -1 && orIndex != -1 ? orIndex + orLength : (andIndex != -1 && orIndex == -1 ? andIndex + andLength : (andIndex <= orIndex ? (endIndex += andLength) : orIndex + orLength)));
            }
            currentStr = target.substring(startIndex, endIndex);
            String[] words = currentStr.split(" ");
            if ("descriptionISNULL".equalsIgnoreCase(currentStr.replaceAll(" ", ""))) {
                result.append(patternNULL);
            } else {
                compareValue = words[words.length - 1];
                compareType = currentStr.substring(words[0].length() + 1, currentStr.length() - words[words.length - 1].length() - 1);
                result.append(MessageFormat.format(pattern, compareType, compareValue));
            }
            startIndex = target.indexOf("description", endIndex);
        }
        if (endIndex < target.length()) {
            result.append(target.substring(endIndex));
        }
        try {
            advanceFilter = new FilterInfo(result.toString());
        }
        catch (ParserException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EmployeeBizException(EmployeeBizException.CONDITION_PARSING_DEFOULT, e);
        }
        return advanceFilter;
    }

    public static String convertSetToString(Set<String> personNameSet) {
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = personNameSet.iterator();
        while (it.hasNext()) {
            sb.append("" + it.next() + "");
            sb.append(",");
        }
        sb = sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }
}

