/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.compensation.util.HRTableTools;
import com.kingdee.eas.hr.org.IJobGrade;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeModuleException;
import com.kingdee.eas.hr.org.JobGradeModuleFactory;
import com.kingdee.eas.hr.org.JobGradeModuleStateCollection;
import com.kingdee.eas.hr.org.JobGradeModuleStateFactory;
import com.kingdee.eas.hr.org.JobGradeModuleStateInfo;
import com.kingdee.eas.hr.org.client.AbstractJobGradeModuleListUI;
import com.kingdee.eas.hr.org.client.JobGradeModuleEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class JobGradeModuleListUI
extends AbstractJobGradeModuleListUI {
    private static final Logger logger = CoreUIObject.getLogger(JobGradeModuleListUI.class);
    private static final String RESOURCE_FILE = "com.kingdee.eas.hr.org.JobGradeModuleResource.";
    private final String CELL_ID = "id";
    private final String CELL_ENABLE = "enable";
    protected KDTSortManager sm = null;

    protected KDTSortManager getKDSortManger() {
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.tblMain);
        }
        return this.sm;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getType() == 0) {
                return;
            }
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            if (actView.isEnabled()) {
                actView.actionPerformed(evt);
            }
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btndisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btndisable.setEnabled(false);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    if (JobGradeModuleListUI.this.tblMain.getRowCount() > 0) {
                        int indexRow = e.getSelectBlock().getTop();
                        JobGradeModuleListUI.this.doButtonState(indexRow);
                    }
                }
                catch (Exception exc) {
                    JobGradeModuleListUI.this.handUIException(exc);
                }
            }
        });
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
            this.doButtonState(0);
        }
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                JobGradeModuleListUI.this.showEnableInfo();
                HRSchemeUtils.enableTableHeadSortNotNeedSortManager((KDTable)JobGradeModuleListUI.this.tblMain, (int)0, (int)(JobGradeModuleListUI.this.tblMain.getRowCount() - 1), (KDTSortManager)JobGradeModuleListUI.this.getKDSortManger());
            }
        });
    }

    private void doButtonState(int indexRow) {
        StateEnum enable = (StateEnum)HRTableTools.getTableSelectCellValue((KDTable)this.tblMain, (String)"enable");
        if (enable != null && enable.getValue() == 1) {
            this.btnEnable.setEnabled(false);
            this.btndisable.setEnabled(true);
        } else {
            this.btndisable.setEnabled(false);
            this.btnEnable.setEnabled(true);
        }
    }

    protected String getEditUIName() {
        return JobGradeModuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JobGradeModuleFactory.getRemoteInstance();
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        super.actionEnable_actionPerformed(e);
        this.checkIsEnable();
        this.checkIHasJobGrade();
        if (this.confirmDialog(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeModuleResource.CONFIRM_ENABLE"))) {
            JobGradeModuleFactory.getRemoteInstance().setEnable((IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
            this.refreshList();
        }
    }

    private void checkIsEnable() throws JobGradeModuleException {
        StateEnum state = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            state = (StateEnum)this.tblMain.getCell(i, this.CELL_ENABLE).getValue();
            if (1 != state.getValue()) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeModuleResource.HAS_ENABLE_JOBGRADEMODULE"));
            SysUtil.abort();
        }
    }

    private void checkIHasJobGrade() throws JobGradeModuleException {
        if (!this.isSelectedOneJobGrade()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeModuleResource.NOT_SELECT_RECORDE"));
            SysUtil.abort();
        }
        if (!this.haveAtLeastOneJobGrade()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeModuleResource.NOT_JOBGRADE"));
            SysUtil.abort();
        }
    }

    private boolean isSelectedOneJobGrade() {
        String id;
        return this.tblMain.getRowCount() <= 0 || null != (id = this.getSelectedKeyValue());
    }

    private boolean haveAtLeastOneJobGrade() {
        String id = this.getSelectedKeyValue();
        boolean flag = false;
        try {
            IJobGrade module = JobGradeFactory.getRemoteInstance();
            JobGradeCollection infos = module.getJobGradeCollection(" where jobGradeModule = '" + id + "'");
            flag = infos.size() > 0;
        }
        catch (Exception e) {
            flag = false;
            ExceptionHandler.handle((Throwable)e);
        }
        return flag;
    }

    protected IObjectPK getBizCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        StateEnum state = null;
        String jobGrandMID = null;
        String isUsed = null;
        state = (StateEnum)HRTableTools.getTableSelectCellValue((KDTable)this.tblMain, (String)this.CELL_ENABLE);
        isUsed = (String)HRTableTools.getTableSelectCellValue((KDTable)this.tblMain, (String)"isUsed");
        if (isUsed != null) {
            if ("1".equals(isUsed.toString())) {
                jobGrandMID = (String)HRTableTools.getTableSelectCellValue((KDTable)this.tblMain, (String)"id");
                uiContext.put((Object)jobGrandMID, (Object)true);
            }
        } else if (state != null && 1 == state.getValue()) {
            jobGrandMID = (String)HRTableTools.getTableSelectCellValue((KDTable)this.tblMain, (String)"id");
            uiContext.put((Object)jobGrandMID, (Object)true);
        }
    }

    private void showEnableInfo() {
        try {
            this.setEnableState();
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void setEnableState() throws BOSException {
        String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String oql = "select jobGradeModule.id,toAdminCU.id,state where  toAdminCU.id='" + cuid + "'";
        JobGradeModuleStateCollection jgmsColl = JobGradeModuleStateFactory.getRemoteInstance().getJobGradeModuleStateCollection(oql);
        JobGradeModuleStateInfo jgmsInfo = null;
        IRow row = null;
        if (jgmsColl.size() > 0) {
            jgmsInfo = jgmsColl.get(0);
            String jobGrandMID = null;
            int size = this.tblMain.getBody().size();
            for (int i = 0; i < size; ++i) {
                row = this.tblMain.getRow2(i);
                jobGrandMID = (String)row.getCell(this.CELL_ID).getValue();
                if (jobGrandMID.equals(jgmsInfo.getJobGradeModule().getId().toString())) {
                    this.tblMain.getCell(i, this.CELL_ENABLE).setValue((Object)jgmsInfo.getState());
                    continue;
                }
                this.tblMain.getCell(i, this.CELL_ENABLE).setValue((Object)StateEnum.DISABLE);
            }
        } else {
            int size = this.tblMain.getBody().size();
            for (int i = 0; i < size; ++i) {
                row = this.tblMain.getRow2(i);
                this.tblMain.getCell(i, this.CELL_ENABLE).setValue((Object)StateEnum.DISABLE);
            }
        }
        HRSchemeUtils.enableTableHeadSortNotNeedSortManager((KDTable)this.tblMain, (int)0, (int)(this.tblMain.getRowCount() - 1), (KDTSortManager)this.getKDSortManger());
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        StateEnum state = null;
        if (rows.length > 0) {
            state = (StateEnum)this.tblMain.getCell(rows[0], this.CELL_ENABLE).getValue();
            if (1 == state.getValue()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeModuleResource.NOT_DEL_JOBGRADEtABLE"));
                return;
            }
            String isUsed = (String)HRTableTools.getTableSelectCellValue((KDTable)this.tblMain, (String)"isUsed");
            if (isUsed != null) {
                throw new JobGradeModuleException(JobGradeModuleException.NOT_DEL_JOBGRADEUSED);
            }
            String jbModID = this.tblMain.getCell(rows[0], this.CELL_ID).getValue().toString();
            boolean jobGradeState = this.getJobGradeModuleState(jbModID);
            if (jobGradeState) {
                throw new JobGradeModuleException(JobGradeModuleException.NOT_DEL_JOBGRADEUSED);
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisable_actionPerformed(e);
        if (this.confirmDialog(EASResource.getString((String)"com.kingdee.eas.hr.org.JobGradeModuleResource.CONFIRM_DISABLE"))) {
            JobGradeModuleFactory.getRemoteInstance().setDisable((IObjectPK)new ObjectStringPK(this.getSelectedKeyValue()));
            this.refreshList();
        }
    }

    private boolean getJobGradeModuleState(String jobModID) {
        if (StringUtils.isEmpty((String)jobModID)) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_HR_JobGradeModuleState where fEnable='1'").append(" and fJobGradeModule='").append(jobModID).append("'");
        try {
            ISQLExecutor iSql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            IRowSet rows = iSql.executeSQL();
            if (rows.next()) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        return filterInfo;
    }
}

