/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.OutputExcelUtil;
import com.kingdee.eas.hr.base.util.HRResourceUtils;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.hr.org.IPersonPlan;
import com.kingdee.eas.hr.org.Period;
import com.kingdee.eas.hr.org.PersonPlanFactory;
import com.kingdee.eas.hr.org.PersonPlanRowInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeTypeEnum;
import com.kingdee.eas.hr.org.PersonPlanType;
import com.kingdee.eas.hr.org.PlanActualInfo;
import com.kingdee.eas.hr.org.client.AbstractPersonPlanReportUI;
import com.kingdee.eas.hr.org.client.PersonPlanReportFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PersonPlanReportUI
extends AbstractPersonPlanReportUI {
    private boolean isMultOrg = false;
    private AdminOrgUnitInfo adminInfo = null;
    private Object[] adminInfos = null;
    private PersonPlanSchemeInfo schemeInfo = null;
    private int level = 0;
    private int startYear = 0;
    private int endYear = 0;
    private int startMonth = 0;
    private int endMonth = 0;
    private int colmnLength = 0;
    private IColumn col = null;
    private IRow row = null;
    private Period period = null;
    private PersonPlanType ppType = null;
    private String resClass = "com.kingdee.eas.hr.org.client.PersonPlanResource.";
    private final String planStr = EASResource.getString((String)(this.resClass + "PLAN"));
    private final String actualStr = EASResource.getString((String)(this.resClass + "ACTUAL"));
    private final String positionStr = EASResource.getString((String)(this.resClass + "POSITION_NAME"));
    private final String jobStr = EASResource.getString((String)(this.resClass + "JOB_NAME"));
    private final String firstHalfYearStr = EASResource.getString((String)(this.resClass + "FIRST_HALFYEAR"));
    private final String secondHalfYearStr = EASResource.getString((String)(this.resClass + "SECOND_HALF_YEAR"));
    private final String yearStr = EASResource.getString((String)(this.resClass + "YEAR"));
    private final String monthStr = EASResource.getString((String)(this.resClass + "MONTH"));
    private final String quarterStr = EASResource.getString((String)(this.resClass + "QUARTER"));
    private final String adminOrgStr = EASResource.getString((String)(this.resClass + "ADMIN_ORG"));
    private final String differenceStr = EASResource.getString((String)(this.resClass + "DIFFERENCE"));
    private final String selfOrgStr = EASResource.getString((String)(this.resClass + "SELF_ORG"));
    private final String childrenOrgStr = EASResource.getString((String)(this.resClass + "CHILDREN_ORG"));
    private boolean flag = false;
    private static int INDEX = 2;
    private CommonQueryDialog commonQueryDialog = null;
    private PersonPlanReportFilterUI customerPanel = null;
    IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.org.app", "PositionSpecDS2Query");
    private boolean isFirstDefaultQuery = true;
    private CustomerParams params = null;

    public PersonPlanReportUI() throws Exception {
        HRSchemeUtils.checkInit();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnOutput.setEnabled(true);
        this.btnOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemOutput.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPrintPreview);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.craeteTabel();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemOutput.setEnabled(true);
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.loadFilterUI(false);
        if (this.schemeInfo.getPlanType() != PersonPlanType.JOB) {
            HRTreeTable.setHRTreeTable((KDTable)this.tblMain, (String)"colOrg");
        }
        this.craeteTabel();
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    @Override
    public void actionOutput_actionPerformed(ActionEvent e) throws Exception {
        super.actionOutput_actionPerformed(e);
        OutputExcelUtil excelUtil = new OutputExcelUtil();
        excelUtil.appendToExcel(this.tblMain, true, true, this.getUITitle());
    }

    private static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    protected Object getLastEntityViewInfo() {
        HashMap<String, HashMap> lastFilterMap = new HashMap<String, HashMap>();
        lastFilterMap.put("Params", this.params.toHashMap());
        return lastFilterMap;
    }

    private void loadFilterUI(boolean loaded) throws Exception {
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = PersonPlanReportUI.getQueryInfo(this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && this.getUIContext().get("RPTFilter") != null && this.getUIContext().get("RPTFilter") instanceof Map) {
            Map lastFilterMap = (Map)this.getUIContext().get("RPTFilter");
            this.params = new CustomerParams();
            this.params.setHm((HashMap)lastFilterMap.get("Params"));
            this.isMultOrg = this.params.getBoolean("rdOrgMult");
            ObjectUuidPK pk = null;
            if (this.isMultOrg) {
                String orgIds = this.params.getCustomerParam("bizAdminOrgMult");
                this.adminInfos = OrgStringUtil.string2OrgInfoArr((String)orgIds);
                this.adminInfo = (AdminOrgUnitInfo)this.adminInfos[0];
            } else {
                if (this.params.getCustomerParam("SelectOrg") == null) {
                    this.showFilterDialog(false);
                    return;
                }
                pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("SelectOrg")));
                if (pk == null || pk != null && !AdminOrgUnitFactory.getRemoteInstance().exists((IObjectPK)pk)) {
                    this.showFilterDialog(false);
                    return;
                }
                this.adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("SelectScheme")));
            if (pk == null || pk != null && !PersonPlanSchemeFactory.getRemoteInstance().exists((IObjectPK)pk)) {
                this.showFilterDialog(false);
                return;
            }
            this.schemeInfo = PersonPlanSchemeFactory.getRemoteInstance().getPersonPlanSchemeInfo((IObjectPK)pk);
            this.level = this.params.getInt("comboOrgLevel");
            this.isFirstDefaultQuery = false;
        } else if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            if (!StringUtils.isEmpty((String)solution.getQueryPanelInfo().get(0).getCustomerParams())) {
                this.params = CustomerParams.getCustomerParams2((String)solution.getQueryPanelInfo().get(0).getCustomerParams());
                this.isMultOrg = this.params.getBoolean("rdOrgMult");
                ObjectUuidPK pk = null;
                if (this.isMultOrg) {
                    String orgIds = this.params.getCustomerParam("bizAdminOrgMult");
                    this.adminInfos = OrgStringUtil.string2OrgInfoArr((String)orgIds);
                    this.adminInfo = (AdminOrgUnitInfo)this.adminInfos[0];
                } else {
                    if (this.params.getCustomerParam("SelectOrg") == null) {
                        this.showFilterDialog(false);
                        return;
                    }
                    pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("SelectOrg")));
                    if (pk == null || pk != null && !AdminOrgUnitFactory.getRemoteInstance().exists((IObjectPK)pk)) {
                        this.showFilterDialog(false);
                        return;
                    }
                    this.adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
                }
                pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("SelectScheme")));
                if (pk == null || pk != null && !PersonPlanSchemeFactory.getRemoteInstance().exists((IObjectPK)pk)) {
                    this.showFilterDialog(false);
                    return;
                }
                this.schemeInfo = PersonPlanSchemeFactory.getRemoteInstance().getPersonPlanSchemeInfo((IObjectPK)pk);
                this.level = this.params.getInt("comboOrgLevel");
            } else {
                this.showFilterDialog(loaded);
            }
            this.isFirstDefaultQuery = false;
        } else {
            this.showFilterDialog(loaded);
        }
    }

    private void showFilterDialog(boolean loaded) throws Exception {
        if (this.commonQueryDialog == null) {
            this.commonQueryDialog = new CommonQueryDialog();
            this.commonQueryDialog.setHeight(355);
            this.commonQueryDialog.setWidth(385);
            if (this.getUIWindow() == null) {
                this.commonQueryDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            } else {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            this.commonQueryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.commonQueryDialog.setQueryObjectPK(this.mainQueryPK);
            this.commonQueryDialog.setShowFilter(false);
            this.commonQueryDialog.setShowSorter(false);
            this.commonQueryDialog.setShowToolbar(true);
            this.commonQueryDialog.setMaxReturnCountVisible(false);
            this.customerPanel = new PersonPlanReportFilterUI();
            if (loaded) {
                this.params = new CustomerParams();
                this.params.addCustomerParam("SelectOrg", this.adminInfo.getId().toString());
                this.params.addCustomerParam("SelectScheme", this.schemeInfo.getId().toString());
                this.params.putInt("level", this.level);
                this.customerPanel.setCustomerParams(this.params);
            }
            this.commonQueryDialog.addUserPanel((KDPanel)this.customerPanel);
            this.commonQueryDialog.setTitle(HRResourceUtils.getMessage((String)"com.kingdee.eas.hr.org.AdjustPeriodResource", (String)"TITLE_CONDITION_QUERY", (String[])new String[]{this.getUITitle()}));
        }
        if (this.commonQueryDialog.show()) {
            this.params = this.customerPanel.getCustomerParams();
            this.isMultOrg = this.params.getBoolean("rdOrgMult");
            ObjectUuidPK pk = null;
            if (this.isMultOrg) {
                String orgIds = this.params.getCustomerParam("bizAdminOrgMult");
                this.adminInfos = OrgStringUtil.string2OrgInfoArr(null, (String)orgIds, (boolean)false);
                this.adminInfo = (AdminOrgUnitInfo)this.adminInfos[0];
            } else {
                pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("SelectOrg")));
                this.adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            pk = new ObjectUuidPK(BOSUuid.read((String)this.params.getCustomerParam("SelectScheme")));
            this.schemeInfo = PersonPlanSchemeFactory.getRemoteInstance().getPersonPlanSchemeInfo((IObjectPK)pk);
            this.level = this.params.getInt("comboOrgLevel");
            this.flag = true;
        } else if (!loaded) {
            SysUtil.abort();
        } else {
            this.flag = false;
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.commonQueryDialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.commonQueryDialog.changeOwner((Component)((Object)this));
        }
        super.actionQuery_actionPerformed(e);
        this.loadFilterUI(true);
        if (this.flag) {
            this.craeteTabel();
        }
        if (this.schemeInfo.getPlanType() == PersonPlanType.JOB) {
            this.tblMain.setID("JOB");
        } else {
            this.tblMain.setID("OTHER");
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    private void craeteTabel() throws Exception {
        if (this.adminInfo == null || this.schemeInfo == null) {
            return;
        }
        this.startYear = this.schemeInfo.getStartYear();
        this.startMonth = this.schemeInfo.getStartMonth();
        this.endYear = this.schemeInfo.getEndYear();
        this.endMonth = this.schemeInfo.getEndMonth();
        this.period = this.schemeInfo.getPeriod();
        this.ppType = this.schemeInfo.getPlanType();
        this.enableExportExcel(this.tblMain);
        this.tblMain.removeColumns();
        this.tblMain.removeHeadRows();
        this.col = this.tblMain.addColumn();
        this.col.setWidth(150);
        this.col.getStyleAttributes().setBackground(new Color(217, 217, 210));
        this.col.getStyleAttributes().setLocked(true);
        this.col.setKey("colOrg");
        this.col = this.tblMain.addColumn();
        this.col.setWidth(150);
        this.col.getStyleAttributes().setBackground(new Color(217, 217, 210));
        this.col.getStyleAttributes().setLocked(true);
        this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.col.setKey("colPosition");
        if (this.schemeInfo.getPlanType() != PersonPlanType.POSITION) {
            this.col.getStyleAttributes().setHided(true);
        }
        if (this.period == Period.MONTH) {
            this.createHeadByMonth();
        } else if (this.period == Period.QUARTER) {
            this.createHeadByQuarter();
        } else if (this.period == Period.HALF_YEAR) {
            this.createHeadByHalfYear();
        } else if (this.period == Period.YEAR) {
            this.createHeadByYear();
        }
        this.loadTableData();
    }

    private void initTableHead() {
        this.row = this.tblMain.addHeadRow();
        if (this.ppType == PersonPlanType.PERSON) {
            this.row.getCell(0).setValue((Object)this.adminOrgStr);
            this.row.getCell(1).setValue((Object)this.positionStr);
        } else if (this.ppType == PersonPlanType.POSITION) {
            this.row.getCell(0).setValue((Object)this.adminOrgStr);
            this.row.getCell(1).setValue((Object)this.positionStr);
        } else if (this.ppType == PersonPlanType.JOB) {
            this.row.getCell(0).setValue((Object)this.jobStr);
            this.row.getCell(1).setValue((Object)this.positionStr);
        }
        this.row = this.tblMain.addHeadRow();
        for (int i = INDEX; i < this.colmnLength + INDEX; ++i) {
            if ((i - INDEX) % 3 == 0) {
                this.row.getCell(i).setValue((Object)this.planStr);
                continue;
            }
            if ((i - INDEX) % 3 == 1) {
                this.row.getCell(i).setValue((Object)this.actualStr);
                continue;
            }
            this.row.getCell(i).setValue((Object)this.differenceStr);
        }
        KDTMergeManager mm = this.tblMain.getHeadMergeManager();
        mm.mergeBlock(0, 0, 1, 0, 4);
        if (this.ppType == PersonPlanType.POSITION) {
            mm.mergeBlock(0, 1, 1, 1, 4);
        }
        for (int i = INDEX; i < this.colmnLength; i += 3) {
            mm.mergeBlock(0, i, 0, i + INDEX, 4);
        }
    }

    private void createHeadByMonth() throws Exception {
        int startYearFromFilter = 0;
        int endYearFromFilter = 0;
        int startMonthFromFilter = 0;
        int endMonthFromFilter = 0;
        int hideStart = 0;
        int hideEnd = 0;
        if (this.params != null) {
            startYearFromFilter = this.params.getInt("startYear");
            endYearFromFilter = this.params.getInt("endYear");
            startMonthFromFilter = this.params.getInt("startMonth");
            endMonthFromFilter = this.params.getInt("endMonth");
        }
        int startColCountTemp = startYearFromFilter * 12 + startMonthFromFilter;
        int endColCountTemp = endYearFromFilter * 12 + endMonthFromFilter;
        int startMonthCount = this.startYear * 12 + this.startMonth + 1;
        int endMonthCount = this.endYear * 12 + this.endMonth + 1;
        if (startMonthCount < startColCountTemp) {
            hideStart = startColCountTemp - startMonthCount;
        }
        if (endMonthCount > endColCountTemp) {
            hideEnd = endMonthCount - endColCountTemp;
        }
        this.colmnLength = (endMonthCount - startMonthCount + 1) * 3;
        int i = 0;
        int j = 1;
        while (i < this.colmnLength) {
            this.col = this.tblMain.addColumn();
            this.col.getStyleAttributes().setLocked(true);
            this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (hideStart != 0 && i < hideStart * 3) {
                this.col.getStyleAttributes().setHided(true);
            }
            if (hideEnd != 0 && i >= (this.colmnLength / 3 - hideEnd) * 3) {
                this.col.getStyleAttributes().setHided(true);
            }
            ++i;
            ++j;
        }
        this.initTableHead();
        this.row = this.tblMain.getHeadRow(0);
        int tempYear = this.startYear;
        int j2 = this.startMonth;
        for (int i2 = INDEX; i2 < this.colmnLength + INDEX; i2 += 3) {
            this.row.getCell(i2).setValue((Object)(tempYear + this.yearStr + (j2 + 1) + this.monthStr));
            if (j2 == 11) {
                j2 = 0;
                ++tempYear;
                continue;
            }
            ++j2;
        }
    }

    private void createHeadByQuarter() throws Exception {
        int startYearFromFilter = 0;
        int endYearFromFilter = 0;
        int startMonthFromFilter = 0;
        int endMonthFromFilter = 0;
        int hideStart = 0;
        int hideEnd = 0;
        if (this.params != null) {
            startYearFromFilter = this.params.getInt("startYear");
            endYearFromFilter = this.params.getInt("endYear");
            startMonthFromFilter = this.params.getInt("startMonth");
            endMonthFromFilter = this.params.getInt("endMonth");
        }
        int startColCountTemp = startYearFromFilter * 4 + startMonthFromFilter;
        int endColCountTemp = endYearFromFilter * 4 + endMonthFromFilter;
        int startMonthCount = this.startYear * 4 + this.startMonth + 1;
        int endMonthCount = this.endYear * 4 + this.endMonth + 1;
        if (startMonthCount < startColCountTemp) {
            hideStart = startColCountTemp - startMonthCount;
        }
        if (endMonthCount > endColCountTemp) {
            hideEnd = endMonthCount - endColCountTemp;
        }
        this.colmnLength = (endMonthCount - startMonthCount + 1) * 3;
        int i = 0;
        int j = 1;
        while (i < this.colmnLength) {
            this.col = this.tblMain.addColumn();
            this.col.getStyleAttributes().setLocked(true);
            this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (hideStart != 0 && i < hideStart * 3) {
                this.col.getStyleAttributes().setHided(true);
            }
            if (hideEnd != 0 && i >= (this.colmnLength / 3 - hideEnd) * 3) {
                this.col.getStyleAttributes().setHided(true);
            }
            ++i;
            ++j;
        }
        this.initTableHead();
        this.row = this.tblMain.getHeadRow(0);
        int tempYear = this.startYear;
        int j2 = this.startMonth;
        for (int i2 = INDEX; i2 < this.colmnLength + INDEX; i2 += 3) {
            this.row.getCell(i2).setValue((Object)(tempYear + this.yearStr + (j2 + 1) + this.quarterStr));
            if (j2 == 3) {
                j2 = 0;
                ++tempYear;
                continue;
            }
            ++j2;
        }
    }

    private void createHeadByHalfYear() throws Exception {
        int startYearFromFilter = 0;
        int endYearFromFilter = 0;
        int startMonthFromFilter = 0;
        int endMonthFromFilter = 0;
        int hideStart = 0;
        int hideEnd = 0;
        if (this.params != null) {
            startYearFromFilter = this.params.getInt("startYear");
            endYearFromFilter = this.params.getInt("endYear");
            startMonthFromFilter = this.params.getInt("startMonth");
            endMonthFromFilter = this.params.getInt("endMonth");
        }
        int startMonthCount = this.startYear * 2 + this.startMonth + 1;
        int endMonthCount = this.endYear * 2 + this.endMonth + 1;
        int startColCountTemp = startYearFromFilter * 2 + startMonthFromFilter + 1;
        int endColCountTemp = endYearFromFilter * 2 + endMonthFromFilter + 1;
        if (startMonthCount < startColCountTemp) {
            hideStart = startColCountTemp - startMonthCount;
        }
        if (endMonthCount > endColCountTemp) {
            hideEnd = endMonthCount - endColCountTemp;
        }
        this.colmnLength = (endMonthCount - startMonthCount + 1) * 3;
        int i = 0;
        int j = 1;
        while (i < this.colmnLength) {
            this.col = this.tblMain.addColumn();
            this.col.getStyleAttributes().setLocked(true);
            this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (hideStart != 0 && i < hideStart * 3) {
                this.col.getStyleAttributes().setHided(true);
            }
            if (hideEnd != 0 && i >= (this.colmnLength / 3 - hideEnd) * 3) {
                this.col.getStyleAttributes().setHided(true);
            }
            ++i;
            ++j;
        }
        this.initTableHead();
        this.row = this.tblMain.getHeadRow(0);
        int tempYear = this.startYear;
        String tempStr = null;
        int j2 = this.startMonth;
        for (int i2 = INDEX; i2 < this.colmnLength + INDEX; i2 += 3) {
            tempStr = tempYear + this.yearStr;
            tempStr = j2 == 0 ? tempStr + this.firstHalfYearStr : tempStr + this.secondHalfYearStr;
            this.row.getCell(i2).setValue((Object)tempStr);
            if (j2 == 0) {
                j2 = 1;
                continue;
            }
            ++tempYear;
            j2 = 0;
        }
    }

    private void createHeadByYear() throws Exception {
        int startYearFromFilter = 0;
        int endYearFromFilter = 0;
        int hideStart = 0;
        int hideEnd = 0;
        if (this.params != null) {
            startYearFromFilter = this.params.getInt("startYear");
            endYearFromFilter = this.params.getInt("endYear");
        }
        if (startYearFromFilter > this.startYear) {
            hideStart = startYearFromFilter - this.startYear;
        }
        if (endYearFromFilter < this.endYear) {
            hideEnd = this.endYear - endYearFromFilter;
        }
        this.colmnLength = (this.endYear - this.startYear + 1) * 3;
        int i = 0;
        int j = 1;
        while (i < this.colmnLength) {
            this.col = this.tblMain.addColumn();
            this.col.getStyleAttributes().setLocked(true);
            this.col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (hideStart != 0 && i < hideStart * 3) {
                this.col.getStyleAttributes().setHided(true);
            }
            if (hideEnd != 0 && i >= (this.colmnLength / 3 - hideEnd) * 3) {
                this.col.getStyleAttributes().setHided(true);
            }
            ++i;
            ++j;
        }
        this.initTableHead();
        this.row = this.tblMain.getHeadRow(0);
        int tempYear = this.startYear;
        for (int i2 = INDEX; i2 < this.colmnLength + INDEX; i2 += 3) {
            this.row.getCell(i2).setValue((Object)(tempYear + this.yearStr));
            ++tempYear;
        }
    }

    private void fillTable(List list) {
        if (list == null) {
            return;
        }
        PersonPlanRowInfo pprInfo = null;
        PlanActualInfo paInfo = null;
        List colList = null;
        HRCellUserObject hrObj = null;
        HRCellTreeRenderer render = new HRCellTreeRenderer();
        int baseLevel = 0;
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            this.row = this.tblMain.addRow();
            pprInfo = (PersonPlanRowInfo)list.get(i);
            if (this.schemeInfo.getPlanType() == PersonPlanType.JOB) {
                this.row.getCell(0).setValue((Object)pprInfo.objName);
            } else {
                hrObj = new HRCellUserObject();
                if (pprInfo.adminInfo.getName() == null) {
                    hrObj.setName("");
                } else if (pprInfo.adminInfo.getName().equals("@SELF_ORG@")) {
                    hrObj.setName(this.selfOrgStr);
                } else if (pprInfo.adminInfo.getName().equals("@CHILDREN_ORG@")) {
                    hrObj.setName(this.childrenOrgStr);
                } else {
                    hrObj.setName(pprInfo.adminInfo.getName());
                }
                hrObj.setCompanyId(pprInfo.adminInfo.getId().toString());
                hrObj.setIsLeaf(pprInfo.adminInfo.isIsLeaf());
                if (i == 0) {
                    baseLevel = pprInfo.adminInfo.getLevel();
                }
                hrObj.setLevel(pprInfo.adminInfo.getLevel() - baseLevel);
                hrObj.setLongNumber(pprInfo.adminInfo.getLongNumber());
                hrObj.setExpanded(true);
                this.row.getCell(0).setValue((Object)hrObj);
                this.row.getCell(0).setRenderer((IBasicRender)render);
                this.row.getCell(1).setValue((Object)pprInfo.objName);
            }
            colList = pprInfo.detailList;
            int size = colList.size();
            for (int j = 0; j < size; ++j) {
                paInfo = (PlanActualInfo)colList.get(j);
                if (paInfo.planCount != 0) {
                    this.row.getCell(j * 3 + INDEX).setValue((Object)paInfo.planCount);
                }
                if (paInfo.actualCount != 0) {
                    this.row.getCell(j * 3 + INDEX + 1).setValue((Object)paInfo.actualCount);
                }
                if (paInfo.difference == 0) continue;
                this.row.getCell(j * 3 + INDEX + 2).setValue((Object)paInfo.difference);
            }
        }
    }

    private void loadTableData() throws Exception {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                HashMap map;
                IPersonPlan iPPlan = PersonPlanFactory.getRemoteInstance();
                if (PersonPlanReportUI.this.isMultOrg) {
                    PersonPlanReportUI.this.adminInfo.put("adminInfos", (Object)PersonPlanReportUI.this.adminInfos);
                    PersonPlanReportUI.this.adminInfo.put("isMultOrg", (Object)true);
                }
                if (PersonPlanSchemeTypeEnum.Group.equals((Object)PersonPlanReportUI.this.schemeInfo.getSchemeType())) {
                    map = HRUtil.getAdminRangeNodeHashMap((boolean)PersonPlanReportUI.this.params.getBoolean("showSealUpOrg"), (boolean)PersonPlanReportUI.this.params.getBoolean("ShowVirtualOrg"));
                    Iterator iter = map.entrySet().iterator();
                    Map.Entry entry = null;
                    DefaultKingdeeTreeNode node = null;
                    while (iter.hasNext()) {
                        entry = iter.next();
                        node = (DefaultKingdeeTreeNode)entry.getValue();
                        node.setCustomIcon(null);
                    }
                    PersonPlanReportUI.this.adminInfo.put("NodeMap", (Object)map);
                } else {
                    map = HRUtil.getAdminNodeHashMap((boolean)PersonPlanReportUI.this.params.getBoolean("ShowVirtualOrg"), (boolean)PersonPlanReportUI.this.params.getBoolean("showSealUpOrg"));
                    Iterator iter = map.entrySet().iterator();
                    Map.Entry entry = null;
                    DefaultKingdeeTreeNode node = null;
                    while (iter.hasNext()) {
                        entry = iter.next();
                        node = (DefaultKingdeeTreeNode)entry.getValue();
                        node.setCustomIcon(null);
                    }
                    PersonPlanReportUI.this.adminInfo.put("NodeMap", (Object)map);
                }
                List list = iPPlan.getReportData(PersonPlanReportUI.this.adminInfo, PersonPlanReportUI.this.schemeInfo, PersonPlanReportUI.this.level, PersonPlanReportUI.this.params.getBoolean("isShowInvalidPosition"), PersonPlanReportUI.this.params.getBoolean("ShowVirtualOrg"), PersonPlanReportUI.this.params.getBoolean("showDisableJob"));
                PersonPlanReportUI.this.fillTable(list);
                return null;
            }
        });
        dlg.show();
    }

    protected KDTable getTableForOA() {
        return this.tblMain;
    }
}

