/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client.tree;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HROrgVersionFacadeFactory;
import com.kingdee.eas.hr.org.OrgStateTypeEnum;
import com.kingdee.eas.hr.org.PosStateTypeEnum;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.util.OrgUnitVerAdjConstant;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class AdminPositionVerTreeBuilder {
    private Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private Icon companyIcon = EASResource.getIcon((String)"imgTree_company");
    private Icon positionIcon = EASResource.getIcon((String)"imgTree_position");
    public static boolean rebuildTree = false;
    private boolean isShowSealUpOrg = false;
    private boolean isShowSealUpPos = false;
    CtrlUnitInfo currentCU = null;
    HROrgAdjSchmInfo curOrgAdjSchm = null;

    public AdminPositionVerTreeBuilder(HROrgAdjSchmInfo curOrgAdjSchm, CtrlUnitInfo currentCU, boolean isShowSealUpOrg, boolean isShowSealUpPos) throws Exception {
        this.curOrgAdjSchm = curOrgAdjSchm;
        this.currentCU = currentCU;
        this.isShowSealUpOrg = isShowSealUpOrg;
        this.isShowSealUpPos = isShowSealUpPos;
    }

    private IRowSet getPositionList(AdminOrgUnitVerInfo adminInfo) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)adminInfo.getLongNumber(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("orgAdjSchm.id", (Object)this.curOrgAdjSchm.getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("posOrgAdjSchm.id", (Object)this.curOrgAdjSchm.getId().toString()));
        if (!this.isShowSealUpPos) {
            fi.getFilterItems().add(new FilterItemInfo("posStateType", (Object)new Integer(1)));
            fi.getFilterItems().add(new FilterItemInfo("posStateType", (Object)new Integer(3)));
            fi.setMaskString("(#0 or #1) and #2 and #3 and (#4 or #5)");
        } else {
            fi.setMaskString("(#0 or #1) and #2 and #3");
        }
        viewInfo.setFilter(fi);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("index"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        selector.add(new SelectorItemInfo("posStateType"));
        selector.add(new SelectorItemInfo("isRespPosition"));
        selector.add(new SelectorItemInfo("AdminOrgUnit.id"));
        selector.add(new SelectorItemInfo("AdminOrgUnitVer.isSealUp"));
        selector.add(new SelectorItemInfo("isRespPosition"));
        SorterItemInfo sortInfo = new SorterItemInfo("index");
        sortInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortInfo);
        viewInfo.setSelector(selector);
        return HROrgVersionFacadeFactory.getRemoteInstance().getPositionVerRowset(viewInfo, this.curOrgAdjSchm);
    }

    public JTree buildTree(JTree tree) throws Exception {
        return this.buildTree(tree, false, false);
    }

    public JTree buildTree(JTree tree, boolean includeSealUp, boolean includePosition) throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        rootNode = this.createRootNode(includeSealUp, includePosition);
        tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
        tree.setShowsRootHandles(true);
        rootNode = null;
        return tree;
    }

    private DefaultKingdeeTreeNode createRootNode(boolean includeSealUp, boolean includePosition) throws Exception {
        AdminOrgUnitVerInfo adminOrg = AdminOrgUnitVerFactory.getRemoteInstance().getTopAdminVerLongNumberOfCU(this.currentCU, this.curOrgAdjSchm);
        IRowSet rows = this.getAdminRowSet(this.curOrgAdjSchm, adminOrg);
        return this.buildTreeByRowSet(rows, includeSealUp, includePosition);
    }

    private PositionVerInfo createPositionVerInfo(IRowSet row) throws Exception {
        PositionVerInfo info = new PositionVerInfo();
        info.setId(BOSUuid.read((String)row.getString("id")));
        int posStateType = row.getInt("posStateType");
        String name = this.getPosAdditionalName(row.getString("name"), posStateType);
        info.setName(name);
        info.setNumber(row.getString("number"));
        info.setDeletedStatus(DeletedStatusEnum.getEnum((int)row.getInt("deletedStatus")));
        info.setPosStateType(PosStateTypeEnum.getEnum(row.getInt("posStateType")));
        info.setIsRespPosition(row.getBoolean("isRespPosition"));
        AdminOrgUnitVerInfo adminOrg = new AdminOrgUnitVerInfo();
        adminOrg.setId(BOSUuid.read((String)row.getString("AdminOrgUnit.id")));
        info.setAdminOrgUnit(adminOrg);
        info.setOrgAdjSchm(this.curOrgAdjSchm);
        return info;
    }

    public void refreshTreeNode(KDTreeNode treeNode) throws Exception {
    }

    public DefaultKingdeeTreeNode buildTreeByRowSet(IRowSet rows, boolean includeSealUp, boolean includePosition) throws Exception {
        if (rows == null) {
            return null;
        }
        KDTreeNode rootTreeNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        KDTreeNode subTreeNode = null;
        DefaultKingdeeTreeNode childNode = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        int index = 0;
        AdminOrgUnitVerInfo adminInfo = null;
        while (rows.next()) {
            adminInfo = this.createAdminUnitInfo(rows);
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(this.groupIcon);
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                continue;
            }
            subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(this.companyIcon);
            if (adminInfo.getParent() != null && nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(adminInfo.getId().toString(), subTreeNode);
        }
        if (!includePosition) {
            return rootTreeNode;
        }
        if (rootTreeNode != null) {
            adminInfo = (AdminOrgUnitVerInfo)rootTreeNode.getUserObject();
            IRowSet rows2 = this.getPositionList(adminInfo);
            String adminID = null;
            PositionVerInfo PositionVerInfo2 = null;
            DefaultKingdeeTreeNode positionTreeNode = null;
            index = 0;
            while (rows2.next()) {
                PositionVerInfo2 = this.createPositionVerInfo(rows2);
                positionTreeNode = new DefaultKingdeeTreeNode((Object)PositionVerInfo2);
                positionTreeNode.setCustomIcon(this.positionIcon);
                adminID = rows2.getString("AdminOrgUnit.id");
                if (!nodeMap.containsKey(adminID)) continue;
                parentNode = (DefaultKingdeeTreeNode)nodeMap.get(adminID);
                if (rows2.getBoolean("isRespPosition")) {
                    parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                    continue;
                }
                if (parentNode.getChildCount() > 0) {
                    childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(0);
                    index = rows2.getInt("index") + 1;
                    if (childNode.getUserObject() instanceof PositionVerInfo && parentNode.getChildCount() > index && rows2.getString("index") != null && rows2.getInt("index") >= 0) {
                        AdminPositionVerTreeBuilder.insertPositionNode(parentNode, positionTreeNode, index);
                        continue;
                    }
                    if (childNode.getUserObject() instanceof PositionVerInfo && parentNode.getChildCount() <= index) {
                        AdminPositionVerTreeBuilder.insertPositionNode(parentNode, positionTreeNode, parentNode.getChildCount());
                        continue;
                    }
                    if (childNode.getUserObject() instanceof PositionVerInfo) {
                        parentNode.insert((MutableTreeNode)positionTreeNode, 1);
                        continue;
                    }
                    parentNode.insert((MutableTreeNode)positionTreeNode, 0);
                    continue;
                }
                parentNode.add((MutableTreeNode)positionTreeNode);
            }
            rows2 = null;
        }
        rows = null;
        nodeMap = null;
        return rootTreeNode;
    }

    private static void insertPositionNode(DefaultKingdeeTreeNode parent, DefaultKingdeeTreeNode child, int index) {
        for (int i = index; i > 0; --i) {
            if (!(((DefaultKingdeeTreeNode)parent.getChildAt(i - 1)).getUserObject() instanceof PositionVerInfo)) continue;
            parent.insert((MutableTreeNode)child, i);
            return;
        }
        parent.insert((MutableTreeNode)child, 0);
    }

    private AdminOrgUnitVerInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitVerInfo adminInfo = new AdminOrgUnitVerInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        int orgStateType = row.getInt("orgStateType");
        String name = this.getAdditionalName(row.getString("name"), orgStateType);
        adminInfo.setName(name);
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIsSealUp(row.getBoolean("isSealUp"));
        adminInfo.setIndex(row.getInt("index"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        adminInfo.setOrgStateType(OrgStateTypeEnum.getEnum(orgStateType));
        adminInfo.setOrgAdjSchm(this.curOrgAdjSchm);
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)row.getString("CtrlUnit.id")));
        adminInfo.setCU(cu);
        AdminOrgUnitVerInfo parentInfo = new AdminOrgUnitVerInfo();
        if (StringUtils.isEmpty((String)row.getString("parent.id"))) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
            parentInfo.setName(row.getString("parent.name"));
            parentInfo.setLevel(row.getInt("parent.level"));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }

    private IRowSet getAdminRowSet(HROrgAdjSchmInfo curOrgAdjSchm, AdminOrgUnitVerInfo rootInfo) throws Exception {
        IRowSet queryResult = this.getAdminbyCU(curOrgAdjSchm, rootInfo);
        return queryResult;
    }

    private IRowSet getAdminbyCU(HROrgAdjSchmInfo curOrgAdjSchm, AdminOrgUnitVerInfo rootInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (rootInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
            fi.setMaskString("#0 or #1");
        }
        FilterInfo sFilter = new FilterInfo();
        sFilter.getFilterItems().add(new FilterItemInfo("orgAdjSchm.id", (Object)curOrgAdjSchm.getId().toString(), CompareType.EQUALS));
        fi.mergeFilter(sFilter, "and");
        if (!this.isShowSealUpOrg) {
            HashSet<Integer> typeSet = new HashSet<Integer>();
            typeSet.add(new Integer(2));
            typeSet.add(new Integer(0));
            sFilter = new FilterInfo();
            sFilter.getFilterItems().add(new FilterItemInfo("orgStateType", typeSet, CompareType.INNER));
            fi.mergeFilter(sFilter, "and");
        }
        viewInfo.setFilter(fi);
        return HROrgVersionFacadeFactory.getRemoteInstance().getAdminOrgUnitVerRowset(viewInfo, curOrgAdjSchm);
    }

    private String getAdditionalName(String name, int orgStateType) {
        String additionalName = name;
        switch (orgStateType) {
            case 1: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_SealUP + ")";
                break;
            }
            case 2: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
                break;
            }
            case 3: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_Wait_SealUP + ")";
                break;
            }
            default: {
                additionalName = name;
            }
        }
        return additionalName;
    }

    private String getPosAdditionalName(String name, int poStateType) {
        String additionalName = name;
        switch (poStateType) {
            case 1: {
                break;
            }
            case 2: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_SealUP + ")";
                break;
            }
            case 3: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_Wait_Enable + ")";
                break;
            }
            case 4: {
                additionalName = name + "(" + OrgUnitVerAdjConstant.Res_Wait_SealUP + ")";
            }
        }
        return additionalName;
    }
}

