/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.client.tree;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.org.AdminOrgUnitVerCollection;
import com.kingdee.eas.hr.org.AdminOrgUnitVerFactory;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.EnableStateEnum;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HROrgVersionFacadeFactory;
import com.kingdee.eas.hr.org.IAdminOrgUnitVer;
import com.kingdee.eas.hr.org.IPositionVer;
import com.kingdee.eas.hr.org.OrgAdjSchmVerException;
import com.kingdee.eas.hr.org.OrgVerAdjEnum;
import com.kingdee.eas.hr.org.PersonVerAdjRecCollection;
import com.kingdee.eas.hr.org.PersonVerAdjRecInfo;
import com.kingdee.eas.hr.org.PersonVerCollection;
import com.kingdee.eas.hr.org.PersonVerFactory;
import com.kingdee.eas.hr.org.PersonVerInfo;
import com.kingdee.eas.hr.org.PositionVerCollection;
import com.kingdee.eas.hr.org.PositionVerFactory;
import com.kingdee.eas.hr.org.PositionVerInfo;
import com.kingdee.eas.hr.org.client.OrgPositionVerListUI;
import com.kingdee.eas.hr.org.client.tree.HROrgVerDnDTree;
import com.kingdee.eas.hr.org.client.tree.OrgVerTreeUtil;
import com.kingdee.eas.hr.org.table.HRDragTable;
import com.kingdee.eas.hr.org.util.OrgUnitVerPositionUtil;
import com.kingdee.eas.hr.org.util.OrgVerAdjUtil;
import com.kingdee.eas.hr.org.util.SortCodeInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OrgVerTreeDropTarget
implements DropTargetListener {
    KDTree targetTree;
    HRDragTable table;
    KDTable tblOptRecoder;
    DefaultKingdeeTreeNode preSelectNode = null;
    HROrgAdjSchmInfo curOrgAdjSchm = null;
    OrgPositionVerListUI orgPosVerListUI = null;
    boolean Permiss_OrgAdjSchm_OrgAdj = false;
    boolean Permiss_OrgAdjSchm_PostionAdj = false;
    boolean Permiss_OrgAdjSchm_PersonAdj = false;

    public HROrgAdjSchmInfo getCurOrgAdjSchm() {
        return this.curOrgAdjSchm;
    }

    public void setCurOrgAdjSchm(HROrgAdjSchmInfo curOrgAdjSchm) {
        this.curOrgAdjSchm = curOrgAdjSchm;
    }

    public OrgVerTreeDropTarget(KDTree tree, HRDragTable table, KDTable tblOptRecoder, OrgPositionVerListUI orgPosVerListUI) {
        this.targetTree = tree;
        this.table = table;
        this.tblOptRecoder = tblOptRecoder;
        this.orgPosVerListUI = orgPosVerListUI;
        new DropTarget((Component)this.targetTree, this);
    }

    public void initPermissCase(boolean Permiss_OrgAdjSchm_OrgAdj, boolean Permiss_OrgAdjSchm_PostionAdj, boolean Permiss_OrgAdjSchm_PersonAdj) {
        this.Permiss_OrgAdjSchm_OrgAdj = Permiss_OrgAdjSchm_OrgAdj;
        this.Permiss_OrgAdjSchm_PostionAdj = Permiss_OrgAdjSchm_PostionAdj;
        this.Permiss_OrgAdjSchm_PersonAdj = Permiss_OrgAdjSchm_PersonAdj;
    }

    private TreeNode getNodeForEvent(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        DropTargetContext dtc = dtde.getDropTargetContext();
        JTree tree = (JTree)dtc.getComponent();
        TreePath path = tree.getClosestPathForLocation(p.x, p.y);
        return (TreeNode)path.getLastPathComponent();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(2);
    }

    private void ctrlPersonMoveCondition(DropTargetDragEvent dtde) {
        boolean isSelectMulType = this.table.checkIsSelectMulTypePerson();
        if (isSelectMulType) {
            ExceptionHandler.handle((Throwable)((Object)new OrgAdjSchmVerException(OrgAdjSchmVerException.SELECT_MULTI_TYPE_PERSON)));
            dtde.rejectDrag();
            this.dragExit(dtde);
            return;
        }
        boolean isNoPos = this.checkIsNoPositionPerson();
        if (isNoPos) {
            Object curNode = this.getCurSelectValOfTreeNode(dtde);
            if (curNode instanceof AdminOrgUnitVerInfo) {
                String personDep = this.table.getSelectedColumnValue(5);
                if (personDep.equals(((AdminOrgUnitVerInfo)curNode).getId().toString())) {
                    dtde.rejectDrag();
                } else {
                    dtde.acceptDrag(2);
                }
            } else if (curNode instanceof PositionVerInfo) {
                dtde.rejectDrag();
            }
        } else {
            Object curNode = this.getCurSelectValOfTreeNode(dtde);
            if (curNode instanceof PositionVerInfo) {
                String personPos = this.table.getSelectedColumnValue(4);
                if (personPos.equals(((PositionVerInfo)curNode).getId().toString())) {
                    dtde.rejectDrag();
                } else {
                    dtde.acceptDrag(2);
                }
            } else if (curNode instanceof AdminOrgUnitVerInfo) {
                dtde.rejectDrag();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.curOrgAdjSchm.getEnableStatus() == EnableStateEnum.ENABLE) {
            return;
        }
        if (this.isPersonMov(dtde)) {
            if (!this.Permiss_OrgAdjSchm_PersonAdj) {
                dtde.rejectDrag();
                return;
            }
            if (this.checkUserMovPersonPermission()) {
                this.SetNodeStyle(dtde);
                this.ctrlPersonMoveCondition(dtde);
                return;
            }
            dtde.rejectDrag();
            return;
        }
        TreePath path = this.targetTree.getSelectionPath();
        if (path == null) return;
        DefaultKingdeeTreeNode curSelectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        Object dragObject = curSelectNode.getUserObject();
        if (dragObject instanceof AdminOrgUnitVerInfo) {
            if (!this.Permiss_OrgAdjSchm_OrgAdj) {
                dtde.rejectDrag();
                return;
            }
            AdminOrgUnitVerInfo org = (AdminOrgUnitVerInfo)dragObject;
            boolean hasPermission = this.checkOrgPermission(org, dtde);
            if (hasPermission) {
                this.paintLine(dtde);
                dtde.acceptDrag(2);
                return;
            }
            String res = EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"No_Permiss_CurOrgAdjSchm_Adj");
            MsgBox.showInfo((String)res);
            dtde.rejectDrag();
            return;
        }
        if (!this.Permiss_OrgAdjSchm_PostionAdj) {
            dtde.rejectDrag();
            return;
        }
        PositionVerInfo position = (PositionVerInfo)dragObject;
        boolean hasPermission = this.checkOrgPermission(position.getAdminOrgUnit(), dtde);
        if (hasPermission) {
            this.paintLine(dtde);
            this.checkPositionCanRemove(dtde, dragObject);
            return;
        }
        String res = EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"No_Permiss_OrgAdjSchm_CurrentPosOfOrgAdj");
        MsgBox.showInfo((String)res);
        dtde.rejectDrag();
    }

    private boolean checkUserMovPersonPermission() {
        int[] selectRows = this.table.getSelectedRows();
        ArrayList<String> personIdList = new ArrayList<String>();
        for (int i = 0; i < selectRows.length; ++i) {
            personIdList.add(this.table.getSelectedColumnValue(1));
        }
        AdminOrgUnitCollection orgColl = new AdminOrgUnitCollection();
        try {
            orgColl = HROrgVersionFacadeFactory.getRemoteInstance().getUserOrgPermission(personIdList);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (orgColl.size() > 0) {
            StringBuffer nameList = new StringBuffer();
            int size = orgColl.size();
            for (int i = 0; i < size; ++i) {
                if (i < size - 1) {
                    nameList.append(orgColl.get(i).getName()).append(",");
                    continue;
                }
                nameList.append(orgColl.get(i).getName());
            }
            String res = EASResource.getString((String)"com.kingdee.eas.hr.org.HROrgAdjSchmVerResource", (String)"No_Permiss_OrgAdjSchm_CurrentOrgPersonAdj");
            MsgBox.showDetailAndOK((Component)((Object)this.orgPosVerListUI), (String)res, (String)nameList.toString(), (int)2);
            return false;
        }
        return true;
    }

    private boolean isPersonMov(DropTargetDragEvent dtde) {
        boolean flag = false;
        DataFlavor[] dataFlavor = dtde.getCurrentDataFlavors();
        if (dataFlavor.length > 1) {
            flag = true;
        }
        return flag;
    }

    private boolean isPersonMov(DropTargetDropEvent dtde) {
        boolean flag = false;
        DataFlavor[] dataFlavor = dtde.getCurrentDataFlavors();
        if (dataFlavor.length > 1) {
            flag = true;
        }
        return flag;
    }

    private void paintLine(DropTargetDragEvent e) {
        DropTargetContext dt = ((DropTarget)e.getSource()).getDropTargetContext();
        Component comp = dt.getComponent();
        JTree jtr = (JTree)comp;
        TreePath closestPath = jtr.getClosestPathForLocation(e.getLocation().x, e.getLocation().y);
        if (closestPath != null) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.getNodeForEvent(e);
            Rectangle pathBounds = jtr.getPathBounds(closestPath);
            if (pathBounds != null) {
                ((HROrgVerDnDTree)((Object)comp)).lineX = pathBounds.x;
                ((HROrgVerDnDTree)((Object)comp)).lineY = pathBounds.y + node.getCustomIcon().getIconHeight();
                ((HROrgVerDnDTree)((Object)comp)).lineW = pathBounds.width;
            }
        }
        comp.repaint();
    }

    private void rmvPaintLine(DropTargetEvent e) {
        DropTargetContext context = e.getDropTargetContext();
        Component comp = context.getComponent();
        ((HROrgVerDnDTree)((Object)comp)).lineX = 0;
        ((HROrgVerDnDTree)((Object)comp)).lineY = 0;
        ((HROrgVerDnDTree)((Object)comp)).lineW = 0;
        ((HROrgVerDnDTree)((Object)comp)).repaint();
    }

    private void checkPositionCanRemove(DropTargetDragEvent dtde, Object dragObject) {
        Point p = dtde.getLocation();
        TreePath path = this.targetTree.getClosestPathForLocation(p.x, p.y);
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object targetObj = targetNode.getUserObject();
        if (targetObj instanceof AdminOrgUnitVerInfo) {
            dtde.acceptDrag(2);
        } else if (targetObj instanceof PositionVerInfo) {
            PositionVerInfo dragPos = (PositionVerInfo)dragObject;
            PositionVerInfo targetPos = (PositionVerInfo)targetObj;
            if (targetPos.getId().equals((Object)dragPos.getId())) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(2);
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.rmvPaintLine(dte);
        this.restoreNodeStyle(this.preSelectNode);
        dte.getSource();
        dte.getDropTargetContext();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.curOrgAdjSchm.getEnableStatus() == EnableStateEnum.ENABLE) {
            return;
        }
        this.rmvPaintLine(dtde);
        this.restoreNodeStyle(this.preSelectNode);
        if (this.isPersonMov(dtde)) {
            if (this.checkIsNoPositionPerson()) {
                this.doWithPersonNoPositionMov(dtde);
            } else {
                this.doWithPersonHasPositionMov(dtde);
            }
            int[] selectRows = this.table.getSelectedRows();
            this.table.removeRows(selectRows);
        } else {
            this.doWithTreeNodeMove(dtde);
        }
    }

    private void doWithPersonNoPositionMov(DropTargetDropEvent dtde) {
        DefaultMutableTreeNode targetNode = this.getTargetTreeObject(dtde);
        if (targetNode != null) {
            AdminOrgUnitVerInfo targetOrgUnit = (AdminOrgUnitVerInfo)targetNode.getUserObject();
            PersonVerAdjRecInfo personVerAdj = null;
            PersonVerInfo personver = null;
            Timestamp currentTime = OrgVerAdjUtil.getTime();
            UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
            HROrgAdjSchmInfo orgAdjSchm = new HROrgAdjSchmInfo();
            orgAdjSchm.setId(BOSUuid.read((String)this.table.getSelectedColumnValue(6)));
            int[] selectRows = this.table.getSelectedRows();
            String beforeAdjOrg = this.table.getSelectedColumnValue(5);
            String targetOrgID = targetOrgUnit.getId().toString();
            PersonVerCollection personVerList = new PersonVerCollection();
            PersonVerAdjRecCollection personVerAdjList = new PersonVerAdjRecCollection();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            StringBuffer nameString = new StringBuffer();
            for (int i = 0; i < selectRows.length; ++i) {
                personver = new PersonVerInfo();
                personver.setId(BOSUuid.read((String)this.table.getValueAt(selectRows[i], 1).toString()));
                personver.setPersonDep(targetOrgUnit);
                personver.setOrgAdjSchm(orgAdjSchm);
                personver.setLastUpdateTime(currentTime);
                personver.setLastUpdateUser(curUser);
                personVerList.add(personver);
                personVerAdj = new PersonVerAdjRecInfo();
                personVerAdj.setPersonVer(personver);
                personVerAdj.setOrgAdjSchm(orgAdjSchm);
                personVerAdj.setBeforeAdjOrg(beforeAdjOrg);
                personVerAdj.setAfterAdjOrg(targetOrgID);
                personVerAdj.setLastUpdateTime(currentTime);
                personVerAdj.setLastUpdateUser(curUser);
                personVerAdj.setCreateTime(currentTime);
                personVerAdj.setCreator(curUser);
                personVerAdj.setIsPrimaryAdj(0);
                personVerAdj.setAdjType(OrgVerAdjEnum.MOVE);
                personVerAdj.setEnableStatus(EnableStateEnum.UNABLE);
                personVerAdjList.add(personVerAdj);
                if (i == 0) {
                    nameString.append(this.table.getValueAt(selectRows[i], 2));
                    continue;
                }
                nameString.append(",").append(this.table.getValueAt(selectRows[i], 2));
            }
            paramMap.put("NoPostion_Person_Mov", new Boolean(true));
            paramMap.put("personVerList", (Object)personVerList);
            paramMap.put("personVerAdjList", (Object)personVerAdjList);
            try {
                PersonVerFactory.getRemoteInstance().move(paramMap);
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, targetOrgUnit.getOrgAdjSchm());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                dtde.rejectDrop();
            }
        }
    }

    private void doWithPersonHasPositionMov(DropTargetDropEvent dtde) {
        DefaultMutableTreeNode targetNode = this.getTargetTreeObject(dtde);
        if (targetNode != null) {
            PositionVerInfo targetPos = (PositionVerInfo)targetNode.getUserObject();
            AdminOrgUnitVerInfo targetOrgUnit = targetPos.getAdminOrgUnit();
            PersonVerInfo personver = null;
            PersonVerAdjRecInfo personVerAdj = null;
            Timestamp currentTime = OrgVerAdjUtil.getTime();
            UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
            HROrgAdjSchmInfo orgAdjSchm = new HROrgAdjSchmInfo();
            orgAdjSchm.setId(BOSUuid.read((String)this.table.getSelectedColumnValue(6)));
            int[] selectRows = this.table.getSelectedRows();
            String beforeAdjOrg = this.table.getSelectedColumnValue(5);
            String targetPosID = targetPos.getId().toString();
            String targetAdjOrg = targetOrgUnit.getId().toString();
            PersonVerCollection personVerList = new PersonVerCollection();
            PersonVerAdjRecCollection personVerAdjList = new PersonVerAdjRecCollection();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            StringBuffer nameString = new StringBuffer();
            for (int i = 0; i < selectRows.length; ++i) {
                personver = new PersonVerInfo();
                personver.setId(BOSUuid.read((String)this.table.getValueAt(selectRows[i], 1).toString()));
                personver.setPersonDep(targetOrgUnit);
                personver.setOrgAdjSchm(orgAdjSchm);
                personver.setPrimaryPosition(targetPos);
                personver.setLastUpdateTime(currentTime);
                personver.setLastUpdateUser(curUser);
                personVerList.add(personver);
                personVerAdj = new PersonVerAdjRecInfo();
                personVerAdj.setPersonVer(personver);
                personVerAdj.setOrgAdjSchm(orgAdjSchm);
                personVerAdj.setBeforeAdjOrg(beforeAdjOrg);
                personVerAdj.setAfterAdjOrg(targetAdjOrg);
                personVerAdj.setBeforeAdjPos(this.table.getSelectedColumnValue(4));
                personVerAdj.setAfterAdjPos(targetPosID);
                personVerAdj.setLastUpdateTime(currentTime);
                personVerAdj.setLastUpdateUser(curUser);
                personVerAdj.setCreateTime(currentTime);
                personVerAdj.setCreator(curUser);
                personVerAdj.setIsPrimaryAdj(1);
                personVerAdj.setAdjType(OrgVerAdjEnum.MOVE);
                personVerAdj.setEnableStatus(EnableStateEnum.UNABLE);
                personVerAdj.setAdjType(OrgVerAdjEnum.MOVE);
                personVerAdjList.add(personVerAdj);
                if (i == 0) {
                    nameString.append(this.table.getValueAt(selectRows[i], 2));
                    continue;
                }
                nameString.append(",").append(this.table.getValueAt(selectRows[i], 2));
            }
            paramMap.put("NoPostion_Person_Mov", new Boolean(false));
            paramMap.put("personVerList", (Object)personVerList);
            paramMap.put("personVerAdjList", (Object)personVerAdjList);
            try {
                PersonVerFactory.getRemoteInstance().move(paramMap);
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, targetPos.getOrgAdjSchm());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                dtde.rejectDrop();
            }
        }
    }

    private void doWithTreeNodeMove(DropTargetDropEvent dtde) {
        Point pt = dtde.getLocation();
        TreePath parentpath = this.targetTree.getClosestPathForLocation(pt.x, pt.y);
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)parentpath.getLastPathComponent();
        Transferable tr = dtde.getTransferable();
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        try {
            for (int i = 0; i < flavors.length; ++i) {
                if (!tr.isDataFlavorSupported(flavors[i]) || !(tr.getTransferData(flavors[i]) instanceof TreePath)) continue;
                TreePath p = (TreePath)tr.getTransferData(flavors[i]);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)p.getLastPathComponent();
                if (node.getUserObject().equals(targetNode.getUserObject())) {
                    return;
                }
                if (node.getUserObject() instanceof PositionVerInfo) {
                    boolean dropSuccess = this.doWithPositionTreeNodeMove(dtde, node, targetNode);
                    if (!dropSuccess) {
                        dtde.rejectDrop();
                    } else {
                        dtde.dropComplete(true);
                    }
                } else if (node.getUserObject() instanceof AdminOrgUnitVerInfo && targetNode.getUserObject() instanceof AdminOrgUnitVerInfo) {
                    boolean dropSuccess = this.doWithAdminOrgTreeNodeMove(dtde, node, targetNode);
                    if (!dropSuccess) {
                        dtde.rejectDrop();
                    } else {
                        dtde.dropComplete(true);
                    }
                }
                return;
            }
            dtde.rejectDrop();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            dtde.rejectDrop();
        }
    }

    private boolean checkIsNoPositionPerson() {
        String posId = this.table.getSelectedColumnValue(4);
        return StringUtils.isEmpty((String)posId);
    }

    private Object getCurSelectValOfTreeNode(DropTargetDragEvent dtde) {
        Object userObj = null;
        TreeNode node = this.getNodeForEvent(dtde);
        if (node instanceof DefaultKingdeeTreeNode) {
            DefaultKingdeeTreeNode curNode = (DefaultKingdeeTreeNode)node;
            userObj = curNode.getUserObject();
        }
        return userObj;
    }

    private DefaultMutableTreeNode getTargetTreeObject(DropTargetDropEvent dtde) {
        Transferable tr = dtde.getTransferable();
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        DefaultMutableTreeNode node = null;
        for (int i = 0; i < flavors.length; ++i) {
            if (!tr.isDataFlavorSupported(flavors[i])) continue;
            try {
                if (!(tr.getTransferData(flavors[i]) instanceof TreePath) && (!(tr.getTransferData(flavors[i]) instanceof String) || !" ".equals(tr.getTransferData(flavors[i])))) continue;
                Point p = dtde.getLocation();
                TreePath path = this.targetTree.getClosestPathForLocation(p.x, p.y);
                return (DefaultMutableTreeNode)path.getLastPathComponent();
            }
            catch (Exception e) {
                dtde.rejectDrop();
            }
        }
        return node;
    }

    private void SetNodeStyle(DropTargetDragEvent dtde) {
        DefaultKingdeeTreeNode curNode;
        TreeNode selectNode = this.getNodeForEvent(dtde);
        if (selectNode != null && (curNode = (DefaultKingdeeTreeNode)selectNode) != this.preSelectNode) {
            this.SetNodeLargeStyle(curNode);
            this.restoreNodeStyle(this.preSelectNode);
            this.preSelectNode = curNode;
        }
    }

    private void SetNodeLargeStyle(DefaultKingdeeTreeNode curNode) {
        curNode.getPath();
        Object userObj = curNode.getUserObject();
        DataBaseInfo Info = (DataBaseInfo)userObj;
        String text = "<html><strong><font size=4>" + Info.getName() + "</font></strong></html>";
        curNode.setText(text);
        ((DefaultTreeModel)this.targetTree.getModel()).nodeChanged((TreeNode)curNode);
    }

    private void restoreNodeStyle(DefaultKingdeeTreeNode curNode) {
        if (this.preSelectNode != null) {
            Object selObj = this.preSelectNode.getUserObject();
            DataBaseInfo selInfo = (DataBaseInfo)selObj;
            this.preSelectNode.setText(selInfo.getName());
            ((DefaultTreeModel)this.targetTree.getModel()).nodeChanged((TreeNode)this.preSelectNode);
            this.preSelectNode = curNode;
        }
    }

    private boolean doWithPositionTreeNodeMove(DropTargetDropEvent dtde, DefaultMutableTreeNode node, DefaultMutableTreeNode targetNode) throws BOSException, EASBizException {
        Timestamp currentTime = OrgVerAdjUtil.getTime();
        UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
        PositionVerInfo dragPosInfo = (PositionVerInfo)node.getUserObject();
        dragPosInfo.setLastUpdateTime(currentTime);
        dragPosInfo.setLastUpdateUser(curUser);
        IPositionVer iPosVer = PositionVerFactory.getRemoteInstance();
        DefaultTreeModel model = (DefaultTreeModel)this.targetTree.getModel();
        HashMap<String, Serializable> movParam = new HashMap<String, Serializable>();
        boolean dragSuccess = false;
        if (targetNode.getUserObject() instanceof AdminOrgUnitVerInfo) {
            AdminOrgUnitVerInfo targetOrg = (AdminOrgUnitVerInfo)targetNode.getUserObject();
            int maxIndex = 0;
            if (dragPosInfo.getAdminOrgUnit().getId().equals((Object)targetOrg.getId())) {
                dtde.rejectDrop();
                dragSuccess = false;
            } else {
                HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
                dragPosInfo.setAdminOrgUnit(targetOrg);
                dragPosInfo.setCU(targetOrg.getCU());
                PositionVerInfo responPos = PositionVerFactory.getRemoteInstance().getResponPositionByAdmin(targetOrg);
                if (responPos != null) {
                    dragPosInfo.setParentPosition(responPos);
                }
                if ((maxIndex = iPosVer.getMaxIndex(targetOrg.getId().toString(), targetOrg.getOrgAdjSchm().getId().toString())) == -1) {
                    dragPosInfo.setIndex(-1);
                    dragPosInfo.setIsRespPosition(true);
                    indexMap.put(dragPosInfo.getId().toString(), new Integer(-1));
                } else {
                    int i;
                    PositionVerCollection psColl = new PositionVerCollection();
                    DefaultMutableTreeNode childNode = null;
                    int size = targetNode.getParent().getChildCount();
                    for (i = 0; i < size; ++i) {
                        childNode = (DefaultMutableTreeNode)targetNode.getParent().getChildAt(i);
                        if (!(childNode.getUserObject() instanceof PositionVerInfo)) continue;
                        PositionVerInfo childInfo = (PositionVerInfo)childNode.getUserObject();
                        psColl.add(childInfo);
                    }
                    psColl.add(dragPosInfo);
                    size = psColl.size();
                    for (i = 0; i < size; ++i) {
                        indexMap.put(psColl.get(i).getId().toString(), new Integer(i - 1));
                    }
                    dragPosInfo.setIndex(maxIndex + 1);
                    dragPosInfo.setIsRespPosition(false);
                    indexMap.put(dragPosInfo.getId().toString(), new Integer(maxIndex + 1));
                }
                movParam.put("positionVerInfo", dragPosInfo);
                movParam.put("indexMap", indexMap);
                iPosVer.move(movParam);
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, dragPosInfo.getOrgAdjSchm());
                DefaultMutableTreeNode childNode = null;
                int posPosition = 0;
                int size = targetNode.getChildCount();
                for (int i = 0; i < size; ++i) {
                    childNode = (DefaultMutableTreeNode)targetNode.getChildAt(i);
                    if (!(childNode.getUserObject() instanceof PositionVerInfo)) continue;
                    ++posPosition;
                }
                model.insertNodeInto(node, targetNode, posPosition);
                dtde.dropComplete(true);
                dragSuccess = true;
            }
        } else if (targetNode.getUserObject() instanceof PositionVerInfo) {
            PositionVerInfo targetPos = (PositionVerInfo)targetNode.getUserObject();
            if (dragPosInfo.getAdminOrgUnit().getId().equals((Object)targetPos.getAdminOrgUnit().getId()) && dragPosInfo.isIsRespPosition()) {
                dtde.rejectDrop();
                dragSuccess = false;
            } else if (!dragPosInfo.getAdminOrgUnit().getId().equals((Object)targetPos.getAdminOrgUnit().getId())) {
                AdminOrgUnitVerInfo targetOrg = targetPos.getAdminOrgUnit();
                targetOrg.setOrgAdjSchm(targetPos.getOrgAdjSchm());
                PositionVerInfo responPos = PositionVerFactory.getRemoteInstance().getResponPositionByAdmin(targetOrg);
                if (responPos != null) {
                    dragPosInfo.setParentPosition(responPos);
                }
                int index = model.getIndexOfChild(targetNode.getParent(), targetNode);
                DefaultMutableTreeNode childNode = null;
                PositionVerCollection psColl = new PositionVerCollection();
                int size = targetNode.getParent().getChildCount();
                for (int i = 0; i < size; ++i) {
                    PositionVerInfo childInfo;
                    childNode = (DefaultMutableTreeNode)targetNode.getParent().getChildAt(i);
                    if (!(childNode.getUserObject() instanceof PositionVerInfo) || (childInfo = (PositionVerInfo)childNode.getUserObject()).getId().equals((Object)dragPosInfo.getId())) continue;
                    psColl.add(childInfo);
                }
                if (index + 1 >= psColl.size()) {
                    psColl.add(dragPosInfo);
                } else {
                    psColl.addObject(index + 1, (IObjectValue)dragPosInfo);
                }
                HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
                int size2 = psColl.size();
                for (int i = 0; i < size2; ++i) {
                    indexMap.put(psColl.get(i).getId().toString(), new Integer(i - 1));
                }
                dragPosInfo.setAdminOrgUnit(targetPos.getAdminOrgUnit());
                dragPosInfo.setCU(targetPos.getAdminOrgUnit().getCU());
                movParam.put("positionVerInfo", dragPosInfo);
                movParam.put("indexMap", indexMap);
                iPosVer.move(movParam);
                model.insertNodeInto(node, (DefaultMutableTreeNode)targetNode.getParent(), index + 1);
                try {
                    OrgUnitVerPositionUtil.refreshPositionOfOrgTreeNode(this.targetTree, dragPosInfo, targetPos.getAdminOrgUnit(), this.curOrgAdjSchm, this.orgPosVerListUI.isIncludeSealUpPosition());
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, dragPosInfo.getOrgAdjSchm());
                dtde.dropComplete(true);
            } else {
                DefaultMutableTreeNode beforeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)node.getParent()).getChildBefore(node);
                if (targetNode.getUserObject().equals(beforeNode.getUserObject())) {
                    dtde.rejectDrop();
                    dragSuccess = false;
                } else {
                    int i;
                    int index = model.getIndexOfChild(targetNode.getParent(), targetNode);
                    HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
                    DefaultMutableTreeNode childNode = null;
                    PositionVerCollection psColl = new PositionVerCollection();
                    int size = targetNode.getParent().getChildCount();
                    for (i = 0; i < size; ++i) {
                        PositionVerInfo childInfo;
                        childNode = (DefaultMutableTreeNode)targetNode.getParent().getChildAt(i);
                        if (!(childNode.getUserObject() instanceof PositionVerInfo) || (childInfo = (PositionVerInfo)childNode.getUserObject()).getId().equals((Object)dragPosInfo.getId())) continue;
                        psColl.add(childInfo);
                    }
                    if (index + 1 >= psColl.size()) {
                        psColl.add(dragPosInfo);
                    } else {
                        psColl.addObject(index + 1, (IObjectValue)dragPosInfo);
                    }
                    size = psColl.size();
                    for (i = 0; i < size; ++i) {
                        indexMap.put(psColl.get(i).getId().toString(), new Integer(i - 1));
                    }
                    movParam.put("indexMap", indexMap);
                    iPosVer.updateIndex(indexMap, dragPosInfo.getOrgAdjSchm().getId().toString(), true, dragPosInfo);
                    model.insertNodeInto(node, (DefaultMutableTreeNode)targetNode.getParent(), index + 1);
                    dtde.dropComplete(true);
                    OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, dragPosInfo.getOrgAdjSchm());
                }
            }
        }
        return dragSuccess;
    }

    private PositionVerCollection getPositionVerCollectionByPosId(IPositionVer iPosVer, String orgAdjSchm, List idList) throws BOSException {
        String idCondition = HRSchemeUtils.getStrFromList((List)idList);
        StringBuffer oql = new StringBuffer();
        oql.append(" select id,index where id in ").append(idCondition).append(" and orgAdjSchm='").append(orgAdjSchm).append("' order by index");
        PositionVerCollection coll = iPosVer.getPositionVerCollection(oql.toString());
        return coll;
    }

    private boolean doWithAdminOrgTreeNodeMove(DropTargetDropEvent dtde, DefaultMutableTreeNode movNode, DefaultMutableTreeNode targetNode) throws BOSException, EASBizException {
        boolean isSuccess = true;
        AdminOrgUnitVerInfo dragOrgVerInfo = (AdminOrgUnitVerInfo)movNode.getUserObject();
        AdminOrgUnitVerInfo targetOrgVerInfo = (AdminOrgUnitVerInfo)targetNode.getUserObject();
        AdminOrgUnitVerCollection dragcoll = new AdminOrgUnitVerCollection();
        dragcoll.add(dragOrgVerInfo);
        dragcoll.add(targetOrgVerInfo);
        String orgAdjSchm = dragOrgVerInfo.getOrgAdjSchm().getId().toString();
        IAdminOrgUnitVer iAdminUnitVer = AdminOrgUnitVerFactory.getRemoteInstance();
        dragcoll = this.refreshAdminOrgUnitCollection(iAdminUnitVer, orgAdjSchm, dragcoll);
        int size = dragcoll.size();
        for (int i = 0; i < size; ++i) {
            if (dragOrgVerInfo.getId().equals((Object)dragcoll.get(i).getId())) {
                dragOrgVerInfo = dragcoll.get(i);
            }
            if (!targetOrgVerInfo.getId().equals((Object)dragcoll.get(i).getId())) continue;
            targetOrgVerInfo = dragcoll.get(i);
        }
        Timestamp currentTime = OrgVerAdjUtil.getTime();
        dragOrgVerInfo.setLastUpdateTime(currentTime);
        UserInfo curUser = SysContext.getSysContext().getCurrentUserInfo();
        dragOrgVerInfo.setLastUpdateUser(curUser);
        DefaultTreeModel model = (DefaultTreeModel)this.targetTree.getModel();
        boolean isExpanded = this.checkOrgMovOrgNodeIsExpanded(targetNode);
        ArrayList<SortCodeInfo> valList = new ArrayList<SortCodeInfo>();
        SortCodeInfo sortInfo = new SortCodeInfo();
        if (!isExpanded) {
            if (!dragOrgVerInfo.getParent().getId().equals((Object)targetOrgVerInfo.getParent().getId())) {
                AdminOrgUnitVerInfo childInfo;
                int index = model.getIndexOfChild(targetNode.getParent(), targetNode);
                DefaultMutableTreeNode childNode = null;
                int orgFirstChildIndex = -1;
                ArrayList<String> idList = new ArrayList<String>();
                int size2 = targetNode.getParent().getChildCount();
                for (int i = index; i < size2; ++i) {
                    childNode = (DefaultMutableTreeNode)targetNode.getParent().getChildAt(i);
                    if (!(childNode.getUserObject() instanceof AdminOrgUnitVerInfo)) continue;
                    childInfo = (AdminOrgUnitVerInfo)childNode.getUserObject();
                    if (orgFirstChildIndex == -1) {
                        orgFirstChildIndex = i + 1;
                    }
                    idList.add(childInfo.getId().toString());
                }
                idList.add(dragOrgVerInfo.getId().toString());
                AdminOrgUnitVerCollection coll = this.getLongNumberByOrgVerId(iAdminUnitVer, orgAdjSchm, idList);
                int size3 = coll.size();
                for (int i = 0; i < size3; ++i) {
                    childInfo = coll.get(i);
                    if (childInfo.getId().equals((Object)targetOrgVerInfo.getId())) {
                        sortInfo = new SortCodeInfo();
                        sortInfo.setId(dragOrgVerInfo.getId().toString());
                        String newLongNumber = childInfo.getLongNumber().substring(0, childInfo.getLongNumber().lastIndexOf("!")) + "!" + dragOrgVerInfo.getNumber();
                        sortInfo.setLongNumber(newLongNumber);
                        dragOrgVerInfo.setLongNumber(newLongNumber);
                        String preStr = childInfo.getSortCode().substring(0, childInfo.getSortCode().lastIndexOf("!"));
                        String endStr = childInfo.getSortCode().substring(childInfo.getSortCode().lastIndexOf("!") + 1);
                        String newSortCode = preStr + "!" + OrgVerAdjUtil.getSortCodePlusIndex(endStr, 1);
                        sortInfo.setOldSortCode(newSortCode);
                        sortInfo.setNewSortCode(newSortCode);
                        dragOrgVerInfo.setSortCode(newSortCode);
                        sortInfo.setOrgAdjSchm(orgAdjSchm);
                        valList.add(sortInfo);
                        continue;
                    }
                    if (childInfo.getId().equals((Object)targetOrgVerInfo.getId()) || childInfo.getId().equals((Object)dragOrgVerInfo.getId())) continue;
                    sortInfo = new SortCodeInfo();
                    sortInfo.setId(childInfo.getId().toString());
                    sortInfo.setLongNumber(childInfo.getLongNumber());
                    sortInfo.setOldSortCode(childInfo.getSortCode());
                    String preStr = childInfo.getSortCode().substring(0, childInfo.getSortCode().lastIndexOf("!"));
                    String endStr = childInfo.getSortCode().substring(childInfo.getSortCode().lastIndexOf("!") + 1);
                    String newSortCode = preStr + "!" + OrgVerAdjUtil.getSortCodePlusIndex(endStr, 1);
                    sortInfo.setNewSortCode(newSortCode);
                    sortInfo.setOrgAdjSchm(orgAdjSchm);
                    valList.add(sortInfo);
                }
                HashMap<String, Serializable> param = new HashMap<String, Serializable>();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)targetNode.getParent();
                param.put("targetOrg", (AdminOrgUnitVerInfo)parent.getUserObject());
                dragOrgVerInfo.setParent((AdminOrgUnitVerInfo)parent.getUserObject());
                param.put("movOrg", dragOrgVerInfo);
                param.put("valList", valList);
                iAdminUnitVer.move(param);
                model.insertNodeInto(movNode, (DefaultMutableTreeNode)targetNode.getParent(), orgFirstChildIndex);
                dtde.dropComplete(true);
                OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, dragOrgVerInfo.getOrgAdjSchm());
            } else {
                DefaultMutableTreeNode beforeNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)movNode.getParent()).getChildBefore(movNode);
                if (beforeNode == null || targetNode.getUserObject().equals(beforeNode.getUserObject())) {
                    dtde.rejectDrop();
                    isSuccess = false;
                } else {
                    AdminOrgUnitVerInfo childInfo;
                    int index = model.getIndexOfChild(targetNode.getParent(), targetNode);
                    DefaultMutableTreeNode childNode = null;
                    int orgFirstChildIndex = -1;
                    ArrayList<String> idList = new ArrayList<String>();
                    int size4 = targetNode.getParent().getChildCount();
                    for (int i = index; i < size4; ++i) {
                        childNode = (DefaultMutableTreeNode)targetNode.getParent().getChildAt(i);
                        if (!(childNode.getUserObject() instanceof AdminOrgUnitVerInfo)) continue;
                        childInfo = (AdminOrgUnitVerInfo)childNode.getUserObject();
                        if (orgFirstChildIndex == -1) {
                            orgFirstChildIndex = i + 1;
                        }
                        idList.add(childInfo.getId().toString());
                    }
                    idList.add(dragOrgVerInfo.getId().toString());
                    AdminOrgUnitVerCollection coll = this.getLongNumberByOrgVerId(iAdminUnitVer, orgAdjSchm, idList);
                    int size5 = coll.size();
                    for (int i = 0; i < size5; ++i) {
                        String newSortCode;
                        String endStr;
                        String preStr;
                        childInfo = coll.get(i);
                        if (childInfo.getId().equals((Object)targetOrgVerInfo.getId())) {
                            sortInfo = new SortCodeInfo();
                            sortInfo.setId(dragOrgVerInfo.getId().toString());
                            sortInfo.setLongNumber(dragOrgVerInfo.getLongNumber());
                            preStr = childInfo.getSortCode().substring(0, childInfo.getSortCode().lastIndexOf("!"));
                            endStr = childInfo.getSortCode().substring(childInfo.getSortCode().lastIndexOf("!") + 1);
                            newSortCode = preStr + "!" + OrgVerAdjUtil.getSortCodePlusIndex(endStr, 1);
                            sortInfo.setOldSortCode(newSortCode);
                            sortInfo.setNewSortCode(newSortCode);
                            sortInfo.setOrgAdjSchm(orgAdjSchm);
                            valList.add(sortInfo);
                            continue;
                        }
                        if (childInfo.getId().equals((Object)targetOrgVerInfo.getId()) || childInfo.getId().equals((Object)dragOrgVerInfo.getId())) continue;
                        sortInfo = new SortCodeInfo();
                        sortInfo.setId(childInfo.getId().toString());
                        sortInfo.setLongNumber(childInfo.getLongNumber());
                        sortInfo.setOldSortCode(childInfo.getSortCode());
                        preStr = childInfo.getSortCode().substring(0, childInfo.getSortCode().lastIndexOf("!"));
                        endStr = childInfo.getSortCode().substring(childInfo.getSortCode().lastIndexOf("!") + 1);
                        newSortCode = preStr + "!" + OrgVerAdjUtil.getSortCodePlusIndex(endStr, i + 1);
                        sortInfo.setNewSortCode(newSortCode);
                        sortInfo.setOrgAdjSchm(orgAdjSchm);
                        valList.add(sortInfo);
                    }
                    iAdminUnitVer.updateSortCode(valList, true, dragOrgVerInfo);
                    model.insertNodeInto(movNode, (DefaultMutableTreeNode)targetNode.getParent(), orgFirstChildIndex);
                    dtde.dropComplete(true);
                    OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, dragOrgVerInfo.getOrgAdjSchm());
                }
            }
        } else {
            AdminOrgUnitVerInfo childInfo;
            DefaultMutableTreeNode childNode = null;
            int orgFirstChildIndex = -1;
            ArrayList<String> idList = new ArrayList<String>();
            int size6 = targetNode.getChildCount();
            for (int i = 0; i < size6; ++i) {
                childNode = (DefaultMutableTreeNode)targetNode.getChildAt(i);
                if (!(childNode.getUserObject() instanceof AdminOrgUnitVerInfo) || (childInfo = (AdminOrgUnitVerInfo)childNode.getUserObject()).getId().equals((Object)dragOrgVerInfo.getId())) continue;
                idList.add(childInfo.getId().toString());
                if (orgFirstChildIndex != -1) continue;
                orgFirstChildIndex = i;
            }
            idList.add(dragOrgVerInfo.getId().toString());
            idList.add(targetOrgVerInfo.getId().toString());
            AdminOrgUnitVerCollection coll = this.getLongNumberByOrgVerId(iAdminUnitVer, orgAdjSchm, idList);
            int size7 = coll.size();
            for (int i = 0; i < size7; ++i) {
                childInfo = coll.get(i);
                if (childInfo.getId().equals((Object)targetOrgVerInfo.getId())) {
                    sortInfo = new SortCodeInfo();
                    sortInfo.setId(dragOrgVerInfo.getId().toString());
                    String newLongNumber = childInfo.getLongNumber() + "!" + dragOrgVerInfo.getNumber();
                    sortInfo.setLongNumber(newLongNumber);
                    dragOrgVerInfo.setLongNumber(newLongNumber);
                    String newSortCode = childInfo.getSortCode() + OrgVerAdjUtil.getOrgInitSortCode();
                    sortInfo.setOldSortCode(newSortCode);
                    sortInfo.setNewSortCode(newSortCode);
                    dragOrgVerInfo.setSortCode(newSortCode);
                    sortInfo.setOrgAdjSchm(orgAdjSchm);
                    valList.add(sortInfo);
                    continue;
                }
                if (childInfo.getId().equals((Object)targetOrgVerInfo.getId()) || childInfo.getId().equals((Object)dragOrgVerInfo.getId())) continue;
                sortInfo = new SortCodeInfo();
                sortInfo.setId(childInfo.getId().toString());
                sortInfo.setLongNumber(childInfo.getLongNumber());
                sortInfo.setOldSortCode(childInfo.getSortCode());
                String preStr = childInfo.getSortCode().substring(0, childInfo.getSortCode().lastIndexOf("!"));
                String endStr = childInfo.getSortCode().substring(childInfo.getSortCode().lastIndexOf("!") + 1);
                String newSortCode = preStr + "!" + OrgVerAdjUtil.getSortCodePlusIndex(endStr, 1);
                sortInfo.setNewSortCode(newSortCode);
                sortInfo.setOrgAdjSchm(orgAdjSchm);
                valList.add(sortInfo);
            }
            if (orgFirstChildIndex == -1) {
                valList = new ArrayList();
                sortInfo = new SortCodeInfo();
                sortInfo.setId(dragOrgVerInfo.getId().toString());
                sortInfo.setLongNumber(targetOrgVerInfo.getLongNumber() + "!" + dragOrgVerInfo.getNumber());
                sortInfo.setOldSortCode(targetOrgVerInfo.getSortCode() + OrgVerAdjUtil.getOrgInitSortCode());
                sortInfo.setNewSortCode(targetOrgVerInfo.getSortCode() + OrgVerAdjUtil.getOrgInitSortCode());
                sortInfo.setOrgAdjSchm(orgAdjSchm);
                valList.add(sortInfo);
                orgFirstChildIndex = targetNode.getChildCount();
            }
            if (dragOrgVerInfo.getParent().getId().equals((Object)targetOrgVerInfo.getId())) {
                iAdminUnitVer.updateSortCode(valList, true, dragOrgVerInfo);
            } else {
                HashMap<String, Serializable> param = new HashMap<String, Serializable>();
                param.put("movOrg", dragOrgVerInfo);
                param.put("targetOrg", targetOrgVerInfo);
                param.put("valList", valList);
                iAdminUnitVer.move(param);
            }
            model.insertNodeInto(movNode, targetNode, orgFirstChildIndex);
            dtde.dropComplete(true);
            OrgVerAdjUtil.writeOptRecoder(this.tblOptRecoder, dragOrgVerInfo.getOrgAdjSchm());
        }
        return isSuccess;
    }

    private AdminOrgUnitVerCollection getLongNumberByOrgVerId(IAdminOrgUnitVer iAdminUnitVer, String orgAdjSchm, List idList) throws BOSException {
        String idCondition = HRSchemeUtils.getStrFromList((List)idList);
        StringBuffer oql = new StringBuffer();
        oql.append(" select id,name,longNumber,sortCode where id in ").append(idCondition).append(" and orgAdjSchm='").append(orgAdjSchm).append("' order by sortCode");
        AdminOrgUnitVerCollection coll = iAdminUnitVer.getAdminOrgUnitVerCollection(oql.toString());
        return coll;
    }

    private AdminOrgUnitVerCollection refreshAdminOrgUnitCollection(IAdminOrgUnitVer iAdminUnitVer, String orgAdjSchm, AdminOrgUnitVerCollection coll) throws BOSException {
        String idCondition = HRSchemeUtils.convertColToString((IObjectCollection)coll);
        StringBuffer oql = new StringBuffer();
        oql.append(" select id,orgStateType,name,number,longNumber,level,isSealUp,index,isLeaf,sortCode").append(",CU.id,CU.name,responPosition.id,responPosition.name,parent.id,parent.name,orgAdjSchm.id,orgAdjSchm.name").append(" where id in (").append(idCondition).append(") and orgAdjSchm='").append(orgAdjSchm).append("'");
        return iAdminUnitVer.getAdminOrgUnitVerCollection(oql.toString());
    }

    private boolean checkOrgMovOrgNodeIsExpanded(DefaultMutableTreeNode targetNode) {
        if (targetNode.getChildCount() <= 0) {
            return false;
        }
        DataBaseInfo targetInfo = (DataBaseInfo)targetNode.getUserObject();
        DefaultKingdeeTreeNode treeNode = OrgVerTreeUtil.searchTreeNodeById((DefaultKingdeeTreeNode)this.targetTree.getModel().getRoot(), targetInfo.getId().toString());
        return this.targetTree.isExpanded(new TreePath(treeNode.getPath()));
    }

    private boolean checkOrgPermission(AdminOrgUnitVerInfo orgVerInfo, DropTargetDragEvent dtde) {
        boolean hasPermission = false;
        try {
            hasPermission = HROrgVersionFacadeFactory.getRemoteInstance().getUserOrgPermission(orgVerInfo);
        }
        catch (Exception e) {
            dtde.rejectDrag();
            this.dragExit(dtde);
        }
        return hasPermission;
    }
}

