/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.org.AdminOrgUnitVerInfo;
import com.kingdee.eas.hr.org.EnableStateEnum;
import com.kingdee.eas.hr.org.HROrgAdjSchmFactory;
import com.kingdee.eas.hr.org.HROrgAdjSchmInfo;
import com.kingdee.eas.hr.org.HROrgAdjSchmLogFactory;
import com.kingdee.eas.hr.org.HROrgAdjSchmLogInfo;
import com.kingdee.eas.hr.org.HROrgAdjSchmOptEnum;
import com.kingdee.eas.hr.org.IHROrgAdjSchm;
import com.kingdee.eas.hr.org.OrgAdjustEnableException;
import com.kingdee.eas.hr.org.OrgPosVerAdjRecCollection;
import com.kingdee.eas.hr.org.OrgPosVerAdjRecEntryInfo;
import com.kingdee.eas.hr.org.OrgPosVerAdjRecFactory;
import com.kingdee.eas.hr.org.OrgPosVerAdjRecInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class OrgVerAdjUtil {
    public static Timestamp getTime() {
        Date date = new Date();
        SimpleDateFormat transeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String transeDate = transeFormat.format(date);
        return Timestamp.valueOf(transeDate);
    }

    public static void writeOptRecoder(KDTable tblOptRecoder, HROrgAdjSchmInfo curOrgAdjSchm) {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("id"));
            coll.add(new SelectorItemInfo("adjType"));
            coll.add(new SelectorItemInfo("lastUpdateTime"));
            coll.add(new SelectorItemInfo("optration"));
            coll.add(new SelectorItemInfo("optObjType"));
            coll.add(new SelectorItemInfo("entry.*"));
            viewInfo.setSelector(coll);
            SorterItemInfo sortInfo = new SorterItemInfo("lastUpdateTime");
            sortInfo.setSortType(SortType.DESCEND);
            viewInfo.getSorter().add(sortInfo);
            viewInfo.setTopCount(1);
            OrgPosVerAdjRecCollection orgVerColl = OrgPosVerAdjRecFactory.getRemoteInstance().getOrgPosVerAdjRecCollection(viewInfo);
            if (orgVerColl.size() > 0) {
                OrgPosVerAdjRecInfo recInfo = orgVerColl.get(0);
                int size = recInfo.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    OrgPosVerAdjRecEntryInfo entryInfo = recInfo.getEntry().get(i);
                    IRow row = tblOptRecoder.addRow(0);
                    row.getCell("optTime").setValue((Object)recInfo.getLastUpdateTime());
                    row.getCell("optName").setValue((Object)recInfo.getOptration());
                    row.getCell("actionRecorder").setValue((Object)entryInfo.getDescription());
                    row.getCell("user").setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getName());
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void writeOptRecoder(KDTable tblOptRecoder, HROrgAdjSchmInfo curOrgAdjSchm, int rowNum) {
        try {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("id"));
            coll.add(new SelectorItemInfo("adjType"));
            coll.add(new SelectorItemInfo("lastUpdateTime"));
            coll.add(new SelectorItemInfo("optration"));
            coll.add(new SelectorItemInfo("optObjType"));
            coll.add(new SelectorItemInfo("entry.*"));
            viewInfo.setSelector(coll);
            SorterItemInfo sortInfo = new SorterItemInfo("lastUpdateTime");
            sortInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(sortInfo);
            viewInfo.setTopCount(rowNum);
            OrgPosVerAdjRecCollection orgVerColl = OrgPosVerAdjRecFactory.getRemoteInstance().getOrgPosVerAdjRecCollection(viewInfo);
            int num = orgVerColl.size();
            for (int j = 0; j < num; ++j) {
                OrgPosVerAdjRecInfo recInfo = orgVerColl.get(j);
                int size = recInfo.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    OrgPosVerAdjRecEntryInfo entryInfo = recInfo.getEntry().get(i);
                    IRow row = tblOptRecoder.addRow(0);
                    row.getCell("optTime").setValue((Object)recInfo.getLastUpdateTime());
                    row.getCell("optName").setValue((Object)recInfo.getOptration());
                    row.getCell("actionRecorder").setValue((Object)entryInfo.getDescription());
                    row.getCell("user").setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getName());
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static void writePositionOptRecoder(KDTable tblOptRecoder, HROrgAdjSchmInfo curOrgAdjSchm) {
        try {
            UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
            StringBuffer oql = new StringBuffer();
            oql.append("select top 1 adjType,optObjType,entry.*  where lastUpdateUser='").append(user.getId()).append("'").append(" order by lastUpdateTime desc");
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection coll = new SelectorItemCollection();
            coll.add(new SelectorItemInfo("id"));
            coll.add(new SelectorItemInfo("adjType"));
            coll.add(new SelectorItemInfo("lastUpdateTime"));
            coll.add(new SelectorItemInfo("optration"));
            coll.add(new SelectorItemInfo("optObjType"));
            coll.add(new SelectorItemInfo("entry.*"));
            viewInfo.setSelector(coll);
            SorterItemInfo sortInfo = new SorterItemInfo("lastUpdateTime");
            sortInfo.setSortType(SortType.DESCEND);
            viewInfo.getSorter().add(sortInfo);
            viewInfo.setTopCount(1);
            OrgPosVerAdjRecCollection orgVerColl = OrgPosVerAdjRecFactory.getRemoteInstance().getOrgPosVerAdjRecCollection(viewInfo);
            OrgPosVerAdjRecInfo recInfo = orgVerColl.get(0);
            int size = recInfo.getEntry().size();
            for (int i = 0; i < size; ++i) {
                OrgPosVerAdjRecEntryInfo entryInfo = recInfo.getEntry().get(i);
                IRow row = tblOptRecoder.addRow();
                row.getCell("optTime").setValue((Object)recInfo.getLastUpdateTime());
                row.getCell("optName").setValue((Object)recInfo.getOptration());
                row.getCell("actionRecorder").setValue((Object)entryInfo.getDescription());
                row.getCell("user").setValue((Object)SysContext.getSysContext().getCurrentUserInfo().getName());
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static String getSortCodeSuffix(int index) {
        StringBuffer sortCodeSuffix = new StringBuffer();
        int digit = new Integer(index).toString().length();
        int zeroNum = 6 - digit;
        for (int i = 0; i < zeroNum; ++i) {
            sortCodeSuffix.append("0");
        }
        sortCodeSuffix.append(index);
        return sortCodeSuffix.toString();
    }

    public static String getSortCodePlusIndex(String sortCode, int index) {
        for (int i = 0; i <= 6 && sortCode.startsWith("0"); ++i) {
            sortCode = sortCode.substring(1);
        }
        if (StringUtils.isEmpty((String)sortCode) || "null".equals(sortCode)) {
            sortCode = "0";
        }
        return OrgVerAdjUtil.getSortCodeSuffix(Integer.parseInt(sortCode) + index);
    }

    public static String getTimeName() {
        Calendar c = Calendar.getInstance();
        StringBuffer dateString = new StringBuffer();
        dateString.append(c.get(1));
        int temp = c.get(2) + 1;
        if (temp < 10) {
            dateString.append("0");
        }
        dateString.append(temp);
        temp = c.get(5);
        if (temp < 10) {
            dateString.append("0");
        }
        dateString.append(temp);
        temp = c.get(10);
        if (temp < 10) {
            dateString.append("0");
        }
        dateString.append(temp);
        temp = c.get(12);
        if (temp < 10) {
            dateString.append("0");
        }
        dateString.append(temp);
        temp = c.get(13);
        if (temp < 10) {
            dateString.append("0");
        }
        dateString.append(temp);
        dateString.append(c.get(14));
        return dateString.toString();
    }

    public static AdminOrgUnitInfo getTopAdminLongNumberOfCU(Context ctx, CtrlUnitInfo cu) throws BOSException {
        AdminOrgUnitInfo adminInfo = null;
        StringBuffer sql = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        sql.append("select top 1  fid,fLongNumber,fnumber,fname_" + l + ",fparentid from T_ORG_Admin where (fcontrolunitid='").append(cu.getId().toString()).append("')").append("  order by fLongNumber asc");
        IRowSet rs = null;
        if (ctx != null) {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        } else {
            ISQLExecutor iSQLE = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            rs = iSQLE.executeSQL();
        }
        try {
            if (rs.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                adminInfo.setLongNumber(rs.getString("flongnumber"));
                adminInfo.setName(rs.getString("fname_" + l + ""));
                adminInfo.setNumber(rs.getString("fnumber"));
                if (!StringUtils.isEmpty((String)rs.getString("fparentid"))) {
                    AdminOrgUnitInfo parent = new AdminOrgUnitInfo();
                    parent.setId(BOSUuid.read((String)rs.getString("fparentid")));
                    adminInfo.setParent(parent);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminInfo;
    }

    public static AdminOrgUnitInfo getTopAdminLongNumberByOrgAdjSchm(Context ctx, HROrgAdjSchmInfo schmInfo) throws BOSException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        AdminOrgUnitInfo adminInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1  fid,fLongNumber,fnumber,fname_" + l + ",fparentid from T_ORG_Admin where (fid='").append(schmInfo.getAdminOrgUnit().getId().toString()).append("')").append("  order by fLongNumber asc");
        IRowSet rs = null;
        if (ctx != null) {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        } else {
            ISQLExecutor iSQLE = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            rs = iSQLE.executeSQL();
        }
        try {
            if (rs.next()) {
                adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                adminInfo.setLongNumber(rs.getString("flongnumber"));
                adminInfo.setName(rs.getString("fname_" + l + ""));
                adminInfo.setNumber(rs.getString("fnumber"));
                if (!StringUtils.isEmpty((String)rs.getString("fparentid"))) {
                    AdminOrgUnitInfo parent = new AdminOrgUnitInfo();
                    parent.setId(BOSUuid.read((String)rs.getString("fparentid")));
                    adminInfo.setParent(parent);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminInfo;
    }

    public static AdminOrgUnitVerInfo getTopAdminVerLongNumberOfCU(Context ctx, CtrlUnitInfo cu, HROrgAdjSchmInfo adjSchm) throws BOSException {
        String l = LocaleUtils.getShortCode((Context)ctx);
        AdminOrgUnitVerInfo adminInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1  fid,fLongNumber,fnumber,fname_" + l + ",fparentid from T_HR_AdminOrgUnitVer where (fcontrolunitid='").append(cu.getId().toString()).append("')").append(" and fOrgAdjSchm='").append(adjSchm.getId()).append("'").append(" order by fLongNumber asc");
        IRowSet rs = null;
        if (ctx != null) {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        } else {
            ISQLExecutor iSQLE = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
            rs = iSQLE.executeSQL();
        }
        try {
            if (rs.next()) {
                adminInfo = new AdminOrgUnitVerInfo();
                adminInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                adminInfo.setLongNumber(rs.getString("flongnumber"));
                adminInfo.setName(rs.getString("fname_" + l + ""));
                adminInfo.setNumber(rs.getString("fnumber"));
                if (!StringUtils.isEmpty((String)rs.getString("fparentid"))) {
                    AdminOrgUnitVerInfo parent = new AdminOrgUnitVerInfo();
                    parent.setId(BOSUuid.read((String)rs.getString("fparentid")));
                    adminInfo.setParent(parent);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminInfo;
    }

    public static String getOrgWhereStr(Context ctx, CtrlUnitInfo ctrlUnitInfo) throws BOSException {
        AdminOrgUnitInfo topAdminInfo = OrgVerAdjUtil.getTopAdminLongNumberOfCU(ctx, ctrlUnitInfo);
        StringBuffer where = new StringBuffer();
        where.append(" (org.flongNumber='");
        where.append(topAdminInfo.getLongNumber());
        where.append("' or org.flongNumber like '");
        where.append(topAdminInfo.getLongNumber()).append("!%'");
        where.append(")");
        return where.toString();
    }

    public static String getOrgWhereStrByOrgAdjSchm(Context ctx, HROrgAdjSchmInfo schmInfo) throws BOSException {
        AdminOrgUnitInfo topAdminInfo = OrgVerAdjUtil.getTopAdminLongNumberByOrgAdjSchm(ctx, schmInfo);
        StringBuffer where = new StringBuffer();
        where.append(" (org.flongNumber='");
        where.append(topAdminInfo.getLongNumber());
        where.append("' or org.flongNumber like '");
        where.append(topAdminInfo.getLongNumber()).append("!%'");
        where.append(")");
        return where.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserOrgRangeCU(Context ctx, UserInfo userInfo) {
        String idstr = " ('') ";
        StringBuffer sql = new StringBuffer();
        sql.append(" select baseUnit.fid FROM T_ORG_BaseUnit baseUnit ").append(" LEFT JOIN T_PM_OrgRange ORGR ON baseUnit.FID = ORGR.FORGID").append(" LEFT JOIN T_PM_USER PUSER ON PUSER.FID = ORGR.FUSERID ").append(" WHERE baseUnit.fisCU=1 and ORGR.FType = 20 AND PUSER.fid = '").append(userInfo.getId()).append("'");
        ArrayList<String> idList = new ArrayList<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                idList.add(rs.getString("fid"));
            }
            idstr = OrgVerAdjUtil.getStrFromList(idList);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, null, null);
        }
        return idstr;
    }

    public static boolean objectIsEquals(ObjectBaseInfo obj1, ObjectBaseInfo obj2) {
        if (obj1 == null || obj2 == null) {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null && obj2 != null) {
                return false;
            }
            return false;
        }
        return obj1.getId().equals((Object)obj2.getId());
    }

    public static boolean objectIsEquals(ObjectBaseInfo obj1, String str) {
        if (obj1 == null) {
            return StringUtils.isEmpty((String)str);
        }
        return obj1.getId().toString().equals(str);
    }

    public static boolean objectIsEquals(String str1, String str2) {
        if (StringUtils.isEmpty((String)str1)) {
            return StringUtils.isEmpty((String)str2);
        }
        return str1.equals(str2);
    }

    public static String getStrFromList(List list) {
        StringBuffer sb = new StringBuffer();
        if (list == null || list.size() == 0) {
            return "('')";
        }
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static FilterItemInfo getUserRangOrgAdjSchmCUFilter(boolean addOrgAdjSchmCU, HROrgAdjSchmInfo orgAdjSchm) {
        StringBuffer sql = new StringBuffer();
        sql.append("select CU.FID from T_PM_OrgRange range inner join t_pm_user us on us.fid=range.fuserID ").append(" INNER JOIN T_ORG_CtrlUnit AS CU ON range.forgID = CU.FID ").append(" WHERE range.FType=10 and fIsCu=1 and us.FID = ").append("'").append(SysContext.getSysContext().getCurrentUserInfo().getId().toString()).append("'");
        if (addOrgAdjSchmCU) {
            StringBuffer oql = new StringBuffer();
            oql.append("select cu.id,cu.name,cu.longNumber where id='").append(orgAdjSchm.getId()).append("'");
            try {
                HROrgAdjSchmInfo orgSchm = HROrgAdjSchmFactory.getRemoteInstance().getHROrgAdjSchmInfo(oql.toString());
                CtrlUnitInfo orgAdjCU = orgSchm.getCU();
                sql.append(" and (cu.fLongNumber='").append(orgAdjCU.getLongNumber()).append("' or cu.fLongNumber like '").append(orgAdjCU.getLongNumber()).append("!%')");
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER);
    }

    public static String convertColToString(IObjectCollection col) {
        if (col == null || col.isEmpty()) {
            return null;
        }
        StringBuffer values = new StringBuffer();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                values.append(",");
            }
            values.append("'");
            values.append(((CoreBaseInfo)col.getObject(i)).getId());
            values.append("'");
        }
        return values.toString();
    }

    public static String getOrgInitSortCode() {
        return "!000000";
    }

    public static void updateOrgAdjSchm(Context ctx, String orgAdjSchmId) throws BOSException {
        try {
            IHROrgAdjSchm iHROrgAdjSchm = HROrgAdjSchmFactory.getLocalInstance(ctx);
            HROrgAdjSchmInfo schmInfo = iHROrgAdjSchm.getHROrgAdjSchmInfo((IObjectPK)new ObjectUuidPK(orgAdjSchmId));
            iHROrgAdjSchm.submit((CoreBaseInfo)schmInfo);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static List getPersonDept(Context ctx, List personIdList) throws BOSException {
        String personId = OrgVerAdjUtil.getStrFromList(personIdList);
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FPersonDep From T_HR_PersonPosition where FPersonID in ").append(personId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> deptList = new ArrayList<String>();
        try {
            while (rs.next()) {
                deptList.add(rs.getString("FPersonDep"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs, null, null);
        }
        return deptList;
    }

    public static void writeImportAdjInfo(Context ctx, HROrgAdjSchmInfo schmInfo, HROrgAdjSchmOptEnum optEnum) throws EASBizException, BOSException {
        HROrgAdjSchmLogInfo logInfo = new HROrgAdjSchmLogInfo();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        logInfo.setOptUserName(user.getName());
        logInfo.setOptUserID(user.getId().toString());
        logInfo.setAction(optEnum);
        logInfo.setOptTime(OrgVerAdjUtil.getTime());
        logInfo.setOrgAdjSchmID(schmInfo.getId().toString());
        logInfo.setOrgAdjSchmName(schmInfo.getName());
        HROrgAdjSchmLogFactory.getLocalInstance(ctx).submit(logInfo);
    }

    public static String getReplaceHisTableSQL(String originalSql) {
        originalSql = originalSql.replaceAll("T_HR_AdminOrgUnitVer", "T_HR_AdminOrgUnitVerHis");
        originalSql = originalSql.replaceAll("T_HR_PositionVer", "T_HR_PositionVerHis");
        originalSql = originalSql.replaceAll("T_HR_PersonVer", "T_HR_PersonVerHis");
        originalSql = originalSql.replaceAll("T_HR_ADMINORGUNITVER", "T_HR_AdminOrgUnitVerHis");
        originalSql = originalSql.replaceAll("T_HR_POSITIONVER", "T_HR_PositionVerHis");
        originalSql = originalSql.replaceAll("T_HR_PERSONVER", "T_HR_PersonVerHis");
        return originalSql;
    }

    public static void checkSchemeEnable(Context ctx, String schemeId) throws EASBizException, BOSException {
        HROrgAdjSchmInfo hrOrgAdjSchmInfo = null;
        hrOrgAdjSchmInfo = ctx == null ? HROrgAdjSchmFactory.getRemoteInstance().getHROrgAdjSchmInfo((IObjectPK)new ObjectUuidPK(schemeId)) : HROrgAdjSchmFactory.getLocalInstance(ctx).getHROrgAdjSchmInfo((IObjectPK)new ObjectUuidPK(schemeId));
        if (EnableStateEnum.ENABLE.equals((Object)hrOrgAdjSchmInfo.getEnableStatus()) || EnableStateEnum.PART_ENABLE.equals((Object)hrOrgAdjSchmInfo.getEnableStatus())) {
            throw new OrgAdjustEnableException(OrgAdjustEnableException.SCHEME_IS_ENABLE);
        }
    }
}

