/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.competmodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.affair.ApproveStateEnum;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.base.EmpInfoMultiPageInfo;
import com.kingdee.eas.hr.base.app.HRDbUtil;
import com.kingdee.eas.hr.competmodel.CapComEmpEntryCollection;
import com.kingdee.eas.hr.competmodel.CapComPosiEntryCollection;
import com.kingdee.eas.hr.competmodel.CapacityCompetFactory;
import com.kingdee.eas.hr.competmodel.CapacityCompetInfo;
import com.kingdee.eas.hr.competmodel.ICapacityCompet;
import com.kingdee.eas.hr.competmodel.app.AbstractCapacityCompetControllerBean;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexFactory;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexHistoryFactory;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexHistoryInfo;
import com.kingdee.eas.hr.emp.EmployeeCompetIndexInfo;
import com.kingdee.eas.hr.emp.IEmployeeCompetIndex;
import com.kingdee.eas.hr.emp.IEmployeeCompetIndexHistory;
import com.kingdee.eas.hr.org.IPositionCompetIndex;
import com.kingdee.eas.hr.org.PositionCompetIndexFactory;
import com.kingdee.eas.hr.org.PositionCompetIndexInfo;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.File;
import java.io.FileInputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CapacityCompetControllerBean
extends AbstractCapacityCompetControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.competmodel.app.CapacityCompetControllerBean");

    @Override
    protected List _getAttachmentByBillId(Context ctx, String billId) throws BOSException, EASBizException {
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String[] attachmentIds = asm.getAttachmentIDsByBoBOSType(billId);
        ArrayList<String> list = new ArrayList<String>();
        if (attachmentIds != null && attachmentIds.length > 0) {
            for (int i = 0; i < attachmentIds.length; ++i) {
                list.add(attachmentIds[i]);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectPK _submitAttachment(Context ctx, List attachments, IObjectValue editData, ApproveStateEnum approveStateEnum) throws BOSException, EASBizException {
        IObjectPK contractPk;
        block8: {
            contractPk = null;
            try {
                AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
                contractPk = approveStateEnum.equals((Object)ApproveStateEnum.DIRECT) ? this._save(ctx, editData) : this._submit(ctx, editData);
                if (attachments == null || attachments.size() <= 0) break block8;
                SimpleAttachmentInfo sai = null;
                byte[] b = null;
                FileInputStream fis = null;
                for (int i = 0; i < attachments.size(); ++i) {
                    AbstractInterruptibleChannel fc = null;
                    try {
                        File file = (File)attachments.get(i);
                        sai = new SimpleAttachmentInfo();
                        sai.setMainName(StringUtil4File.getMainFileName((String)file.getName()));
                        sai.setExtName(StringUtil4File.getExtendedFileName((String)file.getName()));
                        fis = new FileInputStream(file);
                        fc = fis.getChannel();
                        long size = ((FileChannel)fc).size();
                        b = new byte[(int)size];
                        MappedByteBuffer mbb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, size);
                        mbb.get(b);
                        mbb.clear();
                    }
                    finally {
                        if (fc != null) {
                            fc.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    sai.setContent(b);
                    asm.addNewAttachment(ctx, contractPk.toString(), sai);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return contractPk;
    }

    @Override
    protected void _setAuditNotPass(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        ICapacityCompet cc = CapacityCompetFactory.getLocalInstance(ctx);
        CapacityCompetInfo info = cc.getCapacityCompetInfo((IObjectPK)new ObjectUuidPK(billId.toString()));
        info.setAuditState(HRAffairState.STOP);
        cc.submit((CoreBaseInfo)info);
    }

    @Override
    protected void _setAuditPass(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        CoreBillEntryBaseInfo entry;
        int i;
        ICapacityCompet cc = CapacityCompetFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.*"));
        sic.add(new SelectorItemInfo("empEntry.id"));
        sic.add(new SelectorItemInfo("empEntry.*"));
        sic.add(new SelectorItemInfo("positionEntry.id"));
        sic.add(new SelectorItemInfo("positionEntry.*"));
        CapacityCompetInfo info = cc.getCapacityCompetInfo((IObjectPK)new ObjectUuidPK(billId.toString()), sic);
        CapComEmpEntryCollection empColl = info.getEmpEntry();
        CapComPosiEntryCollection posColl = info.getPositionEntry();
        IEmployeeCompetIndex eci = EmployeeCompetIndexFactory.getLocalInstance((Context)ctx);
        if (empColl != null && empColl.size() > 0) {
            IEmployeeCompetIndexHistory ecih = EmployeeCompetIndexHistoryFactory.getLocalInstance((Context)ctx);
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.*"));
            sic.add(new SelectorItemInfo("empCompetIndex.id"));
            sic.add(new SelectorItemInfo("empCompetIndex.*"));
            sic.add(new SelectorItemInfo("indexGrade.id"));
            sic.add(new SelectorItemInfo("indexGrade.*"));
            sic.add(new SelectorItemInfo("hrOrgUnit.id"));
            sic.add(new SelectorItemInfo("hrOrgUnit.*"));
            for (i = 0; i < empColl.size(); ++i) {
                entry = empColl.get(i);
                String historyBillId = entry.getEmpCompetIndexId();
                if (!eci.exists((IObjectPK)new ObjectUuidPK(historyBillId))) continue;
                EmployeeCompetIndexInfo eciInfo = eci.getEmployeeCompetIndexInfo((IObjectPK)new ObjectUuidPK(historyBillId), sic);
                EmployeeCompetIndexHistoryInfo ecihInfo = new EmployeeCompetIndexHistoryInfo();
                ecihInfo.setPerson(eciInfo.getPerson());
                ecihInfo.setEmpCompetIndex(eciInfo.getEmpCompetIndex());
                ecihInfo.setIndexGrade(entry.getIndexGrade());
                ecihInfo.setDescription(entry.getDescription());
                ecihInfo.setHrOrgUnit(eciInfo.getHrOrgUnit());
                ecihInfo.setStartDate(entry.getStartDate());
                ecihInfo.setEndDate(entry.getEndDate());
                ecihInfo.setCapacityBillId(billId.toString());
                ecihInfo.setNumber(info.getNumber());
                ecih.addnew(ecihInfo);
                eci.delete((IObjectPK)new ObjectUuidPK(historyBillId));
            }
        }
        if (posColl != null && posColl.size() > 0) {
            IPositionCompetIndex pci = PositionCompetIndexFactory.getLocalInstance(ctx);
            for (i = 0; i < posColl.size(); ++i) {
                entry = posColl.get(i);
                String posiCompetIndexId = entry.getHistoryPosBillId();
                PositionCompetIndexInfo pciInfo = pci.getPositionCompetIndexInfo((IObjectPK)new ObjectUuidPK(posiCompetIndexId));
                EmployeeCompetIndexInfo eciInfo = new EmployeeCompetIndexInfo();
                eciInfo.setPerson(info.getPerson());
                eciInfo.setEmpCompetIndex(entry.getCompetIndex());
                eciInfo.setIndexGrade(entry.getIndexGrade());
                eciInfo.setDescription(entry.getDescription());
                eciInfo.setHrOrgUnit(pciInfo.getHrOrgUnit());
                eciInfo.setStartDate(entry.getStartDate());
                eciInfo.setEndDate(entry.getEndDate());
                eci.addnew((EmpInfoMultiPageInfo)eciInfo);
            }
        }
        info.setAuditState(HRAffairState.COMPLETE);
        this.mySave(ctx, (IObjectValue)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK contractPk = null;
        contractPk = super._submit(ctx, model);
        this._checkNumberDup(ctx, model);
        return contractPk;
    }

    protected void mySave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CodingRuleServerHelper.recycleNumber((Context)ctx, (IObjectPK)pk, (ICoreBase)CapacityCompetFactory.getLocalInstance(ctx), (String)CapacityCompetInfo.class.getName());
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK contractPk = null;
        contractPk = super._save(ctx, model);
        this._checkNumberDup(ctx, model);
        return contractPk;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CapacityCompetInfo dataBaseInfo = (CapacityCompetInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)dataBaseInfo.getNumber()));
        if (this._exists(ctx, filter)) {
            String number = this.getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private String getPropertyAlias(Context ctx, CapacityCompetInfo dataBaseInfo, String propertyName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = null;
        entity = loader.getEntity(dataBaseInfo.getBOSType());
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            return "";
        }
        return property.getAlias();
    }

    @Override
    public Set _getHROrgUnitIDSet(Context ctx) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT H.FID\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append("FROM T_ORG_UNITRELATION R\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sb.append("INNER JOIN T_ORG_ADMIN A ON R.FFROMUNITID = A.FID\t\t\t\t\t\t\t\n");
        sb.append("INNER JOIN T_ORG_HRO H ON H.FID = R.FTOUNITID\t\t\t\t\t\t\t\t\n");
        sb.append("INNER JOIN T_PM_OrgRange AS OrgRange ON A.fid = OrgRange.FOrgID\t\t\t\t\n");
        sb.append("INNER JOIN T_PM_User Users ON Users.FID = OrgRange.FUserID\t\t\t\t\t\n");
        sb.append("WHERE r.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5'\t\t\n");
        sb.append(" AND Users.FID = '" + userInfo.getId() + "'\t\t\t\t\t\t\t\t\t\t\n");
        IRowSet rs = HRDbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashSet<String> ids = new HashSet<String>();
        String orgID = null;
        if (rs != null && rs.size() > 0) {
            try {
                while (rs.next()) {
                    orgID = rs.getString(1);
                    if (orgID == null) continue;
                    ids.add(orgID);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        return ids;
    }
}

