/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.competmodel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.competmodel.CompetModelException;
import com.kingdee.eas.hr.competmodel.IndexGradeInfo;
import com.kingdee.eas.hr.competmodel.app.AbstractIndexGradeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public class IndexGradeControllerBean
extends AbstractIndexGradeControllerBean {
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IndexGradeInfo info = (IndexGradeInfo)model;
        this._checkNameBlank(ctx, (IObjectValue)info);
        this._checkNameDup(ctx, (IObjectValue)info);
        info.setIndex(this.getMaxIndex(ctx) + 1);
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameDup(ctx, model, "l1");
        this.checkNameDup(ctx, model, "l2");
        this.checkNameDup(ctx, model, "l3");
    }

    private void checkNameDup(Context ctx, IObjectValue model, String lang) throws CompetModelException, BOSException {
        StringBuffer sql = new StringBuffer();
        String name = null;
        String displayName = null;
        displayName = lang.equals("l1") ? Locale.ENGLISH.getDisplayName() : (lang.equals("l2") ? Locale.CHINA.getDisplayName() : Locale.TAIWAN.getDisplayName());
        if (lang.equals(ctx.getLocale().toString())) {
            displayName = BOSLocaleUtil.getLanguage((Locale)ctx.getLocale()).getName();
        }
        name = (String)model.get("name_" + lang);
        sql.append("select fName_").append(lang).append(" from T_HR_IndexGrade where fName_").append(lang).append(" = '").append(name).append("'");
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rows.next()) {
                throw new CompetModelException(CompetModelException.DUPLICATE_INDEXGRADE, new String[]{displayName, name});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        super._update(ctx, pk, model);
    }

    private int getMaxIndex(Context ctx) throws BOSException, EASBizException {
        HROrgUnitInfo hroInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        if (hroInfo == null) {
            return 1;
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)(" SELECT MAX(FIndex) FROM T_HR_IndexGrade WHERE FHROrgUnitID='" + hroInfo.getId().toString() + "'"));
        try {
            if (rows.next()) {
                int n = rows.getInt(1);
                return n;
            }
            int n = 1;
            return n;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rows);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("index"));
        IndexGradeInfo info = (IndexGradeInfo)this._getValue(ctx, pk, sic);
        FilterInfo filter = new FilterInfo();
        if (info != null && info.getHrOrgUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getHrOrgUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("index", (Object)info.getIndex(), CompareType.GREATER));
            if (this._exists(ctx, filter)) {
                throw new CompetModelException(CompetModelException.DEL_LAST);
            }
        }
        super._delete(ctx, pk);
    }
}

