/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.util.StringCollUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.AdminTreeNodeInfo;
import com.kingdee.eas.hr.org.app.AbstractAdminOrgTreeHISFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class AdminOrgTreeHISFacadeControllerBean
extends AbstractAdminOrgTreeHISFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.AdminOrgTreeHISFacadeControllerBean");

    @Override
    protected AdminTreeNodeInfo _getAdminOrgTreeData(Context ctx, String rootAdminId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg, String userOrgRangeSql, String dateString) throws BOSException, EASBizException {
        ArrayList<String> adminList;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (userId.equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            userOrgRange = false;
        }
        if ((adminList = this.getAllAdminList(ctx, rootAdminId, null, includeSealup, userOrgRange, userOrgRangeSql, dateString)) == null || adminList.size() == 0) {
            return null;
        }
        AdminTreeNodeInfo rootNodeInfo = this.getRootAdminInfo(ctx, rootAdminId, adminList, dateString);
        if (rootNodeInfo == null) {
            return null;
        }
        String nodeOrgId = rootNodeInfo.getId();
        StringBuffer sql = this.getBaseAdminSqlBuffer(ctx, dateString);
        sql.append(" AND (treeHIS.FParentID = '").append(nodeOrgId);
        if (StringUtils.isEmpty((String)rootAdminId)) {
            sql.append("' OR adminOrg.FID = '");
            sql.append(nodeOrgId);
        }
        sql.append("') ");
        if (!showVirtualOrg) {
            sql.append(" AND adminHIS.FIsVirtual = 0 ");
        }
        if (!includeSealup) {
            sql.append(" AND adminHIS.FIsSealUp = 0 ");
        }
        sql.append(" ORDER BY adminHIS.FSortCode,treeHIS.FLongNumber");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            ArrayList<AdminTreeNodeInfo> children = new ArrayList<AdminTreeNodeInfo>();
            AdminTreeNodeInfo subNodeInfo = null;
            String longNumber = null;
            String id = null;
            String adminLongNumbers = adminList.toString();
            boolean hasPermission = true;
            boolean isRemove = false;
            while (rows.next()) {
                isRemove = true;
                longNumber = rows.getString("FLongNumber");
                id = rows.getString("FID");
                if (adminList.contains(longNumber)) {
                    hasPermission = true;
                    isRemove = false;
                } else {
                    int length = adminList.size();
                    for (int t = 0; t < length; ++t) {
                        if (adminList.get(t).indexOf(longNumber + "!") == -1) continue;
                        hasPermission = false;
                        isRemove = false;
                        break;
                    }
                }
                if (id.equals(nodeOrgId)) {
                    rootNodeInfo.setHasPermission(hasPermission);
                    continue;
                }
                if (isRemove) continue;
                subNodeInfo = new AdminTreeNodeInfo();
                subNodeInfo.setId(id);
                subNodeInfo.setLongNumber(longNumber);
                subNodeInfo.setHasPermission(hasPermission);
                if (rows.getBoolean("FIsStartSHR")) {
                    subNodeInfo.setName(rows.getString("FName"));
                } else {
                    String soureceStr = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label62", (Context)ctx);
                    subNodeInfo.setName(rows.getString("FName") + "(" + soureceStr + ")");
                }
                if (rows.getBoolean("FIsSealUp")) {
                    String soureceStr = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label63", (Context)ctx);
                    subNodeInfo.setName(subNodeInfo.getName() + "(" + soureceStr + ")");
                }
                subNodeInfo.setNumber(rows.getString("FNumber"));
                if (adminLongNumbers.indexOf(longNumber + "!") > -1) {
                    subNodeInfo.setLeaf(false);
                } else {
                    subNodeInfo.setLeaf(true);
                }
                subNodeInfo.setLevel(rows.getInt("FLevel"));
                subNodeInfo.setHasPermission(rows.getBoolean("FIsStartSHR"));
                children.add(subNodeInfo);
            }
            rootNodeInfo.setSubAdminlist(children);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return rootNodeInfo;
    }

    @Override
    protected AdminTreeNodeInfo _getRootNodeAdminInfo(Context ctx, String rootId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg, String userOrgRangeSql, String dateString) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (userId.equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            userOrgRange = false;
        }
        AdminTreeNodeInfo rootNodeInfo = null;
        ArrayList<String> adminList = null;
        if (StringUtils.isEmpty((String)rootId) && ((adminList = this.getAllAdminList(ctx, rootId, null, includeSealup, userOrgRange, userOrgRangeSql, dateString)) == null || adminList.size() == 0)) {
            return null;
        }
        rootNodeInfo = this.getRootAdminInfo(ctx, rootId, adminList, dateString);
        return rootNodeInfo;
    }

    private ArrayList<String> getAllAdminList(Context ctx, String rootId, HashSet<String> hroSet, boolean includeSealup, boolean userOrgRange, String userOrgRangeSql, String date) throws BOSException, EASBizException {
        ArrayList<String> adminList = new ArrayList<String>();
        try {
            String filterSql;
            IRowSet rowSet;
            StringBuffer sql = this.getBaseAdminSqlBuffer(ctx, date);
            if (!StringUtils.isEmpty((String)rootId) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(filterSql = "SELECT FLongNumber AS FLongNumber FROM T_ORG_AdminOrgTreeHis WHERE FEFFDT < {ts'" + date + "'} AND FLEFFDT >= {ts'" + date + "'} AND FADMINORGID IN (SELECT FID FROM T_ORG_ADMIN WHERE FID = '" + rootId + "')"))).next()) {
                sql.append("and treeHIS.FLongNumber like '");
                sql.append(rowSet.getString("FLongNumber"));
                sql.append("%' ");
            }
            if (!includeSealup) {
                sql.append("AND adminHIS.FIsSealUp = 0 ");
            }
            if (userOrgRange) {
                sql.append(" AND adminOrg.FID IN (" + userOrgRangeSql + ")");
            }
            sql.append(" ORDER BY adminHIS.FLEVEL,treeHIS.FLongNumber ");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rows.next()) {
                adminList.add(rows.getString("FLongNumber"));
            }
            if (adminList.size() == 0) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return adminList;
    }

    private AdminTreeNodeInfo getRootAdminInfo(Context ctx, String rootId, ArrayList<String> adminList, String date) throws BOSException, EASBizException {
        if ((adminList == null || adminList.size() == 0) && StringUtils.isEmpty((String)rootId)) {
            return null;
        }
        StringBuffer sql = this.getBaseAdminSqlBuffer(ctx, date);
        if (StringUtils.isEmpty((String)rootId) && adminList != null) {
            String longNumber = adminList.get(0);
            int size = adminList.size();
            for (int i = 1; i < size; ++i) {
                for (int count = 0; (adminList.get(i).indexOf(longNumber) == -1 || longNumber.lastIndexOf("!") >= 0 && adminList.get(i).lastIndexOf("!") >= 0 && longNumber.substring(0, longNumber.lastIndexOf("!")).equals(adminList.get(i).substring(0, adminList.get(i).lastIndexOf("!")))) && count < 20; ++count) {
                    longNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                }
            }
            sql.append(" AND treeHIS.FlongNumber = '" + longNumber + "'");
        } else {
            sql.append(" AND adminOrg.FID = '" + rootId + "'");
        }
        AdminTreeNodeInfo rootNodeInfo = null;
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (executeQuery.next()) {
                rootNodeInfo = new AdminTreeNodeInfo();
                rootNodeInfo.setId(executeQuery.getString("FID"));
                rootNodeInfo.setNumber(executeQuery.getString("FNumber"));
                rootNodeInfo.setName(executeQuery.getString("FName"));
                rootNodeInfo.setLongNumber(executeQuery.getString("FlongNumber"));
                if (executeQuery.getInt("FIsLeaf") == 1) {
                    rootNodeInfo.setLeaf(true);
                } else {
                    rootNodeInfo.setLeaf(false);
                }
                rootNodeInfo.setLevel(executeQuery.getInt("FLevel"));
                if (executeQuery.getInt("FIsStartSHR") == 1) {
                    rootNodeInfo.setHasPermission(true);
                } else {
                    rootNodeInfo.setHasPermission(false);
                    String soureceStr = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.HRBaseBizResource", (String)"label62", (Context)ctx);
                    rootNodeInfo.setName(executeQuery.getString("FName") + "\uff08<span style=\"font-weight:bold;\">" + soureceStr + "</span>\uff09");
                }
                IRowSet maxLevelExecute = DbUtil.executeQuery((Context)ctx, (String)("SELECT max(FLEVEL) AS maxLevel FROM T_ORG_ADMIN WHERE FLONGNUMBER LIKE '" + executeQuery.getString("FlongNumber") + "%'"));
                if (maxLevelExecute.size() > 0) {
                    while (maxLevelExecute.next()) {
                        rootNodeInfo.setSelectLevel(maxLevelExecute.getInt("maxLevel") - executeQuery.getInt("FLevel"));
                    }
                } else {
                    rootNodeInfo.setSelectLevel(10);
                }
                IRowSet earliestExecute = DbUtil.executeQuery((Context)ctx, (String)("SELECT MIN(FEFFDT) AS effdt FROM T_ORG_ADMINHIS WHERE FHISTORYRELATEID = '" + rootNodeInfo.getId() + "'"));
                while (earliestExecute.next()) {
                    Date effetDate = earliestExecute.getDate("effdt");
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    String dateString = formatter.format(effetDate);
                    rootNodeInfo.setEarliestEffdt(dateString);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rootNodeInfo;
    }

    protected StringBuffer getBaseAdminSqlBuffer(Context ctx, String date) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT adminOrg.FID AS FID,adminHIS.FNAME_").append(ctx.getLocale()).append(" AS FName,adminHIS.FNumber AS FNumber,adminHIS.FIsSealUp AS FIsSealUp,treeHIS.FLONGNUMBER AS FlongNumber,adminHIS.FIsLeaf AS FIsLeaf,adminHIS.FLevel AS FLevel,adminHIS.FIsStartSHR AS FIsStartSHR");
        sql.append(" FROM T_ORG_ADMIN adminOrg ");
        sql.append(" LEFT JOIN T_ORG_ADMINHIS adminHIS ON adminOrg.FID =  adminHIS.FHISTORYRELATEID");
        sql.append(" LEFT JOIN T_ORG_AdminOrgTreeHis treeHIS ON adminOrg.FID = treeHIS.FADMINORGID");
        sql.append(" WHERE adminHIS.FEFFDT <= {ts'").append(date).append("'} AND adminHIS.FLEFFDT >= {ts'").append(date).append("'}");
        sql.append(" AND treeHIS.FEFFDT <= {ts'").append(date).append("'} AND treeHIS.FLEFFDT >= {ts'").append(date).append("'}");
        return sql;
    }

    @Override
    protected List<AdminTreeNodeInfo> _getSyncAdminOrgTreeData(Context ctx, String rootId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg, String userOrgRangeSql, String dateString) throws BOSException, EASBizException {
        return this._getSyncAdminOrgTreeData(ctx, rootId, userOrgRange, includeSealup, showVirtualOrg, userOrgRangeSql, dateString, null);
    }

    private StringBuffer getAdminTreeHisSqlBuffer(Context ctx, String dateString) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT adminOrg.FID AS FID,treeHIS.FParentID as FParentID,adminHIS.FNumber AS FNumber,adminHIS.FNAME_").append(ctx.getLocale()).append(" AS FName,treeHIS.FLONGNUMBER AS FlongNumber,adminHIS.FIsLeaf AS FIsLeaf,adminHIS.FLevel AS FLevel,adminHIS.FIsStartSHR AS FIsStartSHR,adminHIS.FIsSealUp AS FIsSealUp");
        sql.append(" FROM T_ORG_ADMIN adminOrg ");
        sql.append(" LEFT JOIN T_ORG_ADMINHIS adminHIS ON adminOrg.FID =  adminHIS.FHISTORYRELATEID");
        sql.append(" LEFT JOIN T_ORG_AdminOrgTreeHis treeHIS ON adminOrg.FID = treeHIS.FADMINORGID");
        sql.append(" WHERE adminHIS.FEFFDT <= {ts'").append(dateString).append("'} AND adminHIS.FLEFFDT >= {ts'").append(dateString).append("'}");
        sql.append(" AND treeHIS.FEFFDT <= {ts'").append(dateString).append("'} AND treeHIS.FLEFFDT >= {ts'").append(dateString).append("'}");
        return sql;
    }

    @Override
    protected List<AdminTreeNodeInfo> _getSyncAdminOrgTreeData(Context ctx, String rootId, boolean userOrgRange, boolean includeSealup, boolean showVirtualOrg, String userOrgRangeSql, String dateString, String orgTypeId) throws BOSException, EASBizException {
        ArrayList<AdminTreeNodeInfo> children = null;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (userId.equals("00000000-0000-0000-0000-00000000000013B7DE7F")) {
            userOrgRange = false;
        }
        StringBuffer sql = this.getAdminTreeHisSqlBuffer(ctx, dateString);
        try {
            String filterSql;
            IRowSet rowSet;
            if (!StringUtils.isEmpty((String)rootId) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(filterSql = "SELECT FLongNumber AS FLongNumber FROM T_ORG_AdminOrgTreeHis WHERE FEFFDT < {ts'" + dateString + "'} AND FLEFFDT >= {ts'" + dateString + "'} AND FADMINORGID IN (SELECT FID FROM T_ORG_ADMIN WHERE FID = '" + rootId + "')"))).next()) {
                sql.append("and treeHIS.FLongNumber like '");
                sql.append(rowSet.getString("FLongNumber"));
                sql.append("%' ");
            }
            if (!includeSealup) {
                sql.append(" AND adminHIS.FIsSealUp = 0 ");
            }
            if (!showVirtualOrg) {
                sql.append(" AND adminHIS.FIsVirtual = 0 ");
            }
            if (userOrgRange) {
                sql.append(" AND adminOrg.FID IN (" + userOrgRangeSql + ")");
            } else {
                sql.append(" AND adminOrg.FISSTARTSHR = 1");
            }
            if (!StringUtils.isEmpty((String)orgTypeId)) {
                List<String> orgTypeIdList = Arrays.asList(orgTypeId.split(","));
                sql.append(" AND adminOrg.FLayerTypeID in " + StringCollUtil.getStrFromList(orgTypeIdList));
            }
            sql.append(" ORDER BY adminHIS.FLEVEL,treeHIS.FLongNumber ");
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            AdminTreeNodeInfo subNodeInfo = null;
            children = new ArrayList<AdminTreeNodeInfo>();
            while (executeQuery.next()) {
                String soureceStr;
                subNodeInfo = new AdminTreeNodeInfo();
                subNodeInfo.setId(executeQuery.getString("FID"));
                subNodeInfo.setNumber(executeQuery.getString("FNumber"));
                if (executeQuery.getBoolean("FIsStartSHR")) {
                    subNodeInfo.setName(executeQuery.getString("FName"));
                } else {
                    soureceStr = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label62", (Context)ctx);
                    subNodeInfo.setName(executeQuery.getString("FName") + "(" + soureceStr + ")");
                }
                subNodeInfo.setLongNumber(executeQuery.getString("FlongNumber"));
                subNodeInfo.setParentId(executeQuery.getString("FParentID"));
                subNodeInfo.setLevel(executeQuery.getInt("FLevel"));
                subNodeInfo.setHasPermission(executeQuery.getBoolean("FIsStartSHR"));
                if (executeQuery.getInt("FIsLeaf") == 1) {
                    subNodeInfo.setLeaf(true);
                } else {
                    subNodeInfo.setLeaf(false);
                }
                if (executeQuery.getBoolean("FIsSealUp")) {
                    soureceStr = SHRServerResource.getString((String)"com.kingdee.eas.hr.org.HrOrgBizResource", (String)"label63", (Context)ctx);
                    subNodeInfo.setName(subNodeInfo.getName() + "(" + soureceStr + ")");
                }
                children.add(subNodeInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return children;
    }
}

