/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.PositionException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.AdminOrgUnitHierarchyCollection;
import com.kingdee.eas.hr.org.AdminOrgUnitHierarchyInfo;
import com.kingdee.eas.hr.org.app.AbstractAdminOrgUnitHierarchyControllerBean;
import org.apache.log4j.Logger;

public class AdminOrgUnitHierarchyControllerBean
extends AbstractAdminOrgUnitHierarchyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.AdminOrgUnitHierarchyControllerBean");

    private void checkParentPosition(Context ctx, AdminOrgUnitHierarchyInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)info.getHierarchy().getId().toString());
        filter.getFilterItems().add(filterItem);
        if (this._exists(ctx, filter)) {
            throw new PositionException(PositionException.NO_PARENT_ADMINUNIT);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdminOrgUnitHierarchyInfo info = (AdminOrgUnitHierarchyInfo)model;
        this.checkParent(ctx, info);
        if (info.getParent() == info.getChild()) {
            this.checkParentPosition(ctx, info);
        }
        this.setLevelAndLongNumber(ctx, info.getParent(), info.getChild(), info);
        info.setIsLeaf(true);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)info);
        if (info.getParent() != info.getChild()) {
            AdminOrgUnitHierarchyInfo pModel = this.getParentPH(ctx, info, info.getParent());
            pModel.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(pModel.getId()), (IObjectValue)pModel);
        }
        return pk;
    }

    private void checkParent(Context ctx, AdminOrgUnitHierarchyInfo info) throws BOSException, EASBizException {
        boolean flag = this.hasChild2(ctx, info.getHierarchy().getId().toString(), info.getChild().getId().toString());
        if (flag) {
            throw new PositionException(PositionException.EXIST_HIERARCHY_ADMINUNIT);
        }
    }

    private void setLevelAndLongNumber(Context ctx, AdminOrgUnitInfo parentInfo, AdminOrgUnitInfo info, AdminOrgUnitHierarchyInfo model) throws EASBizException, BOSException {
        if (parentInfo == info) {
            model.setLevel(0);
            model.setLongNumber(info.getNumber());
        } else {
            AdminOrgUnitHierarchyInfo pModel = this.getParentPH(ctx, model, parentInfo);
            model.setLevel(pModel.getLevel() + 1);
            info = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getId()));
            model.setLongNumber(pModel.getLongNumber() + "!" + info.getNumber());
        }
    }

    private AdminOrgUnitHierarchyInfo getParentPH(Context ctx, AdminOrgUnitHierarchyInfo model, AdminOrgUnitInfo parentInfo) throws BOSException {
        AdminOrgUnitHierarchyCollection posiHierColl = null;
        posiHierColl = this.getPHListByChild(ctx, model.getHierarchy().getId().toString(), parentInfo.getId().toString());
        if (posiHierColl != null && posiHierColl.size() > 0) {
            return posiHierColl.get(0);
        }
        return null;
    }

    private void checkUpdate(Context ctx, AdminOrgUnitHierarchyInfo info, AdminOrgUnitHierarchyInfo oldInfo) throws BOSException, EASBizException {
        if (info.getParent().getId().toString().equalsIgnoreCase(info.getChild().getId().toString())) {
            throw new PositionException(PositionException.ERROR_PARENT_1);
        }
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(oldInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        FilterItemInfo filterItem = new FilterItemInfo("child", (Object)info.getParent().getId().toString());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem3 = new FilterItemInfo("hierarchy.id", (Object)oldInfo.getHierarchy().getId().toString());
        filter.getFilterItems().add(filterItem3);
        if (this._exists(ctx, filter)) {
            throw new PositionException(PositionException.ERROR_PARENT_2);
        }
    }

    private AdminOrgUnitHierarchyCollection getPHListByChild(Context ctx, String hierarchyId, String childId) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.trim());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("child.id", (Object)childId.trim());
        filter.getFilterItems().add(filterItem2);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return this.getAdminOrgUnitHierarchyCollection(ctx, view);
    }

    private boolean hasChild2(Context ctx, String hierarchyId, String childId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.trim());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("child.id", (Object)childId.trim());
        filter.getFilterItems().add(filterItem2);
        return this._exists(ctx, filter);
    }

    private AdminOrgUnitHierarchyCollection getPHListByParent(Context ctx, String hierarchyId, String fullNumber) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.trim());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(fullNumber.trim() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return this.getAdminOrgUnitHierarchyCollection(ctx, view);
    }

    private boolean hasChild(Context ctx, String hierarchyId, String fullNumber) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("hierarchy.id", (Object)hierarchyId.trim());
        filter.getFilterItems().add(filterItem);
        FilterItemInfo filterItem2 = new FilterItemInfo("longNumber", (Object)(fullNumber.trim() + "!" + "%"), CompareType.LIKE);
        filter.getFilterItems().add(filterItem2);
        return this._exists(ctx, filter);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._deleteNew(ctx, pk, true);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AdminOrgUnitHierarchyInfo info = (AdminOrgUnitHierarchyInfo)model;
        AdminOrgUnitHierarchyInfo oldInfo = this.getAdminOrgUnitHierarchyInfo(ctx, pk);
        if (oldInfo.getParent().getId().toString().equalsIgnoreCase(info.getParent().getId().toString())) {
            throw new PositionException(PositionException.ERROR_PARENT_4);
        }
        if (!info.getHierarchy().getId().equals((Object)oldInfo.getHierarchy().getId())) {
            this.checkParent(ctx, info);
        }
        this.checkUpdate(ctx, info, oldInfo);
        this.setLevelAndLongNumber(ctx, info.getParent(), info.getChild(), info);
        super._update(ctx, pk, (IObjectValue)info);
        AdminOrgUnitHierarchyInfo pModel = this.getParentPH(ctx, info, info.getParent());
        if (pModel.isIsLeaf()) {
            pModel.setIsLeaf(false);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(pModel.getId()), (IObjectValue)pModel);
        }
        AdminOrgUnitHierarchyCollection posiHierColl = null;
        AdminOrgUnitHierarchyInfo phInfo = null;
        posiHierColl = this.getPHListByParent(ctx, oldInfo.getHierarchy().getId().toString(), oldInfo.getLongNumber());
        String temp = "";
        for (int i = 0; i < posiHierColl.size(); ++i) {
            phInfo = posiHierColl.get(i);
            temp = phInfo.getLongNumber().trim();
            temp = info.getLongNumber().trim() + temp.substring(oldInfo.getLongNumber().trim().length(), temp.length());
            phInfo.setLongNumber(temp);
            phInfo.setLevel(phInfo.getLevel() + (info.getLevel() - oldInfo.getLevel()));
            super._update(ctx, (IObjectPK)new ObjectUuidPK(phInfo.getId()), (IObjectValue)phInfo);
        }
        AdminOrgUnitHierarchyInfo oldPModel = this.getParentPH(ctx, info, oldInfo.getParent());
        boolean flag = this.hasChild(ctx, oldPModel.getHierarchy().getId().toString(), oldPModel.getLongNumber());
        if (!flag) {
            oldPModel.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(oldPModel.getId()), (IObjectValue)oldPModel);
        }
    }

    @Override
    protected void _deleteAdminOrgunit(Context ctx, String hierarchyId, String adminUnitId) throws BOSException, EASBizException {
        AdminOrgUnitHierarchyCollection phColl = this.getPHListByChild(ctx, hierarchyId, adminUnitId);
        if (phColl.size() > 0) {
            this.delete(ctx, (IObjectPK)new ObjectUuidPK(phColl.get(0).getId()));
        }
    }

    @Override
    protected void _deleteNew(Context ctx, IObjectPK pk, boolean flag) throws BOSException, EASBizException {
        AdminOrgUnitHierarchyInfo info = this.getAdminOrgUnitHierarchyInfo(ctx, pk);
        if (flag) {
            IHierarchy iHy = HierarchyFactory.getLocalInstance((Context)ctx);
            if (info.getHierarchy().getId().toString().equals(iHy.getDefaultHierarchy().getId().toString())) {
                throw new PositionException(PositionException.FORBID_DELETE_ADMIN_HIERARCHY);
            }
        }
        AdminOrgUnitHierarchyCollection posiHierColl = null;
        posiHierColl = this.getPHListByParent(ctx, info.getHierarchy().getId().toString(), info.getLongNumber());
        if (posiHierColl != null) {
            if (posiHierColl.size() > 1) {
                throw new PositionException(PositionException.EXIST_CHILDREN_ADMINUNIT);
            }
            if (posiHierColl.size() == 1 && !posiHierColl.get(0).getId().toString().equals(pk.toString())) {
                throw new PositionException(PositionException.EXIST_CHILDREN_ADMINUNIT);
            }
        }
        AdminOrgUnitHierarchyInfo oldPModel = this.getParentPH(ctx, info, info.getParent());
        AdminOrgUnitHierarchyCollection oldPosiHierColl = null;
        oldPosiHierColl = this.getPHListByParent(ctx, oldPModel.getHierarchy().getId().toString(), oldPModel.getLongNumber());
        super._delete(ctx, pk);
        if (oldPModel.getId().toString().equals(pk.toString())) {
            return;
        }
        if (oldPosiHierColl != null && oldPosiHierColl.size() == 1 && oldPosiHierColl.get(0).getId().toString().equals(pk.toString())) {
            oldPModel.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(oldPModel.getId()), (IObjectValue)oldPModel);
        }
    }
}

