/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;

public class PersonCountFacade {
    private static PersonCountFacade instance = null;

    private PersonCountFacade() {
    }

    public static PersonCountFacade getInstance() {
        if (instance == null) {
            instance = new PersonCountFacade();
        }
        return instance;
    }

    public int getPlanONCount(Context ctx, String longNumber, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        boolean isAffair;
        if (ctx == null || StringUtils.isEmpty((String)longNumber)) {
            return 0;
        }
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(1) ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("ON T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("INNER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append("WHERE (T_ORG_Admin.FLongNumber = '");
        sql.append(longNumber);
        sql.append("' OR T_ORG_Admin.FLongNumber Like '");
        sql.append(longNumber);
        sql.append("!%') AND (T_HR_BDEmployeeType.FIsOnTheStrength=1 ");
        sql.append("OR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        if (!paramPartimeOnStr) {
            sql.append(" AND T_ORG_PositionMember.FIsPrimary=1");
        }
        if (!(isAffair = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null))) {
            sql.append(" and T_ORG_Position.fDeletedStatus = 1 ");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null && rowSet.next()) {
                count = rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return count += this.getPlanOnCountNoPosition(ctx, longNumber);
    }

    public int getPlanOnCountNoPosition(Context ctx, String longNumber) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)longNumber)) {
            return 0;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) from ");
        sql.append("T_HR_PersonPosition pp ");
        sql.append("inner join T_BD_Person p on pp.FPersonID = p.FID ");
        sql.append("inner join T_HR_BDEmployeeType e on p.FEmployeeTypeID = e.FID ");
        sql.append("inner join T_ORG_Admin a on pp.FPersonDep = a.FID ");
        sql.append("where e.FIsOnTheStrength = 1 and pp.FPrimaryPositionID is null and (a.FLongNumber = '");
        sql.append(longNumber);
        sql.append("' or a.FLongNumber like '");
        sql.append(longNumber);
        sql.append("!%')");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null && rowSet.next()) {
                return rowSet.getInt(1);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), e.getCause());
        }
        return 0;
    }

    public IRowSet getOrgPlanONCount(Context ctx, boolean paramPartimeOnStr) throws BOSException, EASBizException {
        return this.getOrgPlanONCount(ctx, paramPartimeOnStr, true, true);
    }

    public IRowSet getOrgPlanONCount(Context ctx, boolean paramPartimeOnStr, boolean showVirtualOrg, boolean includeDelPos) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FItem,sum(numCount) as numCount ");
        sql.append("from ");
        sql.append("(");
        sql.append("\tSELECT T_ORG_Admin.FLongNumber as FItem, COUNT(1) as numCount ");
        sql.append("\tFROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("\tINNER JOIN T_ORG_PositionMember ");
        sql.append("\tON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("\tON T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("\tLEFT OUTER JOIN T_BD_Person ");
        sql.append("\tINNER JOIN T_HR_BDEmployeeType ");
        sql.append("\tON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("\tON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        sql.append(" \tWHERE (T_HR_BDEmployeeType.FIsOnTheStrength=1 ");
        sql.append("\tOR T_HR_BDEmployeeType.FIsOnTheStrength IS NULL) ");
        if (!paramPartimeOnStr) {
            sql.append(" AND T_ORG_PositionMember.FIsPrimary=1 ");
        }
        if (!showVirtualOrg) {
            sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
        }
        if (!includeDelPos) {
            sql.append(" AND T_ORG_Position.FDeletedStatus = 1");
        }
        sql.append(" \tGROUP BY T_ORG_Admin.FLongNumber ");
        sql.append(" UNION ALL ");
        sql.append("\tselect a.FLongNumber as FItem,count(1) as numCount ");
        sql.append("\tfrom T_HR_PersonPosition pp ");
        sql.append("\tinner join T_BD_Person p on pp.FPersonID = p.FID ");
        sql.append("\tinner join T_HR_BDEmployeeType e on p.FEmployeeTypeID = e.FID ");
        sql.append("\tinner join T_ORG_Admin a on pp.FPersonDep = a.FID ");
        if (!includeDelPos) {
            sql.append(" inner join T_ORG_Position pos on pos.fid=pp.FPrimaryPositionID");
        }
        sql.append("\twhere (e.FIsOnTheStrength = 1 or e.FIsOnTheStrength is null) and pp.FPrimaryPositionID is null ");
        if (!showVirtualOrg) {
            sql.append(" AND a.FIsVirtual = 0");
        }
        if (!includeDelPos) {
            sql.append(" AND pos.FDeletedStatus = 1");
        }
        sql.append("\tgroup by a.FLongNumber ");
        sql.append(") as T ");
        sql.append("group by FItem");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    public IRowSet getPosiONPlanCount(Context ctx, boolean paramPartimeOnStr, String hrOrgUnitID) throws BOSException, EASBizException {
        return this.getPosiONPlanCount(ctx, paramPartimeOnStr, hrOrgUnitID, true);
    }

    public IRowSet getPosiONPlanCount(Context ctx, boolean paramPartimeOnStr, String hrOrgUnitID, boolean showVirtualOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_ORG_Position.FID FItem,T_ORG_Admin.FID, COUNT(1) numCount ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_ORG_PositionMember ");
        sql.append("ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ");
        sql.append("ON T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        sql.append("LEFT OUTER JOIN T_BD_Person ");
        sql.append("INNER JOIN T_HR_BDEmployeeType ");
        sql.append("ON T_BD_Person.FEmployeeTypeID = T_HR_BDEmployeeType.FID ");
        sql.append("ON T_ORG_PositionMember.FPersonID = T_BD_Person.FID ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append("inner join T_ORG_UnitRelation on T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID ");
            sql.append(" and T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        }
        sql.append(" WHERE ");
        sql.append(" T_ORG_Admin.FIsSealUp = 0 ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append(" AND (");
            sql.append("T_ORG_Admin.FID = '");
            sql.append(hrOrgUnitID);
            sql.append("' or (T_ORG_UnitRelation.FToUnitID = '");
            sql.append(hrOrgUnitID);
            sql.append("' )");
            sql.append(")");
        }
        sql.append(" AND T_HR_BDEmployeeType.FIsOnTheStrength=1 ");
        if (!paramPartimeOnStr) {
            sql.append(" AND T_ORG_PositionMember.FIsPrimary=1 ");
        }
        if (!showVirtualOrg) {
            sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
        }
        sql.append(" GROUP BY T_ORG_Position.FID,T_ORG_Admin.FID ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    public IRowSet getPosiActualCount(Context ctx, boolean paramPartimeOrg, String hrOrgUnitID) throws BOSException, EASBizException {
        return this.getPosiActualCount(ctx, paramPartimeOrg, hrOrgUnitID, true);
    }

    public IRowSet getPosiActualCount(Context ctx, boolean paramPartimeOrg, String hrOrgUnitID, boolean showVirtualOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (paramPartimeOrg) {
            sql.append("SELECT T_ORG_Position.FID FItem ,T_ORG_Admin.FID, COUNT(T_BD_Person.FID) numCount ");
        } else {
            sql.append("SELECT T_ORG_Position.FID FItem ,T_ORG_Admin.FID, COUNT(DISTINCT T_BD_Person.FID) numCount ");
        }
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_BD_Person INNER JOIN T_ORG_PositionMember ON ");
        sql.append("T_BD_Person.FID = T_ORG_PositionMember.FPersonID ON ");
        sql.append("T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ON ");
        sql.append("T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append("inner join T_ORG_UnitRelation on T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID ");
            sql.append(" and T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        }
        sql.append(" WHERE ");
        sql.append(" T_ORG_Admin.FIsSealUp = 0 ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append(" AND (");
            sql.append("T_ORG_Admin.FID = '");
            sql.append(hrOrgUnitID);
            sql.append("' or (T_ORG_UnitRelation.FToUnitID = '");
            sql.append(hrOrgUnitID);
            sql.append("' )");
            sql.append(")");
        }
        if (!paramPartimeOrg) {
            sql.append(" AND T_ORG_PositionMember.FisPrimary = 1 ");
        }
        if (!showVirtualOrg) {
            sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
        }
        sql.append(" GROUP BY T_ORG_Position.FID,T_ORG_Admin.FID");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    public IRowSet getPosiPluralityCount(Context ctx, String hrOrgUnitID) throws BOSException, EASBizException {
        return this.getPosiPluralityCount(ctx, hrOrgUnitID, true);
    }

    public IRowSet getPosiPluralityCount(Context ctx, String hrOrgUnitID, boolean showVirtualOrg) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT T_ORG_Position.FID FItem,T_ORG_Admin.FID,COUNT(T_BD_Person.FID) numCount ");
        sql.append("FROM T_ORG_Admin INNER JOIN T_ORG_Position ");
        sql.append("INNER JOIN T_BD_Person INNER JOIN T_ORG_PositionMember ON ");
        sql.append("T_BD_Person.FID = T_ORG_PositionMember.FPersonID ON ");
        sql.append("T_ORG_Position.FID = T_ORG_PositionMember.FPositionID ON ");
        sql.append("T_ORG_Admin.FID = T_ORG_Position.FAdminOrgUnitID ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append("inner join T_ORG_UnitRelation on T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID ");
            sql.append(" and T_ORG_UnitRelation.FTypeRelationID='00000000-0000-0000-0000-0000000000100FE9F8B5'");
        }
        sql.append(" WHERE ");
        sql.append(" T_ORG_Admin.FIsSealUp = 0 ");
        if (!StringUtils.isEmpty((String)hrOrgUnitID)) {
            sql.append(" AND (");
            sql.append("T_ORG_Admin.FID = '");
            sql.append(hrOrgUnitID);
            sql.append("' or (T_ORG_UnitRelation.FToUnitID = '");
            sql.append(hrOrgUnitID);
            sql.append("' )");
            sql.append(")");
        }
        sql.append(" AND T_ORG_PositionMember.FIsPrimary=0 ");
        if (!showVirtualOrg) {
            sql.append(" AND T_ORG_Admin.FIsVirtual = 0");
        }
        sql.append(" GROUP BY T_ORG_Position.FID,T_ORG_Admin.FID ");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }
}

