/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRInitCollection;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.hr.base.IHRInit;
import com.kingdee.eas.hr.org.PersonFixedTimeInfo;
import com.kingdee.eas.hr.org.app.AbstractPersonFixedTimeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class PersonFixedTimeControllerBean
extends AbstractPersonFixedTimeControllerBean {
    private static Logger logger = Logger.getLogger((String)PersonFixedTimeControllerBean.class.getName());

    @Override
    protected void _redoFix(Context ctx) throws BOSException, EASBizException {
    }

    private void _fixEmpserviceData(Context ctx) throws BOSException {
        String clearSql = " delete from T_HR_EmpSericeData ";
        DbUtil.execute((Context)ctx, (String)clearSql);
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_HR_DataServiceSet where FIsByOSF=1 and fState=1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("propName", rs.getString("FPropName"));
                param.put("tipInfo", rs.getString("FTipInfo"));
                IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "fixPersonResignInfoService");
                imsf.process(ctx, param);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _fix(Context ctx) throws BOSException, EASBizException {
        int dbType = -1;
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            dbType = KSqlUtil.getDbType((Connection)conn);
        }
        catch (SQLException e) {
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        PersonFixedTimeInfo timeInfo = new PersonFixedTimeInfo();
        Date date = new Date();
        timeInfo.setFixedTime(new Timestamp(date.getTime()));
        timeInfo.setYear(DateTimeUtils.getYear((Date)date));
        int quater = DateTimeUtils.getQuarter((Date)date);
        timeInfo.setMonth(DateTimeUtils.getMonth((Date)date));
        timeInfo.setQuarter(quater);
        if (quater > 2) {
            timeInfo.setHalfYear(2);
        } else {
            timeInfo.setHalfYear(1);
        }
        timeInfo.setIsSuccess(false);
        IObjectPK pk = this._addnew(ctx, (IObjectValue)timeInfo);
        String id = pk.toString();
        this.doWithSystemParams(ctx);
        this._insertFixHistory(ctx, id);
        this._insertFixHistory2(ctx, id, dbType);
        this.applySysParam(ctx, id);
        timeInfo.setId(BOSUuid.read((String)pk.toString()));
        timeInfo.setIsSuccess(true);
        this._update(ctx, pk, (IObjectValue)timeInfo);
    }

    private String getUpdateCountByParamSql(Context ctx, String paramTempTable) {
        StringBuffer updateCountSql = new StringBuffer();
        updateCountSql.append(" ( ");
        updateCountSql.append(" SELECT A.FID ");
        updateCountSql.append(" FROM T_ORG_Admin A ");
        updateCountSql.append(" INNER JOIN T_ORG_UNITRELATION U ON A.FID = U.FFROMUNITID and U.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000100FE9F8B5'");
        updateCountSql.append(" INNER JOIN ");
        updateCountSql.append(paramTempTable);
        updateCountSql.append(" PR ON U.FToUnitID = PR.FHroId WHERE PR.FParamNumber=? AND PR.FValue=?");
        updateCountSql.append(" ) ");
        return updateCountSql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySysParam(Context ctx, String timeId) throws BOSException, EASBizException {
        Object[] obj = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String paramTempTable = this.createPlurParamTempTable(ctx, pool);
        if (paramTempTable == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.hr.org.ORGAutoGenerateResource", (String)"6_PersonFixedTimeControllerBean", (Locale)ctx.getLocale()));
        }
        try {
            String updateSql = null;
            obj = new Object[]{timeId, "IS_SUM_ADMIN", "true"};
            String updateHistory = "Update T_HR_PersonFixedHistory Set FCount = isnull(FCount,0) + isnull(FPartimeCount,0) where FFixedTimeID = ? and FAdminOrgID  IN ";
            String updateHistory2 = "Update T_HR_PersonFixedHistory2 Set FCount = isnull(FCount,0) + isnull(FPartimeCount,0) where FFixedTimeID = ? and FAdminOrgID  IN ";
            updateSql = this.getUpdateCountByParamSql(ctx, paramTempTable);
            DbUtil.execute((Context)ctx, (String)(updateHistory + updateSql), (Object[])obj);
            DbUtil.execute((Context)ctx, (String)(updateHistory2 + updateSql), (Object[])obj);
            updateSql = null;
            obj = new Object[]{timeId, "IS_AUTH", "true"};
            updateHistory = "Update T_HR_PersonFixedHistory Set FOnStreCount = FOnStreCount2,FOffStreCount = FOffStreCount2 where FFixedTimeID = ? and FAdminOrgID IN ";
            updateHistory2 = "Update T_HR_PersonFixedHistory2 Set FOnStreCount = FOnStreCount2,FOffStreCount = FOffStreCount2 where FFixedTimeID = ? and FAdminOrgID IN ";
            updateSql = this.getUpdateCountByParamSql(ctx, paramTempTable);
            DbUtil.execute((Context)ctx, (String)(updateHistory + updateSql), (Object[])obj);
            DbUtil.execute((Context)ctx, (String)(updateHistory2 + updateSql), (Object[])obj);
        }
        finally {
            if (!StringUtils.isEmpty((String)paramTempTable)) {
                // empty if block
            }
        }
    }

    private String createPlurParamTempTable(Context ctx, TempTablePool pool) throws BOSException, EASBizException {
        String createTempTable = "Create Table Temp_HRPlurParam (FParamNumber VARCHAR(20) NOT NULL,FHroId VARCHAR(44) NOT NULL,FValue VARCHAR(20) NOT NULL)";
        String tempTable = null;
        try {
            tempTable = pool.createTempTable(createTempTable);
            HROrgUnitCollection hrocol = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select id");
            ArrayList<String> paramNumberList = new ArrayList<String>();
            ArrayList<String> orgIdStrList = new ArrayList<String>();
            ArrayList<String[]> newSqlParamList = new ArrayList<String[]>();
            ParamSimpleInfo paramInfo = null;
            String hroId = null;
            paramNumberList.add("IS_SUM_ADMIN");
            paramNumberList.add("IS_AUTH");
            int size = hrocol.size();
            for (int i = 0; i < size; ++i) {
                hroId = hrocol.get(i).getId().toString();
                orgIdStrList.add(hroId);
            }
            ArrayList sqlParamList = new ArrayList();
            sqlParamList = ParamManager.getParamListBatch((Context)ctx, paramNumberList, orgIdStrList);
            int size2 = sqlParamList.size();
            for (int i = 0; i < size2; ++i) {
                if (!(sqlParamList.get(i) instanceof ParamSimpleInfo)) continue;
                paramInfo = (ParamSimpleInfo)sqlParamList.get(i);
                newSqlParamList.add(new String[]{paramInfo.getParamNumber(), paramInfo.getOrgUnitPK().toString(), paramInfo.getParamValue() == null ? "false" : paramInfo.getParamValue().toString()});
            }
            String sql = "insert into " + tempTable + " (FParamNumber,FHroId,FValue) values(?,?,?)";
            DbUtil.executeBatch((Context)ctx, (String)sql, newSqlParamList);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("HRPersonFixedTime_PlurParamTempTable:" + tempTable));
        return tempTable;
    }

    @Override
    protected void _removeFails(Context ctx) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM T_HR_PersonFixedHistory2 ");
        sb.append("WHERE (FFixedTimeID IN (SELECT FID ");
        sb.append("         FROM T_HR_PersonFixedTime ");
        sb.append("         WHERE FIsSuccess = 0)) ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        sb = new StringBuffer();
        sb.append("DELETE FROM T_HR_PersonFixedHistory ");
        sb.append("WHERE (FFixedTimeID IN (SELECT FID ");
        sb.append("         FROM T_HR_PersonFixedTime ");
        sb.append("         WHERE FIsSuccess = 0)) ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_HR_PersonFixedTime WHERE FIsSuccess = 0");
    }

    private void updateStreCount(Context ctx, boolean fixVirtual, String fixedTimeId) throws BOSException, EASBizException {
        boolean isAffair;
        String createTempTable = "Create Table Temp_PersonFixedHistory (FPersonID VARCHAR(44) ,FAdminOrgID VARCHAR(44)  ,FPositionId VARCHAR(44)  ,FIsOnTheStrength INT DEFAULT 0 ,FIsPrimary INT DEFAULT 0 ,FCount INT DEFAULT 0)";
        String tempTable = null;
        StringBuffer selectData = new StringBuffer();
        selectData.append("   SELECT A.FPersonID AS FPersonID,AdminOrg.FID AS FAdminOrgID,pos.FID AS FPositionId,A.FIsOnTheStrength as FIsOnTheStrength,A.FIsPrimary as FIsPrimary ");
        selectData.append("   FROM T_ORG_Admin AdminOrg ");
        selectData.append("   LEFT OUTER JOIN T_ORG_Position pos ON AdminOrg.FID = pos.FAdminOrgUnitID ");
        selectData.append("   LEFT OUTER JOIN (SELECT pm.FPersonID,pm.FPositionID,ISNULL(pm.FIsPrimary , 0) AS FIsPrimary,ISNULL(empType.FIsOnTheStrength, 1) AS FIsOnTheStrength ");
        selectData.append("                    FROM T_ORG_PositionMember pm ");
        selectData.append("                    LEFT OUTER JOIN T_BD_Person px ON pm.FPersonID = px.FID ");
        selectData.append("                    LEFT OUTER JOIN T_HR_BDEmployeeType empType ON px.FEmployeeTypeID = empType.FID) A ON A.FPositionID = pos.FID ");
        selectData.append("  WHERE A.FPositionId > ' ' ");
        if (!fixVirtual) {
            selectData.append(" AND AdminOrg.FIsVirtual = 0 ");
        }
        if (!(isAffair = ((Boolean)ctx.get((Object)"IS_AFFAIR")).booleanValue())) {
            selectData.append(" and pos.fDeletedStatus = 1 ");
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTable = pool.createTempTable(createTempTable);
            if (StringUtils.isEmpty((String)tempTable)) {
                return;
            }
            DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + "(FPersonID,FAdminOrgID,FPositionId,FIsOnTheStrength,FIsPrimary) " + selectData.toString()));
            String indexName = "IX_HRFIX_" + String.valueOf(System.currentTimeMillis());
            if (indexName.length() >= 30) {
                indexName = indexName.substring(0, 29);
            }
            try {
                String createIndex = "create index " + indexName + " on " + tempTable + "(FAdminOrgID,FPositionId,FIsOnTheStrength)";
                DbUtil.execute((Context)ctx, (String)createIndex);
            }
            catch (Exception createIndex) {
                // empty catch block
            }
            StringBuffer update_onCount_sql = new StringBuffer();
            update_onCount_sql.append(" UPDATE T_HR_PersonFixedHistory SET FOnStreCount2 =  ");
            update_onCount_sql.append("  ( ");
            update_onCount_sql.append("  select T.FCount from ");
            update_onCount_sql.append("  ( ");
            update_onCount_sql.append("   SELECT FAdminOrgID, FPositionId ,COUNT(FPersonID) AS FCount ");
            update_onCount_sql.append("   FROM ");
            update_onCount_sql.append(tempTable);
            update_onCount_sql.append("  WHERE FIsOnTheStrength = 1 ");
            update_onCount_sql.append("  GROUP BY FAdminOrgID, FPositionId ");
            update_onCount_sql.append("  ) as T ");
            update_onCount_sql.append("  WHERE T_HR_PersonFixedHistory.FAdminOrgID = T.FAdminOrgID and T_HR_PersonFixedHistory.FPositionID= T.FPositionID  ");
            update_onCount_sql.append(" ) WHERE FFixedTimeID = '");
            update_onCount_sql.append(fixedTimeId);
            update_onCount_sql.append("'");
            DbUtil.execute((Context)ctx, (String)update_onCount_sql.toString());
            StringBuffer update_offCount2_sql = new StringBuffer();
            update_offCount2_sql.append(" UPDATE T_HR_PersonFixedHistory SET FOffStreCount2 =  ");
            update_offCount2_sql.append(" ( ");
            update_offCount2_sql.append("  select T.FCount from ");
            update_offCount2_sql.append("  ( ");
            update_offCount2_sql.append("   SELECT FAdminOrgID, FPositionId ,COUNT(FPersonID) AS FCount ");
            update_offCount2_sql.append("   FROM ");
            update_offCount2_sql.append(tempTable);
            update_offCount2_sql.append("  WHERE FIsOnTheStrength = 0 ");
            update_offCount2_sql.append("  GROUP BY FAdminOrgID, FPositionId ");
            update_offCount2_sql.append("  ) as T ");
            update_offCount2_sql.append("  WHERE T_HR_PersonFixedHistory.FAdminOrgID = T.FAdminOrgID and T_HR_PersonFixedHistory.FPositionID= T.FPositionID  ");
            update_offCount2_sql.append(" ) WHERE FFixedTimeID = '");
            update_offCount2_sql.append(fixedTimeId);
            update_offCount2_sql.append("'");
            DbUtil.execute((Context)ctx, (String)update_offCount2_sql.toString());
            StringBuffer update_offCount_sql = new StringBuffer();
            update_offCount_sql.append(" UPDATE T_HR_PersonFixedHistory SET FOffStreCount =  ");
            update_offCount_sql.append(" ( ");
            update_offCount_sql.append("  select T.FCount from ");
            update_offCount_sql.append("  ( ");
            update_offCount_sql.append("   SELECT FAdminOrgID, FPositionId ,COUNT(FPersonID) AS FCount ");
            update_offCount_sql.append("   FROM ");
            update_offCount_sql.append(tempTable);
            update_offCount_sql.append("  WHERE FIsOnTheStrength = 0  AND FIsPrimary = 1 ");
            update_offCount_sql.append("  GROUP BY FAdminOrgID, FPositionId ");
            update_offCount_sql.append("  ) as T ");
            update_offCount_sql.append("  WHERE T_HR_PersonFixedHistory.FAdminOrgID = T.FAdminOrgID and T_HR_PersonFixedHistory.FPositionID= T.FPositionID  ");
            update_offCount_sql.append(" ) WHERE FFixedTimeID = '");
            update_offCount_sql.append(fixedTimeId);
            update_offCount_sql.append("'");
            DbUtil.execute((Context)ctx, (String)update_offCount_sql.toString());
            StringBuffer updateSql = new StringBuffer();
            updateSql.append(" UPDATE T_HR_PersonFixedHistory SET FOnStreCount = ");
            updateSql.append(" ( ");
            updateSql.append("   select T.FCount from ");
            updateSql.append("   (");
            updateSql.append("   SELECT FAdminOrgID, FPositionId ,COUNT(FPersonID) AS FCount ");
            updateSql.append("   FROM ");
            updateSql.append(tempTable);
            updateSql.append("  WHERE FIsOnTheStrength = 1 AND FIsPrimary = 1");
            updateSql.append("  GROUP BY FAdminOrgID, FPositionId ");
            updateSql.append("   ) as T ");
            updateSql.append("  WHERE T_HR_PersonFixedHistory.FAdminOrgID = T.FAdminOrgID and T_HR_PersonFixedHistory.FPositionID= T.FPositionID ");
            updateSql.append(" ) WHERE FFixedTimeID = '");
            updateSql.append(fixedTimeId);
            updateSql.append("'");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty((String)tempTable)) {
                pool.releaseTable(tempTable);
            }
        }
    }

    private void insertPositionCount(Context ctx, String fixedTimeId, boolean fixVirtual) throws BOSException, EASBizException {
        boolean isAffair;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SELECT adminOrg.FID AS FAdminOrgID,pos.FID AS FPositionId,pos.FJobID AS FJobID,");
        selectSql.append(" CASE WHEN pm.FIsPrimary IS NULL THEN 0 ELSE pm.FIsPrimary END AS FIsPrimary,COUNT(pm.FPersonID) AS FCount ");
        selectSql.append(" FROM T_ORG_Admin adminOrg ");
        selectSql.append(" LEFT OUTER JOIN T_ORG_Position pos ON adminOrg.FId = pos.FAdminOrgUnitID ");
        selectSql.append(" LEFT OUTER JOIN T_ORG_PositionMember pm ON pos.FID = pm.FPositionID  ");
        selectSql.append(" where pos.FID >' ' ");
        if (!fixVirtual) {
            selectSql.append(" and adminOrg.FIsVirtual = 0 ");
        }
        if (!(isAffair = ((Boolean)ctx.get((Object)"IS_AFFAIR")).booleanValue())) {
            selectSql.append(" and pos.fDeletedStatus = 1 ");
        }
        selectSql.append(" GROUP BY adminOrg.FId, pos.FID, pos.FJobID, pm.FIsPrimary ");
        String tempTable = null;
        TableManager tableManager = null;
        try {
            tableManager = TableManager.getTableManager((Context)ctx);
            tempTable = tableManager.getTableName("Temp_PersonFixedHistory");
            StringBuffer createTableSql = new StringBuffer();
            createTableSql.append(" select * into  ").append(tempTable);
            createTableSql.append(" FROM(  ").append(selectSql).append(") T ");
            String indexName = "IX_HRFIX2_" + String.valueOf(System.currentTimeMillis());
            if (indexName.length() >= 30) {
                indexName = indexName.substring(0, 29);
            }
            String createIndex = "create index " + indexName + " on " + tempTable + "(FAdminOrgID,FPositionId,FIsPrimary)";
            DbUtil.execute((Context)ctx, (String)createTableSql.toString());
            DbUtil.execute((Context)ctx, (String)createIndex);
            DbUtil.execute((Context)ctx, (String)("insert into " + tempTable + "(FAdminOrgID,FPositionId,FJobID,FIsPrimary,FCount) " + selectSql.toString()));
            StringBuffer insertPosition = new StringBuffer();
            insertPosition.append(" INSERT INTO T_HR_PersonFixedHistory(FID, FFixedTimeID, FAdminOrgID, FPositionID,FJobID,FCOUNT,FPARTIMECOUNT,FOFFSTRECOUNT,FOffStreCount2,FONSTRECOUNT,FONSTRECOUNT2) ");
            insertPosition.append(" select newbosid('7E88E00B') as fid,'");
            insertPosition.append(fixedTimeId);
            insertPosition.append("' as FFixedTimeID,T.FAdminOrgID,T.FPositionId,T.FJobID,0 as FCOUNT,0 as FPARTIMECOUNT,0 as FOFFSTRECOUNT,0 as FOFFSTRECOUNT2,0 as FONSTRECOUNT,0 as FONSTRECOUNT2 from ");
            insertPosition.append(" ( select distinct FAdminOrgID,FPositionId,FJobID from ");
            insertPosition.append(tempTable);
            insertPosition.append(" ) AS T");
            DbUtil.execute((Context)ctx, (String)insertPosition.toString());
            StringBuffer updatePrimaryPosition = new StringBuffer();
            updatePrimaryPosition.append(" UPDATE T_HR_PersonFixedHistory SET FCount = ");
            updatePrimaryPosition.append(" ( SELECT top 1 T.FCOUNT FROM ");
            updatePrimaryPosition.append(tempTable);
            updatePrimaryPosition.append("  AS T ");
            updatePrimaryPosition.append("  WHERE T_HR_PersonFixedHistory.FAdminOrgID = T.FAdminOrgID AND T_HR_PersonFixedHistory.FPositionID = T.FPositionID AND T.FIsPrimary = 1 ");
            updatePrimaryPosition.append("  ) WHERE FFixedTimeID = '");
            updatePrimaryPosition.append(fixedTimeId);
            updatePrimaryPosition.append("'");
            DbUtil.execute((Context)ctx, (String)updatePrimaryPosition.toString());
            StringBuffer updateParPosition = new StringBuffer();
            updateParPosition.append(" UPDATE T_HR_PersonFixedHistory SET FPartimeCount = ");
            updateParPosition.append(" ( SELECT top 1 T.FCOUNT FROM ");
            updateParPosition.append(tempTable);
            updateParPosition.append("  AS T ");
            updateParPosition.append("  WHERE T_HR_PersonFixedHistory.FAdminOrgID = T.FAdminOrgID AND T_HR_PersonFixedHistory.FPositionID = T.FPositionID AND T.FIsPrimary = 0 ");
            updateParPosition.append("  ) WHERE FFixedTimeID = '");
            updateParPosition.append(fixedTimeId);
            updateParPosition.append("'");
            DbUtil.execute((Context)ctx, (String)updateParPosition.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!StringUtils.isEmpty(tempTable) && tableManager != null) {
                tableManager.releaseTable(tempTable);
            }
        }
    }

    private boolean fixVirtual(Context ctx) throws BOSException, EASBizException {
        IHRInit iHRinit = HRInitFactory.getLocalInstance((Context)ctx);
        HRInitInfo info = null;
        HRInitCollection col = iHRinit.getHRInitCollection("where key='PT_VIRADMIN_PERSON'");
        if (col != null && col.size() > 0) {
            info = col.get(0);
            return info.getValue().equals(Boolean.TRUE.toString());
        }
        return true;
    }

    private void _insertFixHistory(Context ctx, String fixedTimeId) throws BOSException, EASBizException {
        boolean fixVirtual = this.fixVirtual(ctx);
        this.insertPositionCount(ctx, fixedTimeId, fixVirtual);
        this.updateStreCount(ctx, fixVirtual, fixedTimeId);
    }

    private void _insertFixHistory2(Context ctx, String fixedTimeId, int dbType) throws BOSException, EASBizException {
        StringBuffer selectData = new StringBuffer();
        selectData.append(" select A.FID AS FAdminOrgID,A.FLongNumber AS FLongNumber,ISNULL(sum(P.FCount),0) AS FCount,ISNULL(sum(P.FPartimeCount),0) AS FPartimeCount,ISNULL(sum(P.FOffStreCount),0) AS FOffStreCount,ISNULL(sum(P.FOffStreCount2),0) AS FOffStreCount2,ISNULL(sum(P.FOnStreCount),0) AS FOnStreCount,ISNULL(sum(P.FOnStreCount2),0) AS FOnStreCount2 ");
        selectData.append(" from t_org_admin A ");
        selectData.append(" left outer join T_HR_PersonFixedHistory P on A.FID = P.FAdminOrgID ");
        selectData.append(" where P.FFixedTimeID = '").append(fixedTimeId).append("'");
        selectData.append(" group by A.FID,A.FLongNumber ");
        String tempTable = null;
        String tempTableToUpdate = null;
        TableManager tableManager = null;
        try {
            tableManager = TableManager.getTableManager((Context)ctx);
            tempTable = tableManager.getTableName("Temp_PersonFixedHistory");
            StringBuffer createTableSql = new StringBuffer();
            createTableSql.append(" select * into  ").append(tempTable);
            createTableSql.append(" FROM(  ").append(selectData).append(") T ");
            String indexName = "IX_HRFIX3_" + String.valueOf(System.currentTimeMillis());
            if (indexName.length() >= 30) {
                indexName = indexName.substring(0, 29);
            }
            String createIndex = "create index " + indexName + " on " + tempTable + "(FLongNumber)";
            DbUtil.execute((Context)ctx, (String)createTableSql.toString());
            DbUtil.execute((Context)ctx, (String)createIndex);
            tempTableToUpdate = tableManager.getTableName("Temp_PersonFixedHistory");
            createTableSql = new StringBuffer();
            createTableSql.append(" select * into  ").append(tempTableToUpdate);
            createTableSql.append(" FROM  ").append(tempTable).append(" ");
            DbUtil.execute((Context)ctx, (String)createTableSql.toString());
            indexName = "IX_HRFIX4_" + String.valueOf(System.currentTimeMillis());
            if (indexName.length() >= 30) {
                indexName = indexName.substring(0, 29);
            }
            createIndex = "create index " + indexName + " on " + tempTableToUpdate + "(FLongNumber)";
            DbUtil.execute((Context)ctx, (String)createIndex);
            DbUtil.execute((Context)ctx, (String)this.updateTempTableColSql("FCount", tempTable, tempTableToUpdate, dbType));
            DbUtil.execute((Context)ctx, (String)this.updateTempTableColSql("FPartimeCount", tempTable, tempTableToUpdate, dbType));
            DbUtil.execute((Context)ctx, (String)this.updateTempTableColSql("FOffStreCount", tempTable, tempTableToUpdate, dbType));
            DbUtil.execute((Context)ctx, (String)this.updateTempTableColSql("FOffStreCount2", tempTable, tempTableToUpdate, dbType));
            DbUtil.execute((Context)ctx, (String)this.updateTempTableColSql("FOnStreCount", tempTable, tempTableToUpdate, dbType));
            DbUtil.execute((Context)ctx, (String)this.updateTempTableColSql("FOnStreCount2", tempTable, tempTableToUpdate, dbType));
            String view = "select FAdminOrgID,FCount,FPartimeCount,FOffStreCount,FOffStreCount2,FOnStreCount,FOnStreCount2 from " + tempTableToUpdate;
            DbUtil.execute((Context)ctx, (String)this.getInsertFixedHistory2Sql(fixedTimeId, view));
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty(tempTable) && tableManager != null) {
                    tableManager.releaseTable(tempTable);
                }
                if (!StringUtils.isEmpty(tempTableToUpdate) && tableManager != null) {
                    tableManager.releaseTable(tempTableToUpdate);
                }
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)tempTable) && tableManager != null) {
            tableManager.releaseTable(tempTable);
        }
        if (!StringUtils.isEmpty((String)tempTableToUpdate) && tableManager != null) {
            tableManager.releaseTable(tempTableToUpdate);
        }
    }

    private String updateTempTableColSql(String col, String tempTable, String tempTableToUpdate, int dbType) {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update ").append(tempTableToUpdate);
        updateSql.append(" set ").append(col);
        updateSql.append(" = (select sum(T.").append(col).append(") AS ").append(col);
        updateSql.append(" from ").append(tempTable).append(" T ");
        updateSql.append("where T.FLongNumber = ").append(tempTableToUpdate).append(".FLongNumber ");
        if (1 == dbType) {
            updateSql.append(" or CHARINDEX(CONCAT(");
            updateSql.append(tempTableToUpdate);
            updateSql.append(".FLongNumber,'!'),T.FLongNumber)=1");
        } else if (2 == dbType || 8 == dbType || 7 == dbType) {
            updateSql.append(" or T.FLongNumber like ");
            updateSql.append(tempTableToUpdate);
            updateSql.append(".FLongNumber||'!%'");
            updateSql.insert(0, "/*dialect*/");
        } else {
            updateSql.append(" or T.FLongNumber like CONCAT(");
            updateSql.append(tempTableToUpdate);
            updateSql.append(".FLongNumber,'!%')");
        }
        updateSql.append(" )");
        return updateSql.toString();
    }

    private String getInsertFixedHistory2Sql(String fixedTimeId, String view) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" INSERT INTO T_HR_PersonFixedHistory2 (FID, FFixedTimeID, FAdminOrgID, FCount, FPartimeCount, FOffStreCount,FOffStreCount2, FOnStreCount, FOnStreCount2) ");
        insertSql.append(" select newbosid('F56C3036') as fid,'");
        insertSql.append(fixedTimeId);
        insertSql.append("' as FFixedTimeID,T.FAdminOrgID as FAdminOrgID,T.FCount as FCount, T.FPartimeCount as FPartimeCount, T.FOffStreCount as FOffStreCount,T.FOffStreCount2 as FOffStreCount2, T.FOnStreCount as FOnStreCount, T.FOnStreCount2 as FOnStreCount2 ");
        insertSql.append(" from ");
        insertSql.append(" ( ");
        insertSql.append(view);
        insertSql.append(" ) AS T");
        return insertSql.toString();
    }

    private void _insertIntoNoPositionOnStre(Context ctx, boolean fixVirtual, String fixedTimeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)fixedTimeId)) {
            return;
        }
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO T_HR_PersonFixedHistory");
        insertSql.append("(FID, FFixedTimeID, FAdminOrgID,FCount,FPartimeCount,FOffStreCount,FOffStreCount2,FOnStreCount,FOnStreCount2) ");
        insertSql.append(" select newbosid('7E88E00B') as FID,'");
        insertSql.append(fixedTimeId);
        insertSql.append("' as FFixedTimeID,T.FAdminOrgID, 0 as FCount,0 as FPartimeCount,0 as FOffStreCount,0 as FOffStreCount2,T.FOnStreCount as FOnStreCount,T.FOnStreCount as FOnStreCount2 ");
        insertSql.append(" from ");
        insertSql.append(" (");
        insertSql.append("  select pp.FPersonDep as FAdminOrgID,count(distinct pp.FPersonID) as FOnStreCount");
        insertSql.append("  from T_HR_PersonPosition pp ");
        insertSql.append("  inner join T_BD_Person p on pp.FPersonID = p.FID ");
        insertSql.append("  inner join T_HR_BDEmployeeType e on p.FEmployeeTypeID = e.FID ");
        if (!fixVirtual) {
            insertSql.append(" inner join T_ORG_Admin a on pp.FPersonDep = a.FID and a.FIsVirtual = 0 ");
        }
        insertSql.append("  where e.FIsOnTheStrength = 1 and pp.FPrimaryPositionID is null ");
        insertSql.append("  group by pp.FPersonDep ");
        insertSql.append(" ) AS T");
        DbUtil.execute((Context)ctx, (String)insertSql.toString());
    }

    private void doWithSystemParams(Context ctx) throws EASBizException, BOSException {
        boolean isAffair = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_AFFAIR", null);
        ctx.put((Object)"IS_AFFAIR", (Object)isAffair);
    }

    @Override
    protected Set _getYears(Context ctx) throws BOSException, EASBizException {
        LinkedHashSet<Integer> years = new LinkedHashSet<Integer>();
        String sql = "select distinct fyear from t_hr_personfixedtime where fissuccess = 1 order by fyear asc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                years.add(rowSet.getInt("fyear"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return years;
    }
}

