/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.org.IPersonPlanScheme;
import com.kingdee.eas.hr.org.Period;
import com.kingdee.eas.hr.org.PersonPlanException;
import com.kingdee.eas.hr.org.PersonPlanGroupSchemeException;
import com.kingdee.eas.hr.org.PersonPlanSchemeCollection;
import com.kingdee.eas.hr.org.PersonPlanSchemeFactory;
import com.kingdee.eas.hr.org.PersonPlanSchemeInfo;
import com.kingdee.eas.hr.org.PersonPlanSchemeTypeEnum;
import com.kingdee.eas.hr.org.SchemeStatus;
import com.kingdee.eas.hr.org.app.AbstractPersonPlanSchemeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class PersonPlanSchemeControllerBean
extends AbstractPersonPlanSchemeControllerBean {
    private Logger logger = Logger.getLogger(PersonPlanSchemeControllerBean.class);

    @Override
    protected void _enabled(Context ctx, String ppSchemeID) throws BOSException, EASBizException {
        this.logger.info((Object)"------PersonPlanSchemeControllerBean._enabled start...");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ppSchemeID));
        PersonPlanSchemeInfo ppsInfo = this.getPersonPlanSchemeInfo(ctx, (IObjectPK)pk);
        if (ppsInfo.getStatus() != SchemeStatus.SAVE) {
            throw new PersonPlanException(PersonPlanException.ONLY_ENABLED_SAVEDSCHEME);
        }
        DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonPlanScheme SET FStatus=1 WHERE FID='" + ppSchemeID + "'"));
        this.logger.info((Object)"------PersonPlanSchemeControllerBean._enabled end...");
    }

    @Override
    protected void _execute(Context ctx, String ppSechemeID) throws BOSException, EASBizException {
        this.logger.info((Object)"------PersonPlanSchemeControllerBean._execute start...");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ppSechemeID));
        PersonPlanSchemeInfo ppsInfo = this.getPersonPlanSchemeInfo(ctx, (IObjectPK)pk);
        if (ppsInfo.getStatus() != SchemeStatus.ENABLED) {
            throw new PersonPlanException(PersonPlanException.ONLY_EXECUTE_ENABLEDSCHEME);
        }
        if (!PersonPlanSchemeTypeEnum.Group.equals((Object)ppsInfo.getSchemeType())) {
            this.veryNoExistGroupScheme(ctx);
        }
        this.updateSchemeStatus(ppsInfo, ctx);
        DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonPlanScheme SET FStatus=2 WHERE FID='" + ppSechemeID + "'"));
        this.logger.info((Object)"------PersonPlanSchemeControllerBean._execute end...");
    }

    private void veryNoExistGroupScheme(Context ctx) throws BOSException, EASBizException {
        PersonPlanSchemeCollection ppsColl = null;
        ppsColl = this.getPersonPlanSchemeCollection(ctx, "select * where status=2 and schemeType =1");
        if (ppsColl.size() > 0) {
            throw new PersonPlanGroupSchemeException(PersonPlanGroupSchemeException.GROUP_EXIST_EXE, new String[]{ppsColl.get(0).getName()});
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        PersonPlanSchemeInfo info = (PersonPlanSchemeInfo)model;
        if (info.getPeriod() == Period.YEAR) {
            info.setStartMonth(0);
            info.setEndMonth(11);
        }
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        info.setSchemeType(PersonPlanSchemeTypeEnum.HRO);
        return super._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PersonPlanSchemeInfo ppsInfo = this.getPersonPlanSchemeInfo(ctx, pk);
        if (ppsInfo.getStatus() == SchemeStatus.EXECUTE || ppsInfo.getStatus() == SchemeStatus.DISABLED) {
            throw new PersonPlanException(PersonPlanException.CANNOT_DELETE_SCHEME);
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PersonPlanSchemeInfo ppsInfo = (PersonPlanSchemeInfo)model;
        if (ppsInfo.getStatus() != SchemeStatus.SAVE && ppsInfo.getStatus() != SchemeStatus.AUDITING) {
            throw new PersonPlanException(PersonPlanException.ONLY_UPDATE_SAVESCHEME);
        }
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
        this._checkNameBlank(ctx, model);
        super._update(ctx, pk, model);
    }

    protected FilterInfo getFilterForDefaultCU(IObjectValue model) {
        return null;
    }

    @Override
    protected IObjectValue _getDefaultScheme(Context ctx) throws BOSException, EASBizException {
        if (null == ContextUtil.getCurrentHRUnit((Context)ctx)) {
            throw new PersonPlanException(PersonPlanException.ONLY_HR_ORG);
        }
        return this._getDefaultScheme(ctx, ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
    }

    @Override
    protected PersonPlanSchemeInfo _getDefaultScheme(Context ctx, String hrOrgUnitID) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)hrOrgUnitID)) {
            return null;
        }
        PersonPlanSchemeCollection ppsColl = null;
        ppsColl = this.getPersonPlanSchemeCollection(ctx, "select * where status=2 and( hrOrgUnit='" + hrOrgUnitID + "' or schemeType=" + 1 + ")");
        if (ppsColl.size() > 0) {
            return ppsColl.get(0);
        }
        ppsColl = this.getPersonPlanSchemeCollection(ctx, "select * where status=1 and (hrOrgUnit='" + hrOrgUnitID + "' or schemeType=" + 1 + ")");
        if (ppsColl.size() > 0) {
            return ppsColl.get(0);
        }
        return null;
    }

    @Override
    protected void _enGroup(Context ctx, String personPlanSchemeId) throws BOSException, EASBizException {
        PersonPlanSchemeInfo personPlanSchemeInfo = this.getPersonPlanSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(personPlanSchemeId));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)personPlanSchemeInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("id", (Object)personPlanSchemeInfo.getId(), CompareType.NOTEQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PersonPlanSchemeCollection personPlanSchemeCollection = this.getPersonPlanSchemeCollection(ctx, view);
        if (personPlanSchemeCollection.size() > 0) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{personPlanSchemeCollection.get(0).getNumber()});
        }
        if (SchemeStatus.EXECUTE.equals((Object)personPlanSchemeInfo.getStatus()) || SchemeStatus.ENABLED.equals((Object)personPlanSchemeInfo.getStatus())) {
            new PersonPlanGroupSchemeException(PersonPlanGroupSchemeException.EXE_CANOT_GROUP);
        }
        personPlanSchemeInfo.setSchemeType(PersonPlanSchemeTypeEnum.Group);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(personPlanSchemeId), (CoreBaseInfo)personPlanSchemeInfo);
    }

    @Override
    protected void _disGroup(Context ctx, String personPlanSchemeId) throws BOSException, EASBizException {
        PersonPlanSchemeInfo personPlanSchemeInfo = this.getPersonPlanSchemeInfo(ctx, (IObjectPK)new ObjectUuidPK(personPlanSchemeId));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)personPlanSchemeInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("id", (Object)personPlanSchemeInfo.getId(), CompareType.NOTEQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        PersonPlanSchemeCollection personPlanSchemeCollection = this.getPersonPlanSchemeCollection(ctx, view);
        if (personPlanSchemeCollection.size() > 0) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{personPlanSchemeCollection.get(0).getNumber()});
        }
        personPlanSchemeInfo.setSchemeType(PersonPlanSchemeTypeEnum.HRO);
        super._update(ctx, (IObjectPK)new ObjectUuidPK(personPlanSchemeId), (IObjectValue)personPlanSchemeInfo);
    }

    private void verifyGroupScheme(Context ctx, PersonPlanSchemeInfo personPlanSchemeInfo) throws BOSException, EASBizException {
        if (PersonPlanSchemeTypeEnum.Group.equals((Object)personPlanSchemeInfo.getSchemeType())) {
            PersonPlanSchemeCollection ppsColl = null;
            ppsColl = this.getPersonPlanSchemeCollection(ctx, "select *,hrOrgUnit.* where (status=2 or status=1) and schemeType =2");
            if (ppsColl.size() > 0) {
                StringBuffer hro = new StringBuffer();
                for (int i = 0; i < ppsColl.size(); ++i) {
                    hro.append("\n");
                    hro.append(ppsColl.get(i).getHrOrgUnit().getName());
                }
                throw new PersonPlanGroupSchemeException(PersonPlanGroupSchemeException.HRO_EXIST_EXE, new String[]{hro.toString()});
            }
        } else {
            PersonPlanSchemeCollection ppsColl = null;
            ppsColl = this.getPersonPlanSchemeCollection(ctx, "select * where (status=2 or status=1) and schemeType =1");
            if (ppsColl.size() > 0) {
                throw new PersonPlanGroupSchemeException(PersonPlanGroupSchemeException.GROUP_EXIST_EXE);
            }
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    @Override
    protected void _auditInProcessing(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pkScheme = new ObjectUuidPK(id);
        IPersonPlanScheme ipps = PersonPlanSchemeFactory.getLocalInstance(ctx);
        PersonPlanSchemeInfo ppsInfo = ipps.getPersonPlanSchemeInfo("select * from where id='" + id.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)ppsInfo.getBOSType(), (IObjectPK)pkScheme, (String)ppsInfo.getName(), (String)"personplanscheme_audit");
        String userid = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String functionName = "com.kingdee.eas.hr.org.PersonPlanSchemeFunction";
        String operationName = "ActionSubmit";
        String temp = EnactmentServiceProxy.getEnacementService((Context)ctx).findSubmitProcDef(userid, (IObjectValue)ppsInfo, functionName, operationName);
        ppsInfo.setStatus(SchemeStatus.AUDITING);
        if (temp == null || temp.trim().equals("")) {
            throw new PersonPlanException(PersonPlanException.NO_USEDWORKFLOW);
        }
        IPersonPlanScheme ipps2 = PersonPlanSchemeFactory.getLocalInstance(ctx);
        ipps2.submit((CoreBaseInfo)ppsInfo);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _auditPass(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pkScheme = new ObjectUuidPK(id);
        IPersonPlanScheme ipps = PersonPlanSchemeFactory.getLocalInstance(ctx);
        PersonPlanSchemeInfo ppsInfo = ipps.getPersonPlanSchemeInfo("select * where id='" + id.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)ppsInfo.getBOSType(), (IObjectPK)pkScheme, (String)"personplanscheme_audit");
        IPersonPlanScheme ipps2 = PersonPlanSchemeFactory.getLocalInstance(ctx);
        ipps2.submit((CoreBaseInfo)ppsInfo);
        this.updateSchemeStatus(ppsInfo, ctx);
        this.updatePersonPlanSchemeStatus(ctx, id.toString(), 2);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _aduitNotPass(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        ObjectUuidPK pkScheme = new ObjectUuidPK(id);
        IPersonPlanScheme ipps = PersonPlanSchemeFactory.getLocalInstance(ctx);
        PersonPlanSchemeInfo ppsInfo = ipps.getPersonPlanSchemeInfo("select * where id='" + id.toString() + "'");
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)ppsInfo.getBOSType(), (IObjectPK)pkScheme, (String)"personplanscheme_audit");
        IPersonPlanScheme ipps2 = PersonPlanSchemeFactory.getLocalInstance(ctx);
        ipps2.submit((CoreBaseInfo)ppsInfo);
        this.updatePersonPlanSchemeStatus(ctx, id.toString(), 3);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private void updatePersonPlanSchemeStatus(Context ctx, String id, int status) throws BOSException {
        StringBuffer sql = new StringBuffer("UPDATE T_HR_PersonPlanScheme SET FStatus =");
        sql.append(status).append(" WHERE FID ='").append(id.toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updateSchemeStatus(PersonPlanSchemeInfo ppsInfo, Context ctx) throws BOSException {
        String ppsId = null;
        ppsId = ppsInfo.getHrOrgUnit() != null ? ppsInfo.getHrOrgUnit().getId().toString() : ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        if (PersonPlanSchemeTypeEnum.Group.equals((Object)ppsInfo.getSchemeType())) {
            DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PersonPlanScheme SET FStatus=3 WHERE FStatus=2");
        } else {
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_PersonPlanScheme SET FStatus=3 WHERE FStatus=2 and FHROrgUnitID='" + ppsId + "'"));
        }
    }
}

