/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.org.HRJobFactory;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.hr.org.HRPositionException;
import com.kingdee.eas.hr.org.JobException;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.JobLevelFactory;
import com.kingdee.eas.hr.org.JobLevelInfo;
import com.kingdee.eas.hr.org.PositionStandardLibException;
import com.kingdee.eas.hr.org.PositionStandardLibFactory;
import com.kingdee.eas.hr.org.PositionStandardLibInfo;
import com.kingdee.eas.hr.org.RelationBetweenPositionAndLibCollection;
import com.kingdee.eas.hr.org.RelationBetweenPositionAndLibFactory;
import com.kingdee.eas.hr.org.app.AbstractPositionStandardLibControllerBean;
import com.kingdee.eas.hr.org.util.OrgAdjLockManager;
import com.kingdee.eas.hr.org.util.OrgUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.SHRBasicItemCollection;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PositionStandardLibControllerBean
extends AbstractPositionStandardLibControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.org.app.PositionStandardLibControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ObjectUuidPK pk = null;
        PositionStandardLibInfo info = (PositionStandardLibInfo)model;
        this.beforeSubmitCheck(ctx, info);
        this.checkJobGradeIsAble(ctx, info);
        this.checkJobLevelIsAble(ctx, info);
        Object sHRBasicItemInfo = new SHRBasicItemInfo();
        SHRBasicItemCollection coll = SHRBasicItemFactory.getLocalInstance((Context)ctx).getSHRBasicItemCollection("select * where entityName = 'com.kingdee.eas.hr.org.app.PositionStandardLib'");
        sHRBasicItemInfo = coll.size() > 0 ? coll.get(0) : null;
        info.setShrBasicItem((SHRBasicItemInfo)sHRBasicItemInfo);
        if (info.getHrJob() != null) {
            HRJobInfo hrJobInfo = HRJobFactory.getLocalInstance(ctx).getHRJobInfo((IObjectPK)new ObjectUuidPK(info.getHrJob().getId()));
            info.setJob(hrJobInfo.getJob());
        }
        if (info.getId() == null) {
            info.setState(BaseItemStateEnum.NEW);
            this.getNumber(ctx, info);
            pk = super._save(ctx, (IObjectValue)info);
        } else {
            pk = new ObjectUuidPK(info.getId());
            super._save(ctx, (IObjectValue)info);
        }
        return pk;
    }

    private void setJobLevel(Context ctx, PositionStandardLibInfo info) throws EASBizException, BOSException {
        if (info.getHrJob() != null) {
            HRJobInfo jobInfo = HRJobFactory.getLocalInstance(ctx).getHRJobInfo((IObjectPK)new ObjectUuidPK(info.getHrJob().getId()));
            if (jobInfo.getHighJobLevel() != null) {
                info.setHighJobLevel(jobInfo.getHighJobLevel());
            }
            if (jobInfo.getLowJobLevel() != null) {
                info.setLowJobLevel(jobInfo.getLowJobLevel());
            }
        }
    }

    private void getNumber(Context ctx, PositionStandardLibInfo info) throws BOSException, EASBizException {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String cuId = cuInfo.getId().toString();
            PositionStandardLibInfo tmpInfo = new PositionStandardLibInfo();
            tmpInfo.setCU(info.getCU());
            String rdNum = info.getNumber();
            if (codingRuleManager.isExist((IObjectValue)tmpInfo, cuId)) {
                boolean flag = PositionStandardLibFactory.getLocalInstance(ctx).exists(" select id where number='" + rdNum + "'");
                for (int count = 0; flag && count < 10; ++count) {
                    rdNum = codingRuleManager.getNonbreakNumber((IObjectValue)tmpInfo, cuId);
                    flag = PositionStandardLibFactory.getLocalInstance(ctx).exists(" select id where number='" + rdNum + "'");
                }
                info.setNumber(rdNum);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void beforeSubmitCheck(Context ctx, PositionStandardLibInfo info) throws BOSException, EASBizException {
        String nameSql = OrgUtils.getMulNameCheckSql(ctx, (DataBaseInfo)info);
        String posStdLibSortId = null;
        String checkSql = "SELECT * FROM T_HR_PositionStandardLib where " + nameSql;
        if (info.getPositionStandardLibSort() != null) {
            posStdLibSortId = info.getPositionStandardLibSort().getId().toString();
            checkSql = checkSql + " and FPOSITIONSTANDARDLIBSORTID = '" + posStdLibSortId + "'";
        } else {
            checkSql = checkSql + " and FPOSITIONSTANDARDLIBSORTID is null";
        }
        if (info.getHrOrgUnit() != null) {
            checkSql = checkSql + " and FHRORGUNITID = '" + info.getHrOrgUnit().getId().toString() + "' ";
        }
        if (info.getId() != null) {
            checkSql = checkSql + " and FID != '" + info.getId() + "'";
        }
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
        try {
            if (executeQuery.next()) {
                String number = executeQuery.getString("FNumber");
                throw new PositionStandardLibException(PositionStandardLibException.NAME_NOT_DUMP, new Object[]{number});
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (info.getId() != null) {
            String sql = "select id where number = '" + info.getNumber() + "' and id <> '" + info.getId() + "'";
            boolean flag = PositionStandardLibFactory.getLocalInstance(ctx).exists(sql);
            if (flag) {
                throw new PositionStandardLibException(PositionStandardLibException.NUMBER_IS_EXIST, new Object[]{info.getNumber()});
            }
        }
    }

    private void checkJobGradeIsAble(Context ctx, PositionStandardLibInfo info) throws BOSException, EASBizException {
        if (info.getLowJobGrade() == null && info.getHighJobGrade() == null) {
            return;
        }
        if (info.getHighJobGrade() == null && info.getLowJobGrade() != null || info.getLowJobGrade() == null && info.getHighJobGrade() != null) {
            throw new JobException(JobException.JOB_JOBGRADE_NOT_ALL_NULL);
        }
        JobGradeInfo highJobGrade = JobGradeFactory.getLocalInstance(ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(info.getHighJobGrade().getId()));
        JobGradeInfo lowJobGrade = JobGradeFactory.getLocalInstance(ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(info.getLowJobGrade().getId()));
        if (lowJobGrade.getGrade() > highJobGrade.getGrade()) {
            throw new JobException(JobException.JOB_HIGHGRADE_SMALL_LOWGRADE);
        }
    }

    private void checkJobLevelIsAble(Context ctx, PositionStandardLibInfo info) throws BOSException, EASBizException {
        if (info.getLowJobLevel() == null && info.getHighJobLevel() == null) {
            return;
        }
        if (info.getHighJobLevel() == null && info.getLowJobLevel() != null || info.getLowJobLevel() == null && info.getHighJobLevel() != null) {
            throw new JobException(JobException.JOB_JOBLEVEL_NOT_ALL_NULL);
        }
        JobLevelInfo highJobLevel = JobLevelFactory.getLocalInstance(ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(info.getHighJobLevel().getId()));
        JobLevelInfo lowJobLevel = JobLevelFactory.getLocalInstance(ctx).getJobLevelInfo((IObjectPK)new ObjectUuidPK(info.getLowJobLevel().getId()));
        if (lowJobLevel.getIndex() > highJobLevel.getIndex()) {
            throw new JobException(JobException.JOB_HIGHLEVEL_SMALL_LOWLEVEL);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkStandardPositionSync(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    private void checkStandardPositionSync(Context ctx, IObjectPK pk, IObjectValue model) throws HRPositionException {
        try {
            String isSync = ParamManager.getParamValue((Context)ctx, null, (String)"IS_USE_SHR_PositionEdit");
            if ("false".equals(isSync)) {
                PositionStandardLibInfo originalInfo = PositionStandardLibFactory.getLocalInstance(ctx).getPositionStandardLibInfo(pk);
                PositionStandardLibInfo currentInfo = (PositionStandardLibInfo)model;
                String newName = currentInfo.getName();
                if (!StringUtils.equals((String)originalInfo.getName(), (String)newName)) {
                    String oql = "where positionStandardLib = '" + pk.toString() + "' and position.name != '" + newName + "' and position.deletedStatus = 1 and adminPosStandardPro is null";
                    RelationBetweenPositionAndLibCollection relColl = RelationBetweenPositionAndLibFactory.getLocalInstance(ctx).getRelationBetweenPositionAndLibCollection(oql);
                    int size = relColl.size();
                    if (size > 0) {
                        IPosition iPosition = PositionFactory.getLocalInstance((Context)ctx);
                        for (int i = 0; i < size; ++i) {
                            BOSUuid positionId = relColl.get(i).getPosition().getId();
                            OrgAdjLockManager.checkIfOrgLocked(ctx, null, positionId.toString());
                            PositionInfo positionInfo = iPosition.getPositionInfo((IObjectPK)new ObjectUuidPK(positionId));
                            positionInfo.put("IS_FROM_SHR_OPT_CURD", (Object)"IS_FROM_SHR_OPT_CURD");
                            positionInfo.setName(newName);
                            iPosition.update((IObjectPK)new ObjectUuidPK(positionId), (CoreBaseInfo)positionInfo);
                        }
                    }
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new HRPositionException(new NumericExceptionSubItem("200", e.getMessage()), e);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            throw new HRPositionException(new NumericExceptionSubItem("200", e1.getMessage()), e1);
        }
    }
}

