/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.org.ORGActionEnum;
import com.kingdee.eas.hr.org.OrgActionLogFactory;
import com.kingdee.eas.hr.org.OrgActionLogInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;

public class OrgActionUtil {
    private static void cleanInfo(Context ctx, OrgActionLogInfo logInfo) throws EASBizException, BOSException {
        if (logInfo.getEFFDT() == null) {
            logInfo.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
        } else {
            logInfo.setEFFDT(DateTimeUtils.truncateDate((Date)logInfo.getEFFDT()));
        }
        if (StringUtils.isEmpty((String)logInfo.getParentID())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("parent.id"));
            AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(logInfo.getOperateID()), sic);
            if (adminInfo.getParent() != null) {
                logInfo.setParentID(adminInfo.getParent().getId().toString());
            }
        }
    }

    public static void addAction(Context ctx, ORGActionEnum action, Date effectDate, String id, String parentID, String historyID, String relateID) throws EASBizException, BOSException {
        OrgActionLogInfo logInfo = new OrgActionLogInfo();
        logInfo.setAction(action);
        logInfo.setOperateID(id);
        logInfo.setParentID(parentID);
        logInfo.setEFFDT(effectDate);
        logInfo.setRelateID(relateID);
        logInfo.setHistoryID(historyID);
        OrgActionUtil.cleanInfo(ctx, logInfo);
        OrgActionLogFactory.getLocalInstance(ctx).addnew(logInfo);
    }

    public static void updateAction(Context ctx, ORGActionEnum action, Date effectDate, String id, String parentID, String historyID, String relateID) throws EASBizException, BOSException {
        OrgActionLogInfo logInfo = new OrgActionLogInfo();
        logInfo.setAction(action);
        logInfo.setOperateID(id);
        logInfo.setParentID(parentID);
        logInfo.setEFFDT(effectDate);
        logInfo.setRelateID(relateID);
        logInfo.setHistoryID(historyID);
        OrgActionUtil.cleanInfo(ctx, logInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("historyID", (Object)historyID));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)effectDate, CompareType.NOTEQUALS));
        OrgActionLogFactory.getLocalInstance(ctx).delete(filter);
        OrgActionLogFactory.getLocalInstance(ctx).addnew(logInfo);
    }
}

