/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.org.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.org.OrgActionLogFactory;
import com.kingdee.eas.hr.org.PositionActionEnum;
import com.kingdee.eas.hr.org.PositionActionLogFactory;
import com.kingdee.eas.hr.org.PositionActionLogInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Date;

public class PositionActionUtil {
    private static void cleanInfo(Context ctx, PositionActionLogInfo logInfo) throws EASBizException, BOSException {
        if (logInfo.getEFFDT() == null) {
            logInfo.setEFFDT(DateTimeUtils.truncateDate((Date)new Date()));
        } else {
            logInfo.setEFFDT(DateTimeUtils.truncateDate((Date)logInfo.getEFFDT()));
        }
        if (StringUtils.isEmpty((String)logInfo.getParentID()) || StringUtils.isEmpty((String)logInfo.getAdminID())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("parent.id"));
            sic.add(new SelectorItemInfo("adminOrgUnit.id"));
            PositionInfo pInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(logInfo.getOperateID()), sic);
            if (StringUtils.isEmpty((String)logInfo.getParentID()) && pInfo.getParent() != null) {
                logInfo.setParentID(pInfo.getParent().getId().toString());
            }
            if (StringUtils.isEmpty((String)logInfo.getAdminID()) && pInfo.getAdminOrgUnit() != null) {
                logInfo.setAdminID(pInfo.getAdminOrgUnit().getId().toString());
            }
        }
    }

    public static void addAction(Context ctx, PositionActionEnum action, Date effectDate, String id, String parentID, String adminID, String historyID, String relateID) throws EASBizException, BOSException {
        PositionActionLogInfo logInfo = new PositionActionLogInfo();
        logInfo.setAction(action);
        logInfo.setOperateID(id);
        logInfo.setParentID(parentID);
        logInfo.setEFFDT(effectDate);
        logInfo.setRelateID(relateID);
        logInfo.setHistoryID(historyID);
        logInfo.setAdminID(adminID);
        PositionActionUtil.cleanInfo(ctx, logInfo);
        OrgActionLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)logInfo);
    }

    public static void updateAction(Context ctx, PositionActionEnum action, Date effectDate, String id, String parentID, String adminID, String historyID, String relateID) throws EASBizException, BOSException {
        PositionActionLogInfo logInfo = new PositionActionLogInfo();
        logInfo.setAction(action);
        logInfo.setOperateID(id);
        logInfo.setParentID(parentID);
        logInfo.setEFFDT(effectDate);
        logInfo.setRelateID(relateID);
        logInfo.setAdminID(adminID);
        logInfo.setHistoryID(historyID);
        PositionActionUtil.cleanInfo(ctx, logInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("historyID", (Object)historyID));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.EFFDT, (Object)effectDate, CompareType.NOTEQUALS));
        PositionActionLogFactory.getLocalInstance(ctx).delete(filter);
        PositionActionLogFactory.getLocalInstance(ctx).addnew(logInfo);
    }
}

