/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.base.app.filter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class StructureConfigUtils {
    public static String getStructureConfigEntityNameByKey(Context ctx, String key, String scheme) {
        String entityName = "";
        try {
            StructureConfigInfo structureConfigInfo = StructureConfigConvertHelper.getStructureConfigByKey(ctx, key, scheme);
            if (null != structureConfigInfo) {
                entityName = structureConfigInfo.getEntityName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entityName;
    }

    public static String getStructureConfigParentEntityNameByKey(Context ctx, String key, String scheme) {
        String entityName = "";
        try {
            StructureConfigInfo structureConfigInfo = StructureConfigConvertHelper.getStructureConfigByKey(ctx, key, scheme);
            if (null != structureConfigInfo && structureConfigInfo.getParent() != null) {
                entityName = structureConfigInfo.getParent().getEntityName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entityName;
    }

    public static String getStructureConfigTableNameByKey(Context ctx, String key, String scheme) {
        String entityName = StructureConfigUtils.getStructureConfigEntityNameByKey(ctx, key, scheme);
        return StructureConfigUtils.getTableNameByEntityName(ctx, entityName);
    }

    public static String getStructureConfigParentTableNameByKey(Context ctx, String key, String scheme) {
        String entityName = StructureConfigUtils.getStructureConfigParentEntityNameByKey(ctx, key, scheme);
        return StructureConfigUtils.getTableNameByEntityName(ctx, entityName);
    }

    private static String getTableNameByEntityName(Context ctx, String entityName) {
        String tableName = "";
        if (StringUtils.isEmpty((String)entityName)) {
            return tableName;
        }
        EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName((Context)ctx, (String)entityName);
        if (null != entityObjectInfo && null != entityObjectInfo.getTable()) {
            tableName = entityObjectInfo.getTable().getName();
        }
        return tableName;
    }

    public static String getStructureConfigTableNameByKeyToUpperCase(Context ctx, String key, String scheme) {
        String tableName = StructureConfigUtils.getStructureConfigTableNameByKey(ctx, key, scheme);
        return tableName != null ? tableName.toUpperCase() : "";
    }

    public static String getStructureConfigParentTableNameByKeyToUpperCase(Context ctx, String key, String scheme) {
        String tableName = StructureConfigUtils.getStructureConfigParentTableNameByKey(ctx, key, scheme);
        return tableName != null ? tableName.toUpperCase() : "";
    }

    public static Map<String, String> getStructureConfigParentTableNameAndTableAliasMappingByKey(Context ctx, String key, String scheme) {
        String tableName = StructureConfigUtils.getStructureConfigParentTableNameByKeyToUpperCase(ctx, key, scheme);
        String tableAlias = "";
        if (!StringUtils.isEmpty((String)tableName)) {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                StructureConfigInfo structureConfigInfo = StructureConfigConvertHelper.getStructureConfigByKey(ctx, key, scheme);
                if (null != structureConfigInfo & structureConfigInfo.getParent() != null) {
                    tableAlias = structureConfigInfo.getParent().getClientNumber().toUpperCase();
                }
                map.put(tableName, tableAlias);
                return map;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> getStructureConfigTableNameAndTableAliasMappingByKey(Context ctx, String key, String scheme) {
        String tableName = StructureConfigUtils.getStructureConfigTableNameByKeyToUpperCase(ctx, key, scheme);
        String tableAlias = "";
        if (!StringUtils.isEmpty((String)tableName)) {
            HashMap<String, String> map = new HashMap<String, String>();
            try {
                StructureConfigInfo structureConfigInfo = StructureConfigConvertHelper.getStructureConfigByKey(ctx, key, scheme);
                if (null != structureConfigInfo) {
                    tableAlias = structureConfigInfo.getClientNumber().toUpperCase();
                }
                map.put(tableName, tableAlias);
                return map;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyMap();
    }
}

