/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.baseconfig.service.api;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.permission.FieldPermCustomPageCollection;
import com.kingdee.shr.base.permission.FieldPermCustomPageFactory;
import com.kingdee.shr.base.permission.FieldPermCustomPageInfo;
import com.kingdee.shr.baseconfig.BaseConfigException;
import com.kingdee.shr.baseconfig.service.api.ISHRCustomFieldBuilder;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class SHRCustomFieldBuilderFactory {
    private static Logger logger = Logger.getLogger(SHRCustomFieldBuilderFactory.class);

    public static ISHRCustomFieldBuilder getInstance(Context ctx, String schemeNum) throws EASBizException, BOSException {
        String builderImplClass = SHRCustomFieldBuilderFactory.getBuilderImplClass(ctx, schemeNum);
        if (null == builderImplClass) {
            throw new BaseConfigException(BaseConfigException.IMPL_CLASS_NO_LOAD, new Object[]{builderImplClass});
        }
        try {
            Class<?> clazz = Class.forName(builderImplClass);
            Object obj = clazz.newInstance();
            if (!(obj instanceof ISHRCustomFieldBuilder)) {
                throw new BaseConfigException(BaseConfigException.NO_IMPL, new Object[]{builderImplClass, ISHRCustomFieldBuilder.class.toString()});
            }
            return (ISHRCustomFieldBuilder)obj;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BaseConfigException(BaseConfigException.IMPL_CLASS_NO_LOAD, new Object[]{builderImplClass});
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static String getBuilderImplClass(Context ctx, String modelFullName) throws BOSException {
        FieldPermCustomPageInfo fieldPermCustomPageInfo;
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)modelFullName)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)modelFullName, CompareType.EQUALS));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        FieldPermCustomPageCollection fieldPermCustomPageCollection = FieldPermCustomPageFactory.getLocalInstance((Context)ctx).getFieldPermCustomPageCollection(entityViewInfo);
        if (null != fieldPermCustomPageCollection && null != (fieldPermCustomPageInfo = fieldPermCustomPageCollection.get(0))) {
            return fieldPermCustomPageInfo.getBuilderImplClass();
        }
        return null;
    }
}

