/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.app.util.HRWorkFlowCheckUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.cmpdesign.CmpStdLevelCollection;
import com.kingdee.shr.cmpdesign.CmpStdLevelFactory;
import com.kingdee.shr.cmpdesign.CmpStdLevelInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyCollection;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyFactory;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyInfo;
import com.kingdee.shr.cmpdesign.dto.v2.BatchAdjustRuleItemDTO;
import com.kingdee.shr.cmpdesign.util.AdjustSalarySqlUtils;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class AdjustSalaryUtils {
    private static final Logger logger = Logger.getLogger(AdjustSalaryUtils.class);

    public static Set<String> getHROrgDownRange(Context ctx, Set<String> hrOrgIds) throws BOSException, SQLException, EASBizException {
        HashSet<String> hrIds = new HashSet<String>();
        if (CollectionUtils.isEmpty(hrOrgIds)) {
            return hrIds;
        }
        HashSet<String> longNumberSet = new HashSet<String>();
        HROrgUnitCollection hrOrgUnitCollection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select longnumber where id in " + AdjustSalarySqlUtils.convertSetToSql(hrOrgIds));
        if (hrOrgUnitCollection != null && hrOrgUnitCollection.size() > 0) {
            HROrgUnitInfo hrOrgUnitInfo = null;
            for (int i = 0; i < hrOrgUnitCollection.size(); ++i) {
                hrOrgUnitInfo = hrOrgUnitCollection.get(i);
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hrOrgUnitInfo.getLongNumber())) continue;
                longNumberSet.add(hrOrgUnitInfo.getLongNumber());
            }
            if (!CollectionUtils.isEmpty(longNumberSet)) {
                StringBuilder queryHrOrgSql = new StringBuilder();
                queryHrOrgSql.append("select fid from t_org_hro where " + AdjustSalarySqlUtils.convertSetToLikeSql(longNumberSet, "flongnumber", "value%"));
                IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)queryHrOrgSql.toString());
                while (iRowSet.next()) {
                    hrIds.add(iRowSet.getString(1));
                }
            }
        }
        return hrIds;
    }

    public static String getHROrgUpRange(Context ctx, String permItemId) throws BOSException, SQLException {
        StringBuilder hrOrgInSql = new StringBuilder();
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String hrOrgRangeInSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hrOrgRangeInSQL)) {
            HashSet<String> numberSet = new HashSet<String>();
            HROrgUnitCollection hrOrgUnitCollection = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitCollection("select longNumber where id in (" + hrOrgRangeInSQL + ")");
            if (hrOrgUnitCollection != null && hrOrgUnitCollection.size() > 0) {
                HROrgUnitInfo hrOrgUnitInfo = null;
                String longNumber = "";
                String[] numberArr = null;
                for (int i = 0; i < hrOrgUnitCollection.size(); ++i) {
                    hrOrgUnitInfo = hrOrgUnitCollection.get(i);
                    longNumber = hrOrgUnitInfo.getLongNumber();
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)longNumber) || (numberArr = longNumber.split("!")) == null || numberArr.length <= 0) continue;
                    for (String number : numberArr) {
                        numberSet.add(number);
                    }
                }
                if (!CollectionUtils.isEmpty(numberSet)) {
                    AdjustSalarySqlUtils.convertSetToSql(numberSet);
                    StringBuilder queryHrOrgSql = new StringBuilder();
                    queryHrOrgSql.append("select fid from t_org_hro where fnumber in " + AdjustSalarySqlUtils.convertSetToSql(numberSet));
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryHrOrgSql.toString());
                    while (rowSet.next()) {
                        String fid = rowSet.getString("fid");
                        hrOrgInSql.append("'" + fid + "',");
                    }
                }
            }
        }
        if (hrOrgInSql.length() > 0) {
            return hrOrgInSql.substring(0, hrOrgInSql.length() - 1);
        }
        return hrOrgInSql.toString();
    }

    public static boolean checkSubmitSchemeIsUsingBill(Context ctx, String schemeId) {
        boolean flag = false;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeId)) {
            return flag;
        }
        String sql = "Select fid  from T_HR_SAdjustSalaryApply where fbillstate in (0,1,2)  and FAdjustSalaryRuleID = ? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{schemeId});
            if (rs.size() > 0) {
                flag = true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    public static boolean deleteAdjBaseFormula(Context ctx, String schemeId) throws EASBizException, BOSException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeId)) {
            return false;
        }
        StringBuilder delFormulaSql = new StringBuilder();
        delFormulaSql.append("delete from T_HR_SBaseFormula bf where exists (select brc.fid from T_HR_SBusinessRelationConfig brc where brc.fid=bf.FBusinessRelationConfigID and ftype = '3'and brc.FBusinessId=? )");
        DbUtil.execute((Context)ctx, (String)delFormulaSql.toString(), (Object[])new Object[]{schemeId});
        StringBuilder delConfigSql = new StringBuilder();
        delConfigSql.append("delete from T_HR_SBusinessRelationConfig where FBusinessId=? and ftype = '3'");
        DbUtil.execute((Context)ctx, (String)delConfigSql.toString(), (Object[])new Object[]{schemeId});
        return true;
    }

    public static boolean deleteAdjustSalaryPlan(Context ctx, String schemeId) throws EASBizException, BOSException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeId)) {
            return false;
        }
        StringBuilder delSql = new StringBuilder();
        delSql.append("delete from T_HR_SAdjustSalaryPlan where FAdjustSalaryRuleID=?");
        DbUtil.execute((Context)ctx, (String)delSql.toString(), (Object[])new Object[]{schemeId});
        return true;
    }

    public static boolean deleteAdjustLalaryScheme(Context ctx, String schemeId) throws BOSException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeId)) {
            return false;
        }
        StringBuilder delSql = new StringBuilder();
        delSql.append("delete from T_HR_SCalSubmitScheme where fid=?");
        DbUtil.execute((Context)ctx, (String)delSql.toString(), (Object[])new Object[]{schemeId});
        return true;
    }

    public static boolean deleteBatchAdjustRuleItem(Context ctx, String schemeId) throws EASBizException, BOSException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeId)) {
            return false;
        }
        StringBuilder delSql = new StringBuilder();
        delSql.append("delete from T_HR_SBatchAdjustRuleItem where FCalSubmitSchemeID=?");
        DbUtil.execute((Context)ctx, (String)delSql.toString(), (Object[])new Object[]{schemeId});
        return true;
    }

    public static boolean deleteAdjustSalaryVerificationRule(Context ctx, String schemeId) throws EASBizException, BOSException {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeId)) {
            return false;
        }
        StringBuilder delSql = new StringBuilder();
        delSql.append("delete from T_HR_SAdjVerificationRule where FAdjustSalaryRuleID=?");
        DbUtil.execute((Context)ctx, (String)delSql.toString(), (Object[])new Object[]{schemeId});
        return true;
    }

    public static boolean deleteAdjSalaryTableRelation(Context ctx, String schemeId) throws BOSException, SQLException {
        boolean flag = false;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)schemeId)) {
            return flag;
        }
        String sql = "select FBillEntryTableName , FAdjustBaseTableName  from T_HR_SAdjSalaryTableRelation where FAdjustSalaryRule = '" + schemeId + "'";
        String adjustBaseTableName = "";
        String billEntryTableName = "";
        IRowSet list = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (list.next()) {
            billEntryTableName = list.getString("FBillEntryTableName");
            adjustBaseTableName = list.getString("FAdjustBaseTableName");
        }
        if (!CmpStrUtil.isEmpty((String)adjustBaseTableName)) {
            DbUtil.execute((Context)ctx, (String)("If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + billEntryTableName + "') drop table " + billEntryTableName + ""));
            DbUtil.execute((Context)ctx, (String)("If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='" + adjustBaseTableName + "') drop table " + adjustBaseTableName + ""));
        }
        DbUtil.execute((Context)ctx, (String)("delete   from T_HR_SAdjSalaryTableRelation where FAdjustSalaryRule = '" + schemeId + "'"));
        return flag;
    }

    public static Map<String, Integer> initFormulaIsCal(String adjustSalaryRuleId, Context ctx) throws BOSException, SQLException {
        HashMap<String, Integer> isCalMap = new HashMap<String, Integer>();
        StringBuilder formulaSql = new StringBuilder();
        formulaSql.append(" select formula.FIsCal, formula.FCalItem from T_HR_SBusinessRelationConfig config ");
        formulaSql.append(" left join t_hr_sbaseformula formula on formula.FBusinessRelationConfigID = config.fid ");
        formulaSql.append(" where FBusinessId = '").append(adjustSalaryRuleId).append("' ");
        IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)formulaSql.toString());
        while (rs.next()) {
            String isCal = rs.getString("FIsCal");
            String item = rs.getString("FCalItem");
            if (isCal == null || Integer.parseInt(isCal) != 1 || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)item)) continue;
            isCalMap.put(item, 1);
        }
        return isCalMap;
    }

    public static List<Map<String, Object>> getADJSalaryItemValue(Context ctx, String adjustSalaryRuleId, String dataType) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> map = null;
        StringBuilder sql = new StringBuilder();
        sql.append("select item.fieldSn, item.FDataLength ");
        sql.append("from T_HR_SCalSubmitScheme sch ");
        sql.append("inner join T_HR_SBatchAdjustRuleItem rul on rul.FCalSubmitSchemeID = sch.fid ");
        sql.append("inner join T_HR_AdjustSalaryItem item on item.fid = rul.FAdjustSalaryItemID ");
        sql.append("where sch.fid = ? ");
        if (CmpStrUtil.isNotEmpty((String)dataType)) {
            sql.append(" and item.FDataType = '").append(dataType).append("'");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{adjustSalaryRuleId});
            while (rs.next()) {
                map = new HashMap<String, Integer>();
                map.put("fieldSn", rs.getInt(1));
                map.put("dataLength", rs.getInt(2));
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Map<String, Object> getBillColumnListAndQuerySql(Context ctx, String adjustSalaryRuleId, String billId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)adjustSalaryRuleId)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        try {
            String sqlBuffer = " SELECT   item.fieldSn FIELDSN,  b.FTable FTABLE FROM T_HR_SCalSubmitScheme scheme  inner join T_HR_sbatchAdjustRuleItem schemeItem on scheme.fid = schemeItem.FCalSubmitSchemeID  inner join T_HR_AdjustSalaryItem item on item.fid = schemeItem.FAdjustSalaryItemID  inner join T_HR_SCalSchemeItemForF7 b on item.FilterFieldID = b.fid  where scheme.fid =  '" + adjustSalaryRuleId + "' and item.FDataType = '" + "3" + "' order by  FSortCode";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer);
            HashMap<String, String> f7ItemTableMapper = new HashMap<String, String>();
            HashMap<String, String> f7ItemAliasMapper = new HashMap<String, String>();
            while (rs.next()) {
                f7ItemTableMapper.put("S" + rs.getInt("FIELDSN"), rs.getString("FTABLE"));
                f7ItemAliasMapper.put("S" + rs.getInt("FIELDSN"), rs.getString("FTABLE") + rs.getInt("FIELDSN"));
            }
            String sql = "select item.fieldSn, item.fdataType, item.fname_" + language + " itemName, item.FDataDot ,n.FBillEntryTableName from T_HR_SCalSubmitScheme sch inner join T_HR_sbatchAdjustRuleItem rul on rul.FCalSubmitSchemeID = sch.fid inner join T_HR_AdjustSalaryItem item on item.fid = rul.FAdjustSalaryItemID inner join T_HR_SAdjSalaryTableRelation n on n.FAdjustSalaryRule =sch.fid where sch.fid = '" + adjustSalaryRuleId + "' and rul.FIsAdjustRuleShow = 1 order by FSortCode";
            colNames.add("id");
            colNames.add("effectDate");
            colNames.add("leffectDate");
            colNames.add("description");
            colNames.add("currency");
            StringBuilder sd = new StringBuilder();
            sd.append("select t.fid id, t.FState, t.FEffectDate effectDate, t.FLeffectDate leffectDate, t.FAdjustEmpORelationID adjustEmpORelation, t.FForwarnContent forwarnContent, ");
            sd.append("currency.fid currency, currency.fname_").append(language).append(" currencyName, t.fdescription_l1 description_l1,t.fdescription_l2 description_l2,t.fdescription_l3 description_l3, ");
            String fBillEntryTableName = "";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean columnFlag = true;
            while (rs.next()) {
                String fieldName;
                if (columnFlag) {
                    columnFlag = false;
                    fBillEntryTableName = rs.getString("FBillEntryTableName");
                    colNames.add("forwarnContent");
                    colNames.add("personId");
                    colNames.add("name");
                    colNames.add("number");
                    colNames.add("admOrgId");
                    colNames.add("admOrgName");
                    colNames.add("positionId");
                    colNames.add("positionName");
                    colNames.add("hrOrgId");
                    colNames.add("hrOrgName");
                    colNames.add("adjustEmpORelation");
                    colNames.add("state");
                    colNames.add("cmpStandardId");
                    colNames.add("cmpStandardName");
                    colNames.add("cmpStdLevelId");
                    colNames.add("cmpStdLevelName");
                    colNames.add("floatRate");
                    colNames.add("cmpStdPointId");
                    colNames.add("cmpStdPointName");
                    colNames.add("cmpStdScopeId");
                    colNames.add("cmpStdScopeName");
                    sd.append(" person.fid personId, person.fname_").append(language).append(" name, person.fnumber number, adminOrgUnit.fid admOrgId, adminOrgUnit.fname_").append(language).append(" admOrgName, position.fid positionId, position.fname_").append(language).append(" positionName, ");
                    sd.append(" hrOrgUnit.fid hrOrgId, hrOrgUnit.fname_").append(language).append(" hrOrgName, ");
                    sd.append(" cmpStandard.fid cmpStandardId, cmpStandard.fname_").append(language).append(" cmpStandardName, ");
                    sd.append(" cmpStdLevel.fid cmpStdLevelId, cmpStdLevel.fname_").append(language).append(" cmpStdLevelName, cmpStdLevel.FloatRate floatRate,");
                    sd.append(" cmpStdPoint.fid cmpStdPointId, cmpStdPoint.fname_").append(language).append(" cmpStdPointName, ");
                    sd.append(" cmpStdScope.fid cmpStdScopeId, cmpStdScope.fname_").append(language).append(" cmpStdScopeName ");
                }
                if (f7ItemTableMapper.containsKey(fieldName = "S" + rs.getString("fieldSn"))) {
                    String aliasName = (String)f7ItemAliasMapper.get(fieldName);
                    sd.append(",").append(aliasName).append(".FID ").append(fieldName).append("id,").append(aliasName).append(".FNAME_").append(language).append(" ").append(fieldName).append(",").append(aliasName).append(".FNUMBER ").append(fieldName).append("number");
                } else {
                    sd.append(",").append(fieldName);
                }
                colNames.add(fieldName);
                if (!"0".equals(rs.getString("fdataType"))) continue;
                columnMap.put(fieldName, rs.getInt("FDataDot"));
            }
            sd.append(" from ").append(fBillEntryTableName).append(" t ");
            sd.append(" LEFT join T_HR_SAdjustSalaryApply bill on t.FBillID = bill.FID ");
            sd.append(" inner join t_bd_person person on t.fpersonId = person.fid ");
            sd.append(" LEFT join T_ORG_Admin adminOrgUnit on t.FAdminOrgUnitID = adminOrgUnit.fid ");
            sd.append(" left join t_org_hro hrOrgUnit on t.FHrOrgUnitID = hrOrgUnit.fid ");
            sd.append(" LEFT join T_ORG_Position position on t.FPositionID = position.fid ");
            sd.append(" LEFT join T_BD_Currency currency on t.fCurrencyID = currency.fid ");
            sd.append(" LEFT join T_HR_SCmpStandard cmpStandard on t.FCmpStandardID = cmpStandard.fid ");
            sd.append(" LEFT join T_HR_SCmpStdLevel cmpStdLevel on t.FCmpStdLevelID = cmpStdLevel.fid ");
            sd.append(" LEFT join T_HR_SCmpStdPoint cmpStdPoint on t.FCmpStdPointID = cmpStdPoint.fid ");
            sd.append(" LEFT join T_HR_SCmpStdScope cmpStdScope on t.FCmpStdScopeID = cmpStdScope.fid ");
            Set f7KeySet = f7ItemTableMapper.keySet();
            for (String f7Key : f7KeySet) {
                String tableName = (String)f7ItemTableMapper.get(f7Key);
                String aliasName = (String)f7ItemAliasMapper.get(f7Key);
                sd.append(" LEFT JOIN ").append(tableName).append(" ").append(aliasName).append(" on t.").append(f7Key).append(" = ").append(aliasName).append(".FID ");
            }
            sd.append(" where t.fbillid = '").append(billId).append("'");
            sd.append(" and  t.FCalSubmitSchemeID = '").append(adjustSalaryRuleId).append("' ");
            map.put("querySql", sd.toString());
            map.put("colNames", colNames);
            map.put("columnMap", columnMap);
        }
        catch (Exception e) {
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryApplyResource", (String)"label21", (Context)ctx));
        }
        return map;
    }

    public static Map<String, Object> getBillColumnListAndQuerySqlForExport(Context ctx, String adjustSalaryRuleId, String billId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)adjustSalaryRuleId)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        try {
            String sqlBuffer = " SELECT item.fieldSn FIELDSN, b.FTable FTABLE FROM T_HR_SCalSubmitScheme scheme  inner join T_HR_sbatchAdjustRuleItem schemeItem on scheme.fid = schemeItem.FCalSubmitSchemeID  inner join T_HR_AdjustSalaryItem item on item.fid = schemeItem.FAdjustSalaryItemID  inner join T_HR_SCalSchemeItemForF7 b on item.FilterFieldID = b.fid  where scheme.fid =  '" + adjustSalaryRuleId + "' and item.FDataType = '" + "3" + "' order by  FSortCode";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer);
            HashMap<String, String> f7ItemTableMapper = new HashMap<String, String>();
            HashMap<String, String> f7ItemAliasMapper = new HashMap<String, String>();
            while (rs.next()) {
                f7ItemTableMapper.put("S" + rs.getInt("FIELDSN"), rs.getString("FTABLE"));
                f7ItemAliasMapper.put("S" + rs.getInt("FIELDSN"), rs.getString("FTABLE") + rs.getInt("FIELDSN"));
            }
            String sql = "select item.fieldSn, item.fdataType, item.fname_" + language + " itemName, item.FDataDot ,n.FBillEntryTableName from T_HR_SCalSubmitScheme sch inner join T_HR_sbatchAdjustRuleItem rul on rul.FCalSubmitSchemeID = sch.fid inner join T_HR_AdjustSalaryItem item on item.fid = rul.FAdjustSalaryItemID inner join T_HR_SAdjSalaryTableRelation n on n.FAdjustSalaryRule =sch.fid where sch.fid = '" + adjustSalaryRuleId + "' and rul.FIsAdjustRuleShow = 1 order by FSortCode";
            colNames.add("id");
            colNames.add("effectDate");
            colNames.add("leffectDate");
            colNames.add("description");
            colNames.add("currency");
            StringBuilder sd = new StringBuilder();
            sd.append("select t.fstate state,t.fid id, t.FEffectDate effectDate, t.FLeffectDate leffectDate, t.FAdjustEmpORelationID adjustEmpORelation, t.FForwarnContent forwarnContent, ");
            sd.append("currency.fid currency, currency.fname_").append(language).append(" currencyName, t.fdescription_l1 description_l1,t.fdescription_l2 description_l2,t.fdescription_l3 description_l3, ");
            String fBillEntryTableName = "";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean columnFlag = true;
            while (rs.next()) {
                String fieldName;
                if (columnFlag) {
                    columnFlag = false;
                    fBillEntryTableName = rs.getString("FBillEntryTableName");
                    colNames.add("forwarnContent");
                    colNames.add("personId");
                    colNames.add("name");
                    colNames.add("number");
                    colNames.add("admOrgId");
                    colNames.add("admOrgName");
                    colNames.add("positionId");
                    colNames.add("positionName");
                    colNames.add("hrOrgId");
                    colNames.add("hrOrgName");
                    colNames.add("adjustEmpORelation");
                    colNames.add("cmpStandardId");
                    colNames.add("cmpStandard");
                    colNames.add("cmpStdLevelId");
                    colNames.add("cmpStdLevel");
                    colNames.add("floatRate");
                    colNames.add("cmpStdPointId");
                    colNames.add("cmpStdPoint");
                    colNames.add("cmpStdScopeId");
                    colNames.add("cmpStdScope");
                    sd.append(" person.fid personId, person.fname_").append(language).append(" name, person.fnumber number, adminOrgUnit.fid admOrgId, adminOrgUnit.fname_").append(language).append(" admOrgName, position.fid positionId, position.fname_").append(language).append(" positionName, ");
                    sd.append(" hrOrgUnit.fid hrOrgId, hrOrgUnit.fname_").append(language).append(" hrOrgName, ");
                    sd.append(" cmpStandard.fid cmpStandardId, cmpStandard.fname_").append(language).append(" cmpStandard, ");
                    sd.append(" cmpStdLevel.fid cmpStdLevelId, cmpStdLevel.fname_").append(language).append(" cmpStdLevel, cmpStdLevel.FloatRate floatRate,");
                    sd.append(" cmpStdPoint.fid cmpStdPointId, cmpStdPoint.fname_").append(language).append(" cmpStdPoint, ");
                    sd.append(" cmpStdScope.fid cmpStdScopeId, cmpStdScope.fname_").append(language).append(" cmpStdScope ");
                }
                if (f7ItemTableMapper.containsKey(fieldName = "S" + rs.getString("fieldSn"))) {
                    String aliasName = (String)f7ItemAliasMapper.get(fieldName);
                    sd.append(",").append(aliasName).append(".FID ").append(fieldName).append("id,").append(aliasName).append(".FNAME_").append(language).append(" ").append(fieldName).append(",").append(aliasName).append(".FNUMBER ").append(fieldName).append("number");
                } else {
                    sd.append(",").append(fieldName);
                }
                colNames.add(fieldName);
                if (!"0".equals(rs.getString("fdataType"))) continue;
                columnMap.put(fieldName, rs.getInt("FDataDot"));
            }
            sd.append(" from ").append(fBillEntryTableName).append(" t ");
            sd.append(" LEFT join T_HR_SAdjustSalaryApply bill on t.FBillID = bill.FID ");
            sd.append(" inner join t_bd_person person on t.fpersonId = person.fid ");
            sd.append(" LEFT join T_ORG_Admin adminOrgUnit on t.FAdminOrgUnitID = adminOrgUnit.fid ");
            sd.append(" left join t_org_hro hrOrgUnit on t.FHrOrgUnitID = hrOrgUnit.fid ");
            sd.append(" LEFT join T_ORG_Position position on t.FPositionID = position.fid ");
            sd.append(" LEFT join T_BD_Currency currency on t.fCurrencyID = currency.fid ");
            sd.append(" LEFT join T_HR_SCmpStandard cmpStandard on t.FCmpStandardID = cmpStandard.fid ");
            sd.append(" LEFT join T_HR_SCmpStdLevel cmpStdLevel on t.FCmpStdLevelID = cmpStdLevel.fid ");
            sd.append(" LEFT join T_HR_SCmpStdPoint cmpStdPoint on t.FCmpStdPointID = cmpStdPoint.fid ");
            sd.append(" LEFT join T_HR_SCmpStdScope cmpStdScope on t.FCmpStdScopeID = cmpStdScope.fid ");
            Set f7KeySet = f7ItemTableMapper.keySet();
            for (String f7Key : f7KeySet) {
                String tableName = (String)f7ItemTableMapper.get(f7Key);
                String aliasName = (String)f7ItemAliasMapper.get(f7Key);
                sd.append(" LEFT JOIN ").append(tableName).append(" ").append(aliasName).append(" on t.").append(f7Key).append(" = ").append(aliasName).append(".FID ");
            }
            sd.append(" where t.fbillid = '").append(billId).append("'");
            sd.append(" and  t.FCalSubmitSchemeID = '").append(adjustSalaryRuleId).append("' ");
            map.put("querySql", sd.toString());
            map.put("colNames", colNames);
            map.put("columnMap", columnMap);
        }
        catch (Exception e) {
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryApplyResource", (String)"label21", (Context)ctx));
        }
        return map;
    }

    public static String assembleInsertSql(Context ctx, String billEntryTable, List<String> colNames, String billId) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        StringBuilder insertCol = new StringBuilder();
        insertCol.append(" insert into " + billEntryTable);
        insertCol.append(" (FID ,FBillID , FCreatorID, FCreateTime, FEffectDate, FLeffectDate, ");
        insertCol.append(" FHrOrgUnitID, FPersonID , FAdminOrgUnitID, FPositionID, FAdjustEmpORelationID, ");
        insertCol.append(" FCurrencyID,FDescription_l1,FDescription_l2,FDescription_l3,FBillState ,FDataSource, FBaseTableID,FCalSubmitSchemeID,FForwarnContent, ");
        insertCol.append(" FCmpStandardID,FCmpStdLevelID,FCmpStdPointID,FCmpStdScopeID ,FState");
        StringBuilder insertval = new StringBuilder(" values ( ?,'" + billId + "', '" + userId + "', ?");
        insertval.append(", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,?, ?, ?, ?,?, ?, ?, ? , ?, ? ");
        for (String schemeItem : colNames) {
            insertCol.append("," + schemeItem);
            insertval.append(", ? ");
        }
        insertCol.append(" )");
        insertval.append(" )");
        insertCol.append((CharSequence)insertval);
        return insertCol.toString();
    }

    public static String assembleInsertSql(Context ctx, String billEntryTable, List<String> colNames, String billId, List<String> customerFields) {
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        StringBuilder insertCol = new StringBuilder();
        insertCol.append(" insert into " + billEntryTable);
        insertCol.append(" (FID ,FBillID , FCreatorID, FCreateTime, FEffectDate, FLeffectDate, ");
        insertCol.append(" FHrOrgUnitID, FPersonID , FAdminOrgUnitID, FPositionID, FAdjustEmpORelationID, ");
        insertCol.append(" FCurrencyID,FDescription_l1,FDescription_l2,FDescription_l3,FBillState ,FDataSource, FBaseTableID,FCalSubmitSchemeID,FForwarnContent, ");
        insertCol.append(" FCmpStandardID,FCmpStdLevelID,FCmpStdPointID,FCmpStdScopeID ,FState");
        StringBuilder insertval = new StringBuilder(" values ( ?,'" + billId + "', '" + userId + "', ?");
        insertval.append(", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,?, ?, ?, ?,?, ?, ?, ? , ?, ? ");
        for (String fields : customerFields) {
            insertCol.append("," + fields);
            insertval.append(", ? ");
        }
        for (String schemeItem : colNames) {
            insertCol.append("," + schemeItem);
            insertval.append(", ? ");
        }
        insertCol.append(" )");
        insertval.append(" )");
        insertCol.append((CharSequence)insertval);
        return insertCol.toString();
    }

    public static String assembleImportInsertSql(Context ctx, String billEntryTable, List<String> colNames, String billId) {
        StringBuilder insertCol = new StringBuilder(" insert into ");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        insertCol.append(billEntryTable);
        insertCol.append(" (FID ,FBillID , FCreatorID, FCreateTime, FEffectDate, FLeffectDate, ");
        insertCol.append(" FHrOrgUnitID, FPersonID , FAdminOrgUnitID, FPositionID, FAdjustEmpORelationID, ");
        insertCol.append(" FCurrencyID,FDescription_l1,FDescription_l2,FDescription_l3,FBillState ,FDataSource, FBaseTableID,FCalSubmitSchemeID,FForwarnContent, ");
        insertCol.append(" FCmpStandardID,FCmpStdLevelID,FCmpStdPointID,FCmpStdScopeID,FLastUpdateUserID,FLastUpdateTime ");
        StringBuilder insertval = new StringBuilder(" values ( ?,'" + billId + "', '" + userId + "', ?");
        insertval.append(", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,?, ?, ?, ?,?, ?, ?, ? , ?, ?, ? ");
        for (String schemeItem : colNames) {
            insertCol.append("," + schemeItem);
            insertval.append(", ? ");
        }
        insertCol.append(" )");
        insertval.append(" )");
        insertCol.append((CharSequence)insertval);
        return insertCol.toString();
    }

    public static String assembleImportInsertSql(Context ctx, String billEntryTable, List<String> colNames, String billId, List<String> customerFields) {
        StringBuilder insertCol = new StringBuilder(" insert into ");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        insertCol.append(billEntryTable);
        insertCol.append(" (FID ,FBillID , FCreatorID,FState, FCreateTime, FEffectDate, FLeffectDate, ");
        insertCol.append(" FHrOrgUnitID, FPersonID , FAdminOrgUnitID, FPositionID, FAdjustEmpORelationID, ");
        insertCol.append(" FCurrencyID,FDescription_l1,FDescription_l2,FDescription_l3,FBillState ,FDataSource, FBaseTableID,FCalSubmitSchemeID,FForwarnContent, ");
        insertCol.append(" FCmpStandardID,FCmpStdLevelID,FCmpStdPointID,FCmpStdScopeID,FLastUpdateUserID,FLastUpdateTime ");
        StringBuilder insertval = new StringBuilder(" values ( ?,'" + billId + "', '" + userId + "', 0,?");
        insertval.append(", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? ,?, ?, ?, ?,?, ?, ?, ? , ?, ?, ? ");
        for (String fields : customerFields) {
            insertCol.append("," + fields);
            insertval.append(", ? ");
        }
        for (String schemeItem : colNames) {
            insertCol.append("," + schemeItem);
            insertval.append(", ? ");
        }
        insertCol.append(" )");
        insertval.append(" )");
        insertCol.append((CharSequence)insertval);
        return insertCol.toString();
    }

    public static String getCalShemeTableName(Context ctx, String adjustSalaryRuleId) throws BOSException {
        String calShemeTableName = "";
        String sql = "Select FBillEntryTableName from T_HR_SAdjSalaryTableRelation where FAdjustSalaryRule = '" + adjustSalaryRuleId + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                calShemeTableName = rs.getString("FBillEntryTableName");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        return calShemeTableName;
    }

    public static String getCalShemeBaseTableName(Context ctx, String submitSchemeId) {
        String calShemeTableName = "";
        StringBuilder sql = new StringBuilder(" SELECT FBillEntryTableName, FAdjustBaseTableName ");
        sql.append(" FROM T_HR_SAdjSalaryTableRelation where FAdjustSalaryRule = '");
        sql.append(submitSchemeId).append("' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                calShemeTableName = rs.getString("FAdjustBaseTableName");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return calShemeTableName;
    }

    public static Map<String, Object> getBillColumnListAndBillEntryTableName(Context ctx, String adjustSalaryRuleId) throws BOSException {
        return AdjustSalaryUtils._getBillColumnListAndBillEntryTableName(ctx, adjustSalaryRuleId, false);
    }

    public static Map<String, Object> _getBillColumnListAndBillEntryTableName(Context ctx, String adjustSalaryRuleId, boolean mappingCmpItem) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        HashMap<String, Integer> dataLength = new HashMap<String, Integer>();
        HashMap<String, Integer> dataDot = new HashMap<String, Integer>();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)adjustSalaryRuleId)) {
            return map;
        }
        String language = ctx.getLocale().getLanguage();
        StringBuilder sql = new StringBuilder();
        sql.append("Select m.fieldSn, m.FDataDot,m.fdataType,m.fname_" + language + " ,n.FBillEntryTableName, n.FAdjustBaseTableName, cmp.fid, m.FDataLength from  T_HR_SCalSubmitScheme e ");
        sql.append(" inner join  T_HR_SBatchAdjustRuleItem t on t.FCalSubmitSchemeID = e.fid ");
        sql.append(" inner join T_HR_AdjustSalaryItem m on  m.fid = t.FAdjustSalaryItemID ");
        sql.append(" inner join T_HR_SAdjSalaryTableRelation n on n.FAdjustSalaryRule = e.fid ");
        sql.append(" left join t_hr_scmpitem cmp on cmp.fid = m.fcmpItemID ");
        sql.append(" where e.fid = ? ");
        sql.append(" and FIsAdjustRuleShow = 1 ");
        if (mappingCmpItem) {
            sql.append(" and m.fcmpItemId is not null ");
        }
        sql.append(" order by FSortCode ");
        try {
            String fBillEntryTableName = "";
            String fAdjustBaseTableName = "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{adjustSalaryRuleId});
            while (rs.next()) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fBillEntryTableName)) {
                    fBillEntryTableName = rs.getString("FBillEntryTableName");
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fAdjustBaseTableName)) {
                    fAdjustBaseTableName = rs.getString("FAdjustBaseTableName");
                }
                colNames.add("S" + rs.getString("fieldSn"));
                colTypes.add(rs.getString("fdataType"));
                mapping.put("S" + rs.getString("fieldSn"), rs.getObject("fid"));
                dataLength.put("S" + rs.getString("fieldSn"), rs.getInt("FDataLength"));
                dataDot.put("S" + rs.getString("fieldSn"), rs.getInt("FDataDot"));
            }
            map.put("fBillEntryTableName", fBillEntryTableName);
            map.put("fAdjustBaseTableName", fAdjustBaseTableName);
            map.put("colNames", colNames);
            map.put("colTypes", colTypes);
            map.put("mapping", mapping);
            map.put("dataLength", dataLength);
            map.put("dataDot", dataDot);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static Map<String, Object> getBillColumnListExcludeCalItem(Context ctx, String adjustSalaryRuleId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        Map<String, Integer> isCalMap = null;
        try {
            isCalMap = AdjustSalaryUtils.initFormulaIsCal(adjustSalaryRuleId, ctx);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)adjustSalaryRuleId)) {
            return map;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("Select m.fieldSn, m.fdataType,n.FBillEntryTableName, n.FAdjustBaseTableName from  T_HR_SCalSubmitScheme e ");
        sql.append(" inner join  T_HR_SBatchAdjustRuleItem t on t.FCalSubmitSchemeID = e.fid ");
        sql.append(" inner join T_HR_AdjustSalaryItem m on  m.fid = t.FAdjustSalaryItemID ");
        sql.append(" inner join T_HR_SAdjSalaryTableRelation n on n.FAdjustSalaryRule = e.fid ");
        sql.append(" where e.fid = '" + adjustSalaryRuleId + "' ");
        sql.append(" and FIsAdjustRuleShow = 1 ");
        sql.append(" order by FSortCode ");
        try {
            String fBillEntryTableName = "";
            String fAdjustBaseTableName = "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String sFieldSn;
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fBillEntryTableName)) {
                    fBillEntryTableName = rs.getString("FBillEntryTableName");
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fAdjustBaseTableName)) {
                    fAdjustBaseTableName = rs.getString("FAdjustBaseTableName");
                }
                if (isCalMap.containsKey(sFieldSn = "S" + rs.getString("fieldSn"))) continue;
                colNames.add(sFieldSn);
                colTypes.add(rs.getString("fdataType"));
            }
            map.put("fBillEntryTableName", fBillEntryTableName);
            map.put("fAdjustBaseTableName", fAdjustBaseTableName);
            map.put("colNames", colNames);
            map.put("colTypes", colTypes);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static Map<String, String> getAdjItem2CmpItem(Context ctx, String adjustSalaryRuleId) throws BOSException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)adjustSalaryRuleId)) {
            return mapping;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select cmp.fid, m.fieldSn from  T_HR_SCalSubmitScheme e ");
        sql.append(" inner join  T_HR_SBatchAdjustRuleItem t on t.FCalSubmitSchemeID = e.fid ");
        sql.append(" inner join T_HR_AdjustSalaryItem m on  m.fid = t.FAdjustSalaryItemID ");
        sql.append(" left join t_hr_scmpitem cmp on cmp.fid = m.fcmpItemID ");
        sql.append(" where e.fid = '" + adjustSalaryRuleId + "' ");
        sql.append(" and FIsAdjustRuleShow = 1 ");
        sql.append(" and m.fcmpItemId is not null ");
        sql.append(" order by FSortCode ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                mapping.put(rs.getString("fid"), "S" + rs.getString("fieldSn"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return mapping;
    }

    public static Map<String, String> getCmpItem2AdjItem(Context ctx, String adjustSalaryRuleId) throws BOSException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        Map<String, String> temp = AdjustSalaryUtils.getAdjItem2CmpItem(ctx, adjustSalaryRuleId);
        for (Map.Entry<String, String> entry : temp.entrySet()) {
            mapping.put(entry.getValue(), entry.getKey());
        }
        return mapping;
    }

    public static Map<String, Object> getAllBillColumnList(Context ctx, String adjustSalaryRuleId) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        String language = ctx.getLocale().getLanguage();
        StringBuilder sql = new StringBuilder();
        sql.append("Select m.fieldSn,m.fdataType,m.fname_" + language + " ,n.FBillEntryTableName, n.FAdjustBaseTableName, cmp.fid from  T_HR_SCalSubmitScheme e ");
        sql.append(" inner join  T_HR_SBatchAdjustRuleItem t on t.FCalSubmitSchemeID = e.fid ");
        sql.append(" inner join T_HR_AdjustSalaryItem m on  m.fid = t.FAdjustSalaryItemID ");
        sql.append(" inner join T_HR_SAdjSalaryTableRelation n on n.FAdjustSalaryRule = e.fid ");
        sql.append(" left join t_hr_scmpitem cmp on cmp.fid = m.fcmpItemID ");
        sql.append(" where e.fid = '" + adjustSalaryRuleId + "' ");
        sql.append(" order by FSortCode ");
        try {
            String fBillEntryTableName = "";
            String fAdjustBaseTableName = "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fBillEntryTableName)) {
                    fBillEntryTableName = rs.getString("FBillEntryTableName");
                }
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)fAdjustBaseTableName)) {
                    fAdjustBaseTableName = rs.getString("FAdjustBaseTableName");
                }
                colNames.add("S" + rs.getString("fieldSn"));
                colTypes.add(rs.getString("fdataType"));
            }
            map.put("fBillEntryTableName", fBillEntryTableName);
            map.put("fAdjustBaseTableName", fAdjustBaseTableName);
            map.put("colNames", colNames);
            map.put("colTypes", colTypes);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static boolean checkAdjustReason(Context ctx, String adjustSalaryRuleId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("Select m.fieldSn from  T_HR_SCalSubmitScheme e ");
        sql.append(" inner join  T_HR_SBatchAdjustRuleItem t on t.FCalSubmitSchemeID = e.fid ");
        sql.append(" inner join T_HR_AdjustSalaryItem m on  m.fid = t.FAdjustSalaryItemID ");
        sql.append(" where e.fid = '" + adjustSalaryRuleId + "' ");
        sql.append(" and m.FieldSn = 10 ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static void updateEntryBillState(Context ctx, String billId, HRBillStateEnum stateEnum) throws BOSException, EASBizException {
        AdjustSalaryApplyInfo info = AdjustSalaryApplyFactory.getLocalInstance((Context)ctx).getAdjustSalaryApplyInfo("where id = '" + billId + "'");
        Map<String, Object> map = AdjustSalaryUtils.getBillColumnListAndBillEntryTableName(ctx, info.getAdjustSalaryRule().getId().toString());
        String billEntryTable = map.get("fBillEntryTableName").toString();
        String str = " UPDATE " + billEntryTable + " SET FBILLSTATE = " + stateEnum.getValue() + " WHERE FBILLID = '" + info.getId().toString() + "' ";
        DbUtil.execute((Context)ctx, (String)str);
    }

    public static void updateEntryBillState(Context ctx, AdjustSalaryApplyInfo info, HRBillStateEnum stateEnum) throws BOSException, EASBizException {
        Map<String, Object> map = AdjustSalaryUtils.getBillColumnListAndBillEntryTableName(ctx, info.getAdjustSalaryRule().getId().toString());
        String billEntryTable = map.get("fBillEntryTableName").toString();
        String str = " UPDATE " + billEntryTable + " SET FBILLSTATE = " + stateEnum.getValue() + " WHERE FBILLID = '" + info.getId().toString() + "' ";
        DbUtil.execute((Context)ctx, (String)str);
    }

    public static String assembleUpdateSql(Context ctx, String billEntryTable, List<String> colNames) {
        StringBuilder updateSql = new StringBuilder(" update  ");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        updateSql.append(billEntryTable);
        updateSql.append(" set FLastUpdateUserID  =  '" + userId + "' , FLastUpdateTime = ? ");
        updateSql.append(" , FEffectDate = ? ,FHrOrgUnitID = ? , FPersonID = ? , FAdminOrgUnitID = ? , FPositionID = ?, FCurrencyID = ?, FDescription_l1 = ?,FDescription_l2 = ?,FDescription_l3 = ?, FLeffectDate = ?");
        updateSql.append(" , FCmpStandardID = ? ,FCmpStdLevelID = ? , FCmpStdPointID = ? , FCmpStdScopeID = ?, FAdjustEmpORelationID = ?, FState = ? ");
        for (String schemeItem : colNames) {
            updateSql.append("," + schemeItem + " = ? ");
        }
        StringBuilder updateval = new StringBuilder(" where fid = ? ");
        updateSql.append((CharSequence)updateval);
        return updateSql.toString();
    }

    public static String assembleUpdateSql(Context ctx, String billEntryTable, List<String> colNames, List<String> customerFields) {
        StringBuilder updateSql = new StringBuilder(" update  ");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        updateSql.append(billEntryTable);
        updateSql.append(" set FLastUpdateUserID  =  '" + userId + "' , FLastUpdateTime = ? ");
        updateSql.append(" , FEffectDate = ? ,FHrOrgUnitID = ? , FPersonID = ? , FAdminOrgUnitID = ? , FPositionID = ?, FCurrencyID = ?, FDescription_l1 = ?,FDescription_l2 = ?,FDescription_l3 = ?, FLeffectDate = ?");
        updateSql.append(" , FCmpStandardID = ? ,FCmpStdLevelID = ? , FCmpStdPointID = ? , FCmpStdScopeID = ?, FAdjustEmpORelationID = ?, FState = ? ");
        for (String field : customerFields) {
            updateSql.append("," + field + " = ? ");
        }
        for (String schemeItem : colNames) {
            updateSql.append("," + schemeItem + " = ? ");
        }
        StringBuilder updateval = new StringBuilder(" where fid = ? ");
        updateSql.append((CharSequence)updateval);
        return updateSql.toString();
    }

    public static List<Map<String, Object>> assembleAdjBaseTableData(Context ctx, String tableName, String fidIn, String billIdIn, List<String> colNames, boolean existAdjReason) throws BOSException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> batchParam = null;
        StringBuilder selectSQL = new StringBuilder();
        selectSQL.append("select FState,FID,FEffectDate,FLeffectDate,fdescription_l1,fdescription_l2,fdescription_l3,FHrOrgUnitID,FAdminOrgUnitID, ");
        selectSQL.append("FAdjustEmpORelationID,FPositionID,FCurrencyID,FBillState,FPersonID, FBillID,FForwarnContent, ");
        selectSQL.append("FCmpStandardID, FCmpStdLevelID, FCmpStdPointID, FCmpStdScopeID ,(SELECT apply.FHrOrgUnitID FROM T_HR_SAdjustSalaryApply apply where apply.fid=FBillID) AS FAdjHrOrgUnitID ");
        if (existAdjReason) {
            selectSQL.append(", S10");
        }
        for (String colName : colNames) {
            selectSQL.append(", ").append(colName);
        }
        selectSQL.append(" from ");
        selectSQL.append(tableName).append(" where 1 = 1 ");
        if (CmpStrUtil.isNotEmpty((String)fidIn)) {
            selectSQL.append(" and fid in (").append(fidIn).append(")");
        }
        if (CmpStrUtil.isNotEmpty((String)billIdIn)) {
            selectSQL.append(" and fbillid in ('").append(billIdIn).append("')");
        }
        IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
        try {
            while (rs.next()) {
                batchParam = new HashMap<String, Object>();
                batchParam.put("FState", rs.getObject("FState"));
                batchParam.put("FID", rs.getObject("FID"));
                batchParam.put("FEffectDate", rs.getObject("FEffectDate"));
                batchParam.put("FLeffectDate", rs.getObject("FLeffectDate"));
                batchParam.put("fdescription_l1", rs.getObject("fdescription_l1"));
                batchParam.put("fdescription_l2", rs.getObject("fdescription_l2"));
                batchParam.put("fdescription_l3", rs.getObject("fdescription_l3"));
                batchParam.put("FHrOrgUnitID", rs.getObject("FHrOrgUnitID"));
                batchParam.put("FAdminOrgUnitID", rs.getObject("FAdminOrgUnitID"));
                batchParam.put("FAdjustEmpORelationID", rs.getObject("FAdjustEmpORelationID"));
                batchParam.put("FPositionID", rs.getObject("FPositionID"));
                batchParam.put("FCurrencyID", rs.getObject("FCurrencyID"));
                batchParam.put("FBillState", rs.getObject("FBillState"));
                batchParam.put("FPersonID", rs.getObject("FPersonID"));
                batchParam.put("FBillID", rs.getObject("FBillID"));
                batchParam.put("FCmpStandardID", rs.getObject("FCmpStandardID"));
                batchParam.put("FCmpStdLevelID", rs.getObject("FCmpStdLevelID"));
                batchParam.put("FCmpStdPointID", rs.getObject("FCmpStdPointID"));
                batchParam.put("FCmpStdScopeID", rs.getObject("FCmpStdScopeID"));
                batchParam.put("FAdjHrOrgUnitID", rs.getObject("FAdjHrOrgUnitID"));
                if (existAdjReason) {
                    batchParam.put("S10", rs.getObject("S10"));
                }
                for (int i = 0; i < colNames.size(); ++i) {
                    batchParam.put(colNames.get(i), rs.getObject(colNames.get(i)));
                }
                list.add(batchParam);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    public static String initCalItemData(Set<Map.Entry<String, Integer>> set) throws BOSException {
        StringBuilder sb = new StringBuilder();
        if (set.size() == 0) {
            return null;
        }
        for (Map.Entry<String, Integer> entry : set) {
            sb.append(entry.getKey()).append(",");
        }
        return sb.toString();
    }

    public static List<BatchAdjustRuleItemDTO> getDynamicAdjustSalaryItemByRuleId(Context ctx, String adjustSalaryRuleId) {
        ArrayList<BatchAdjustRuleItemDTO> batchAdjustRuleItemDTOS = new ArrayList<BatchAdjustRuleItemDTO>();
        StringBuffer sqlBuffer = new StringBuffer();
        String language = ctx.getLocale().getLanguage();
        sqlBuffer.append(" SELECT E.FID AS SCHEMEID, M.FID as ITEMID,  M.FIELDSN,M.FDATATYPE,M.FCmpItemID, M.FNAME_" + language + " AS ITEMNAME,M.FNUMBER ITEMNUM,M.FDATADOT,M.FDATALENGTH,T.FIsAdjustItemRequire ");
        sqlBuffer.append(" FROM  T_HR_SCALSUBMITSCHEME E  ");
        sqlBuffer.append(" INNER JOIN T_HR_SBatchAdjustRuleItem T ON T.FCalSubmitSchemeID = E.FID  ");
        sqlBuffer.append(" INNER JOIN T_HR_AdjustSalaryItem M ON  M.FID = T.FAdjustSalaryItemID WHERE E.FID = '");
        sqlBuffer.append(adjustSalaryRuleId);
        sqlBuffer.append("' and T.FIsAdjustRuleShow = 1 ");
        sqlBuffer.append(" ORDER BY T.FSortCode");
        try {
            Map<String, Integer> isCalMap = AdjustSalaryUtils.initFormulaIsCal(adjustSalaryRuleId, ctx);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            BatchAdjustRuleItemDTO batchAdjustRuleItemDTO = null;
            int isCal = 0;
            while (rs.next()) {
                batchAdjustRuleItemDTO = new BatchAdjustRuleItemDTO();
                batchAdjustRuleItemDTO.setAdjustSalaryRuleId(rs.getString("SCHEMEID"));
                batchAdjustRuleItemDTO.setItemId(rs.getString("ITEMID"));
                batchAdjustRuleItemDTO.setFieldSn(rs.getInt("FIELDSN"));
                batchAdjustRuleItemDTO.setDataType(rs.getString("FDATATYPE"));
                batchAdjustRuleItemDTO.setAdjustSalaryItemName(rs.getString("ITEMNAME"));
                batchAdjustRuleItemDTO.setAdjustSalaryItemNum(rs.getString("ITEMNUM"));
                String fieldSn = "S" + rs.getInt("FIELDSN");
                int n = isCal = isCalMap.get(fieldSn) != null ? isCalMap.get(fieldSn) : 0;
                if (rs.getBoolean("FIsAdjustItemRequire") && isCal == 0) {
                    batchAdjustRuleItemDTO.setIsRequired(1);
                } else {
                    batchAdjustRuleItemDTO.setIsRequired(0);
                }
                batchAdjustRuleItemDTO.setDataDot(rs.getInt("FDATADOT"));
                batchAdjustRuleItemDTO.setDataLength(rs.getInt("FDATALENGTH"));
                batchAdjustRuleItemDTOS.add(batchAdjustRuleItemDTO);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return batchAdjustRuleItemDTOS;
    }

    public static Map<String, FixAdjustSalaryInfo> getLastFixAdjustInfo(Context ctx, String personFilter) {
        HashMap<String, FixAdjustSalaryInfo> cmpStructMap = new HashMap<String, FixAdjustSalaryInfo>();
        String mainField = "";
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT tt.fid id, tt.FCMPITEMID cmpItemId,tt.FPERSONID personId, tt.FeffectDay, tt.FPayHrOrgUnitID payHrOrg ");
        sql.append(" FROM t_hr_sfixadjustsalary tt inner join ");
        sql.append(" (SELECT max(FeffectDay) effdt, FPersonId, FCmpItemId, FPayHrOrgUnitID FROM t_hr_sfixadjustsalary group by  FPersonId, FPayHrOrgUnitID, FCMPITEMID ) t1 ");
        sql.append(" on tt.FeffectDay = t1.effdt and tt.FCmpItemId = t1.FCmpItemId  and tt.FPersonId = t1.FPersonId and (tt.FPayHrOrgUnitID = t1.FPayHrOrgUnitID  or (tt.FPayHrOrgUnitID is null and t1.FPayHrOrgUnitID is null)) ");
        sql.append(" where tt.FPERSONID in (" + personFilter + ") ");
        try {
            IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)sql.toString());
            FixAdjustSalaryInfo info = null;
            while (rs.next()) {
                info = new FixAdjustSalaryInfo();
                info.setId(BOSUuid.read((String)rs.getString("id")));
                info.setEffectDay((Date)rs.getDate("FeffectDay"));
                mainField = rs.getString("payHrOrg") + "_" + rs.getString("personId") + "_" + rs.getString("cmpItemId");
                cmpStructMap.put(mainField, info);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return cmpStructMap;
    }

    public static Map<String, Map<String, Object>> getLastFixAdjustInfoByHrOrg(Context ctx, String personFilter) {
        HashMap<String, String> hrOrgMap = new HashMap<String, String>();
        HashMap<String, String> noHrOrgMap = new HashMap<String, String>();
        HashMap<String, Map<String, Object>> cmpStructMap = new HashMap<String, Map<String, Object>>();
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT tt.fid id, tt.FCMPITEMID cmpItemId,tt.FPERSONID personId, tt.FeffectDay, tt.FPayHrOrgUnitID payHrOrg ");
        sql.append(" FROM t_hr_sfixadjustsalary tt inner join ");
        sql.append(" (SELECT max(FeffectDay) effdt, FPersonId, FCmpItemId, FPayHrOrgUnitID FROM t_hr_sfixadjustsalary group by  FPersonId, FPayHrOrgUnitID, FCMPITEMID ) t1 ");
        sql.append(" on tt.FeffectDay = t1.effdt and tt.FCmpItemId = t1.FCmpItemId  and tt.FPersonId = t1.FPersonId and (tt.FPayHrOrgUnitID = t1.FPayHrOrgUnitID  or (tt.FPayHrOrgUnitID is null and t1.FPayHrOrgUnitID is null)) ");
        sql.append(" where tt.FPERSONID in (" + personFilter + ") ");
        try {
            IRowSet rs = CmpSQLUtil.executeQuery((Context)ctx, (String)sql.toString());
            FixAdjustSalaryInfo info = null;
            while (rs.next()) {
                info = new FixAdjustSalaryInfo();
                info.setId(BOSUuid.read((String)rs.getString("id")));
                String hrOrgId = rs.getString("payHrOrg");
                String mainField = rs.getString("personId") + "_" + rs.getString("cmpItemId");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)hrOrgId)) {
                    noHrOrgMap.put(mainField, hrOrgId);
                    continue;
                }
                hrOrgMap.put(mainField, hrOrgId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        cmpStructMap.put("hrOrgMap", hrOrgMap);
        cmpStructMap.put("noHrOrgMap", noHrOrgMap);
        return cmpStructMap;
    }

    public static Map<String, String> getFloatRateMap(Context ctx) {
        HashMap<String, String> floatRateMap = new HashMap<String, String>();
        CmpStdLevelCollection levels = null;
        try {
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add(new SelectorItemInfo("id"));
            selectorColl.add(new SelectorItemInfo("floatRate"));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setSelector(selectorColl);
            levels = CmpStdLevelFactory.getLocalInstance(ctx).getCmpStdLevelCollection(entityViewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        for (int i = 0; levels != null && i < levels.size(); ++i) {
            CmpStdLevelInfo level = levels.get(i);
            if (!CmpStrUtil.isNotEmpty((String)level.getFloatRate())) continue;
            floatRateMap.put(level.getId().toString(), level.getFloatRate());
        }
        return floatRateMap;
    }

    public static void checkHRBillIsEdit(Context ctx, String billId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)billId)) {
            AdjustSalaryApplyCollection applyInfoC = AdjustSalaryApplyFactory.getLocalInstance((Context)ctx).getAdjustSalaryApplyCollection("select id,billState where id = '" + billId + "'");
            AdjustSalaryApplyInfo applyInfo = applyInfoC.isEmpty() ? null : applyInfoC.get(0);
            HRBillStateEnum oldBillState = applyInfoC.isEmpty() ? null : applyInfoC.get(0).getBillState();
            HRWorkFlowCheckUtil.checkHRBillIsEdit((Context)ctx, (HRBillBaseInfo)applyInfo, (HRBillStateEnum)oldBillState);
        }
    }

    public static List<Object> getRequiredAdjustItem(Context ctx, String adjustSalaryRuleId) {
        ArrayList<Object> objectList = new ArrayList<Object>();
        ArrayList<String> colNames = new ArrayList<String>();
        HashMap<String, String> dataTypeMap = new HashMap<String, String>();
        HashMap<String, String> field2Name = new HashMap<String, String>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT M.FIELDSN,M.FDataType,T.FIsAdjustItemRequire, M.FName_" + ctx.getLocale().getLanguage() + " name ");
        sqlBuffer.append(" FROM  T_HR_SCALSUBMITSCHEME E  ");
        sqlBuffer.append(" INNER JOIN T_HR_SBatchAdjustRuleItem T ON T.FCalSubmitSchemeID = E.FID  ");
        sqlBuffer.append(" INNER JOIN T_HR_AdjustSalaryItem M ON  M.FID = T.FAdjustSalaryItemID WHERE E.FID = '");
        sqlBuffer.append(adjustSalaryRuleId);
        sqlBuffer.append("' and T.FIsAdjustRuleShow = 1 ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            while (rs.next()) {
                String fieldSn = "S" + rs.getInt("FIELDSN");
                if (!rs.getBoolean("FIsAdjustItemRequire")) continue;
                colNames.add(fieldSn);
                field2Name.put(fieldSn, rs.getString("name"));
                dataTypeMap.put(fieldSn, rs.getString("FDataType"));
            }
            objectList.add(colNames);
            objectList.add(field2Name);
            objectList.add(dataTypeMap);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return objectList;
    }
}

