/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2.notice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.baseconfig.StructureConfigColumnsInfo;
import com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemCollection;
import com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemFactory;
import com.kingdee.shr.cmpdesign.app.v2.BatchAdjustRuleItemInfo;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemInfo;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.AbstractAdjustSalaryNoticeEntryFacadeControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjSalaryNoticeConfirmType;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjSalaryNoticeSendingState;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryCollection;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryFacadeFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeException;
import com.kingdee.shr.cmpdesign.app.v2.notice.ConfirmStateEnum;
import com.kingdee.shr.cmpdesign.app.v2.notice.IAdjustSalaryNoticeEntry;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeParamInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateCFieldCollection;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateCFieldFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateCFieldInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateFieldCollection;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateFieldFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateFieldInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.TemplateFontCollection;
import com.kingdee.shr.cmpdesign.app.v2.notice.TemplateFontFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.TemplateFontInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.TimeUnitEnum;
import com.kingdee.shr.cmpdesign.service.SeriesNumService;
import com.kingdee.shr.cmpdesign.util.AdjustSalaryUtils;
import com.kingdee.shr.cmpdesign.v2.notice.util.NoticeDaoUtils;
import com.kingdee.shr.cmpdesign.v2.notice.util.TemplateResult;
import com.kingdee.shr.compensation.FixAdjustSalaryInfo;
import com.kingdee.shr.compensation.app.config.CloudHubMessageConfigInfo;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateHISCollection;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateHISFactory;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateHISInfo;
import com.kingdee.shr.compensation.taxCal.util.TaxCalcFileUtils;
import com.kingdee.shr.compensation.util.AdjustSalaryNoticeTemplateUtils;
import com.kingdee.shr.compensation.util.Base64Utils;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.NewMailUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.pdf.Html2PdfConverter;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class AdjustSalaryNoticeEntryFacadeControllerBean
extends AbstractAdjustSalaryNoticeEntryFacadeControllerBean {
    private static final Logger LOG = Logger.getLogger(AdjustSalaryNoticeEntryFacadeControllerBean.class);
    protected Timestamp now = new Timestamp(System.currentTimeMillis());
    private final Map<String, String> enumMap = new HashMap<String, String>();
    private final Map<String, String> dateFormatMap = new HashMap<String, String>();
    private final Map<String, String> dynamicColumns = new HashMap<String, String>();
    private final Pattern fieldPattern = Pattern.compile("#(.+?)#");
    public static volatile Map<String, Long> templateThread = new Hashtable<String, Long>();
    protected NoticeTemplateCFieldCollection yearFields;

    @Override
    protected List _sendNotice(Context ctx, Map param, AdjustSalaryNoticeEntryCollection noticeEntries, CloudHubMessageConfigInfo adjSalaryNoticeConf) throws BOSException, EASBizException {
        List<AdjustSalaryNoticeEntryInfo> entries;
        ArrayList list = Lists.newArrayList();
        NoticeParamInfo paramInfo = NoticeDaoUtils.getNoticeParamInfo(ctx);
        ConfirmStateEnum confirmState = paramInfo.isConfirmAuth() ? ConfirmStateEnum.UNCONFIRMED : null;
        ArrayList<String> persons = new ArrayList<String>();
        for (int i = 0; i < noticeEntries.size(); ++i) {
            persons.add(noticeEntries.get(i).getPerson().getId().toString());
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String personRange = cmpInSql.createInSqlBaseOnFId(ctx, persons);
        String userOql = "select id, email, person.id where person.id in " + personRange;
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(userOql);
        Map<String, List<AdjustSalaryNoticeEntryInfo>> groups = this.groupByTemplate(noticeEntries);
        HashMap<String, String> entry2User = new HashMap<String, String>();
        for (Map.Entry<String, List<AdjustSalaryNoticeEntryInfo>> group : groups.entrySet()) {
            entries = group.getValue();
            UserCollection users = new UserCollection();
            for (AdjustSalaryNoticeEntryInfo entry : entries) {
                String personId = entry.getPerson().getId().toString();
                UserInfo user = this.filterByPerson(personId, userCollection);
                if (null == user) continue;
                users.add(user);
                entry2User.put(entry.getId().toString(), user.getId().toString());
            }
            String content = entries.get(0).getTemplate().getHistoryRelate().getSendContent();
            if (!entries.get(0).getTemplate().getHistoryRelate().isSendEmail() || users.isEmpty()) continue;
            this.sendEmail(ctx, users, content);
        }
        for (Map.Entry<String, List<AdjustSalaryNoticeEntryInfo>> group : groups.entrySet()) {
            entries = group.getValue();
            TemplateResult templateResult = new TemplateResult();
            HashSet sendedList = Sets.newHashSet();
            HashSet failedList = Sets.newHashSet();
            list.add(templateResult);
            try {
                ArrayList entryIds = Lists.newArrayList();
                UserCollection users = new UserCollection();
                Iterator<AdjustSalaryNoticeEntryInfo> iterator = entries.iterator();
                while (iterator.hasNext()) {
                    AdjustSalaryNoticeEntryInfo entry = iterator.next();
                    entryIds.add(entry.getId().toString());
                    entry.setConfirmState(confirmState);
                    String personId = entry.getPerson().getId().toString();
                    UserInfo user = this.filterByPerson(personId, userCollection);
                    if (null != user) {
                        users.add(user);
                        continue;
                    }
                    iterator.remove();
                    failedList.add(entry);
                }
                templateResult.setEntryIds(entryIds);
                if (entries.isEmpty()) {
                    LOG.error((Object)"send notice\uff0cusers is empty...");
                    templateResult.setFailedEntryIds(entryIds);
                    this.updateSendAndConfirmStatus(ctx, sendedList, failedList);
                    continue;
                }
                String content = entries.get(0).getTemplate().getHistoryRelate().getSendContent();
                String url = adjSalaryNoticeConf.getUrl();
                url = MessageFormat.format(url, adjSalaryNoticeConf.getAppId(), adjSalaryNoticeConf.getEid());
                HttpResultVo result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextLinkMessageToUser(content, adjSalaryNoticeConf.getAppId(), url, users, adjSalaryNoticeConf.getPubaccName(), adjSalaryNoticeConf.isIsPrivate());
                LOG.info((Object)("send notice, result: " + JSON.toJSONString((Object)result)));
                templateResult.setResult(true);
                List noOpenIdUsers = result.getNoOpenIdUsers();
                if (noOpenIdUsers != null && !noOpenIdUsers.isEmpty()) {
                    this.addFailureEntries(noOpenIdUsers, templateResult, entry2User);
                    this.recordSuccessAndFailure(entries, templateResult, sendedList, failedList);
                } else {
                    sendedList.addAll(entries);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"genPdfAndSendMessage error: ", (Throwable)e);
                templateResult.setResult(false);
                templateResult.setFailedEntryIds(templateResult.getEntryIds());
                templateResult.setMsg(e.getMessage());
            }
            this.updateSendAndConfirmStatus(ctx, sendedList, failedList);
        }
        return list;
    }

    private void recordSuccessAndFailure(List<AdjustSalaryNoticeEntryInfo> entries, TemplateResult templateResult, Set<AdjustSalaryNoticeEntryInfo> sendedList, Set<AdjustSalaryNoticeEntryInfo> failedList) {
        for (AdjustSalaryNoticeEntryInfo entryInfo : entries) {
            if (templateResult.getFailedEntryIds().contains(entryInfo.getId().toString())) {
                failedList.add(entryInfo);
                continue;
            }
            if (failedList.contains(entryInfo)) continue;
            sendedList.add(entryInfo);
        }
    }

    private void addFailureEntries(List<String> noOpenIdUsers, TemplateResult templateResult, Map<String, String> entry2User) {
        for (Map.Entry<String, String> entry : entry2User.entrySet()) {
            if (!noOpenIdUsers.contains(entry.getValue())) continue;
            templateResult.getFailedEntryIds().add(entry.getKey());
        }
    }

    private UserInfo filterByPerson(String personId, UserCollection userCollection) {
        for (int i = 0; i < userCollection.size(); ++i) {
            if (!userCollection.get(i).getPerson().getId().toString().equalsIgnoreCase(personId)) continue;
            return userCollection.get(i);
        }
        return null;
    }

    @Override
    protected List _remind(Context ctx, Map otherParams, AdjustSalaryNoticeEntryCollection noticeEntries, CloudHubMessageConfigInfo noticeConfig) throws BOSException, EASBizException {
        List<AdjustSalaryNoticeEntryInfo> entries;
        ArrayList list = Lists.newArrayList();
        Map<String, List<AdjustSalaryNoticeEntryInfo>> groups = this.groupByTemplate(noticeEntries);
        HashSet<String> persons = new HashSet<String>();
        for (int i = 0; i < noticeEntries.size(); ++i) {
            persons.add(noticeEntries.get(i).getPerson().getId().toString());
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String personRange = cmpInSql.createInSqlBaseOnFId(ctx, persons);
        String userOql = "select id, email, person.id where person.id in " + personRange;
        UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(userOql);
        HashMap<String, String> entry2User = new HashMap<String, String>();
        for (Map.Entry<String, List<AdjustSalaryNoticeEntryInfo>> group : groups.entrySet()) {
            entries = group.getValue();
            String content = entries.get(0).getTemplate().getHistoryRelate().getConfirmContent();
            UserCollection users = new UserCollection();
            for (AdjustSalaryNoticeEntryInfo adjustSalaryNoticeEntryInfo : entries) {
                String personId = adjustSalaryNoticeEntryInfo.getPerson().getId().toString();
                UserInfo user = this.filterByPerson(personId, userCollection);
                if (null == user) continue;
                users.add(user);
                entry2User.put(adjustSalaryNoticeEntryInfo.getId().toString(), user.getId().toString());
            }
            if (!entries.get(0).getTemplate().getHistoryRelate().isConfirmEmail() || StringUtils.isEmpty((String)content)) continue;
            this.sendEmail(ctx, users, content);
        }
        for (Map.Entry<String, List<AdjustSalaryNoticeEntryInfo>> group : groups.entrySet()) {
            entries = group.getValue();
            TemplateResult templateResult = new TemplateResult();
            list.add(templateResult);
            ArrayList entryIds = Lists.newArrayList();
            UserCollection users = new UserCollection();
            for (AdjustSalaryNoticeEntryInfo entry : entries) {
                entryIds.add(entry.getId().toString());
                String personId = entry.getPerson().getId().toString();
                UserInfo user = this.filterByPerson(personId, userCollection);
                users.add(user);
            }
            templateResult.setEntryIds(entryIds);
            String string = entries.get(0).getTemplate().getHistoryRelate().getConfirmContent();
            if (StringUtils.isEmpty((String)string)) {
                String errMsg = EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"28");
                templateResult.setMsg(errMsg);
                templateResult.setResult(false);
                break;
            }
            String url = noticeConfig.getUrl();
            url = MessageFormat.format(url, noticeConfig.getAppId(), noticeConfig.getEid());
            HttpResultVo result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextLinkMessageToUser(string, noticeConfig.getAppId(), url, users, noticeConfig.getPubaccName(), noticeConfig.isIsPrivate());
            if (result.getStatus() != 200) {
                Object data = result.getData();
                LOG.error((Object)("send notice failed, status = " + result.getStatus() + ", data: " + data));
                String label = "03";
                String errMsg = EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)label) + result.getStatus();
                templateResult.setMsg(errMsg);
                templateResult.setResult(false);
                continue;
            }
            String sucMsg = EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"05");
            templateResult.setMsg(sucMsg);
            templateResult.setResult(true);
            List noOpenIdUsers = result.getNoOpenIdUsers();
            if (noOpenIdUsers == null || noOpenIdUsers.isEmpty()) continue;
            this.addFailureEntries(noOpenIdUsers, templateResult, entry2User);
        }
        return list;
    }

    private Map<String, List<AdjustSalaryNoticeEntryInfo>> groupByTemplate(AdjustSalaryNoticeEntryCollection noticeEntries) {
        HashMap groups = Maps.newHashMap();
        for (int i = 0; i < noticeEntries.size(); ++i) {
            AdjustSalaryNoticeEntryInfo entry = noticeEntries.get(i);
            AdjustSalaryNoticeTemplateHISInfo template = entry.getTemplate();
            String key = template.getId().toString();
            List list = groups.computeIfAbsent(key, k -> new ArrayList());
            list.add(entry);
        }
        return groups;
    }

    private Map<String, List<AdjustSalaryNoticeEntryInfo>> groupByScheme(List<AdjustSalaryNoticeEntryInfo> noticeEntries) {
        HashMap groups = Maps.newHashMap();
        for (AdjustSalaryNoticeEntryInfo entry : noticeEntries) {
            String scheme = entry.getNoticeBill().getAdjBill().getAdjustSalaryRule().getId().toString();
            List list = groups.computeIfAbsent(scheme, k -> new ArrayList());
            list.add(entry);
        }
        return groups;
    }

    private void updateSendAndConfirmStatus(Context ctx, Set<AdjustSalaryNoticeEntryInfo> sendedList, Set<AdjustSalaryNoticeEntryInfo> failedList) throws BOSException, EASBizException {
        AdjustSalaryNoticeEntryCollection collection = new AdjustSalaryNoticeEntryCollection();
        for (AdjustSalaryNoticeEntryInfo entry : sendedList) {
            AdjSalaryNoticeSendingState sendingState = entry.getSendState();
            sendingState = sendingState == AdjSalaryNoticeSendingState.CANCELLED ? AdjSalaryNoticeSendingState.RESENDED : AdjSalaryNoticeSendingState.SENDED;
            entry.setSendState(sendingState);
            entry.setSendTime(this.now);
            entry.setResetTime(null);
            collection.add(entry);
        }
        for (AdjustSalaryNoticeEntryInfo entry : failedList) {
            entry.setSendState(AdjSalaryNoticeSendingState.FAIlED);
            collection.add(entry);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("sendState");
        selector.add("sendTime");
        selector.add("resetTime");
        AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)collection, selector);
    }

    protected void sendEmail(Context ctx, UserCollection users, String content) throws EASBizException {
        try {
            StringBuilder to = new StringBuilder();
            for (int i = 0; i < users.size(); ++i) {
                String email = users.get(i).getEmail();
                if (StringUtils.isEmpty((String)email)) continue;
                if (to.length() > 0) {
                    to.append(",");
                }
                to.append(email);
            }
            if (StringUtils.isEmpty((String)to.toString())) {
                return;
            }
            NewMailUtil.getInstance().sendHtmlMail(null, to.toString(), content, content);
        }
        catch (Exception e) {
            LOG.error((Object)"send email failed, caused by:", (Throwable)e);
            String errMsg = EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"24");
            throw new EASBizException(new NumericExceptionSubItem("00", errMsg));
        }
    }

    @Override
    protected Map _confirm(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String entryId = (String)param.get("entryId");
        String personId = (String)param.get("personId");
        AdjustSalaryNoticeEntryInfo entryInfo = this.getAdjustSalaryNoticeEntryInfo(ctx, entryId, personId);
        NoticeParamInfo paramInfo = NoticeDaoUtils.getNoticeParamInfo(ctx);
        ConfirmStateEnum confirmState = (ConfirmStateEnum)((Object)param.get("confirmState"));
        entryInfo.setConfirmType(AdjSalaryNoticeConfirmType.MANUAL);
        if (confirmState == ConfirmStateEnum.GIVEN_UP) {
            if (!paramInfo.isAllowGivingUp()) {
                throw new AdjustSalaryNoticeException(AdjustSalaryNoticeException.EXCEPTION7);
            }
            this.updateConfirmedAdjustSalaryNoticeEntry(ctx, entryInfo, ConfirmStateEnum.GIVEN_UP);
            entryInfo.setConfirmState(ConfirmStateEnum.GIVEN_UP);
            result.put("state", NoticeDaoUtils.getOsfConfirmStatus(entryInfo, paramInfo));
            return result;
        }
        AdjustSalaryNoticeTemplateHISInfo template = entryInfo.getTemplate();
        if (null == template || StringUtils.isEmpty((String)template.getHtmlContent())) {
            throw new BOSException("Notice template is empty");
        }
        String htmlContent = entryInfo.getHtmlContent();
        String pdfFilePath = this.getPdfFilePath();
        HashMap<String, byte[]> signature = null;
        String oql = "select name, number, description where type =4";
        NoticeTemplateCFieldCollection signatureFields = NoticeTemplateCFieldFactory.getLocalInstance(ctx).getNoticeTemplateCFieldCollection(oql);
        String base64Sig = (String)param.get("signature");
        NoticeTemplateCFieldInfo sigField = this.filterByNumber("signature", signatureFields);
        String signatureField = sigField.getName();
        signatureField = "##" + signatureField + "##";
        boolean signAuth = paramInfo.isSignAuth();
        String imgTag = "";
        if (signAuth) {
            if (StringUtils.isEmpty((String)base64Sig)) {
                throw new AdjustSalaryNoticeException(AdjustSalaryNoticeException.EXCEPTION6);
            }
            signature = new HashMap<String, byte[]>();
            byte[] byteBase64 = Base64Utils.decode((String)base64Sig, (String)"UTF-8");
            signature.put(signatureField, byteBase64);
            AttachmentInfo attachment = new AttachmentInfo();
            String id = this.initSignatureAttachment(byteBase64, attachment);
            AttachmentFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)attachment);
            entryInfo.setSignatureAttachment(id);
            imgTag = "<img id=\"signature\" src=\"data:image/jpeg;base64," + base64Sig + "\" style=\"width:100px;\"";
        }
        NoticeTemplateCFieldInfo signingDayField = this.filterByNumber("Signing_Day", signatureFields);
        String signingDay = "##" + signingDayField.getName() + "##";
        htmlContent = this.fillSigningDayInTemplate(htmlContent, signingDay, signingDayField.getDescription());
        entryInfo.setConfirmType(AdjSalaryNoticeConfirmType.MANUAL);
        entryInfo.setConfirmState(ConfirmStateEnum.CONFIRMED);
        result.put("state", NoticeDaoUtils.getOsfConfirmStatus(entryInfo, paramInfo));
        File file = new File(pdfFilePath);
        try {
            Html2PdfConverter converter = this.getHtml2PdfConverter(ctx);
            this.loadCustomFonts(ctx, converter);
            converter.generatePdfFile(htmlContent, file, signature);
            AttachmentInfo attachment = new AttachmentInfo();
            String id = this.initPDFAttachment(file, attachment);
            AttachmentFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)attachment);
            entryInfo.setPdfAttatchment(id);
            htmlContent = htmlContent.replace(signatureField, imgTag);
            entryInfo.setHtmlContent(htmlContent);
            this.updateConfirmedAdjustSalaryNoticeEntry(ctx, entryInfo, entryInfo.getConfirmState());
            this.makeAdjustSalaryEffective(ctx, entryInfo);
            result.put("htmlContent", htmlContent);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (IOException | SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
    }

    protected void makeAdjustSalaryEffective(Context ctx, AdjustSalaryNoticeEntryInfo entryInfo) throws BOSException, EASBizException, SQLException {
        if (entryInfo.getNoticeBill() == null || entryInfo.getNoticeBill().getAdjBill() == null || entryInfo.getNoticeBill().getAdjBill().getHrOrgUnit() == null) {
            return;
        }
        boolean secondaryConfirm = HRParamUtil.getParamOfHR((Context)ctx, (String)"shr_adj_003", (String)entryInfo.getNoticeBill().getAdjBill().getHrOrgUnit().getId().toString());
        if (secondaryConfirm) {
            return;
        }
        String submitSchemeId = entryInfo.getNoticeBill().getAdjBill().getAdjustSalaryRule().getId().toString();
        String calSchemeTableName = AdjustSalaryUtils.getCalShemeTableName(ctx, submitSchemeId);
        String personFilter = "'" + entryInfo.getPerson().getId().toString() + "'";
        Map<String, FixAdjustSalaryInfo> map = AdjustSalaryUtils.getLastFixAdjustInfo(ctx, personFilter);
        Map<String, Map<String, Object>> cmpStructMap = AdjustSalaryUtils.getLastFixAdjustInfoByHrOrg(ctx, personFilter);
        Map<String, Object> hrOrgMap = cmpStructMap.get("hrOrgMap");
        Map<String, Object> noHrOrgMap = cmpStructMap.get("noHrOrgMap");
        String adjustSalaryEntryId = entryInfo.getAdjEntry().getId().toString();
        String str = " SELECT AA.*, adjItem.FCmpItemId  FROM " + calSchemeTableName + " AA left join T_HR_SAdjustSalaryApply s on s.fid = AA.Fbillid  left join t_hr_sCalSubmitScheme cal on cal.fid = s.FAdjustSalaryRuleID  left join T_HR_SBatchAdjustRuleItem rul on rul.FCalSubmitSchemeID = cal.fid  left join T_HR_AdjustSalaryItem adjItem on adjItem.fid = rul.FAdjustSalaryItemID  left join t_hr_sCmpItem item on item.fid = adjItem.FCmpItemID  WHERE AA.Fid = '" + adjustSalaryEntryId + "'";
        String adjItemOql = "select adjustSalaryItem.cmpItem.id, adjustSalaryItem.fieldSn where calSubmitScheme.id = '" + submitSchemeId + "'";
        BatchAdjustRuleItemCollection items = BatchAdjustRuleItemFactory.getLocalInstance(ctx).getBatchAdjustRuleItemCollection(adjItemOql);
        HashMap cmpItem2AdjItemField = Maps.newHashMap();
        for (int i = 0; i < items.size(); ++i) {
            BatchAdjustRuleItemInfo info = items.get(i);
            String fieldName = "S" + info.getAdjustSalaryItem().getFieldSn();
            if (null == info.getAdjustSalaryItem().getCmpItem() || null == info.getAdjustSalaryItem().getCmpItem().getId()) continue;
            cmpItem2AdjItemField.put(info.getAdjustSalaryItem().getCmpItem().getId().toString(), fieldName);
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        while (rowSet.next()) {
            String errMsg;
            String fieldName;
            Object fieldValue;
            String hrOrgId = rowSet.getString("FHrOrgUnitID");
            String cmpItemId = rowSet.getString("FCmpItemId");
            if (cmpItem2AdjItemField.containsKey(cmpItemId) && null == (fieldValue = rowSet.getObject(fieldName = (String)cmpItem2AdjItemField.get(cmpItemId)))) continue;
            String key = hrOrgId + "_" + rowSet.getString("FPersonId") + "_" + cmpItemId;
            java.sql.Date effdt = rowSet.getDate("FEffectDate");
            int entryState = rowSet.getInt("FState");
            if (entryState == 1) {
                errMsg = EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"26");
                throw new EASBizException(new NumericExceptionSubItem("00", errMsg));
            }
            if (map.containsKey(key) && map.get(key).getEffectDay().compareTo(effdt) >= 0) {
                errMsg = EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)"27");
                throw new EASBizException(new NumericExceptionSubItem("00", errMsg));
            }
            String hrOrgKey = rowSet.getString("FPersonId") + "_" + rowSet.getString("FCmpItemId");
            if (StringUtils.isEmpty((String)hrOrgId) && hrOrgMap.containsKey(hrOrgKey)) {
                String msg = NoticeDaoUtils.getMultiLan(ctx, "label53");
                throw new EASBizException(new NumericExceptionSubItem("00", msg));
            }
            if (StringUtils.isEmpty((String)hrOrgId) || !noHrOrgMap.containsKey(hrOrgKey)) continue;
            String msg = NoticeDaoUtils.getMultiLan(ctx, "label54");
            throw new EASBizException(new NumericExceptionSubItem("00", msg));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fids", "'" + adjustSalaryEntryId + "'");
        params.put("calShemeTableName", calSchemeTableName);
        params.put("adjustSalaryRuleId", submitSchemeId);
        AdjustSalaryApplyFactory.getLocalInstance(ctx).validationEntry(params);
    }

    protected String fillSigningDayInTemplate(String htmlContent, String signingDayField, String dateFormat) {
        String date = new SimpleDateFormat(dateFormat).format(new Date());
        return htmlContent.replace(signingDayField, date);
    }

    private NoticeTemplateCFieldInfo filterByNumber(String number, NoticeTemplateCFieldCollection signatureFields) {
        for (int i = 0; i < signatureFields.size(); ++i) {
            if (!number.equals(signatureFields.get(i).getNumber())) continue;
            return signatureFields.get(i);
        }
        return signatureFields.get(0);
    }

    @Override
    protected Map _fillTemplate(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        String entryId = (String)param.get("entryId");
        AdjustSalaryNoticeEntryInfo entryInfo = this.getAdjustSalaryNoticeEntryInfo(ctx, entryId, null);
        AdjustSalaryNoticeTemplateHISInfo template = entryInfo.getTemplate();
        if (null == template || StringUtils.isEmpty((String)template.getHtmlContent())) {
            throw new BOSException("Notice template is empty");
        }
        String templateId = template.getId().toString();
        String sql = this.getQuerySQL(ctx, entryInfo, templateId);
        String htmlContent = template.getHtmlContent();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        List<Map<String, Object>> dataList = this.getFieldValues(rs);
        Map<String, Object> columnValues = dataList.get(0);
        htmlContent = this.fillTemplate(ctx, htmlContent, columnValues);
        entryInfo.setHtmlContent(htmlContent);
        String title = this.fillTitle(ctx, template.getBosTitle(), columnValues);
        entryInfo.setNoticeTitle(title);
        result.put("htmlContent", htmlContent);
        this.updateHtmlContent(ctx, entryInfo);
        return result;
    }

    @Override
    protected Map _generateOne(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String entryId = (String)param.get("entryId");
        AdjustSalaryNoticeEntryInfo entryInfo = this.getAdjustSalaryNoticeEntryInfo(ctx, entryId, null);
        AdjustSalaryNoticeTemplateHISInfo template = entryInfo.getTemplate();
        if (null == template || StringUtils.isEmpty((String)template.getHtmlContent())) {
            throw new BOSException("Notice template is empty");
        }
        String templateId = template.getId().toString();
        String sql = this.getQuerySQL(ctx, entryInfo, templateId);
        String htmlContent = template.getHtmlContent();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        List<Map<String, Object>> dataList = this.getFieldValues(rs);
        Map<String, Object> columnValues = dataList.get(0);
        htmlContent = this.fillTemplate(ctx, htmlContent, columnValues);
        String title = this.fillTitle(ctx, template.getBosTitle(), columnValues);
        entryInfo.setNoticeTitle(title);
        String pdfFilePath = this.getPdfFilePath();
        File file = new File(pdfFilePath);
        try {
            Html2PdfConverter converter = this.getHtml2PdfConverter(ctx);
            this.loadCustomFonts(ctx, converter);
            converter.generatePdfFile(htmlContent, file, null);
            AttachmentInfo attachment = new AttachmentInfo();
            String id = this.initPDFAttachment(file, attachment);
            AttachmentFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)attachment);
            entryInfo.setPdfAttatchment(id);
            entryInfo.setHtmlContent(htmlContent);
            this.updateAttachment(ctx, entryInfo);
            result.put("attachmentId", entryInfo.getPdfAttatchment());
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            result.put("file", bytes);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
    }

    protected String initSignatureAttachment(byte[] byteBase64, AttachmentInfo attachment) {
        attachment.setIsShared(false);
        attachment.setSharedDesc("No");
        attachment.setName("signature");
        attachment.setFile(byteBase64);
        attachment.setSizeInByte(byteBase64.length);
        attachment.setAttachID(String.valueOf(System.currentTimeMillis()));
        attachment.setSimpleName("png");
        BOSUuid id = BOSUuid.create((BOSObjectType)attachment.getBOSType());
        attachment.setId(id);
        return id.toString();
    }

    protected String initPDFAttachment(File file, AttachmentInfo attachment) {
        attachment.setIsShared(false);
        attachment.setSharedDesc("No");
        attachment.setName("mainName");
        byte[] bytes = TaxCalcFileUtils.file2ByteArray((File)file);
        attachment.setFile(bytes);
        attachment.setSizeInByte(bytes.length);
        attachment.setAttachID(String.valueOf(System.currentTimeMillis()));
        attachment.setSimpleName("pdf");
        BOSUuid id = BOSUuid.create((BOSObjectType)attachment.getBOSType());
        attachment.setId(id);
        return id.toString();
    }

    protected String getPdfFilePath() {
        boolean b;
        String parentPath = "/tmp/";
        File parent = new File(parentPath);
        if (!parent.exists() && (b = parent.mkdirs())) {
            LOG.info((Object)("make dir: " + parentPath));
        }
        return parentPath + TaxCalcFileUtils.getUUID() + ".pdf";
    }

    protected void updateConfirmedAdjustSalaryNoticeEntry(Context ctx, AdjustSalaryNoticeEntryInfo entryInfo, ConfirmStateEnum stateEnum) throws BOSException, EASBizException {
        this.now = stateEnum == ConfirmStateEnum.EXPIRED ? null : new Timestamp(System.currentTimeMillis());
        entryInfo.setConfirmTime(this.now);
        entryInfo.setConfirmState(stateEnum);
        entryInfo.setConfirmType(entryInfo.getConfirmType());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("confirmState");
        selector.add("confirmTime");
        selector.add("confirmType");
        selector.add("signatureAttachment");
        selector.add("pdfAttatchment");
        selector.add("htmlContent");
        AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).updatePartial(entryInfo, selector);
    }

    protected void updateAttachment(Context ctx, AdjustSalaryNoticeEntryInfo entryInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("pdfAttatchment");
        selector.add("htmlContent");
        AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).updatePartial(entryInfo, selector);
    }

    protected void updateHtmlContent(Context ctx, AdjustSalaryNoticeEntryInfo entryInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("htmlContent");
        selector.add("noticeTitle");
        AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).updatePartial(entryInfo, selector);
    }

    protected String fillTitle(Context ctx, String title, Map<String, Object> columnValues) throws BOSException {
        title = this.replaceYearInfo(ctx, title);
        for (Map.Entry<String, Object> entry : columnValues.entrySet()) {
            String column = entry.getKey();
            Object columnValue = entry.getValue();
            String value = columnValue.toString();
            String id = this.getFieldId(column);
            String columnName = this.concatTemplateField(id);
            title = title.replace(columnName, value);
        }
        Matcher matcher = this.fieldPattern.matcher(title);
        while (matcher.find()) {
            String field = matcher.group();
            title = title.replace(field, "");
        }
        return title;
    }

    protected String fillTemplate(Context ctx, String htmlContent, Map<String, Object> columnValues) throws BOSException, EASBizException {
        htmlContent = this.replaceYearInfo(ctx, htmlContent);
        for (Map.Entry<String, Object> entry : columnValues.entrySet()) {
            String value;
            String column = entry.getKey();
            Object columnValue = entry.getValue();
            String id = this.getFieldId(column);
            String enumSource = this.enumMap.get(column);
            if (null == columnValue) {
                value = "";
            } else if (columnValue instanceof BigDecimal) {
                value = ((BigDecimal)columnValue).setScale(2, RoundingMode.HALF_UP).toPlainString();
            } else if (columnValue instanceof Date) {
                String defaultDateFormat = "yyyy-MM-dd";
                if (this.dateFormatMap.containsKey(id)) {
                    defaultDateFormat = this.dateFormatMap.get(id);
                }
                value = new SimpleDateFormat(defaultDateFormat).format((Date)columnValue);
            } else {
                value = null != enumSource ? this.convertEnumValue2Alias(columnValue, enumSource) : columnValue.toString();
            }
            if (null == id) continue;
            if (this.dateFormatMap.containsKey(id)) {
                id = id + "," + this.dateFormatMap.get(id);
            }
            String columnName = this.concatTemplateField(id);
            htmlContent = htmlContent.replace(columnName, value);
        }
        ArrayList<String> dynamicAreaList = new ArrayList<String>();
        Matcher matcher = AdjustSalaryNoticeTemplateUtils.DYNAMIC_PATTERN.matcher(htmlContent);
        try {
            while (matcher.find()) {
                String dynamicArea = matcher.group();
                dynamicArea = dynamicArea.substring(dynamicArea.indexOf("{"));
                htmlContent = this.clearEmptyAdjustItemParagraph(htmlContent, dynamicArea, dynamicAreaList);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"resolving DYNAMIC_PATTERN error: ", (Throwable)e);
        }
        htmlContent = this.fillUsedFieldsWithWhiteSpace(htmlContent);
        return this.setSeries(ctx, htmlContent, dynamicAreaList);
    }

    protected String convertEnumValue2Alias(Object columnValue, String enumSource) {
        try {
            if (columnValue instanceof Integer) {
                int val = (Integer)columnValue;
                Class<?> clazz = Class.forName(enumSource.trim());
                Method method = clazz.getMethod("getEnum", Integer.TYPE);
                IntEnum intEnum = (IntEnum)method.invoke(null, val);
                return intEnum.getAlias();
            }
            String val = (String)columnValue;
            Class<?> clazz = Class.forName(enumSource.trim());
            Method method = clazz.getMethod("getEnum", String.class);
            StringEnum strEnum = (StringEnum)method.invoke(null, val);
            return strEnum.getAlias();
        }
        catch (Exception e) {
            LOG.error((Object)"convertEnumValue2Alias error: ", (Throwable)e);
            return "-";
        }
    }

    private String fillUsedFieldsWithWhiteSpace(String htmlContent) {
        Matcher fieldMatcher = this.fieldPattern.matcher(htmlContent);
        while (fieldMatcher.find()) {
            String field = fieldMatcher.group();
            if (field.startsWith("##")) continue;
            htmlContent = htmlContent.replace(field, "&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        return htmlContent;
    }

    protected String replaceYearInfo(Context ctx, String htmlContent) throws BOSException {
        String currentYearNum = "current year";
        String nextYearNum = "next year";
        if (null == this.yearFields) {
            String oql = "select name, number where number in ('" + currentYearNum + "', '" + nextYearNum + "')";
            this.yearFields = NoticeTemplateCFieldFactory.getLocalInstance(ctx).getNoticeTemplateCFieldCollection(oql);
        }
        int thisYear = Calendar.getInstance().get(1);
        for (int i = 0; i < this.yearFields.size(); ++i) {
            NoticeTemplateCFieldInfo info = this.yearFields.get(i);
            String name = this.concatTemplateCommonField(info.getName());
            if (currentYearNum.equals(info.getNumber())) {
                htmlContent = htmlContent.replace(name, String.valueOf(thisYear));
                continue;
            }
            if (!nextYearNum.equals(info.getNumber())) continue;
            htmlContent = htmlContent.replace(name, String.valueOf(thisYear + 1));
        }
        return htmlContent;
    }

    private String getFieldId(String column) {
        return this.dynamicColumns.get(column.toUpperCase());
    }

    protected String setSeries(Context ctx, String htmlContent, List<String> dynamicParagraphs) throws BOSException {
        String name;
        String number;
        if (dynamicParagraphs.isEmpty()) {
            return htmlContent;
        }
        String oql = "select name, number where type =3";
        NoticeTemplateCFieldCollection seriesFields = NoticeTemplateCFieldFactory.getLocalInstance(ctx).getNoticeTemplateCFieldCollection(oql);
        HashMap groups = new HashMap();
        SeriesNumService seriesNumService = this.getSeriesNumService();
        for (int i = 0; i < seriesFields.size(); ++i) {
            NoticeTemplateCFieldInfo seriesField = seriesFields.get(i);
            ArrayList<String> list = new ArrayList<String>();
            String pattern = this.concatTemplateCommonField(seriesField.getName());
            for (String paragraph : dynamicParagraphs) {
                if (!paragraph.contains(pattern)) continue;
                list.add(paragraph);
            }
            if (list.isEmpty()) continue;
            number = seriesField.getNumber();
            name = seriesField.getName();
            groups.put(number + "_" + name, list);
        }
        for (Map.Entry entry : groups.entrySet()) {
            String key = (String)entry.getKey();
            String[] arr = key.split("_");
            number = arr[0];
            name = arr[1];
            String seriesField = this.concatTemplateCommonField(name);
            List paragraphList = (List)entry.getValue();
            List<String> seriesNums = seriesNumService.generateSeriesNumList(number, paragraphList.size());
            for (int i = 0; i < paragraphList.size(); ++i) {
                String seriesNum = seriesNums.get(i);
                String source = (String)paragraphList.get(i);
                String target = source.replace(seriesField, seriesNum).replace("{", "").replace("}", "");
                htmlContent = htmlContent.replace(source, target);
            }
        }
        return htmlContent;
    }

    protected SeriesNumService getSeriesNumService() {
        return new SeriesNumService();
    }

    private String concatTemplateField(String fieldName) {
        return "#" + fieldName + "#";
    }

    private String concatTemplateCommonField(String fieldName) {
        return "##" + fieldName + "##";
    }

    private String clearEmptyAdjustItemParagraph(String htmlContent, String dynamicArea, List<String> dynamicParagraphs) {
        boolean isUseful = true;
        Matcher matcher = this.fieldPattern.matcher(dynamicArea = dynamicArea.replace("##", "~~"));
        if (matcher.find()) {
            dynamicArea = dynamicArea.replace("~~", "##");
            htmlContent = htmlContent.replace(dynamicArea, "");
            isUseful = false;
        }
        if (isUseful) {
            dynamicArea = dynamicArea.replace("~~", "##");
            dynamicParagraphs.add(dynamicArea);
        }
        return htmlContent;
    }

    protected Html2PdfConverter getHtml2PdfConverter(Context ctx) {
        return new Html2PdfConverter(ctx);
    }

    private List<Map<String, Object>> getFieldValues(IRowSet rs) throws BOSException {
        ArrayList list = Lists.newArrayList();
        try {
            IRowSetMetaData metaData = rs.getRowSetMetaData();
            ArrayList<String> columns = new ArrayList<String>();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i);
                columns.add(columnName);
            }
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String column : columns) {
                    Object value = rs.getObject(column);
                    if (null == value) continue;
                    map.put(column, value);
                }
                list.add(map);
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"getFieldValues error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private String getQuerySQL(Context ctx, AdjustSalaryNoticeEntryInfo entryInfo, String templateId) throws BOSException, EASBizException {
        FilterInfo filterInfo;
        SqlParam sqlParam = new SqlParam();
        String filter = "CMP_SMT001.id = '" + entryInfo.getAdjEntry().getId().toString() + "'";
        try {
            filterInfo = new FilterInfo(filter);
        }
        catch (ParserException e) {
            LOG.error((Object)"add filter error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme("006_CMP_ADJ");
        HashSet<String> schemeItems = new HashSet<String>();
        if (entryInfo.getNoticeBill() != null && entryInfo.getNoticeBill().getAdjBill() != null && entryInfo.getNoticeBill().getAdjBill().getAdjustSalaryRule() != null) {
            String schemeId = entryInfo.getNoticeBill().getAdjBill().getAdjustSalaryRule().getId().toString();
            BatchAdjustRuleItemCollection itemCol = BatchAdjustRuleItemFactory.getLocalInstance(ctx).getBatchAdjustRuleItemCollection("select adjustSalaryItem.id where calSubmitScheme.id ='" + schemeId + "'");
            for (int i = 0; i < itemCol.size(); ++i) {
                BatchAdjustRuleItemInfo itemInfo = itemCol.get(i);
                if (itemInfo.getAdjustSalaryItem() == null) continue;
                schemeItems.add(itemInfo.getAdjustSalaryItem().getId().toString());
            }
        }
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        String templateFieldOql = "select adjustItem.id, adjustItem.fieldSn, queryConfigField.id, structureColumn.id, structureColumn.enumSource, structureColumn.number, structureColumn.structureConfig.clientNumber, fieldNum  where template.id = '" + templateId + "'";
        NoticeTemplateFieldCollection fields = NoticeTemplateFieldFactory.getLocalInstance(ctx).getNoticeTemplateFieldCollection(templateFieldOql);
        for (int i = 0; i < fields.size(); ++i) {
            String column;
            NoticeTemplateFieldInfo templateFieldInfo = fields.get(i);
            StructureConfigColumnsInfo structureConfigColumnsInfo = templateFieldInfo.getStructureColumn();
            if (null != structureConfigColumnsInfo && null != structureConfigColumnsInfo.getId()) {
                String clientNumber = structureConfigColumnsInfo.getStructureConfig().getClientNumber();
                column = templateFieldInfo.getStructureColumn().getNumber();
                String queryField = clientNumber + "." + column;
                queryField = queryField.toUpperCase();
                String id = templateFieldInfo.getQueryConfigField().getId().toString();
                this.dynamicColumns.put(queryField, id);
                if (!StringUtils.isEmpty((String)structureConfigColumnsInfo.getEnumSource())) {
                    this.enumMap.put(queryField, structureConfigColumnsInfo.getEnumSource());
                }
                if (null != templateFieldInfo.getFieldNum()) {
                    this.dateFormatMap.put(id, templateFieldInfo.getFieldNum());
                }
                selectMapping.put(queryField, queryField);
                continue;
            }
            if (null == templateFieldInfo.getAdjustItem() || null == templateFieldInfo.getAdjustItem().getId() || !schemeItems.contains(templateFieldInfo.getAdjustItem().getId().toString())) continue;
            String adjustItemId = templateFieldInfo.getAdjustItem().getId().toString();
            if (null != templateFieldInfo.getFieldNum()) {
                this.dateFormatMap.put(adjustItemId, templateFieldInfo.getFieldNum());
            }
            column = "CMP_SMT001.S" + templateFieldInfo.getAdjustItem().getFieldSn();
            this.dynamicColumns.put(column.toUpperCase(), adjustItemId);
        }
        String schemeId = entryInfo.getNoticeBill().getAdjBill().getAdjustSalaryRule().getId().toString();
        String itemOql = "select adjustSalaryItem.id, adjustSalaryItem.fieldSn, adjustSalaryItem.dataDot where calSubmitScheme = '" + schemeId + "'";
        BatchAdjustRuleItemCollection adjustItems = BatchAdjustRuleItemFactory.getLocalInstance(ctx).getBatchAdjustRuleItemCollection(itemOql);
        HashMap<String, String> schemeColumns = new HashMap<String, String>();
        for (int i = 0; i < adjustItems.size(); ++i) {
            AdjustSalaryItemInfo itemInfo = adjustItems.get(i).getAdjustSalaryItem();
            String adjustItemId = itemInfo.getId().toString();
            String column = "CMP_SMT001.S" + itemInfo.getFieldSn();
            this.dynamicColumns.put(column.toUpperCase(), adjustItemId);
            schemeColumns.put(column.toUpperCase(), adjustItemId);
        }
        selectMapping.put("CMP_SMT001.id", "adjEntryId");
        sqlParam.setSelectMapping(selectMapping);
        String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        String adjRuleId = entryInfo.getNoticeBill().getAdjBill().getAdjustSalaryRule().getId().toString();
        String entryTable = AdjustSalaryUtils.getCalShemeTableName(ctx, adjRuleId);
        sql = this.addAdjSalaryItemFields(ctx, sql, entryTable, schemeColumns, schemeId);
        LOG.debug((Object)("query SQL: " + sql));
        return sql;
    }

    private String addAdjSalaryItemFields(Context ctx, String sql, String entryTable, Map<String, String> dynamicColumns, String schemeId) throws BOSException {
        sql = sql.replace("T_HR_SADJUSTSALARYAPPLYENTRY", entryTable);
        if (dynamicColumns.isEmpty()) {
            return sql;
        }
        String[] sqlParts = this.splitSQL(sql);
        String f7InfoSQL = " SELECT item.fieldSn fieldSn, b.FTable FTable FROM T_HR_SCalSubmitScheme scheme  inner join T_HR_sbatchAdjustRuleItem schemeItem on scheme.fid = schemeItem.FCalSubmitSchemeID  inner join T_HR_AdjustSalaryItem item on item.fid = schemeItem.FAdjustSalaryItemID  inner join T_HR_SCalSchemeItemForF7 b on item.FilterFieldID = b.fid  where scheme.fid =  '" + schemeId + "' and item.FDataType = '" + "3" + "' order by FSortCode";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)f7InfoSQL);
        HashMap<String, String> f7ItemTableMapper = new HashMap<String, String>();
        HashMap<String, String> f7TableAliasMapper = new HashMap<String, String>();
        try {
            while (rs.next()) {
                int fieldSn = rs.getInt("fieldSn");
                String fieldName = "S" + fieldSn;
                String tableName = rs.getString("FTable");
                f7ItemTableMapper.put(fieldName, tableName);
                f7TableAliasMapper.put(fieldName, tableName + fieldSn);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String lan = ctx.getLocale().getLanguage();
        String sqlPart1 = sqlParts[0];
        sqlPart1 = sqlPart1.replace("SELECT", "");
        StringBuilder part1 = new StringBuilder(sqlPart1);
        for (Map.Entry<String, String> entry : dynamicColumns.entrySet()) {
            String column = entry.getKey();
            String field = column.split("\\.")[1];
            if (f7ItemTableMapper.containsKey(field)) {
                String tableName = (String)f7ItemTableMapper.get(field);
                String tableAlias = (String)f7TableAliasMapper.get(field);
                column = tableAlias + ".FName_" + lan + " \"" + column + "\",";
                part1.append("left join ").append(tableName).append(" ").append(tableAlias).append(" on ").append(entry.getKey()).append("=").append(tableAlias).append(".fid ");
                part1.insert(0, column);
                continue;
            }
            part1.insert(0, column + " \"" + column + "\", ");
        }
        part1.insert(0, "SELECT ");
        return part1 + sqlParts[1];
    }

    protected String[] splitSQL(String sql) {
        int whereIdx = sql.lastIndexOf("WHERE");
        String part1 = sql.substring(0, whereIdx);
        String part2 = sql.substring(whereIdx);
        return new String[]{part1, part2};
    }

    protected AdjustSalaryNoticeEntryInfo getAdjustSalaryNoticeEntryInfo(Context ctx, String entryId, String personId) throws BOSException {
        AdjustSalaryNoticeEntryCollection entryCollection;
        String oql = "select id, person.id, noticeBill.adjBill.hrOrgUnit.id ,noticeBill.adjBill.adjustSalaryRule.id, adjEntry.id, sendTime, resetTime, confirmType, template.htmlContent, pdfAttatchment, htmlContent, template.bosTitle  where id = '" + entryId + "'";
        if (!StringUtils.isEmpty((String)personId)) {
            oql = oql + " and person.id = '" + personId + "'";
        }
        if ((entryCollection = AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).getAdjustSalaryNoticeEntryCollection(oql)).isEmpty()) {
            LOG.error((Object)("cannot find AdjustSalaryNoticeEntryInfo by id: " + entryId + ", personId: " + personId));
            throw new BOSException("Cannot find AdjustSalaryNoticeEntryInfo by id: " + entryId);
        }
        return entryCollection.get(0);
    }

    public void loadCustomFonts(Context ctx, Html2PdfConverter converter) throws IOException {
        File[] fonts;
        String basePath = Html2PdfConverter.getFontFilePath();
        String userFontPath = basePath + File.separator + "fonts";
        File fontDir = new File(userFontPath);
        if (!fontDir.exists() && fontDir.mkdir()) {
            LOG.info((Object)("make dir: " + userFontPath));
        }
        if (null == (fonts = fontDir.listFiles())) {
            return;
        }
        HashMap<String, String> fileNameMap = new HashMap<String, String>();
        try {
            TemplateFontCollection collection = TemplateFontFactory.getLocalInstance(ctx).getTemplateFontCollection();
            for (int i = 0; i < collection.size(); ++i) {
                TemplateFontInfo font = collection.get(i);
                fileNameMap.put(font.getFileName(), font.getFontName());
            }
        }
        catch (BOSException e) {
            LOG.error((Object)"loadCustomFonts error: ", (Throwable)e);
        }
        for (File font : fonts) {
            BaseFont baseFont = this.createFont(font.getAbsolutePath());
            String fileName = font.getName();
            if (null == baseFont || !fileNameMap.containsKey(fileName)) continue;
            converter.getFontMap().put(fileNameMap.get(fileName), baseFont);
        }
    }

    private BaseFont createFont(String fontPath) {
        BaseFont baseFont = this.createFont(fontPath, "Identity-H");
        if (null == baseFont && null == (baseFont = this.createFont(fontPath, "Cp1250")) && null == (baseFont = this.createFont(fontPath, "Cp1252")) && null == (baseFont = this.createFont(fontPath, "Cp1257")) && null == (baseFont = this.createFont(fontPath, "Identity-V"))) {
            baseFont = this.createFont(fontPath, "MacRoman");
        }
        return baseFont;
    }

    private BaseFont createFont(String fontPath, String encoding) {
        try {
            return BaseFont.createFont((String)fontPath, (String)encoding, (boolean)true);
        }
        catch (Exception e) {
            LOG.error((Object)"createFont error:", (Throwable)e);
            return null;
        }
    }

    @Override
    protected String _batchGeneratePDF(Context ctx, List entries) throws BOSException, EASBizException {
        String taskId = TaxCalcFileUtils.getUUID();
        new Thread(() -> {
            try {
                this.doGeneratePDF(ctx, entries);
            }
            catch (BOSException | EASBizException e) {
                LOG.error((Object)"_batchGeneratePDF error: ", e);
            }
        }).start();
        return taskId;
    }

    @Override
    protected Map _fillTitle(Context ctx, List entries) throws BOSException, EASBizException {
        Map<String, List<AdjustSalaryNoticeEntryInfo>> groups = this.groupByScheme(entries);
        CoreBaseCollection noticeEntries = new CoreBaseCollection();
        for (Map.Entry<String, List<AdjustSalaryNoticeEntryInfo>> group : groups.entrySet()) {
            List<AdjustSalaryNoticeEntryInfo> entryList = group.getValue();
            String schemeId = group.getKey();
            String sql = this.getBatchQuerySQL(ctx, entryList, schemeId);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            List<Map<String, Object>> dataList = this.getFieldValues(rs);
            for (Map<String, Object> personData : dataList) {
                String adjEntryId = (String)personData.get("ADJENTRYID");
                Optional<AdjustSalaryNoticeEntryInfo> optional = entryList.stream().filter(e -> e.getAdjEntry().getId().toString().equals(adjEntryId)).findFirst();
                if (!optional.isPresent()) continue;
                AdjustSalaryNoticeEntryInfo entryInfo = optional.get();
                String title = this.fillTitle(ctx, entryInfo.getTemplate().getBosTitle(), personData);
                entryInfo.setNoticeTitle(title);
            }
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("noticeTitle");
        AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)noticeEntries, selector);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGeneratePDF(Context ctx, List<AdjustSalaryNoticeEntryInfo> entries) throws BOSException, EASBizException {
        Html2PdfConverter converter = this.getHtml2PdfConverter(ctx);
        try {
            this.loadCustomFonts(ctx, converter);
        }
        catch (IOException e2) {
            throw new BOSException((Throwable)e2);
        }
        Map<String, List<AdjustSalaryNoticeEntryInfo>> groups = this.groupByScheme(entries);
        CoreBaseCollection noticeEntries = new CoreBaseCollection();
        CoreBaseCollection attachments = new CoreBaseCollection();
        ArrayList tmpFiles = Lists.newArrayList();
        long currentThreadId = Thread.currentThread().getId();
        try {
            HashSet templateIds = Sets.newHashSet();
            entries.forEach(e -> {
                String templateId = e.getTemplate().getId().toString();
                templateIds.add(templateId);
                templateThread.put(templateId, currentThreadId);
            });
            String templateOql = "select id, bosTitle, htmlContent where id in (" + CmpStrUtil.convertSetToSqlString((Set)templateIds) + ")";
            AdjustSalaryNoticeTemplateHISCollection templates = AdjustSalaryNoticeTemplateHISFactory.getLocalInstance((Context)ctx).getAdjustSalaryNoticeTemplateHISCollection(templateOql);
            for (Map.Entry<String, List<AdjustSalaryNoticeEntryInfo>> group : groups.entrySet()) {
                List<AdjustSalaryNoticeEntryInfo> entryList = group.getValue();
                String schemeId = group.getKey();
                String sql = this.getBatchQuerySQL(ctx, entryList, schemeId);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                List<Map<String, Object>> dataList = this.getFieldValues(rs);
                for (Map<String, Object> personData : dataList) {
                    String adjEntryId = (String)personData.get("ADJENTRYID");
                    Optional<AdjustSalaryNoticeEntryInfo> optional = entryList.stream().filter(e -> e.getAdjEntry().getId().toString().equals(adjEntryId)).findFirst();
                    if (!optional.isPresent()) continue;
                    AdjustSalaryNoticeEntryInfo entryInfo = optional.get();
                    String templateId = entryInfo.getTemplate().getId().toString();
                    long threadId = templateThread.get(templateId);
                    if (currentThreadId != threadId) {
                        LOG.error((Object)"template is modified, new thread is used for generating PDF");
                        continue;
                    }
                    AdjustSalaryNoticeTemplateHISInfo template = this.filterTemplate(templateId, templates);
                    if (null == template) continue;
                    String pdfContent = this.fillTemplate(ctx, template.getHtmlContent(), personData);
                    String title = this.fillTitle(ctx, template.getBosTitle(), personData);
                    entryInfo.setNoticeTitle(title);
                    String pdfFilePath = this.getPdfFilePath();
                    File file = new File(pdfFilePath);
                    converter.generatePdfFile(pdfContent, file, null);
                    AttachmentInfo attachmentInfo = new AttachmentInfo();
                    String attachmentId = this.initPDFAttachment(file, attachmentInfo);
                    entryInfo.setPdfAttatchment(attachmentId);
                    entryInfo.setHtmlContent(pdfContent);
                    noticeEntries.add((CoreBaseInfo)entryInfo);
                    attachments.add((CoreBaseInfo)attachmentInfo);
                    tmpFiles.add(file);
                }
            }
            AttachmentFactory.getLocalInstance((Context)ctx).saveBatchData(attachments);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("pdfAttatchment");
            selector.add("noticeTitle");
            selector.add("htmlContent");
            AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).updatePartialBatchData((IObjectCollection)noticeEntries, selector);
        }
        finally {
            this.clearTemplateThread(currentThreadId);
            tmpFiles.forEach(FileUtils::deleteQuietly);
        }
    }

    private void clearTemplateThread(long currentThreadId) {
        templateThread.entrySet().removeIf(entry -> currentThreadId == (Long)entry.getValue());
    }

    private AdjustSalaryNoticeTemplateHISInfo filterTemplate(String templateId, AdjustSalaryNoticeTemplateHISCollection templates) {
        for (int i = 0; i < templates.size(); ++i) {
            if (!templateId.equals(templates.get(i).getId().toString())) continue;
            return templates.get(i);
        }
        return null;
    }

    @Override
    protected void _autoConfirm(Context ctx) throws BOSException {
        long sendTime;
        AdjustSalaryNoticeEntryInfo entry;
        int i;
        long time;
        TimeUnitEnum unit;
        NoticeParamInfo paramInfo = NoticeDaoUtils.getNoticeParamInfo(ctx);
        if (!paramInfo.isConfirmAuth()) {
            return;
        }
        if (!paramInfo.isEnableExpiration()) {
            return;
        }
        String oql = "select id, person.id, noticeBill.adjBill.hrOrgUnit.id ,noticeBill.adjBill.adjustSalaryRule.id, adjEntry.id, confirmType, sendTime, resetTime,htmlContent,pdfAttatchment where confirmState in (5, 4) and sendState in (1, 3) and confirmState in (5,4) and adjEntryState !=3";
        IAdjustSalaryNoticeEntry iAdjustSalaryNoticeEntry = AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx);
        AdjustSalaryNoticeEntryCollection entries = iAdjustSalaryNoticeEntry.getAdjustSalaryNoticeEntryCollection(oql);
        if (entries.isEmpty()) {
            return;
        }
        boolean isAutoConfirm = paramInfo.isAutoAuth();
        long now = System.currentTimeMillis();
        Timestamp confirmTime = new Timestamp(now);
        CoreBaseCollection toUpdate = new CoreBaseCollection();
        if (!isAutoConfirm) {
            int authAfterDay = paramInfo.getAuthAfterDay();
            unit = paramInfo.getUnit();
            time = (long)(authAfterDay * 1000) * 60L;
            if (unit == TimeUnitEnum.HOUR) {
                time *= 60L;
            } else if (unit == TimeUnitEnum.DAY) {
                time = time * 60L * 24L;
            }
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                if (entry.getResetTime() == null && entry.getSendTime() == null) continue;
                long l = sendTime = null == entry.getResetTime() ? entry.getSendTime().getTime() : entry.getResetTime().getTime();
                if (now - sendTime < time) continue;
                entry.setConfirmState(ConfirmStateEnum.CONFIRMED);
                entry.setConfirmType(AdjSalaryNoticeConfirmType.AUTO);
                entry.setConfirmTime(confirmTime);
                try {
                    this.makeAdjustSalaryEffective(ctx, entry);
                    toUpdate.add((CoreBaseInfo)entry);
                    continue;
                }
                catch (EASBizException | SQLException e) {
                    LOG.error((Object)e.getMessage(), e);
                }
            }
        } else if (paramInfo.isEnableExpiration()) {
            int expiredDays = paramInfo.getExpiredDays();
            unit = paramInfo.getExpiredUnit();
            time = (long)(expiredDays * 1000) * 60L;
            if (unit == TimeUnitEnum.HOUR) {
                time *= 60L;
            } else if (unit == TimeUnitEnum.DAY) {
                time = time * 60L * 24L;
            }
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                if (entry.getResetTime() == null && entry.getSendTime() == null) continue;
                long l = sendTime = null == entry.getResetTime() ? entry.getSendTime().getTime() : entry.getResetTime().getTime();
                if (now - sendTime < time) continue;
                entry.setConfirmState(ConfirmStateEnum.EXPIRED);
                toUpdate.add((CoreBaseInfo)entry);
            }
        }
        if (!toUpdate.isEmpty()) {
            try {
                for (int i2 = 0; i2 < toUpdate.size(); ++i2) {
                    AdjustSalaryNoticeEntryInfo entryInfo = (AdjustSalaryNoticeEntryInfo)toUpdate.get(i2);
                    String entryId = entryInfo.getId().toString();
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("entryId", entryId);
                    Map result = AdjustSalaryNoticeEntryFacadeFactory.getLocalInstance(ctx).fillTemplate(params);
                    String htmlContent = (String)result.get("htmlContent");
                    entryInfo.setHtmlContent(htmlContent);
                }
            }
            catch (EASBizException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("confirmState");
            selector.add("confirmTime");
            selector.add("confirmType");
            try {
                iAdjustSalaryNoticeEntry.updatePartialBatchData((IObjectCollection)toUpdate, selector);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String getBatchQuerySQL(Context ctx, List<AdjustSalaryNoticeEntryInfo> list, String schemeId) throws BOSException, EASBizException {
        FilterInfo filterInfo;
        SqlParam sqlParam = new SqlParam();
        ArrayList idList = Lists.newArrayList();
        for (AdjustSalaryNoticeEntryInfo entryInfo : list) {
            idList.add(entryInfo.getAdjEntry().getId().toString());
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String inCondition = cmpInSql.createInSqlBaseOnFId(ctx, (Collection)idList);
        String filter = "CMP_SMT002.id in " + inCondition;
        try {
            filterInfo = new FilterInfo(filter);
        }
        catch (ParserException e2) {
            LOG.error((Object)"add filter error: ", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme("006_CMP_ADJ");
        HashSet templateIds = Sets.newHashSet();
        list.forEach(e -> templateIds.add(e.getTemplate().getId().toString()));
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        String templateFieldOql = "select adjustItem.id, queryConfigField.id, structureColumn.id, structureColumn.enumSource, structureColumn.number, structureColumn.structureConfig.clientNumber, fieldNum  where template.id in (" + CmpStrUtil.convertSetToSqlString((Set)templateIds) + ")";
        NoticeTemplateFieldCollection fields = NoticeTemplateFieldFactory.getLocalInstance(ctx).getNoticeTemplateFieldCollection(templateFieldOql);
        for (int i = 0; i < fields.size(); ++i) {
            NoticeTemplateFieldInfo templateFieldInfo = fields.get(i);
            StructureConfigColumnsInfo structureConfigColumnsInfo = templateFieldInfo.getStructureColumn();
            if (null != structureConfigColumnsInfo && null != structureConfigColumnsInfo.getId()) {
                String clientNumber = structureConfigColumnsInfo.getStructureConfig().getClientNumber();
                String column = templateFieldInfo.getStructureColumn().getNumber();
                String queryField = clientNumber + "." + column;
                queryField = queryField.toUpperCase();
                String id = templateFieldInfo.getQueryConfigField().getId().toString();
                this.dynamicColumns.put(queryField, id);
                if (!StringUtils.isEmpty((String)structureConfigColumnsInfo.getEnumSource())) {
                    this.enumMap.put(queryField, structureConfigColumnsInfo.getEnumSource());
                }
                if (null != templateFieldInfo.getFieldNum()) {
                    this.dateFormatMap.put(id, templateFieldInfo.getFieldNum());
                }
                selectMapping.put(queryField, queryField);
                continue;
            }
            if (null == templateFieldInfo.getAdjustItem() || null == templateFieldInfo.getAdjustItem().getId() || null == templateFieldInfo.getFieldNum()) continue;
            this.dateFormatMap.put(templateFieldInfo.getAdjustItem().getId().toString(), templateFieldInfo.getFieldNum());
        }
        String itemOql = "select adjustSalaryItem.id, adjustSalaryItem.fieldSn, adjustSalaryItem.dataDot, adjustSalaryItem.dataType where calSubmitScheme = '" + schemeId + "'";
        BatchAdjustRuleItemCollection adjustItems = BatchAdjustRuleItemFactory.getLocalInstance(ctx).getBatchAdjustRuleItemCollection(itemOql);
        HashMap<String, String> schemeColumns = new HashMap<String, String>();
        for (int i = 0; i < adjustItems.size(); ++i) {
            AdjustSalaryItemInfo itemInfo = adjustItems.get(i).getAdjustSalaryItem();
            String adjustItemId = itemInfo.getId().toString();
            String column = "CMP_SMT002.S" + itemInfo.getFieldSn();
            this.dynamicColumns.put(column.toUpperCase(), adjustItemId);
            schemeColumns.put(column.toUpperCase(), adjustItemId);
        }
        selectMapping.put("CMP_SMT002.id", "adjEntryId");
        sqlParam.setSelectMapping(selectMapping);
        String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
        String entryTable = AdjustSalaryUtils.getCalShemeTableName(ctx, schemeId);
        sql = this.addAdjSalaryItemFields(ctx, sql, entryTable, schemeColumns, schemeId);
        LOG.debug((Object)("batch query SQL: " + sql));
        return sql;
    }

    @Override
    protected Map _autoConfirmByInfo(Context ctx, Map param) throws BOSException, EASBizException {
        if (param.get("entryInfo") == null) {
            return null;
        }
        AdjustSalaryNoticeEntryInfo entryInfo = (AdjustSalaryNoticeEntryInfo)param.get("entryInfo");
        String entryId = entryInfo.getId().toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entryId", entryId);
        Map result = this._fillTemplate(ctx, params);
        String htmlContent = (String)result.get("htmlContent");
        entryInfo.setHtmlContent(htmlContent);
        try {
            this.makeAdjustSalaryEffective(ctx, entryInfo);
            this.updateConfirmedAdjustSalaryNoticeEntry(ctx, entryInfo, entryInfo.getConfirmState());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

