/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.cmpdesign.app.v2.notice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.cmpdesign.app.v2.bill.AdjustSalaryApplyInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.AbstractAdjustSalaryNoticeFacadeControllerBean;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeBillFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeBillInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeParamInfo;
import com.kingdee.shr.cmpdesign.v2.notice.util.NoticeAssembleUtils;
import com.kingdee.shr.cmpdesign.v2.notice.util.NoticeDaoUtils;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateInfo;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.util.List;
import java.util.Map;
import oadd.org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AdjustSalaryNoticeFacadeControllerBean
extends AbstractAdjustSalaryNoticeFacadeControllerBean {
    private static Logger LOG = Logger.getLogger(AdjustSalaryNoticeFacadeControllerBean.class);

    @Override
    protected void _createNoticeData(Context ctx, Map param) throws BOSException, EASBizException {
        if (param.get("adjBillId") == null) {
            return;
        }
        String adjBillId = param.get("adjBillId").toString();
        IObjectPK billIdPk = this.createNoticeBillData(ctx, adjBillId);
        this.createNoticeEntryData(ctx, billIdPk, adjBillId);
    }

    public void createNoticeEntryData(Context ctx, IObjectPK billIdPk, String adjBillId) throws EASBizException, BOSException {
        if (billIdPk == null) {
            return;
        }
        AdjustSalaryApplyInfo adjBillInfo = NoticeDaoUtils.getAdjBillInfo(ctx, adjBillId);
        AdjustSalaryNoticeTemplateInfo defaultTemplate = null;
        if (adjBillInfo.getAdjustSalaryRule() != null && adjBillInfo.getAdjustSalaryRule().getNoticeTemplate() != null) {
            defaultTemplate = adjBillInfo.getAdjustSalaryRule().getNoticeTemplate();
        }
        List<Map<String, Object>> adjEntryData = NoticeDaoUtils.assembleAdjEntryData(ctx, adjBillId);
        adjEntryData = NoticeDaoUtils.assembleExtendNoticeEntryData(ctx, adjEntryData);
        NoticeParamInfo paramInfo = NoticeDaoUtils.getNoticeParamInfo(ctx);
        boolean confirmAuth = paramInfo.isConfirmAuth();
        CoreBaseCollection col = NoticeAssembleUtils.assembleNoticeEntryCol(billIdPk.toString(), adjEntryData, defaultTemplate, confirmAuth);
        if (!col.isEmpty()) {
            AdjustSalaryNoticeEntryFactory.getLocalInstance(ctx).addnewBatchData(col);
        }
    }

    public IObjectPK createNoticeBillData(Context ctx, String adjBillId) throws EASBizException, BOSException {
        AdjustSalaryNoticeBillInfo billInfo = NoticeAssembleUtils.assembleAdjustSalaryNoticeBillInfo(adjBillId);
        return AdjustSalaryNoticeBillFactory.getLocalInstance(ctx).addnew(billInfo);
    }

    @Override
    protected void _resetNoticeData(Context ctx, Map param) throws BOSException, EASBizException {
        boolean confirmAuth;
        String billIds = param.get("billIds") != null ? param.get("billIds").toString() : null;
        String entryIds = param.get("entryIds") != null ? param.get("entryIds").toString() : null;
        boolean bl = confirmAuth = param.get("confirmAuth") != null ? (Boolean)param.get("confirmAuth") : false;
        if (StringUtils.isEmpty((CharSequence)billIds) && StringUtils.isEmpty((CharSequence)entryIds)) {
            return;
        }
        NoticeDaoUtils.resetEntryData(ctx, billIds, entryIds, confirmAuth);
    }

    @Override
    protected void _resetConfirmData(Context ctx, Map param) throws BOSException, EASBizException {
        String entryIds = param.get("entryIds").toString();
        entryIds = StringEscapeUtils.escapeSql((String)entryIds);
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update  T_HR_SAdjustSalaryNoticeEntry set FConfirmState=4,FConfirmTime=null,FConfirmType=null,FResetTime=now(),FSignatureAttachmentId='',FAdjEntryState=0,FLastUpdateUserID=?,FLastUpdateTime=now() where ");
        String createInSql = CmpSQLUtil.createInSql((Context)ctx, (String[])entryIds.split(","), (String)"T_HR_SAdjustSalaryNoticeEntry", (String)"fid");
        updateSql.append(" fid in ").append("(" + createInSql + ")");
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{currentUserInfo.getId().toString()});
    }

    @Override
    protected void _deleteNoticeDataByAdjBillId(Context ctx, Map param) throws BOSException, EASBizException {
        if (param.get("adjBillId") == null) {
            return;
        }
        String adjBillId = param.get("adjBillId") != null ? param.get("adjBillId").toString() : null;
        String adjBillIdInSql = CmpStrUtil.buildInSql((String)adjBillId);
        String delEntrySql = "update T_HR_SAdjustSalaryNoticeEntry set FIsRemove=1 where FIsRemove<>1 and FNoticeBillId in (select fid from T_HR_SAdjustSalaryNoticeBill where FIsRemove<>1 and FAdjBillId in " + adjBillIdInSql + ")";
        String delBillSql = "update T_HR_SAdjustSalaryNoticeBill set FIsRemove=1 where FIsRemove<>1 and FAdjBillId in " + adjBillIdInSql;
        DbUtil.execute((Context)ctx, (String)delEntrySql);
        DbUtil.execute((Context)ctx, (String)delBillSql);
    }

    @Override
    protected void _deleteNoticeDataByNoticeBillId(Context ctx, Map param) throws BOSException, EASBizException {
        if (param.get("billIds") == null) {
            return;
        }
        String billIds = param.get("billIds") != null ? param.get("billIds").toString() : null;
        String billIdInSql = CmpStrUtil.buildInSql((String)billIds);
        String delEntrySql = "update T_HR_SAdjustSalaryNoticeEntry set FIsRemove=1 where FIsRemove<>1 and FNoticeBillId in (select fid from T_HR_SAdjustSalaryNoticeBill where FIsRemove<>1 and fid in " + billIdInSql + ")";
        String delBillSql = "update T_HR_SAdjustSalaryNoticeBill set FIsRemove=1 where FIsRemove<>1 and fid in " + billIdInSql;
        DbUtil.execute((Context)ctx, (String)delEntrySql);
        DbUtil.execute((Context)ctx, (String)delBillSql);
    }
}

