/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalTableDesTypeEnum;
import com.kingdee.shr.compensation.CmpCalTableCollection;
import com.kingdee.shr.compensation.app.AbstractCmpSchemePersonFacadeControllerBean;
import com.kingdee.shr.compensation.cmpBudget.CmpBudgetFacadeService;
import com.kingdee.shr.compensation.helper.CalSchemeBizHelper;
import com.kingdee.shr.compensation.helper.CalSchemePersonHelper;
import com.kingdee.shr.compensation.sql.wizard.CmpSchemePersonSQL;
import com.kingdee.shr.compensation.util.CmpCalUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.CmpTaxUtil;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CmpSchemePersonFacadeControllerBean
extends AbstractCmpSchemePersonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.CmpSchemePersonFacadeControllerBean");

    private Set<String> getHasPersonSet(Context ctx, String calSchemeId) throws BOSException, EASBizException {
        HashSet<String> personSet = new HashSet<String>();
        CmpCalTableCollection personCollection = CalSchemePersonHelper.getCalSchemePersonSCol(ctx, calSchemeId);
        int size = personCollection.size();
        for (int i = 0; i < size; ++i) {
            personSet.add(personCollection.get(i).getPerson().getId().toString());
        }
        return personSet;
    }

    @Override
    protected int _addPerson(Context ctx, String permItemId, String calSchemeId, List personList) throws BOSException, EASBizException {
        ArrayList<Object[]> executeBatchParamList = new ArrayList<Object[]>();
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, calSchemeId);
        Set<String> hasPersonSet = this.getHasPersonSet(ctx, calSchemeId);
        HashSet<String> addPersonSet = new HashSet<String>();
        int size = personList.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = new HashMap();
            map = (Map)personList.get(i);
            map.put("cmpEmpORelation.useDefault", map.get("cmpemporelation.usedefault"));
            String personId = map.get("person.id").toString();
            if (hasPersonSet.contains(personId)) continue;
            hasPersonSet.add(personId);
            addPersonSet.add(personId);
            Object[] executeBatchParam = this.getExecuteBatchParam(ctx, map, calSchemeInfo);
            executeBatchParamList.add(executeBatchParam);
        }
        String addPersonSql = this.getAddPeronSql(ctx);
        int[] retVal = CmpSQLUtil.executeBatch(ctx, addPersonSql, executeBatchParamList);
        this.updateCmpCalOrg(ctx, addPersonSet, calSchemeInfo, permItemId);
        if (calSchemeInfo.getTaxUnit() != null || !CmpStrUtil.isNullOrEmpty(calSchemeInfo.getTaxUnit())) {
            CmpTaxUtil taxUtil = new CmpTaxUtil();
            taxUtil.updateTaxUnit(ctx, addPersonSet, calSchemeInfo);
        }
        CmpCalUtil.updateNewCalSchemeState(ctx, calSchemeId);
        return retVal.length;
    }

    @Override
    protected int _addPerson(Context ctx, String permItemId, String calSchemeId, IRowSet rowSet) throws BOSException, EASBizException {
        HashMap<Object, Object> map = new HashMap();
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, calSchemeId);
        Set<String> hasPersonSet = this.getHasPersonSet(ctx, calSchemeId);
        HashSet<String> addPersonSet = new HashSet<String>();
        ArrayList<Object[]> executeBatchParamList = new ArrayList<Object[]>();
        try {
            while (rowSet.next()) {
                map = this.convertRowSetToMap(rowSet);
                String personId = map.get("person.id").toString();
                if (hasPersonSet.contains(personId)) continue;
                hasPersonSet.add(personId);
                addPersonSet.add(personId);
                Object[] executeBatchParam = this.getExecuteBatchParam(ctx, map, calSchemeInfo);
                executeBatchParamList.add(executeBatchParam);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e);
        }
        String addPersonSql = this.getAddPeronSql(ctx);
        int[] retVals = CmpSQLUtil.executeBatch(ctx, addPersonSql, executeBatchParamList);
        this.updateCmpCalOrg(ctx, addPersonSet, calSchemeInfo, permItemId);
        if (calSchemeInfo.getTaxUnit() != null || !CmpStrUtil.isNullOrEmpty(calSchemeInfo.getTaxUnit())) {
            CmpTaxUtil taxUtil = new CmpTaxUtil();
            taxUtil.updateTaxUnit(ctx, addPersonSet, calSchemeInfo);
        }
        CmpCalUtil.updateNewCalSchemeState(ctx, calSchemeId);
        return executeBatchParamList.size();
    }

    private int updateCmpCalOrg(Context ctx, Set<String> personSet, CalSchemeInfo calSchemeInfo, String permItemId) {
        int count = 0;
        if (personSet.size() <= 0 || calSchemeInfo == null) {
            return count;
        }
        try {
            String beginDateStr = CmpDateUtil.toKSqlDate(calSchemeInfo.getBeginDate());
            String adminRangSql = CmpSchemeFilter.getAdminOrgUnitRangeSQL(ctx, permItemId);
            String[] ids = new String[personSet.size()];
            personSet.toArray(ids);
            String personIds = CmpSQLUtil.createInSql(ctx, ids, "T_BD_PERSON", "FID");
            StringBuilder sb = new StringBuilder();
            sb.append("update T_HR_SCMPCALTABLE calTable  set FCMPCALORGID =").append(" (SELECT FCLUORGID FROM T_HR_SCmpCalOrg cmpCalOrg").append(" inner join (select max(FEFFECTDATE) effectDate,FPersonID personId from T_HR_SCmpCalOrg where FEFFECTDATE < " + beginDateStr + " and FCluOrgID in (" + adminRangSql + ") group by FPersonID ) maxCmpOrg").append(" on cmpCalOrg.FPersonID = maxCmpOrg.personId and cmpCalOrg.FEFFECTDATE = maxCmpOrg.effectDate where calTable.FPERSONID = cmpCalOrg.FPERSONID)").append(" where calTable.FPersonID in (").append(personIds).append(") and calTable.FCalSchemeID='").append(calSchemeInfo.getId().toString()).append("' and calTable.FPeriodYear=").append(calSchemeInfo.getPeriodYear()).append(" and calTable.FPeriodMonth=").append(calSchemeInfo.getPeriodMonth()).append(" and calTable.FCalTime=").append(calSchemeInfo.getCalTime());
            count = CmpSQLUtil.executeUpdate(ctx, sb.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    protected String _importHisPerson(Context ctx, String permItemId, String calSchemeId, CalSchemeInfo mergeCalSchemeInfo, boolean isCover, boolean isDelete, Map param) throws BOSException, EASBizException {
        String currentUserID = HRFilterUtils.getCurrentUserId((Context)ctx);
        CalSchemeInfo calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(ctx, calSchemeId);
        String mergeSchemeId = mergeCalSchemeInfo.getId().toString();
        param.put("mergeSchemeId", mergeSchemeId);
        int periodYear = calSchemeInfo.getPeriodYear();
        int periodMonth = calSchemeInfo.getPeriodMonth();
        int calTime = calSchemeInfo.getCalTime();
        if (isDelete) {
            if (calSchemeInfo.getBudgetTemplate() != null) {
                String calTabelFilter = CmpSchemePersonSQL.getDeleteCalSqlIds(param, calSchemeId, periodYear, periodMonth, calTime);
                CmpBudgetFacadeService executeBudgetService = new CmpBudgetFacadeService();
                executeBudgetService.rollBackBudgetWhenStopCal(ctx, calSchemeInfo, calTabelFilter, Boolean.TRUE);
            }
            Object[] deleteCalSchemeSqls = CmpSchemePersonSQL.getDeleteCalSchemeSqls(param, calSchemeId, periodYear, periodMonth, calTime);
            CmpSQLUtil.executeBatchSql(ctx, deleteCalSchemeSqls);
        }
        Boolean isUseForTaxCal = true;
        Boolean mergeSchemeIsUseForTaxCal = true;
        String FID = "";
        try {
            IRowSet iRowSet = CmpSQLUtil.executeQuery(ctx, "select FISUSEFORTAXCAL,FID  from T_HR_SCalScheme where FID in ('" + calSchemeInfo.getId().toString() + "','" + mergeSchemeId + "')");
            while (iRowSet.next()) {
                FID = iRowSet.getString("FID");
                if (mergeSchemeId.equals(FID)) {
                    mergeSchemeIsUseForTaxCal = iRowSet.getBoolean("FISUSEFORTAXCAL");
                    continue;
                }
                isUseForTaxCal = iRowSet.getBoolean("FISUSEFORTAXCAL");
            }
            if (calSchemeInfo.getId().toString().equals(mergeSchemeId)) {
                isUseForTaxCal = mergeSchemeIsUseForTaxCal;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        param.put("mergeSchemeIsUseForTaxCal", mergeSchemeIsUseForTaxCal);
        param.put("isUseForTaxCal", isUseForTaxCal);
        int updateCountNum = 0;
        if (isCover) {
            String updateSqlByCalSchemeSql = CmpSchemePersonSQL.getUpdateSqlByCalSchemeSql(calSchemeId, param, periodYear, periodMonth, calTime, currentUserID);
            logger.info((Object)("quoteCalSchemeSQL:" + updateSqlByCalSchemeSql));
            updateCountNum = CmpSQLUtil.executeUpdate(ctx, updateSqlByCalSchemeSql);
        }
        String insertByCalSchemeSql = CmpSchemePersonSQL.getInsertByCalSchemeSql(calSchemeInfo, param, currentUserID);
        int addCountNum = CmpSQLUtil.executeUpdate(ctx, insertByCalSchemeSql);
        String message = "";
        boolean isDownload = false;
        List list = (List)param.get("errList");
        String messageSuccess = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label1", (Locale)ctx.getLocale());
        if (!isDelete && !isCover) {
            message = addCountNum == 0 ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label0", (Locale)ctx.getLocale()) : messageSuccess + addCountNum + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label2", (Locale)ctx.getLocale());
        } else if (isDelete && !isCover) {
            message = messageSuccess + addCountNum + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label3", (Locale)ctx.getLocale()) + list.size() + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label4", (Locale)ctx.getLocale()) + list.size();
            isDownload = true;
        } else if (isDelete && isCover) {
            message = messageSuccess + addCountNum + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label5", (Locale)ctx.getLocale()) + updateCountNum + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label3", (Locale)ctx.getLocale()) + list.size() + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label4", (Locale)ctx.getLocale()) + list.size();
            isDownload = true;
        } else if (!isDelete && isCover) {
            message = messageSuccess + addCountNum + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label5", (Locale)ctx.getLocale()) + updateCountNum + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpSchemePersonFacadeResource", (String)"label2", (Locale)ctx.getLocale());
        }
        String append = "";
        if (isDownload) {
            for (int i = 0; i < list.size(); ++i) {
                append = append + (String)((Map)list.get(i)).get("name") + ",";
            }
            String string = append = append.length() > 0 ? append.substring(0, append.length() - 1) : append;
            if (list.size() > 5) {
                String more = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label64", (Locale)ctx.getLocale());
                append = append + "\uff0c<a href='/shr/dynamic.do?handler=com.kingdee.shr.compensation.web.file.ImportHisPersonFileHandler&method=downloadTemplate&uipk=shr.compensation.cmpPersonWebDynamicList'>" + more + "</a>";
            }
        }
        CmpCalUtil.updateNewCalSchemeState(ctx, calSchemeId);
        return message + append;
    }

    private HashMap<String, Object> convertRowSetToMap(IRowSet rowSet) throws SQLException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("person.id", rowSet.getString("person.id"));
        res.put("adminorgunit.id", rowSet.getString("adminorgunit.id"));
        res.put("adminorgunit.longnumber", rowSet.getString("adminorgunit.longnumber"));
        res.put("position.id", rowSet.getString("position.id"));
        res.put("job.id", rowSet.getString("job.id"));
        res.put("emporgrelation.id", rowSet.getString("emporgrelation.id"));
        res.put("emptype.id", rowSet.getString("emptype.id"));
        res.put("person.name", rowSet.getString("person.name"));
        res.put("person.number", rowSet.getString("person.number"));
        res.put("cmpemporelation.id", rowSet.getString("cmpemporelation.id"));
        res.put("cmpemporelation.leffectdate", rowSet.getString("cmpemporelation.leffectdate"));
        res.put("cmpEmpORelation.useDefault", rowSet.getString("cmpEmpORelation.useDefault"));
        return res;
    }

    private Object[] getExecuteBatchParam(Context ctx, Map<String, Object> map, CalSchemeInfo calSchemeInfo) {
        Date createTime = new Date(System.currentTimeMillis());
        java.util.Date endDate = calSchemeInfo.getEndDate();
        java.util.Date cmpEmpLeffectDate = CmpDateUtil.toDate(map.get("cmpemporelation.leffectdate"));
        Object[] executeBatchParam = new Object[]{map.get("person.id"), calSchemeInfo.getId().toString(), calSchemeInfo.getCmpPeriodType().getValue(), calSchemeInfo.getTaxUnit() == null ? null : calSchemeInfo.getTaxUnit().getId().toString(), calSchemeInfo.getPeriodYear(), calSchemeInfo.getPeriodMonth(), calSchemeInfo.getCalTime(), calSchemeInfo.getBeginDate(), endDate, map.get("adminorgunit.id"), map.get("adminorgunit.longnumber"), map.get("adminorgunit.id"), map.get("position.id"), map.get("job.id"), map.get("emporgrelation.id"), map.get("emptype.id"), (String)map.get("person.name"), (String)map.get("person.number"), HRFilterUtils.getCurrentUserId((Context)ctx), createTime, HRFilterUtils.getCurrentUserId((Context)ctx), createTime, map.get("cmpemporelation.id"), calSchemeInfo.getHrOrgUnit().getId().toString(), endDate.compareTo(cmpEmpLeffectDate) > 0 ? CmpDateUtil.toSqlDate(cmpEmpLeffectDate) : endDate, 0, map.get("cmpEmpORelation.useDefault"), null == calSchemeInfo.getCurrency() ? null : calSchemeInfo.getCurrency().getId().toString(), null == calSchemeInfo.getExchangeTable() ? null : calSchemeInfo.getExchangeTable().getId().toString(), null == calSchemeInfo.getExchangeRule() ? null : Integer.valueOf(calSchemeInfo.getExchangeRule().getValue())};
        return executeBatchParam;
    }

    private String getAddPeronSql(Context ctx) {
        StringBuffer addPersonSql = new StringBuffer();
        String l = LocaleUtils.getShortCode((Context)ctx);
        addPersonSql.append("Insert into T_HR_SCmpCalTable(");
        addPersonSql.append("FID, FPersonID, FCalSchemeID, FCmpPeriodType, FTaxUnitID,");
        addPersonSql.append("FPeriodYear, FPeriodMonth, FCalTime, FBeginDate, FEndDate, FCalState, FIsLockOtherSysData, FCalUpdateType,");
        addPersonSql.append("FAdminOrgUnitID, FLongNumber, FCostBearOrgID, FCmpCalOrgID, FPositionID, FJobID,");
        addPersonSql.append("FEmpPosOrgRelationID, FEmployeeTypeID,");
        addPersonSql.append("FName_" + l + ", FNumber,FDescription_l1, FDescription_l2,FDescription_l3, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, ");
        addPersonSql.append("FCmpEmpORelationID,FHrOrgUnitID,FRealEndDate,FIsCostBear, FUseDefault, FCurrencyID, FExchangeTableID, FExchangeRule, FisNotNeedCal)");
        addPersonSql.append("values(");
        addPersonSql.append("newbosid('269E3024'), ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("1, ");
        addPersonSql.append("0, ");
        addPersonSql.append("1, ");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("null, ");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?,\t");
        addPersonSql.append("?, ");
        addPersonSql.append("'" + CalTableDesTypeEnum.PERSONWEB.getAlias(LocaleUtils.locale_en_US) + "', ");
        addPersonSql.append("'" + CalTableDesTypeEnum.PERSONWEB.getAlias(LocaleUtils.locale_zh_CN) + "', ");
        addPersonSql.append("'" + CalTableDesTypeEnum.PERSONWEB.getAlias(LocaleUtils.locale_zh_TW) + "', ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("?, ");
        addPersonSql.append("0 ");
        addPersonSql.append(")");
        return addPersonSql.toString();
    }
}

