/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AgentPayBillFactory;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.IAgentPayBill;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryCollection;
import com.kingdee.shr.compensation.CmpAgentPayBillException;
import com.kingdee.shr.compensation.CmpAgentPayBillFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.CmpBillStatusEnum;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.PaymentCompany;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillCreating;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCmpAgentPayBillEASCreating
extends AbstractCmpAgentPayBillCreating {
    protected Map<String, BEBankInfo> recBankMap = new HashMap<String, BEBankInfo>();

    @Override
    protected void initPayBillInfo(Context ctx, Map param) throws BOSException, EASBizException {
        super.initPayBillInfo(ctx, param);
        if (this.hasCmpAgentPayBillSchemeInfo() && PaymentCompany.OptionalPayOrg.equals((Object)this.getCmpAgentPayBillSchemeInfoNotNull().getPaymentCompany())) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION13);
        }
        try {
            this.assembleRecBankMap(ctx);
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void assembleRecBankMap(Context ctx) throws BOSException, SQLException {
        String sql = "select fname_" + LocaleUtils.getShortCode((Context)ctx) + " bankName, FBeProvince recProvince, FBeCity recCity, fid bankId from t_be_bebank";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        BEBankInfo bankInfo = null;
        while (rowSet.next()) {
            bankInfo = new BEBankInfo();
            String bankId = rowSet.getString("bankId");
            String bankName = rowSet.getString("bankName");
            String recProvince = rowSet.getString("recProvince");
            String recCity = rowSet.getString("recCity");
            bankInfo.setId(BOSUuid.read((String)bankId));
            bankInfo.setName(bankName);
            bankInfo.setBeProvince(recProvince);
            bankInfo.setBeCity(recCity);
            this.recBankMap.put(bankName, bankInfo);
        }
    }

    protected void buildAndSavePayBill(Context ctx, Map param, String key, EASEntryGroups entryGroups) throws EASBizException, BOSException {
        String currencyId = this.getCurrencyId(key, entryGroups);
        CmpAgentPayBillInfo cmpPayBillInfo = this.buildEASCmpPayBill(ctx, key, param, entryGroups);
        this.fillCmpBillPayOrg(cmpPayBillInfo, key);
        this.fillSplitInfo(cmpPayBillInfo, key);
        AgentPayBillInfo agentPayBillInfo = new AgentPayBillInfo();
        CurrencyInfo currentcy = new CurrencyInfo();
        currentcy.setId(BOSUuid.read((String)currencyId));
        agentPayBillInfo.setCurrency(currentcy);
        CompanyOrgUnitInfo companyOrgUnitInfo = entryGroups.getOrgIdAndPayOrgMap().get(this.getOrgIdFromSplitKey(key));
        if (companyOrgUnitInfo == null) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION9);
        }
        agentPayBillInfo.setCompany(companyOrgUnitInfo);
        agentPayBillInfo.setBillStatus(BillStatusEnum.SAVE);
        agentPayBillInfo.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        agentPayBillInfo.setSourceType(SourceTypeEnum.SHR);
        agentPayBillInfo.put("entrys", (Object)entryGroups.getCashEntrysGroup().get(key));
        IAgentPayBill agentPayBillInstance = AgentPayBillFactory.getLocalInstance((Context)ctx);
        IObjectPK agentPayId = agentPayBillInstance.save((CoreBaseInfo)agentPayBillInfo);
        agentPayBillInfo.setCount(agentPayBillInfo.getEntrys().size());
        agentPayBillInfo.setSourceBillId(cmpPayBillInfo.getId().toString());
        agentPayBillInstance.update(agentPayId, (CoreBaseInfo)agentPayBillInfo);
        agentPayBillInfo = agentPayBillInstance.getAgentPayBillInfo(agentPayId);
        cmpPayBillInfo.setCashBillId(agentPayId.toString());
        cmpPayBillInfo.setCashBillNum(agentPayBillInfo.getNumber());
        this.putPayBillSumAmount(cmpPayBillInfo, entryGroups, key);
        cmpPayBillInfo.put("entry", (Object)entryGroups.getCmpEntrysGroup().get(key));
        CmpAgentPayBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)cmpPayBillInfo);
    }

    protected CmpAgentPayBillInfo buildEASCmpPayBill(Context ctx, String key, Map param, EASEntryGroups entryGroups) throws EASBizException, BOSException {
        return null;
    }

    protected String getCurrencyId(String key, EASEntryGroups entryGroups) {
        return null;
    }

    protected Map<String, CompanyOrgUnitInfo> getOrgIdAndPayOrgMap(Context ctx, Map<String, CmpAgentPayBillEntryCollection> cmpEntrysGroup) throws BOSException, EASBizException {
        HashMap<String, CompanyOrgUnitInfo> orgIdAndPayOrgMap = new HashMap<String, CompanyOrgUnitInfo>();
        for (String key : cmpEntrysGroup.keySet()) {
            orgIdAndPayOrgMap.put(this.getOrgIdFromSplitKey(key), null);
        }
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection("where id in ('" + StringUtils.join((Object[])orgIdAndPayOrgMap.keySet().toArray(), (String)"','") + "')");
        for (int i = 0; i < coll.size(); ++i) {
            orgIdAndPayOrgMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        return orgIdAndPayOrgMap;
    }

    @Override
    protected CmpAgentPayBillInfo buildCmpPayBill(Context ctx, Map param, CmpItemInfo cmpItemInfo, String currencyId) throws EASBizException, BOSException {
        CmpAgentPayBillInfo info = super.buildCmpPayBill(ctx, param, cmpItemInfo, currencyId);
        info.setState(CmpBillStatusEnum.SAVE);
        return info;
    }

    protected void assembleOptionalPayOrgInfo(StringBuilder splitFiledkeyBuilder) throws EASBizException {
        throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION10);
    }

    public static class EASEntryGroups
    extends AbstractCmpAgentPayBillCreating.EntryGroups {
        private Map<String, CompanyOrgUnitInfo> orgIdAndPayOrgMap;

        public Map<String, CompanyOrgUnitInfo> getOrgIdAndPayOrgMap() {
            return this.orgIdAndPayOrgMap;
        }

        public void setOrgIdAndPayOrgMap(Map<String, CompanyOrgUnitInfo> orgIdAndPayOrgMap) {
            this.orgIdAndPayOrgMap = orgIdAndPayOrgMap;
        }
    }
}

