/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.budget.AbstractSchemeDeduConfigControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetDeductionConfig;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigCollection;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigFactory;
import com.kingdee.shr.compensation.app.budget.SchemeDeduConfigInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class SchemeDeduConfigControllerBean
extends AbstractSchemeDeduConfigControllerBean {
    @Override
    protected BatchMessageTipsHeader _batchDelete(Context ctx, String submitSchemeId, String deductionConfigIds) throws BOSException {
        BatchMessageTipsHeader tips = new BatchMessageTipsHeader();
        tips.setBillId(deductionConfigIds);
        List<String> deductionConfigIdList = Arrays.asList(deductionConfigIds.split(","));
        String oql = "where calSubmitScheme.id = '" + submitSchemeId + "' order by deduNode";
        SchemeDeduConfigCollection configBeforeDel = SchemeDeduConfigFactory.getLocalInstance(ctx).getSchemeDeduConfigCollection(oql);
        HashSet<String> deleteDirectly = new HashSet<String>();
        Map<String, List<String>> submitItem2Relation = this.getSubmitItem2Config(configBeforeDel);
        for (Map.Entry<String, List<String>> entry : submitItem2Relation.entrySet()) {
            List<String> ids = entry.getValue();
            if (!this.isRemoveAllSubmitItemConfig(deductionConfigIdList, ids)) continue;
            deleteDirectly.addAll(ids);
        }
        Map<String, String> id2BudgetItem = this.getId2BudgetItem(configBeforeDel);
        List<BudgetDeductionConfig> budget2Rel = this.getBudgetStdRelation(ctx, submitSchemeId);
        int success = 0;
        int failed = 0;
        ArrayList<String> list = new ArrayList<String>();
        String msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label33", (Locale)ctx.getLocale());
        for (String toDel : deductionConfigIdList) {
            boolean successful;
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(toDel);
            tips.addResult(body);
            if (deleteDirectly.contains(toDel)) {
                ++success;
                successful = true;
                list.add(toDel);
                body.setMuitTipsMessage(msg);
            } else {
                String budgetItem = id2BudgetItem.get(toDel);
                Optional<BudgetDeductionConfig> optional = budget2Rel.stream().filter(e -> e.getBudgetItemId().equals(budgetItem)).findAny();
                if (optional.isPresent()) {
                    String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label80", (Locale)ctx.getLocale());
                    errMsg = MessageFormat.format(errMsg, String.join((CharSequence)",", optional.get().getSubmitSchemeNames()));
                    ++failed;
                    successful = false;
                    body.setMuitTipsMessage(errMsg);
                } else {
                    ++success;
                    successful = true;
                    list.add(toDel);
                    body.setMuitTipsMessage(msg);
                }
            }
            body.setMuitTipsState(successful);
        }
        tips.setSuccessCount(success);
        tips.setFailureCount(failed);
        if (!list.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_SSchemeDeduConfig where fid in (" + CmpStrUtil.convertListToString(list) + ")"));
            this.resetOffsetNode(ctx, configBeforeDel, list);
        }
        return tips;
    }

    private void resetOffsetNode(Context ctx, SchemeDeduConfigCollection configBeforeDel, List<String> list) throws BOSException {
        List configList;
        if (configBeforeDel.size() == list.size()) {
            return;
        }
        HashMap<String, List> groups = new HashMap<String, List>();
        for (int i = 0; i < configBeforeDel.size(); ++i) {
            SchemeDeduConfigInfo info = configBeforeDel.get(i);
            if (list.contains(info.getId().toString())) continue;
            String submitItemId = info.getCalSubmitItem().getId().toString();
            configList = groups.computeIfAbsent(submitItemId, e -> new ArrayList());
            configList.add(info);
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map.Entry entry : groups.entrySet()) {
            configList = (List)entry.getValue();
            int size = configList.size();
            ((SchemeDeduConfigInfo)configList.get(size - 1)).setOffsetNode(null);
            Object[] param1 = new Object[]{null, ((SchemeDeduConfigInfo)configList.get(size - 1)).getId().toString()};
            params.add(param1);
            for (int j = size - 1; j > 0; --j) {
                int offsetNode = ((SchemeDeduConfigInfo)configList.get(j)).getDeduNode().getValue();
                String id = ((SchemeDeduConfigInfo)configList.get(j - 1)).getId().toString();
                Object[] param2 = new Object[]{offsetNode, id};
                params.add(param2);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)"update t_hr_sSchemeDeduConfig set fOffsetNode = ? where fid = ?", params);
    }

    private Map<String, String> getId2BudgetItem(SchemeDeduConfigCollection configBeforeDel) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < configBeforeDel.size(); ++i) {
            String budgetItem = configBeforeDel.get(i).getCmpBudgetItem().getId().toString();
            String id = configBeforeDel.get(i).getId().toString();
            map.put(id, budgetItem);
        }
        return map;
    }

    private boolean isRemoveAllSubmitItemConfig(List<String> deductionConfigIds, List<String> ids) {
        for (String id : ids) {
            if (deductionConfigIds.contains(id)) continue;
            return false;
        }
        return true;
    }

    private Map<String, List<String>> getSubmitItem2Config(SchemeDeduConfigCollection configBeforeDel) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (int i = 0; i < configBeforeDel.size(); ++i) {
            String submitItem = configBeforeDel.get(i).getCalSubmitItem().getId().toString();
            List list = map.computeIfAbsent(submitItem, k -> new ArrayList());
            list.add(configBeforeDel.get(i).getId().toString());
        }
        return map;
    }

    @Override
    protected BatchMessageTipsHeader _saveList(Context ctx, String calSubmitSchemeId, String submitData) throws BOSException {
        List list = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)submitData, List.class);
        BatchMessageTipsHeader tips = new BatchMessageTipsHeader();
        if (null == list) {
            return tips;
        }
        StringBuilder billId = new StringBuilder();
        for (Map e : list) {
            if (list.indexOf(e) > 0) {
                billId.append(",");
            }
            String id = (String)e.get("id");
            billId.append(id);
        }
        tips.setBillId(billId.toString());
        List<BudgetDeductionConfig> budget2Rel = this.getBudgetStdRelation(ctx, calSubmitSchemeId);
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
        Map<String, List<Map<String, Object>>> groups = this.groupAndSort(list);
        Map<String, String> errMap = this.checkSchemeDeductionConfig(ctx, budget2Rel, groups);
        int success = 0;
        int failed = 0;
        for (Map map : list) {
            boolean successful;
            String id = (String)map.get("id");
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            body.setId(id);
            tips.addResult(body);
            String errMsg = errMap.get(id);
            if (null != errMsg) {
                successful = false;
                ++failed;
            } else {
                ++success;
                successful = true;
                errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label35", (Locale)ctx.getLocale());
                String calSubmitItemId = (String)map.get("calSubmitItem.id");
                String cmpBudgetItemId = (String)map.get("templateStbItem.cmpBudgetItem.id");
                String templateStbItemId = (String)map.get("templateStbItem.id");
                Integer deduNode = SchemeDeduConfigControllerBean.getIntValue(map.get("deduNode"));
                Integer rollBackNode = SchemeDeduConfigControllerBean.getIntValue(map.get("rollBackNode"));
                Integer offsetNode = SchemeDeduConfigControllerBean.getIntValue(map.get("offsetNode"));
                if (CmpStrUtil.isNumber(id)) {
                    Object[] insertParam = new Object[]{calSubmitItemId, cmpBudgetItemId, templateStbItemId, deduNode, rollBackNode, offsetNode, calSubmitSchemeId, userId};
                    insertParams.add(insertParam);
                } else {
                    Object[] updateParam = new Object[]{calSubmitItemId, cmpBudgetItemId, templateStbItemId, deduNode, rollBackNode, offsetNode, calSubmitSchemeId, userId, id};
                    updateParams.add(updateParam);
                }
            }
            body.setMuitTipsState(successful);
            body.setMuitTipsMessage(errMsg);
        }
        tips.setFailureCount(failed);
        tips.setSuccessCount(success);
        this.saveData(ctx, insertParams, updateParams);
        String oql = "where calSubmitScheme.id = '" + calSubmitSchemeId + "' order by deduNode";
        SchemeDeduConfigCollection cfgList = SchemeDeduConfigFactory.getLocalInstance(ctx).getSchemeDeduConfigCollection(oql);
        this.resetOffsetNode(ctx, cfgList, new ArrayList<String>());
        return tips;
    }

    private Map<String, String> checkSchemeDeductionConfig(Context ctx, List<BudgetDeductionConfig> budget2Rel, Map<String, List<Map<String, Object>>> groups) {
        HashMap<String, String> errMap = new HashMap<String, String>();
        for (Map.Entry<String, List<Map<String, Object>>> entry : groups.entrySet()) {
            List<Map<String, Object>> group = entry.getValue();
            String budgetItemId = (String)group.get(0).get("templateStbItem.cmpBudgetItem.id");
            Optional<BudgetDeductionConfig> optional = budget2Rel.stream().filter(e -> e.getBudgetItemId().equals(budgetItemId)).findFirst();
            if (!optional.isPresent()) continue;
            List<String> existedRelations = optional.get().getRelationIds();
            List relations = group.stream().map(e -> (String)e.get("templateStbItem.id")).collect(Collectors.toList());
            List<String> ids = group.stream().map(e -> (String)e.get("id")).collect(Collectors.toList());
            if (existedRelations.size() != relations.size()) {
                String msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label79", (Locale)ctx.getLocale());
                String finalMsgTemplate = MessageFormat.format(msgTemplate, String.join((CharSequence)",", optional.get().getSubmitSchemeNames()));
                ids.forEach(e -> errMap.put((String)e, finalMsgTemplate));
                continue;
            }
            for (int i = 0; i < existedRelations.size(); ++i) {
                if (((String)relations.get(i)).equals(existedRelations.get(i))) continue;
                String msgTemplate = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetMutiLangResource", (String)"label79", (Locale)ctx.getLocale());
                String finalMsgTemplate = MessageFormat.format(msgTemplate, String.join((CharSequence)",", optional.get().getSubmitSchemeNames()));
                ids.forEach(e -> errMap.put((String)e, finalMsgTemplate));
            }
        }
        return errMap;
    }

    protected List<BudgetDeductionConfig> getBudgetStdRelation(Context ctx, String calSubmitSchemeId) throws BOSException {
        String language = LocaleUtils.getShortCode((Context)ctx);
        String schemeDeductionConfigSQL = "select sdc.FCalSubmitSchemeID schemeId, sdc.FCalSubmitItemID submitItem, sdc.FCmpBudgetItemID, sdc.FTemplateStbItemID, sdc.FDeduNode, css.fName_" + language + " schemeName from T_HR_SSchemeDeduConfig sdc  inner join T_HR_SCalSubmitScheme css on sdc.FCalSubmitSchemeID = css.fid where css.fBudgetTemplateId = (select fBudgetTemplateId from T_HR_SCalSubmitScheme where fid = ?) and css.fid != ? order by schemeId, submitItem, FDeduNode";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)schemeDeductionConfigSQL, (Object[])new Object[]{calSubmitSchemeId, calSubmitSchemeId});
        ArrayList<BudgetDeductionConfig> list = new ArrayList<BudgetDeductionConfig>();
        try {
            while (rs.next()) {
                BudgetDeductionConfig config;
                String budgetItemId = rs.getString("FCmpBudgetItemID");
                String relId = rs.getString("FTemplateStbItemID");
                Optional<BudgetDeductionConfig> optional = list.stream().filter(e -> e.getBudgetItemId().equals(budgetItemId)).findAny();
                if (!optional.isPresent()) {
                    config = new BudgetDeductionConfig();
                    config.setBudgetItemId(budgetItemId);
                    config.getRelationIds().add(relId);
                    list.add(config);
                } else {
                    config = optional.get();
                    if (!config.getRelationIds().contains(relId)) {
                        config.getRelationIds().add(relId);
                    }
                }
                config.getSubmitSchemeNames().add(rs.getString("schemeName"));
            }
        }
        catch (SQLException e2) {
            throw new BOSException((Throwable)e2);
        }
        return list;
    }

    private Map<String, List<Map<String, Object>>> groupAndSort(List<Map<String, Object>> list) {
        return list.stream().sorted(Comparator.comparing(e -> Integer.parseInt((String)e.get("deduNode")))).collect(Collectors.groupingBy(e -> (String)e.get("calSubmitItem.id")));
    }

    protected void saveData(Context ctx, List<Object[]> insertParams, List<Object[]> updateParams) throws BOSException {
        if (!insertParams.isEmpty()) {
            String insertSQL = "insert into T_HR_SSchemeDeduConfig (FCalSubmitItemID, FCmpBudgetItemId, FTemplateStbItemId, FDeduNode, FRollBackNode, FOffsetNode, FCalSubmitSchemeID, fCreatorId, fCreateTime, FIsPreset, fid) values (?,?,?,?,?,?,?,?,now(),0,newBosId('F0A7B920'))";
            DbUtil.executeBatch((Context)ctx, (String)insertSQL, insertParams);
        }
        if (!updateParams.isEmpty()) {
            String updateSQL = "update T_HR_SSchemeDeduConfig set FCalSubmitItemID = ?, FCmpBudgetItemId = ?, FTemplateStbItemId = ?, FDeduNode = ?, FRollBackNode = ?, FOffsetNode = ?, FCalSubmitSchemeID = ?, fLastUpdateUserId = ?, fLastUpdateTime = now() where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, updateParams);
        }
    }

    private static Integer getIntValue(Object val) {
        if (null == val || StringUtils.isEmpty((String)String.valueOf(val))) {
            return null;
        }
        return (int)Double.parseDouble(String.valueOf(val));
    }
}

