/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalFormulaCollection;
import com.kingdee.shr.compensation.CalFormulaFactory;
import com.kingdee.shr.compensation.CalFormulaInfo;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemCollection;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeItemInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataDot;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.CmpQueryConfigCollection;
import com.kingdee.shr.compensation.CmpQueryConfigFactory;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.ColumnAttributes;
import com.kingdee.shr.compensation.app.formula.data.DataRow;
import com.kingdee.shr.compensation.app.formula.data.DataSet;
import com.kingdee.shr.compensation.app.formula.data.DataTable;
import com.kingdee.shr.compensation.secret.SecretUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;

public class SalaryCalExecutor
extends Thread {
    private int precision = 2;
    private final String mainTableItemKey = "fid";
    private final String mainTableForeignKey = "FPERSONID";
    private String mainTableName = "T_HR_SCmpCalTable";
    private Context ctx;
    private String calMessage = "";
    private boolean isDataSecret = false;
    private CalSchemeInfo calScheme;
    private SalaryCalFunction calObj;
    private DataSet dataSet;
    private Set secColSet;
    private Map<String, Object> changeSqlMap = new HashMap<String, Object>();
    private boolean isExecuteFinished = false;
    private static final FunUtils util = new FunUtils();
    private double ext_finishedPer = 0.0;
    private final String maxDotString = "0.0000000000";
    private Map<String, Object> editedItems;
    private Set<String> submitRelySet = new HashSet<String>();

    public Map<String, Object> getChangeSqlList() {
        return this.changeSqlMap;
    }

    public SalaryCalExecutor() {
    }

    public SalaryCalExecutor(int precision, String mainTableName, Context ctx, String calMessage, boolean isDataSecret, CalSchemeInfo calScheme, SalaryCalFunction calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems) {
        String init = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"init", (Locale)ctx.getLocale());
        this.precision = precision;
        this.mainTableName = mainTableName;
        this.ctx = ctx;
        this.calMessage = init;
        this.isDataSecret = isDataSecret;
        this.calScheme = calScheme;
        this.calObj = calObj;
        this.dataSet = dataSet;
        this.secColSet = secColSet;
        this.editedItems = editedItems;
    }

    public boolean isExecuteFinished() {
        return this.isExecuteFinished;
    }

    @Override
    public void run() {
        try {
            this.changeSqlMap = this.doExecute();
            this.isExecuteFinished = true;
        }
        catch (Exception e) {
            this.changeSqlMap.put("errMsg", e.getMessage());
            this.changeSqlMap.put("changeSqlList", new ArrayList());
            e.printStackTrace();
            this.isExecuteFinished = true;
        }
    }

    public Map<String, BizEnumValueCollection> getEnumProperty() {
        HashMap<String, BizEnumValueCollection> map = new HashMap<String, BizEnumValueCollection>();
        CmpQueryConfigCollection coll = null;
        try {
            coll = CmpQueryConfigFactory.getLocalInstance(this.ctx).getCmpQueryConfigCollection("select structure.* ");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < coll.size(); ++i) {
            String entityName;
            if (null == coll.get(i).getStructure() || CmpStrUtil.isEmpty(entityName = coll.get(i).getStructure().getEntityName())) continue;
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            if (entityInfo == null || entityInfo.getProperties() == null) {
                System.out.println("----enumEntity not found----" + entityName);
                continue;
            }
            PropertyCollection properties = entityInfo.getProperties();
            for (int k = 0; k < properties.size(); ++k) {
                String dataType;
                PropertyInfo propertyInfo = properties.get(k);
                IStateManager stateManager = propertyInfo.getStateManager();
                if (null == stateManager.getStateValue("dataType") || !"Enum".equalsIgnoreCase(dataType = stateManager.getStateValue("dataType").toString())) continue;
                String dataRef = stateManager.getStateValue("metadataRef").toString();
                BizEnumInfo enumInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)dataRef));
                BizEnumValueCollection enumValueColl = enumInfo.getEnumValue();
                map.put(entityInfo.getTable().getName().toUpperCase(Locale.ENGLISH) + "_" + propertyInfo.getMappingField().getName().toUpperCase(Locale.ENGLISH), enumValueColl);
            }
        }
        return map;
    }

    private Map<String, Object> doExecute() throws Exception {
        Map<String, Object> cnSn;
        HashMap<String, String> socRecordMap = new HashMap<String, String>();
        String caltableid = null;
        String personid = null;
        DataTable mainTable = this.dataSet.getTables(this.mainTableName);
        HashMap<String, Object> paras = new HashMap<String, Object>();
        ArrayList<String> changeSqlList = new ArrayList<String>();
        ArrayList<String> budgetChangeList = new ArrayList<String>();
        ArrayList<Object[]> submitRelyList = new ArrayList<Object[]>();
        HashMap<String, Set<String>> submitDataStateMap = new HashMap<String, Set<String>>();
        HashMap<String, Set> stopCalReferMap = new HashMap<String, Set>();
        HashMap<String, Object> changeSqlMap = new HashMap<String, Object>();
        String errMsg = "";
        String attName = "";
        String columnName = "";
        changeSqlMap.put("errMsg", errMsg);
        changeSqlMap.put("changeSqlList", new ArrayList());
        int rowCount = mainTable.rowCount();
        HashMap<String, String> personMap = new HashMap<String, String>();
        StringBuilder str = new StringBuilder();
        String lanType = this.calScheme.getLanType().getValue();
        str.append("select calTable.FPersonId as personId, person.FName_" + lanType + " as personName ");
        str.append("from T_HR_SCmpCalTable calTable ");
        str.append("inner join T_BD_Person person on calTable.FPersonId = person.Fid ");
        str.append("and calTable.FCalSchemeId = '");
        str.append(this.calScheme.getId().toString());
        str.append("' and calTable.FPeriodYear = " + this.calScheme.getPeriodYear());
        str.append(" and calTable.FPeriodMonth = " + this.calScheme.getPeriodMonth());
        str.append(" and calTable.FCalTime = " + this.calScheme.getCalTime());
        str.append(" and calTable.FCalState in (1,2,3,4,5,6,7) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)str.toString());
        while (rowSet.next()) {
            personMap.put(rowSet.getString("personId"), rowSet.getString("personName"));
        }
        Map<String, BizEnumValueCollection> enumMap = this.getEnumProperty();
        List<DataRow> datas = mainTable.datas;
        FunUtils.setSessionMap("getCalItemSetKey_" + this.calScheme.getId().toString(), null);
        String getCnSnMapKey = "getCnSnMapKey_" + this.calScheme.getId().toString();
        FunUtils.setSessionMap(getCnSnMapKey, null);
        if (FunUtils.getSessionMap(getCnSnMapKey) == null) {
            cnSn = this.getCnSn(this.calScheme.getId().toString());
            FunUtils.setSessionMap(getCnSnMapKey, cnSn);
        } else {
            cnSn = (Map<String, Object>)FunUtils.getSessionMap(getCnSnMapKey);
        }
        long l1 = System.currentTimeMillis();
        System.out.println("-----------calAppend-----begin---");
        long rwSum = 0L;
        long dsSum = 0L;
        long calSum = 0L;
        if (datas != null) {
            int size = datas.size();
            for (int index = 0; index < size; ++index) {
                String calId;
                ColumnAttributes att;
                paras.clear();
                DataRow mtDataRow = mainTable.getRows(index);
                if (mtDataRow == null) continue;
                long rw1 = System.currentTimeMillis();
                for (int loop = 0; loop < mtDataRow.columnCount(); ++loop) {
                    att = mtDataRow.getColumns(loop);
                    if (att.getName().equalsIgnoreCase("fid")) {
                        caltableid = (String)mtDataRow.getValue(loop);
                    }
                    if (att.getName().equalsIgnoreCase("FPERSONID")) {
                        personid = (String)mtDataRow.getValue(loop);
                    }
                    if (this.isDataSecret && mtDataRow.getValue(loop) != null && this.secColSet.contains(att.getName().toUpperCase(Locale.ENGLISH))) {
                        BigDecimal val = SecretUtil.decode(this.ctx, (BigDecimal)mtDataRow.getValue(loop), personid);
                        paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(Locale.ENGLISH), val);
                        mtDataRow.setValue(loop, (Object)val);
                    }
                    if (att.isVar()) {
                        paras.put(att.getName().toUpperCase(Locale.ENGLISH), mtDataRow.getValue(loop));
                        continue;
                    }
                    if (!att.getName().contains(".")) {
                        paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(Locale.ENGLISH), mtDataRow.getValue(loop));
                    }
                    if (!att.getName().toUpperCase(Locale.ENGLISH).contains("CMP_CTB.S")) continue;
                    paras.put((this.mainTableName + "_" + att.getName().toUpperCase(Locale.ENGLISH).replace("CMP_CTB.", "")).toUpperCase(Locale.ENGLISH), mtDataRow.getValue(loop));
                }
                long rw2 = System.currentTimeMillis();
                rwSum += rw2 - rw1;
                long ds1 = System.currentTimeMillis();
                for (int loop = 0; loop < this.dataSet.tableCount(); ++loop) {
                    DataRow dataRow;
                    DataTable tb = this.dataSet.getTables(loop);
                    String tableName = tb.tablename.split("~")[0].toUpperCase(Locale.ENGLISH);
                    String tbAndNum = tb.tablename.indexOf("~") != -1 ? tb.tablename.replace("~", "_") : tb.tablename;
                    if (this.mainTableName.equals(tbAndNum) || null == (dataRow = tb.getDataRow(caltableid))) continue;
                    for (int i = 0; i < dataRow.columnCount(); ++i) {
                        att = dataRow.getColumns(i);
                        Object value = dataRow.getValue(i);
                        columnName = (att.getName().contains(".") ? att.getName().split("\\.")[att.getName().split("\\.").length - 1] : att.getName()).toUpperCase(Locale.ENGLISH);
                        if (enumMap.containsKey(tableName + "_" + columnName) && null != value) {
                            BizEnumValueCollection enumValueColl = enumMap.get(tableName + "_" + columnName);
                            for (int k = 0; k < enumValueColl.size(); ++k) {
                                if (enumValueColl.get(k) == null || !value.toString().equals(enumValueColl.get(k).getValue())) continue;
                                value = enumValueColl.get(k).getAlias();
                            }
                        }
                        if (this.calObj.getType().equals("test")) {
                            paras.put((tbAndNum + "_" + att.getName()).toUpperCase(Locale.ENGLISH), value);
                            continue;
                        }
                        if (tb.tablename.contains("~")) {
                            String structNum = tb.tablename.split("~")[1];
                            columnName = att.getName();
                            if (!structNum.toLowerCase(Locale.ENGLISH).equals(columnName.split("\\.")[0].toLowerCase(Locale.ENGLISH))) continue;
                        }
                        columnName = attName = att.getName();
                        if (attName.split("\\.").length > 1) {
                            columnName = attName.split("\\.")[1];
                        }
                        paras.put((tbAndNum + "_" + columnName).toUpperCase(Locale.ENGLISH), value);
                    }
                }
                long ds2 = System.currentTimeMillis();
                dsSum += ds2 - ds1;
                this.addEditedItem(caltableid, paras);
                long cal1 = System.currentTimeMillis();
                try {
                    this.calObj.setParamMap(paras);
                    paras.put("ThisParamUsedForAnalasysTimePrint", this.ctx.get((Object)"shr_cmp_compensation_cal_spend_time_print"));
                    paras.put("ThisParamUsedForAnalasysTimeIsLastPerson", index == size - 1);
                    this.calObj.getClass().getMethod("calculate", HashMap.class).invoke((Object)this.calObj, paras);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("======" + e.getMessage());
                    System.out.println("======" + e);
                    this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            e.printStackTrace();
                        }
                    });
                    String calFormulaName = null == e.getMessage() ? e.getCause().toString() : e.getMessage();
                    calFormulaName = calFormulaName.substring(calFormulaName.indexOf("{") + 1, calFormulaName.indexOf("}"));
                    errMsg = null != personid ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label2", (Locale)this.ctx.getLocale()) + "\uff1a" + (String)personMap.get(personid) + "\uff0c" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label3", (Locale)this.ctx.getLocale()) + "\uff1a" + calFormulaName + EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label4", (Locale)this.ctx.getLocale()) + "<br>" : EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalFacadeResource", (String)"label1", (Locale)this.ctx.getLocale()) + "<br>" + e;
                    changeSqlMap.put("errMsg", errMsg);
                }
                this.addSubmitRelyData(submitRelyList, submitDataStateMap, (Map)cnSn.get("fieldSnAndId"), paras, caltableid);
                String changeSql = this.getChangeSql(mtDataRow, paras, this.secColSet, cnSn);
                if (changeSql != null && changeSql.length() > 0) {
                    changeSqlList.add(changeSql);
                    changeSqlMap.put("changeSqlList", changeSqlList);
                    budgetChangeList.add(caltableid);
                }
                this.ext_finishedPer = 50.0 / (double)rowCount * (double)index;
                if (paras.get("socRecordId") != null) {
                    calId = (String)paras.get("T_HR_SCMPCALTABLE_FID");
                    socRecordMap.put(calId, paras.get("socRecordId").toString());
                }
                if (paras.get("stopCalPersonId") != null) {
                    calId = (String)paras.get("T_HR_SCMPCALTABLE_FID");
                    stopCalReferMap.put(calId, (Set)paras.get("stopCalPersonId"));
                }
                long cal2 = System.currentTimeMillis();
                calSum += cal2 - cal1;
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("-----------Calculation and assembly-----end---" + (l2 - l1));
        System.out.println("-----------Assembly data parameters-------" + rwSum);
        System.out.println("-----------Fill in other tables------" + dsSum);
        System.out.println("-----------Calculation-------" + calSum);
        Hashtable<String, String> socPayTempDatas = this.dataSet.getSocPayTempDatas();
        changeSqlMap.put("socRecordMap", socRecordMap);
        changeSqlMap.put("socPayTempDatas", socPayTempDatas);
        changeSqlMap.put("submitRelyList", submitRelyList);
        changeSqlMap.put("submitDataStateMap", submitDataStateMap);
        changeSqlMap.put("stopCalReferMap", stopCalReferMap);
        changeSqlMap.put("budgetChangeList", budgetChangeList);
        return changeSqlMap;
    }

    private void addSubmitRelyData(List<Object[]> submitRelyList, Map<String, Set<String>> submitDataMap, Map<String, String> fieldAndIdMap, Map<String, Object> parasMap, String caltableid) {
        if (!parasMap.containsKey("SUBMITRELY")) {
            return;
        }
        Map paramRelayMap = (Map)parasMap.get("SUBMITRELY");
        for (Map.Entry entry : paramRelayMap.entrySet()) {
            String fieldSn = (String)entry.getKey();
            String cmpItemId = fieldAndIdMap.get(fieldSn);
            List reayDataList = (List)entry.getValue();
            if (null == reayDataList) continue;
            for (int i = 0; i < reayDataList.size(); ++i) {
                String basicItemId;
                Map relyDataMap = (Map)reayDataList.get(i);
                String submitTable = null == relyDataMap.get("SUBMITTABLE") ? null : relyDataMap.get("SUBMITTABLE").toString();
                String submitDataId = null == relyDataMap.get("SUBMITTABLEID") ? null : relyDataMap.get("SUBMITTABLEID").toString();
                String submitItemNum = relyDataMap.get("SUBMITNUMBER").toString();
                String string = basicItemId = null == relyDataMap.get("SUBMITITEMID") ? null : relyDataMap.get("SUBMITITEMID").toString();
                if (null != basicItemId) {
                    String key = caltableid + "_" + cmpItemId + "_" + submitTable + "_" + submitDataId + "_" + submitItemNum + "_" + basicItemId;
                    if (this.submitRelySet.contains(key)) continue;
                    this.submitRelySet.add(key);
                }
                Object[] param = new Object[]{BOSUuid.create((String)"B6E0B777").toString(), relyDataMap.get("SUBMITMONEY"), this.calScheme.getId().toString(), caltableid, cmpItemId, this.calScheme.getPeriodYear(), this.calScheme.getPeriodMonth(), this.calScheme.getCalTime(), submitDataId, submitTable, basicItemId, relyDataMap.get("SUBMITITEMTABLE"), parasMap.containsKey("T_HR_SCMPCALTABLE_" + fieldSn) ? parasMap.get("T_HR_SCMPCALTABLE_" + fieldSn) + "" : null, relyDataMap.get("ISBASIC"), submitItemNum, parasMap.get("T_HR_SCMPCALTABLE_FPERSONID")};
                submitRelyList.add(param);
                if (null == submitTable) continue;
                if (submitDataMap.containsKey(submitTable)) {
                    submitDataMap.get(submitTable).add(submitDataId);
                    continue;
                }
                HashSet<String> submitDataSet = new HashSet<String>();
                submitDataSet.add(submitDataId);
                submitDataMap.put(submitTable, submitDataSet);
            }
        }
    }

    private void addEditedItem(String caltableid, Map paras) throws BOSException, SQLException {
        if (this.editedItems == null) {
            return;
        }
        Map editedItem = (Map)this.editedItems.get(caltableid);
        if (editedItem != null) {
            for (String key : editedItem.keySet()) {
                paras.put(key, editedItem.get(key));
            }
        }
    }

    public String getChangeSql(DataRow rw, Map paras, Set secColSet, Map<String, Object> cnSn) throws BOSException, EASBizException {
        Set<String> set;
        int size = rw.columnCount();
        int pre = 10;
        String caltableid = (String)rw.getValue("fid");
        String personid = (String)rw.getValue("FPERSONID");
        String schemeID = this.calScheme.getId().toString();
        boolean isChange = false;
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("UPDATE ").append(this.mainTableName).append(" SET ");
        updateSql.append("FCalState = 4");
        updateSql.append(", FCalTaxDataState = case when FCalTaxDataState = 1 then 3 when FCalTaxDataState = 2 then 3 when FCalTaxDataState in (3,4) then 3 when FCalTaxDataState = 5 then 3 else 0 end");
        String getCnSnMapKey = "getCnSnMapKey_" + schemeID;
        if (FunUtils.getSessionMap(getCnSnMapKey) == null) {
            cnSn = this.getCnSn(schemeID);
            FunUtils.setSessionMap(getCnSnMapKey, cnSn);
        } else {
            cnSn = (Map)FunUtils.getSessionMap(getCnSnMapKey);
        }
        Map dataTypeMap = (Map)cnSn.get("dataTypeMap");
        Map dataDotMap = (Map)cnSn.get("dataDotMap");
        String getCalItemSetKey = "getCalItemSetKey_" + schemeID;
        if (FunUtils.getSessionMap(getCalItemSetKey) == null) {
            set = new HashSet();
            CalFormulaCollection collection = CalFormulaFactory.getLocalInstance(this.ctx).getCalFormulaCollection("select calItem where calScheme='" + schemeID + "' and isCal = 1");
            for (int i = 0; i < collection.size(); ++i) {
                CalFormulaInfo calFormulaInfo = collection.get(i);
                set.add(calFormulaInfo.getCalItem());
            }
            FunUtils.setSessionMap(getCalItemSetKey, set);
        } else {
            set = (Set)FunUtils.getSessionMap(getCalItemSetKey);
        }
        for (int index = 0; index < size; ++index) {
            String calValueStr;
            String orgValueStr;
            String key = rw.getColumns(index).getName().toUpperCase(Locale.ENGLISH);
            key = key.contains("CMP_CTB.") ? key.replace("CMP_CTB.", "") : key;
            String paraName = (this.mainTableName + "_" + key).toUpperCase(Locale.ENGLISH);
            Object orgValue = rw.getValue(index);
            Object calValue = paras.get(paraName);
            if (null == orgValue && !set.contains(key)) {
                calValue = null;
            }
            if (this.isEqual(orgValue, calValue) || key.contains(".")) continue;
            CmpItemDataType cmpItemDataType = (CmpItemDataType)((Object)dataTypeMap.get(key.toLowerCase(Locale.ENGLISH)));
            if (cmpItemDataType == CmpItemDataType.NUMBER) {
                CmpItemDataDot cmpItemDataDot = (CmpItemDataDot)((Object)dataDotMap.get(key.toLowerCase(Locale.ENGLISH)));
                pre = cmpItemDataDot.getValue();
                orgValueStr = this.getDoubleByScienNotation(orgValue, "0.0000000000");
                if (this.isEqual(orgValueStr, calValueStr = this.getDoubleByScienNotation(calValue, "0.0000000000"))) continue;
                calValueStr = this.getDoubleByScienNotation(calValue, cmpItemDataDot.toString());
            } else {
                orgValueStr = FunUtils.toString(orgValue);
                calValueStr = FunUtils.toString(calValue);
            }
            if (this.isEqual(orgValueStr, calValueStr)) continue;
            isChange = true;
            if (this.isDataSecret && secColSet.contains(key)) {
                try {
                    calValueStr = FunUtils.toString(SecretUtil.encode(this.ctx, FunUtils.toBigDecimal(calValueStr), personid));
                }
                catch (Exception e) {
                    calValueStr = "0";
                }
            }
            calValueStr = StringEscapeUtils.escapeSql((String)calValueStr);
            updateSql.append("," + key + " = '" + calValueStr + "'");
        }
        updateSql.append(" WHERE fid = '" + caltableid + "';");
        if (isChange) {
            return updateSql.toString();
        }
        return null;
    }

    private String getDoubleByScienNotation(Object obj, String cmpItemDataDot) {
        if (null == obj) {
            return null;
        }
        Double res = FunUtils.toBigDecimal(obj).doubleValue();
        DecimalFormat df = new DecimalFormat(cmpItemDataDot);
        return df.format(res);
    }

    private Map<String, Object> getCnSn(String cmpschemeid) throws BOSException {
        CmpItemCollection cmpItemCollection = new CmpItemCollection();
        String oql = "select id,name,number,cmpItem.id,cmpItem.name,cmpItem.number,cmpItem.fieldSn,cmpItem.dataDot,cmpItem.dataType,cmpItem.adminOrgUnit.id,cmpItem.adminOrgUnit.name,cmpItem.adminOrgUnit.number,cmpItem.adminOrgUnit.longNumber where calScheme.id = '" + cmpschemeid + "'  order by sortSn";
        CalSchemeItemCollection calSchemeItemcoll = CalSchemeItemFactory.getLocalInstance(this.ctx).getCalSchemeItemCollection(oql);
        for (int i = 0; i < calSchemeItemcoll.size(); ++i) {
            CalSchemeItemInfo calSchemeItemInfo = calSchemeItemcoll.get(i);
            CmpItemInfo cmpItem = calSchemeItemInfo.getCmpItem();
            cmpItemCollection.add(cmpItem);
        }
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        ArrayList<String> an = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, CmpItemDataType> dataTypeMap = new HashMap<String, CmpItemDataType>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        for (int j = 0; j < cmpItemCollection.size(); ++j) {
            CmpItemInfo cmpItemInfo = cmpItemCollection.get(j);
            CmpItemDataDot dataDot = cmpItemInfo.getDataDot();
            CmpItemDataType dataType = cmpItemInfo.getDataType();
            String name = cmpItemInfo.getName();
            int fieldSn = cmpItemInfo.getFieldSn();
            if (fieldSn <= 0) continue;
            String fieldName = "s" + fieldSn;
            an.add("T_HR_SCmpCalTable." + fieldName + " " + fieldName);
            sn.add(fieldName);
            cn.add(name);
            dataDotMap.put(fieldName, dataDot);
            dataTypeMap.put(fieldName, dataType);
            idItemMap.put(fieldName.toUpperCase(Locale.ENGLISH), cmpItemInfo.getId().toString());
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("an", an);
        res.put("coll", (Object)cmpItemCollection);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        return res;
    }

    public boolean isEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if ((a == null || StringUtils.isEmpty((String)a.toString())) && (b == null || StringUtils.isEmpty((String)b.toString()))) {
            return true;
        }
        if (a instanceof String) {
            return ((String)a).equals(b);
        }
        if (b instanceof String) {
            return ((String)b).equals(a);
        }
        if (a instanceof Double) {
            return ((Double)a).equals(b);
        }
        if (b instanceof Double) {
            return ((Double)b).equals(a);
        }
        if (a instanceof Number && a != null && b != null && ((Number)a).doubleValue() == ((Number)b).doubleValue()) {
            return true;
        }
        return a == b;
    }

    public double getExt_finishedPer() {
        return this.ext_finishedPer;
    }
}

