/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.common.CalculateTempMap;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.util.SqlUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SalaryCalFunction {
    private String calDate;
    private String schemeID;
    private String condition;
    private String type;
    private int precision = 2;
    private CalSchemeInfo calScheme;
    private HashMap<String, Object> tempMap = new CalculateTempMap<String, Object>();
    public Map<String, Object> paramMap = new HashMap<String, Object>();
    public Map<String, Object> calRecordMap = new HashMap<String, Object>();
    public Map<String, BigDecimal> currencyMap = new HashMap<String, BigDecimal>();
    public boolean isCurrency = false;
    public final String MAIN_ID = "T_HR_SCMPCALTABLE_FID";
    private static final Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
    public Context ctx;

    public String getCalDate() {
        return this.calDate;
    }

    public CalSchemeInfo getCalScheme() {
        return this.calScheme;
    }

    public String getMainTableRowFilter() {
        return this.condition;
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }

    public Map<String, Object> getCalRecordMap() {
        return this.calRecordMap;
    }

    public void setCalRecordMap(Map<String, Object> calRecordMap) {
        this.calRecordMap = calRecordMap;
    }

    public Map<String, BigDecimal> getCurrencyMap() {
        return this.currencyMap;
    }

    public void setCurrencyMap(Map<String, BigDecimal> currencyMap) {
        this.currencyMap = currencyMap;
    }

    public boolean isCurrency() {
        return this.isCurrency;
    }

    public void setCurrency(boolean isCurrency) {
        this.isCurrency = isCurrency;
    }

    public double getRound(double v) {
        return Double.parseDouble(FunctionTools.getRound(this.precision, v));
    }

    public String getSchemeID() {
        return this.schemeID;
    }

    public HashMap<String, Object> getTempMap() {
        return this.tempMap;
    }

    public boolean isEqual(double a, double b) {
        return a == b;
    }

    public boolean isEqual(Object a, Object b) {
        if (a instanceof String) {
            return ((String)a).equals(b);
        }
        if (b instanceof String) {
            return ((String)b).equals(a);
        }
        if (a instanceof Double) {
            return ((Double)a).equals(b);
        }
        if (b instanceof Double) {
            return ((Double)b).equals(a);
        }
        return a == b;
    }

    public boolean isEqual(String a, String b) {
        if (StringUtils.isEmpty((String)a) && StringUtils.isEmpty((String)b)) {
            return true;
        }
        if (a instanceof String) {
            return a.equals(b);
        }
        if (b instanceof String) {
            return b.equals(a);
        }
        return a == b;
    }

    public boolean isGtOrEql(double a, double b) {
        return a >= b;
    }

    public boolean isGtOrEql(String a, String b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return true;
        }
        return a.compareTo(b) >= 0;
    }

    public boolean isGtThn(double a, double b) {
        return a > b;
    }

    public boolean isGtThn(String a, String b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        return a.compareTo(b) > 0;
    }

    public boolean isLsOrEql(double a, double b) {
        return a <= b;
    }

    public boolean isLsOrEql(String a, String b) {
        if (a == null) {
            if (b == null) {
                return true;
            }
            return true;
        }
        if (b == null) {
            return false;
        }
        return a.compareTo(b) <= 0;
    }

    public boolean isLsThn(double a, double b) {
        return a < b;
    }

    public boolean isLsThn(String a, String b) {
        if (a == null) {
            return true;
        }
        if (b == null) {
            return false;
        }
        return a.compareTo(b) < 0;
    }

    public boolean include(String a, String b) {
        if (null == a) {
            return false;
        }
        if (null == b || "".equals(b.trim())) {
            return true;
        }
        return a.contains(b);
    }

    public void setCalDate(String calDate) {
        this.calDate = calDate;
    }

    public void setCalScheme(CalSchemeInfo calScheme) {
        this.calScheme = calScheme;
    }

    public void setMainTableRowFilter(String condition) {
        this.condition = condition;
    }

    public void setParamMap(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setSchemeID(String schemeID) {
        this.schemeID = schemeID;
    }

    public void setTempMap(HashMap<String, Object> tempMap) {
        this.tempMap = tempMap;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public double toDouble(Object obj) {
        if (obj == null) {
            return 0.0;
        }
        double v = 0.0;
        try {
            if (obj instanceof Double) {
                v = new BigDecimal(String.valueOf(obj)).doubleValue();
            }
            if (obj instanceof Integer) {
                v = ((Integer)obj).doubleValue();
            }
            if (obj instanceof Float) {
                v = ((Float)obj).doubleValue();
            }
            if (obj instanceof BigDecimal) {
                v = ((BigDecimal)obj).doubleValue();
            } else if (obj instanceof String && pattern.matcher(obj.toString()).matches()) {
                v = Double.valueOf(new String(obj.toString()));
            }
        }
        catch (Exception e) {
            try {
                v = Double.valueOf(new String(obj.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return v;
    }

    public String toString(Object obj) {
        try {
            if (obj == null) {
                return "";
            }
            if (obj instanceof String) {
                return obj.toString();
            }
            if (obj instanceof java.util.Date || obj instanceof Date) {
                return Tools.getInstance().formatDate((java.util.Date)obj);
            }
            return obj.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public double toDouble(double d) {
        return d;
    }

    public double toDouble(BigDecimal value) {
        if (null == value) {
            return 0.0;
        }
        return value.doubleValue();
    }

    public BigDecimal add(BigDecimal a, BigDecimal b) {
        if (null == a) {
            return b;
        }
        if (null == b) {
            return a;
        }
        return a.add(b);
    }

    public String add(String a, String b) {
        return a + b;
    }

    public BigDecimal subtract(BigDecimal a, BigDecimal b) {
        if (null == a && null == b) {
            return null;
        }
        if (null == a) {
            a = BigDecimal.ZERO;
        }
        if (null == b) {
            b = BigDecimal.ZERO;
        }
        return a.subtract(b);
    }

    public BigDecimal multiply(BigDecimal a, BigDecimal b) {
        if (null == a || null == b) {
            return null;
        }
        return a.multiply(b);
    }

    public BigDecimal divide(BigDecimal a, BigDecimal b) {
        if (null == a || null == b) {
            return null;
        }
        return a.divide(b, 1000, 6);
    }

    public BigDecimal getBigVal(Object value) {
        if (null == value) {
            return BigDecimal.ZERO;
        }
        if (value instanceof String) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Double) {
            return new BigDecimal(String.valueOf(value));
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getBigVal(double value) {
        return new BigDecimal(String.valueOf(value));
    }

    public BigDecimal getBigVal(int value) {
        return new BigDecimal(String.valueOf(value));
    }

    public BigDecimal getBigVal(BigDecimal value) {
        return value;
    }

    public List<IRowSet> executeQueryPaging(Context ctx, String sql) throws Exception {
        int columnSize;
        int exceptionNumber;
        int mod;
        ArrayList<IRowSet> result = new ArrayList<IRowSet>();
        IRowSet rs = null;
        String tempSql = "";
        if (sql.contains(" ")) {
            int orderIndex = 0;
            if (sql.contains("order by")) {
                orderIndex = sql.indexOf("order by");
            } else if (sql.contains("ORDER BY")) {
                orderIndex = sql.indexOf("ORDER BY");
            }
            tempSql = orderIndex > 0 ? sql.substring(0, orderIndex) : sql;
        }
        int pageSize = 0 == (mod = (exceptionNumber = JdbcRowSet.UPPER_CELLNUMBER_FOR_EXCEPTION) % (columnSize = (rs = DbUtil.executeQuery((Context)ctx, (String)("select TEMPTABLE.* from (" + tempSql + ") TEMPTABLE where 1<>1"))).getMetaData().getColumnCount() + 2)) ? exceptionNumber / columnSize + 1 : (exceptionNumber - mod) / columnSize;
        rs = DbUtil.executeQuery((Context)ctx, (String)("select count(*) counts from (" + tempSql + ")TEMPTABLE"));
        int rowTotalSize = 0;
        while (rs.next()) {
            rowTotalSize = rs.getInt("counts");
        }
        int totalPage = 1;
        if (rowTotalSize > pageSize) {
            totalPage = rowTotalSize / pageSize + 1;
        }
        int length = pageSize;
        PagingHelper pageHelper = new PagingHelper();
        String pagingSQL = "";
        for (int curPage = 1; curPage < totalPage + 1; ++curPage) {
            if (curPage * pageSize > rowTotalSize) {
                length = rowTotalSize - (curPage - 1) * pageSize;
            }
            pagingSQL = pageHelper.getPagingSqlNoOptmize(ctx, sql, (curPage - 1) * pageSize, length);
            IRowSet rsn = SqlUtil.executeQuery(ctx, pagingSQL, pageHelper.getParamData());
            result.add(rsn);
        }
        return result;
    }
}

