/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.data;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.compensation.app.formula.data.Consts;
import com.kingdee.shr.compensation.app.formula.data.Context;
import com.kingdee.shr.compensation.app.formula.data.DBTypes;
import com.kingdee.shr.compensation.app.formula.data.DataAccess;
import com.kingdee.shr.compensation.app.formula.data.Decrypt;
import com.kingdee.shr.compensation.exception.ConParametersException;
import com.kingdee.util.StringUtils;
import java.io.File;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class ConParameters {
    private static boolean loaded = false;
    private static String driver;
    private static String name;
    private static String ip;
    private static String database;
    private static String userid;
    private static String pwd;
    private static String url;
    private static String comp;
    private static String expport;
    int queryTimeout = 30;

    public ConParameters() throws EASBizException {
        if (!loaded) {
            this.init("daconfig.xml", "");
            loaded = true;
        }
    }

    public ConParameters(String filename, String type) throws EASBizException {
        if (!loaded) {
            this.init(filename, type);
            loaded = true;
        }
    }

    public void init(String filename, String type) throws EASBizException {
        Document doc;
        SAXBuilder builder;
        try {
            builder = new SAXBuilder();
            builder.setIgnoringElementContentWhitespace(true);
        }
        catch (Exception e) {
            throw new ConParametersException(ConParametersException.LACKDOM);
        }
        if (filename.equals("")) {
            filename = "daconfig.xml";
        }
        try {
            String path = "";
            if (Context.getRealPath() != null) {
                path = Context.getRealPath() + "WEB-INF/";
            } else {
                String tmpstr1 = ConParameters.class.getResource("").toString();
                String tmppath = tmpstr1.substring(0, tmpstr1.lastIndexOf("com/hinge")).substring(6);
                if (tmppath.indexOf(":") != 1) {
                    tmppath = "/" + tmppath;
                }
                String basepath = tmppath;
                path = basepath.substring(0, basepath.length() - 8);
            }
            doc = builder.build(new File(path + filename));
        }
        catch (Exception e) {
            doc = null;
        }
        if (doc == null) {
            driver = "WEBLOGIC";
            name = "aiehr";
            ip = null;
            database = "ORACLE";
            userid = null;
            pwd = null;
            comp = "adbc";
        } else {
            Element root = doc.getRootElement();
            if (root == null) {
                throw new ConParametersException(ConParametersException.FILEFORMATERROR);
            }
            root = type.equalsIgnoreCase("test") ? root.getChild("Test") : root.getChild("Default");
            Element child = root.getChild("driver");
            driver = child == null ? "WEBLOGIC" : this.decode(child.getText());
            child = root.getChild("name");
            name = child == null ? "aiehr" : this.decode(child.getText());
            child = root.getChild("comp");
            comp = child == null ? "adbc" : this.decode(child.getText());
            child = root.getChild("ip");
            ip = child == null ? null : this.decode(child.getText());
            child = root.getChild("database");
            String string = database = child == null ? "ORACLE" : this.decode(child.getText());
            DataAccess.dbtype = database.equals("ORACLE") ? DBTypes.ORACLE : (database.equals("SQLSERVER") ? DBTypes.SQLSERVER : DBTypes.UNKNOWN);
            child = root.getChild("userid");
            userid = child == null ? null : this.decode(child.getText());
            child = root.getChild("pwd");
            pwd = child == null ? null : this.decode(child.getText());
            child = root.getChild("expport");
            expport = child == null ? null : this.decode(child.getText());
            url = StringUtils.isEmpty((String)ip) ? "jdbc:oracle:thin:@" + name : "jdbc:oracle:thin:@" + ip + ":" + name;
            child = root.getChild("QueryTimeout");
            if (child != null) {
                try {
                    this.queryTimeout = Integer.parseInt(this.decode(child.getText()), 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public String decode(String s) {
        if (!Consts.ProjectStatus.equals("dev")) {
            return Decrypt.decrypt(s);
        }
        return s;
    }

    public String getDatabase() {
        return database;
    }

    public String getDriver() {
        return driver;
    }

    public String getIp() {
        return ip;
    }

    public String getName() {
        return name;
    }

    public String getPwd() {
        return pwd;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public String getUrl() {
        return url;
    }

    public String getUserid() {
        return userid;
    }

    public String getComp() {
        return comp;
    }

    public String getExpport() {
        return expport;
    }
}

