/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.incomeTax;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.compensation.app.incomeTax.AbstractTaxUnitRegisterDetailControllerBean;
import com.kingdee.shr.compensation.app.incomeTax.ITaxUnitRegisterDetail;
import com.kingdee.shr.compensation.app.incomeTax.TaxUnitRegisterDetailCollection;
import com.kingdee.shr.compensation.app.incomeTax.TaxUnitRegisterDetailFactory;
import com.kingdee.shr.compensation.app.incomeTax.TaxUnitRegisterDetailInfo;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.vo.RegisterInfo;
import com.kingdee.shr.compensation.app.taxCal.vo.TaxUnitRegisterInfo;
import com.kingdee.shr.compensation.app.taxCal.vo.TaxUnitRegisterInfoVO;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;

public class TaxUnitRegisterDetailControllerBean
extends AbstractTaxUnitRegisterDetailControllerBean {
    private static final Logger LOG = Logger.getLogger(TaxUnitRegisterDetailControllerBean.class);

    @Override
    protected void _resolveRegisterInfo(Context ctx, String decryptResult, String taskId) throws BOSException {
        TaxUnitRegisterInfoVO registerInfoVO = (TaxUnitRegisterInfoVO)JSON.parseObject((String)decryptResult, TaxUnitRegisterInfoVO.class);
        TaxUnitRegisterInfo data = registerInfoVO.getData();
        if (null == data) {
            LOG.error((Object)"_resolveRegisterInfo error: data is null");
            return;
        }
        List<RegisterInfo> taxUnits = data.getQylb();
        if (null == taxUnits || taxUnits.isEmpty()) {
            LOG.error((Object)"_resolveRegisterInfo error: qylb is null");
            return;
        }
        try {
            TaxCalTaskInfo taxCalTaskInfo = TaxCalTaskFactory.getLocalInstance(ctx).getTaskById(taskId);
            String taxUnitId = taxCalTaskInfo.getTaxUnit().getId().toString();
            String taxNumber = taxCalTaskInfo.getTaxUnit().getTaxNumber();
            ITaxUnitRegisterDetail taxUnitRegisterDetail = TaxUnitRegisterDetailFactory.getLocalInstance(ctx);
            String oql = "select registerNo where taxNumber = '" + taxNumber + "'";
            TaxUnitRegisterDetailCollection existed = taxUnitRegisterDetail.getTaxUnitRegisterDetailCollection(oql);
            CoreBaseCollection collection = new CoreBaseCollection();
            for (RegisterInfo registerInfo : taxUnits) {
                String registerNo = registerInfo.getDjxh();
                if (this.isExisted(registerNo, existed)) continue;
                TaxUnitRegisterDetailInfo taxUnitRegisterInfo = new TaxUnitRegisterDetailInfo();
                taxUnitRegisterInfo.setId(BOSUuid.create((BOSObjectType)taxUnitRegisterInfo.getBOSType()));
                taxUnitRegisterInfo.setAddress(registerInfo.getLxdz());
                if (!StringUtils.isEmpty((String)registerInfo.getDjrq())) {
                    taxUnitRegisterInfo.setRegisterDate(CmpDateUtil.parseDate(registerInfo.getDjrq()));
                }
                taxUnitRegisterInfo.setRegisterName(registerInfo.getDjzcmc());
                taxUnitRegisterInfo.setRegisterNo(registerInfo.getDjxh());
                taxUnitRegisterInfo.setName(registerInfo.getZgswjmc());
                taxUnitRegisterInfo.setTaxAuthName(registerInfo.getZgswjmc());
                taxUnitRegisterInfo.setTaxNumber(registerInfo.getNsrsbh());
                TaxUnitInfo tu = new TaxUnitInfo();
                tu.setId(BOSUuid.read((String)taxUnitId));
                taxUnitRegisterInfo.setTaxUnit(tu);
                taxUnitRegisterInfo.setTelephone(registerInfo.getLxdh());
                collection.add((CoreBaseInfo)taxUnitRegisterInfo);
            }
            if (!collection.isEmpty()) {
                taxUnitRegisterDetail.saveBatchData(collection);
            }
        }
        catch (EASBizException e) {
            LOG.error((Object)"_resolveRegisterInfo error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        catch (ParseException e) {
            LOG.error((Object)"_resolveRegisterInfo error: ", (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private boolean isExisted(String registerNo, TaxUnitRegisterDetailCollection existed) {
        if (null == existed || existed.isEmpty()) {
            return false;
        }
        boolean isExisted = false;
        for (int i = 0; i < existed.size(); ++i) {
            if (!registerNo.equals(existed.get(i).getRegisterNo())) continue;
            isExisted = true;
            break;
        }
        return isExisted;
    }
}

