/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.submitPeriod;

import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.hr.compensation.util.CmpDateUtils;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodChangeSourceEnum;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodDetailInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitPeriodInfo;
import com.kingdee.shr.compensation.app.integrate.submitPeriod.ISubmitPeriodGenetor;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import java.sql.Timestamp;
import java.util.Date;

public abstract class AbstractSubmitPeriodGenetor
implements ISubmitPeriodGenetor {
    protected abstract int getPeriodInterval();

    protected abstract int getPeriodLength();

    @Override
    public SubmitPeriodDetailCollection generate(SubmitPeriodInfo submitPeriod, SubmitPeriodChangeSourceEnum changeSource) {
        Date basePeriodStartDate = this.ensureStartDate(submitPeriod);
        Date basePeriodEndDate = this.ensureEndDate(submitPeriod, basePeriodStartDate);
        return this.generate(basePeriodStartDate, basePeriodEndDate, submitPeriod, changeSource);
    }

    public Date ensureStartDate(SubmitPeriodInfo submitPeriod) {
        Date periodStartDate;
        SubmitPeriodDetailCollection details = submitPeriod.getEntry();
        Date date = periodStartDate = submitPeriod.isIsLastStartDate() ? CmpDateUtil.getMonthEndDate(submitPeriod.getPeriodStartDate()) : submitPeriod.getPeriodStartDate();
        if (details == null || details.size() == 0) {
            return periodStartDate;
        }
        Date startDate = periodStartDate;
        Date tailEndDate = this.getTailEndDateByAsc(details);
        if (periodStartDate.compareTo(tailEndDate) <= 0) {
            Double maxMonthDif = this.getMaxMonthDifBetweenPeriodStartDateAndTailEndDate(periodStartDate, tailEndDate);
            int relDifMonth = new Double(maxMonthDif).intValue();
            startDate = CmpDateUtil.getAddMonth(periodStartDate, relDifMonth);
        }
        if (startDate.compareTo(tailEndDate) <= 0) {
            startDate = CmpDateUtil.getAddMonth(startDate, this.getPeriodInterval());
        }
        return startDate;
    }

    private Double getMaxMonthDifBetweenPeriodStartDateAndTailEndDate(Date periodStartDate, Date tailEndDate) {
        int difMonth = CmpDateUtil.getDifMonth(periodStartDate, tailEndDate);
        int currentPeriodInterval = this.getPeriodInterval();
        Double periodLength = Math.ceil(new Double(difMonth) / (double)currentPeriodInterval);
        return periodLength * (double)this.getPeriodInterval();
    }

    public Date ensureEndDate(SubmitPeriodInfo submitPeriod, Date startDate) {
        Date periodStartDate = submitPeriod.isIsLastStartDate() ? CmpDateUtil.getMonthEndDate(submitPeriod.getPeriodStartDate()) : submitPeriod.getPeriodStartDate();
        Date periodEndDate = submitPeriod.isIsLastEndDate() ? CmpDateUtil.getMonthEndDate(submitPeriod.getPeriodEndDate()) : submitPeriod.getPeriodEndDate();
        int periodMonthInterval = CmpDateUtil.getDifMonth(periodStartDate, periodEndDate);
        Date calculateEndDate = CmpDateUtil.getAddMonth(startDate, periodMonthInterval);
        int endYear = CmpDateUtil.getYear(calculateEndDate);
        int endMonth = CmpDateUtil.getActualMonth(calculateEndDate);
        int endDay = CmpDateUtil.getDay(periodEndDate);
        int dayOfMonth = CmpDateUtils.getDayOfMonth((Date)calculateEndDate);
        endDay = endDay > dayOfMonth ? dayOfMonth : endDay;
        return CmpDateUtils.getDate((int)endYear, (int)endMonth, (int)endDay);
    }

    protected Date getTailEndDate(SubmitPeriodDetailCollection detailsByDesc) {
        SubmitPeriodDetailInfo tailDetail = detailsByDesc.get(0);
        return tailDetail.getEndDate();
    }

    protected Date getTailEndDateByAsc(SubmitPeriodDetailCollection detailsSortedByAsc) {
        SubmitPeriodDetailInfo tailDetail = detailsSortedByAsc.get(detailsSortedByAsc.size() - 1);
        return tailDetail.getEndDate();
    }

    @Override
    public SubmitPeriodDetailCollection generate(Date baseStartDate, Date baseEndDate, SubmitPeriodInfo submitPeriod, SubmitPeriodChangeSourceEnum changeSource) {
        return this.generate(submitPeriod, baseStartDate, baseEndDate, submitPeriod.isIsLastStartDate(), submitPeriod.isIsLastEndDate(), changeSource);
    }

    protected SubmitPeriodDetailCollection generate(SubmitPeriodInfo submitPeriod, Date baseStartDate, Date baseEndDate, boolean applyIsLastStartDate, boolean applyIsLastEndDate, SubmitPeriodChangeSourceEnum changeSource) {
        SubmitPeriodDetailCollection nextPeriodDetailCols = new SubmitPeriodDetailCollection();
        int actualPeriodDetailCount = this.getActualPeriodDetailCount(submitPeriod);
        SubmitPeriodDetailInfo previousDetailInfo = null;
        for (int i = 0; i < actualPeriodDetailCount; ++i) {
            SubmitPeriodDetailInfo detailInfo = new SubmitPeriodDetailInfo();
            detailInfo.setBill(submitPeriod);
            detailInfo.setPeriodType(submitPeriod.getType());
            detailInfo.setState(StateEnum.ENABLE);
            detailInfo.setIsApplyCalendar(false);
            detailInfo.setChangeSource(changeSource);
            detailInfo.setCreateTime(new Timestamp(new Date().getTime()));
            int intervalAfterBase = i * this.getPeriodInterval();
            Date startDate = CmpDateUtil.getAddMonth(baseStartDate, intervalAfterBase);
            startDate = applyIsLastStartDate ? CmpDateUtil.getMonthEndDate(startDate) : startDate;
            detailInfo.setStartDate(startDate);
            Date endDate = CmpDateUtil.getAddMonth(baseEndDate, intervalAfterBase);
            endDate = this.adjustAndGetEndDateBeforeGenerate(endDate, submitPeriod.getPeriodEndDate(), applyIsLastEndDate);
            detailInfo.setEndDate(endDate);
            if (previousDetailInfo == null) {
                previousDetailInfo = detailInfo;
            } else {
                if (previousDetailInfo.getEndDate().compareTo(detailInfo.getStartDate()) == 0) {
                    previousDetailInfo.setEndDate(CmpDateUtil.getAddDate(previousDetailInfo.getEndDate(), -1));
                }
                previousDetailInfo = detailInfo;
            }
            nextPeriodDetailCols.add(detailInfo);
        }
        return nextPeriodDetailCols;
    }

    protected Date adjustAndGetEndDateBeforeGenerate(Date endDate, Date periodEndDate, boolean applyIsLastEndDate) {
        Date newEndDate = endDate;
        if (applyIsLastEndDate) {
            newEndDate = CmpDateUtil.getMonthEndDate(newEndDate);
        } else {
            int dayOfMonth = CmpDateUtils.getDayOfMonth((Date)newEndDate);
            int dayOfPeriodEndDate = CmpDateUtil.getDay(periodEndDate);
            int dayOfEndDate = CmpDateUtil.getDay(newEndDate);
            if (dayOfPeriodEndDate > dayOfMonth) {
                dayOfPeriodEndDate = dayOfMonth;
            }
            if (dayOfEndDate < dayOfPeriodEndDate) {
                int endYear = CmpDateUtil.getYear(newEndDate);
                int endMonth = CmpDateUtil.getActualMonth(newEndDate);
                newEndDate = CmpDateUtils.getDate((int)endYear, (int)endMonth, (int)dayOfPeriodEndDate);
            }
        }
        return newEndDate;
    }

    protected int getActualPeriodDetailCount(SubmitPeriodInfo submitPeriod) {
        return this.getPeriodLength();
    }
}

