/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.tax.TaxUnitInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractTaxServiceTaskFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalTask;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskParamInfo;
import com.kingdee.shr.compensation.tax.task.TaskServiceFactory;
import com.kingdee.shr.compensation.util.AesUtils;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.HttpUtil;
import com.kingdee.shr.compensation.util.TaxDeclaReportUtil;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxServiceTaskFacadeControllerBean
extends AbstractTaxServiceTaskFacadeControllerBean {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeControllerBean");
    private static final String POST_URL = "/taxbot/v3/create";
    private static final String GET_URL = "/taxbot/v3/query";
    private static final List<TaxCalTaskCatalogEnum> GET_ACCEPT_ID_FROM_REQUEST_PARAM = Arrays.asList(TaxCalTaskCatalogEnum.TaxCal, TaxCalTaskCatalogEnum.TaxCalDelete, TaxCalTaskCatalogEnum.FbUpload, TaxCalTaskCatalogEnum.TaxReportFeedBack, TaxCalTaskCatalogEnum.TaxSpeAddtionalDedReport);
    protected static Map<TaxCalTaskCatalogEnum, Integer> PRIORITIES = new HashMap<TaxCalTaskCatalogEnum, Integer>();
    private static final Map<TaxCalTaskCatalogEnum, String> beforeSubmitMap;

    @Override
    protected IObjectPK _addTask(Context ctx, TaxCalTaskCatalogEnum taskCategory, Map paramMap) throws BOSException {
        IObjectPK uuidPK;
        String creatorID;
        ITaxCalTask iTask = TaxCalTaskFactory.getLocalInstance(ctx);
        TaxCalTaskInfo taskInfo = new TaxCalTaskInfo();
        TaxServiceTaskParamInfo paramInfo = new TaxServiceTaskParamInfo();
        paramInfo.setParamContent(JSON.toJSONString((Object)paramMap));
        taskInfo.setRequestParam(paramInfo);
        taskInfo.setCatalog(taskCategory);
        taskInfo.setState(TaxCalTaskStateEnum.WAITTING);
        String taxUnitID = (String)paramMap.get("TAXUNITID");
        TaxUnitInfo taxUnitInfo = new TaxUnitInfo();
        taxUnitInfo.setId(BOSUuid.read((String)taxUnitID));
        taskInfo.setTaxUnit(taxUnitInfo);
        String period = (String)paramMap.get("PERIOD");
        if (StringUtils.isEmpty((String)period)) {
            period = (String)paramMap.get("sdyf");
        }
        if (!StringUtils.isEmpty((String)period)) {
            period = !period.contains("-") ? period.substring(0, 4) + "-" + period.substring(4, 6) : period.substring(0, 7);
        }
        taskInfo.setPeriod(period);
        taskInfo.setDealLevel(PRIORITIES.get((Object)taskCategory));
        String relayTaskID = (String)paramMap.get("RELAYTASK");
        if (!StringUtils.isEmpty((String)relayTaskID)) {
            TaxCalTaskInfo relayTask = new TaxCalTaskInfo();
            relayTask.setId(BOSUuid.read((String)relayTaskID));
            taskInfo.setRelayTask(relayTask);
            taskInfo.setState(TaxCalTaskStateEnum.STANDBY);
        }
        if (!StringUtils.isEmpty((String)(creatorID = (String)paramMap.get("creator")))) {
            UserInfo creator = new UserInfo();
            creator.setId(BOSUuid.read((String)creatorID));
            taskInfo.setCreator(creator);
        }
        try {
            uuidPK = iTask.addnew(taskInfo);
            logger.info((Object)("*********TaxServiceTaskFacadeControllerBean._addTask>>uuidPK : " + uuidPK.toString() + "  >taskCategory: " + (Object)((Object)taskCategory) + "    >taxUnitID : " + taxUnitID + "   > period : " + period));
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return uuidPK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _submitTask(Context ctx) throws BOSException {
        String lockKey = "individual-tax-auto-executing";
        String lockRes = "task";
        boolean lock = CmpDistributedLockUtils.tryLock(ctx, lockKey, lockRes);
        if (!lock) {
            logger.error((Object)"\u4e2a\u7a0e\u7533\u62a5\u4efb\u52a1\u81ea\u52a8\u6267\u884c\u5931\u8d25\uff0c\u4e0a\u4e00\u4e2a\u4efb\u52a1\u672a\u6267\u884c\u5b8c\u6210...");
            return;
        }
        try {
            ITaxCalTask iTask = TaxCalTaskFactory.getLocalInstance(ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("accept_id");
            selector.add("state");
            selector.add("catalog");
            selector.add("requestParam.id");
            selector.add("requestParam.paramContent");
            selector.add("dealLevel");
            selector.add("taxUnit.id");
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setSelector(selector);
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            FilterItemInfo stateFilterItem1 = new FilterItemInfo("state", (Object)TaxCalTaskStateEnum.RUNNING, CompareType.EQUALS);
            filterItems.add(stateFilterItem1);
            FilterItemInfo stateFilterItem2 = new FilterItemInfo("state", (Object)TaxCalTaskStateEnum.WAITTING, CompareType.EQUALS);
            filterItems.add(stateFilterItem2);
            filterInfo.setMaskString("#0 or #1");
            viewInfo.setFilter(filterInfo);
            SorterItemCollection sorterItems = viewInfo.getSorter();
            SorterItemInfo stateSorterItem = new SorterItemInfo("state");
            stateSorterItem.setSortType(SortType.DESCEND);
            sorterItems.add(stateSorterItem);
            SorterItemInfo dealLevelSorterItem = new SorterItemInfo("dealLevel");
            dealLevelSorterItem.setSortType(SortType.ASCEND);
            sorterItems.add(dealLevelSorterItem);
            SorterItemInfo createTimeSorterItemInfo = new SorterItemInfo("createTime");
            createTimeSorterItemInfo.setSortType(SortType.ASCEND);
            sorterItems.add(createTimeSorterItemInfo);
            TaxCalTaskCollection taxCalTaskCollection = iTask.getTaxCalTaskCollection(viewInfo);
            if (taxCalTaskCollection.isEmpty()) {
                return;
            }
            this.submitTask(ctx, taxCalTaskCollection);
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, lockKey, lockRes);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void submitTask(Context ctx, TaxCalTaskCollection taxCalTaskCollection) throws BOSException {
        Map<String, List<TaxCalTaskInfo>> taxUnitTasks = this.groupTaskByTaxUnitId(taxCalTaskCollection);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Object[]> updateTaskParamList = new ArrayList<Object[]>();
        String companyId = this.getCompanyId(ctx);
        String baseUrl = TaxDeclaReportUtil.getServiceUrl(ctx, "BASE");
        try {
            for (Map.Entry<String, List<TaxCalTaskInfo>> entry : taxUnitTasks.entrySet()) {
                String result;
                TaxCalTaskInfo taskInfo = entry.getValue().get(0);
                if (taskInfo.getState() == TaxCalTaskStateEnum.RUNNING && StringUtils.isEmpty((String)taskInfo.getAccept_id())) continue;
                TaxCalTaskCatalogEnum catalog = taskInfo.getCatalog();
                boolean isSubmit = taskInfo.getState() == TaxCalTaskStateEnum.WAITTING;
                String taxBotURL = isSubmit ? POST_URL : GET_URL;
                String requestURL = baseUrl + taxBotURL;
                StringBuilder queryString = new StringBuilder();
                queryString.append("company_id=").append(companyId);
                queryString.append("&taskCatalog=").append(catalog.getValue());
                String taskID = taskInfo.getId().toString();
                queryString.append("&taskId=").append(taskID);
                String paramContent = taskInfo.getRequestParam().getParamContent();
                String beforeSubmit = beforeSubmitMap.get((Object)catalog);
                try {
                    if (!StringUtils.isEmpty((String)beforeSubmit)) {
                        Class<?> beforeSubmitClass = Class.forName(beforeSubmit);
                        Object newInstance = beforeSubmitClass.newInstance();
                        Method beforeSubmitExecute = newInstance.getClass().getDeclaredMethod("execute", Context.class, String.class);
                        paramContent = (String)beforeSubmitExecute.invoke(newInstance, ctx, taskID);
                        Object[] params = new Object[]{paramContent, taskInfo.getRequestParam().getId().toString()};
                        updateTaskParamList.add(params);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                logger.info((Object)("-----TaskID" + taskID + "---->submitTask-->paramContentNew: " + paramContent));
                JSONObject paramMap = JSON.parseObject((String)paramContent);
                String acceptId = GET_ACCEPT_ID_FROM_REQUEST_PARAM.contains((Object)catalog) && isSubmit ? (String)paramMap.get("accept_id") : taskInfo.getAccept_id();
                if (!StringUtils.isEmpty((String)acceptId)) {
                    queryString.append("&accept_id=").append(acceptId);
                }
                String secretKeyStr = this.getSecretKey(ctx);
                String decryptContent = AesUtils.encrypt(paramContent, secretKeyStr);
                if (isSubmit) {
                    result = HttpUtil.post(requestURL + "?" + queryString, decryptContent, "utf-8");
                    logger.info((Object)("--------->submitTask-->result: " + result));
                    if (StringUtils.isEmpty((String)result)) throw new BOSException("\u8c03\u7528\u4e2a\u7a0e\u4e91\u5931\u8d25");
                    JSONObject convertJsonToObject = JSON.parseObject((String)result);
                    logger.info((Object)("-----TaskID" + taskID + "--------->submitTask-->convertJsonToObject: " + convertJsonToObject));
                    if (convertJsonToObject.containsKey("code")) {
                        String code = (String)convertJsonToObject.get("code");
                        if ("0000".equals(code)) {
                            String msgId = (String)convertJsonToObject.get("body");
                            Timestamp calTime = new Timestamp(System.currentTimeMillis());
                            Object[] params = new Object[]{msgId, calTime, taskID};
                            paramList.add(params);
                        } else if ("9999".equals(code)) {
                            this.handleFailure(ctx, catalog, taskInfo, (String)convertJsonToObject.get("msg"));
                        }
                    }
                } else {
                    result = HttpUtil.get(requestURL, queryString.toString());
                    logger.info((Object)("--------->submitTask-->requestURL: " + requestURL + "--->queryString: " + queryString));
                    logger.info((Object)("--------->submitTask-->result: " + result));
                    if (StringUtils.isEmpty((String)result)) {
                        throw new BOSException("\u8c03\u7528\u4e2a\u7a0e\u4e91\u5931\u8d25");
                    }
                }
                this.pause();
            }
            if (!paramList.isEmpty()) {
                String updateMsgID = "update T_HR_STaxCalTask set FMessage_id = ?,FState = 20, FCalTime=? where fid = ?";
                CmpSQLUtil.executeBatchAndReturn(ctx, updateMsgID, paramList);
            }
            if (updateTaskParamList.isEmpty()) return;
            String updateTaskParamSQL = "update T_HR_STaxServiceTaskParam set FPARAMCONTENT = ? where fid = ?";
            CmpSQLUtil.executeBatchAndReturn(ctx, updateTaskParamSQL, updateTaskParamList);
            return;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, List<TaxCalTaskInfo>> groupTaskByTaxUnitId(TaxCalTaskCollection taxCalTaskCollection) {
        HashMap<String, List<TaxCalTaskInfo>> taxUnitTasks = new HashMap<String, List<TaxCalTaskInfo>>();
        for (int i = 0; i < taxCalTaskCollection.size(); ++i) {
            TaxCalTaskInfo task = taxCalTaskCollection.get(i);
            String taxUnitId = task.getTaxUnit().getId().toString();
            List tasks = taxUnitTasks.computeIfAbsent(taxUnitId, k -> new ArrayList());
            tasks.add(task);
        }
        return taxUnitTasks;
    }

    private String getSecretKey(Context ctx) throws BOSException {
        String secretKeyStr;
        try {
            secretKeyStr = TaxDeclaReportUtil.getSecretKeyStr(ctx);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException(e1.getMessage(), (Throwable)e1);
        }
        return secretKeyStr;
    }

    private String getCompanyId(Context ctx) throws BOSException {
        try {
            String companyId = TaxDeclaReportUtil.getServiceId(ctx);
            return companyId;
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new BOSException(e1.getMessage(), (Throwable)e1);
        }
    }

    protected void pause() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Map _manualExecue(Context ctx, String taskID) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("message_id");
        selector.add("accept_id");
        selector.add("state");
        selector.add("catalog");
        selector.add("requestParam.id");
        selector.add("taxUnit.id");
        selector.add("requestParam.paramContent");
        boolean resultState = false;
        String resultStr = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label27", (Locale)ctx.getLocale());
        try {
            TaxCalTaskInfo taxCalTaskInfo = TaxCalTaskFactory.getLocalInstance(ctx).getTaxCalTaskInfo((IObjectPK)new ObjectUuidPK(taskID), selector);
            String acceptId = taxCalTaskInfo.getAccept_id();
            TaxCalTaskStateEnum state = taxCalTaskInfo.getState();
            TaxCalTaskCollection taxCalTaskCollection = new TaxCalTaskCollection();
            taxCalTaskCollection.add(taxCalTaskInfo);
            if (TaxCalTaskStateEnum.STANDBY == state) {
                resultStr = "\u7b49\u5f85\u4e2d\u7684\u4efb\u52a1\u4e0d\u80fd\u8fdb\u884c\u624b\u52a8\u6267\u884c\uff0c\u9700\u8981\u7b49\u5f85\u524d\u7f6e\u4efb\u52a1\u5904\u7406\u5b8c\u6210\u624d\u80fd\u8fdb\u884c\u5904\u7406\u3002";
            } else if (TaxCalTaskStateEnum.WAITTING == state) {
                this.submitTask(ctx, taxCalTaskCollection);
                resultState = true;
            } else if (TaxCalTaskStateEnum.RUNNING == state) {
                if (!StringUtils.isEmpty((String)acceptId)) {
                    this.submitTask(ctx, taxCalTaskCollection);
                    resultState = true;
                } else {
                    resultStr = "\u7a0e\u5c40\u53d7\u7406ID\u8fd8\u672a\u8fd4\u56de\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed3\u679c\u83b7\u53d6\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5";
                }
            } else if (TaxCalTaskStateEnum.FINISHED == state || TaxCalTaskStateEnum.FAIDED == state) {
                resultStr = "\u64cd\u4f5c\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a\u53ea\u6709\u672a\u5904\u7406\u548c\u5904\u7406\u4e2d\u7684\u624d\u80fd\u8fdb\u884c\u624b\u52a8\u6267\u884c\uff01";
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            resultStr = EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label30", (Locale)ctx.getLocale()) + e.getMessage();
        }
        result.put("state", resultState);
        result.put("result", resultStr);
        return result;
    }

    private void handleFailure(Context ctx, TaxCalTaskCatalogEnum catalog, TaxCalTaskInfo taskInfo, String msg) {
        try {
            String taskId = taskInfo.getId().toString();
            String updateSQL = "update T_HR_STaxCalTask Set fState = 30 , FMsg = '" + msg + "' where fid = '" + taskId + "'";
            DbUtil.execute((Context)ctx, (String)updateSQL);
            TaskServiceFactory.getInstance(catalog).onFailure(ctx, taskInfo, msg);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static {
        PRIORITIES.put(TaxCalTaskCatalogEnum.PersonReport, 0);
        PRIORITIES.put(TaxCalTaskCatalogEnum.IncomeIssueObtain, 0);
        PRIORITIES.put(TaxCalTaskCatalogEnum.IncomeIssueHandle, 0);
        PRIORITIES.put(TaxCalTaskCatalogEnum.ConfirmedIncomeIssueInvite, 0);
        PRIORITIES.put(TaxCalTaskCatalogEnum.PersonCollect, 1);
        PRIORITIES.put(TaxCalTaskCatalogEnum.PersonCollectConfirm, 2);
        PRIORITIES.put(TaxCalTaskCatalogEnum.TaxSpeAddtionalDedReport, 3);
        PRIORITIES.put(TaxCalTaskCatalogEnum.TaxCalDelete, 4);
        PRIORITIES.put(TaxCalTaskCatalogEnum.TaxCal, 5);
        PRIORITIES.put(TaxCalTaskCatalogEnum.FbUpload, 5);
        PRIORITIES.put(TaxCalTaskCatalogEnum.TaxReport, 6);
        PRIORITIES.put(TaxCalTaskCatalogEnum.TaxDeclareUpdate, 6);
        PRIORITIES.put(TaxCalTaskCatalogEnum.CancelTaxUpdate, 6);
        PRIORITIES.put(TaxCalTaskCatalogEnum.CancelTaxDeclare, 6);
        PRIORITIES.put(TaxCalTaskCatalogEnum.TaxReportFeedBack, 7);
        PRIORITIES.put(TaxCalTaskCatalogEnum.GetTriAgreement, 8);
        PRIORITIES.put(TaxCalTaskCatalogEnum.TaxPayment, 9);
        PRIORITIES.put(TaxCalTaskCatalogEnum.DownloadWszm, 10);
        beforeSubmitMap = new HashMap<TaxCalTaskCatalogEnum, String>();
        beforeSubmitMap.put(TaxCalTaskCatalogEnum.TaxSpeAddtionalDedReport, "com.kingdee.shr.compensation.taxCal.analysis.CombineData4TaxSpeAddDedReport");
        beforeSubmitMap.put(TaxCalTaskCatalogEnum.TaxCal, "com.kingdee.shr.compensation.taxCal.analysis.CombineDataForTaxCal");
        beforeSubmitMap.put(TaxCalTaskCatalogEnum.TaxCalDelete, "com.kingdee.shr.compensation.taxCal.analysis.CombineDataForTaxCal");
        beforeSubmitMap.put(TaxCalTaskCatalogEnum.FbUpload, "com.kingdee.shr.compensation.taxCal.analysis.CombineDataForTaxCal");
        beforeSubmitMap.put(TaxCalTaskCatalogEnum.TaxPayment, "com.kingdee.shr.compensation.taxCal.analysis.CombineDataForTaxPayment");
    }
}

