/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.externaldata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.concurrent.ExecutionException;
import com.kingdee.bos.util.backport.concurrent.Future;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.integrate.BillEntryCalState;
import com.kingdee.shr.compensation.app.timepiece.externaldata.AbstractSyncExternalDataFacadeControllerBean;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataCalculateFacadeFactory;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataSource;
import com.kingdee.shr.compensation.app.timepiece.externaldata.IExternalDataCalculateFacade;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.ConfigEntry;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.ConfigInfo;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.StructureColumn;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.StructureInfo;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.timepiece.ExternalConfigUtil;
import com.kingdee.shr.validaterule.CmpItemDataType;
import com.kingdee.shr.validaterule.formula.CalculatorManager2;
import com.kingdee.shr.validaterule.formula.base.vo.ErrRow;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.util.EntityUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SyncExternalDataFacadeControllerBean
extends AbstractSyncExternalDataFacadeControllerBean {
    private static Logger logger = Logger.getLogger(SyncExternalDataFacadeControllerBean.class);
    private Map<String, ConfigInfo> schemeMap = Maps.newHashMap();
    private Map<String, Object> returnMap;
    private List<Map<String, String>> rerurnDataList;
    private Map<String, Map<String, Integer>> savedDataIds = Maps.newHashMap();

    @Override
    protected Map _syncData(Context ctx, Map param) throws BOSException, EASBizException {
        List dataList;
        this.initReturnData();
        if (!param.containsKey("data") || !(param.get("data") instanceof List)) {
            String label27 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label27", (Locale)ctx.getLocale());
            this.changeReturnValue("0050", label27);
        }
        if ((dataList = (List)param.get("data")).size() < 1) {
            String label28 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label28", (Locale)ctx.getLocale());
            this.changeReturnValue("0050", label28);
        }
        this.initDataListIndex(dataList);
        this.validRequiredAttr(dataList, ctx);
        if (this.returnMap.get("code").equals("0050") || dataList.size() < 1) {
            return this.returnMap;
        }
        this.initExternalDataConfig(ctx, dataList);
        this.validData(ctx, dataList);
        if (this.returnMap.get("code").equals("0050") || dataList.size() < 1) {
            return this.returnMap;
        }
        this.saveData(ctx, dataList);
        this.calculate(ctx);
        return this.returnMap;
    }

    private void initDataListIndex(List<Map<String, Object>> dataList) {
        int index = 1;
        for (Map<String, Object> data : dataList) {
            data.put("index", index++);
        }
    }

    private String getDataIndex(Map<String, Object> dataMap) {
        return dataMap.get("index").toString();
    }

    private void initReturnData() {
        this.returnMap = Maps.newHashMap();
        this.rerurnDataList = Lists.newArrayList();
        this.returnMap.put("code", "0000");
        this.returnMap.put("msg", null);
        this.returnMap.put("data", this.rerurnDataList);
    }

    private void changeReturnValue(String code, String msg) {
        if (!StringUtils.isEmpty((String)code)) {
            this.returnMap.put("code", code);
        }
        if (!StringUtils.isEmpty((String)msg)) {
            this.returnMap.put("msg", msg);
        }
    }

    protected void validRequiredAttr(List<Map<String, Object>> dataList, Context ctx) {
        boolean isValid = true;
        HashMap<String, String> map = new HashMap<String, String>();
        String label29 = ExternalConfigUtil.getResoureString(ctx, "EffectDate");
        String label30 = ExternalConfigUtil.getResoureString(ctx, "extDataConfigNumber");
        map.put("effectDate", label29);
        map.put("scheme", label30);
        Iterator<Map<String, Object>> iterator = dataList.iterator();
        block0: while (iterator.hasNext()) {
            String format;
            Map<String, Object> tempMap = iterator.next();
            String index = this.getDataIndex(tempMap);
            for (Map.Entry entry : map.entrySet()) {
                isValid = true;
                if (!CmpStrUtil.isNullOrEmpty(tempMap.get(entry.getKey()))) continue;
                String label37 = ExternalConfigUtil.getResoureString(ctx, "label37");
                String format2 = MessageFormat.format(label37, index, entry.getKey(), entry.getValue());
                this.assembleUnvalidData(format2, ctx);
                isValid = false;
                break;
            }
            if (!isValid) {
                iterator.remove();
                continue;
            }
            if (!tempMap.get("effectDate").toString().matches("\\d{4}-\\d{1,2}-\\d{1,2}")) {
                String label38 = ExternalConfigUtil.getResoureString(ctx, "label38");
                format = MessageFormat.format(label38, index);
                this.assembleUnvalidData(format, ctx);
                iterator.remove();
                continue;
            }
            if (null == tempMap.get("item") || !(tempMap.get("item") instanceof List)) {
                String label39 = ExternalConfigUtil.getResoureString(ctx, "label39");
                format = MessageFormat.format(label39, index);
                this.assembleUnvalidData(format, ctx);
                iterator.remove();
                continue;
            }
            if (tempMap.containsKey("description") && !(tempMap.get("description") instanceof Map)) {
                String label40 = ExternalConfigUtil.getResoureString(ctx, "label40");
                format = MessageFormat.format(label40, index);
                this.assembleUnvalidData(format, ctx);
                iterator.remove();
                continue;
            }
            List itemList = (List)tempMap.get("item");
            for (Map stringObjectMap : itemList) {
                if (!CmpStrUtil.isNullOrEmpty(stringObjectMap.get("name"))) continue;
                String label41 = ExternalConfigUtil.getResoureString(ctx, "label41");
                String format3 = MessageFormat.format(label41, index);
                this.assembleUnvalidData(format3, ctx);
                iterator.remove();
                continue block0;
            }
        }
    }

    protected void assembleUnvalidData(String msg, Context ctx) {
        String label44 = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpXQLangResource", (String)"label44", (Locale)ctx.getLocale());
        this.changeReturnValue("0010", label44);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("msg", msg);
        this.rerurnDataList.add(map);
    }

    protected void initExternalDataConfig(Context ctx, List<Map<String, Object>> dataList) {
        HashSet schemeSets = Sets.newHashSet();
        for (Map<String, Object> data : dataList) {
            String schemeNum = data.get("scheme").toString();
            schemeSets.add(schemeNum);
        }
        try {
            this.schemeMap = ExternalConfigUtil.initExtDataConfig(ctx, schemeSets);
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"Query ExternalDataConfig Failed, ", e);
        }
    }

    protected void validData(Context ctx, List<Map<String, Object>> dataList) {
        Iterator<Map<String, Object>> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            String format;
            Object stringObjectMap2;
            boolean isValid = true;
            Map<String, Object> dataMap = iterator.next();
            String schemeNumber = dataMap.get("scheme").toString();
            String index = this.getDataIndex(dataMap);
            if (!this.schemeMap.containsKey(schemeNumber)) {
                String label42 = ExternalConfigUtil.getResoureString(ctx, "label42");
                String format2 = MessageFormat.format(label42, index, schemeNumber);
                this.assembleUnvalidData(format2, ctx);
                iterator.remove();
                continue;
            }
            ConfigInfo configInfo = this.schemeMap.get(schemeNumber);
            if (configInfo.getEntityEnableStatus() == 0) {
                String configInfoEntity = configInfo.getEntity();
                try {
                    EntityUtil.getBizInterface((Context)ctx, (String)configInfoEntity);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    isValid = false;
                    configInfo.setEntityEnableStatus(2);
                }
            }
            if (!isValid || configInfo.getEntityEnableStatus() == 2) {
                String label43 = ExternalConfigUtil.getResoureString(ctx, "label43");
                String format3 = MessageFormat.format(label43, index, schemeNumber);
                this.assembleUnvalidData(format3, ctx);
                iterator.remove();
                continue;
            }
            List itemList = (List)dataMap.get("item");
            HashMap itemNameIndexMapper = Maps.newHashMap();
            for (Object stringObjectMap2 : itemList) {
                String format4;
                String fieldName = stringObjectMap2.get("name").toString();
                if (!configInfo.has(fieldName)) {
                    String label44 = ExternalConfigUtil.getResoureString(ctx, "label44");
                    format = MessageFormat.format(label44, index, fieldName, schemeNumber);
                    this.assembleUnvalidData(format, ctx);
                    iterator.remove();
                    isValid = false;
                    break;
                }
                itemNameIndexMapper.put(fieldName, itemNameIndexMapper.size());
                ConfigEntry entry = configInfo.getEntry(fieldName);
                CmpItemDataType dataType = entry.getDataType();
                Object valueObj = stringObjectMap2.get("value");
                if (CmpStrUtil.isNullOrEmpty(valueObj)) continue;
                String valueStr = valueObj.toString();
                if (CmpItemDataType.NUMBER == dataType) {
                    String format5;
                    String label;
                    if (!SyncExternalDataFacadeControllerBean.isNumber(valueStr)) {
                        String label45 = ExternalConfigUtil.getResoureString(ctx, "label45");
                        format4 = MessageFormat.format(label45, index, fieldName, valueStr);
                        this.assembleUnvalidData(format4, ctx);
                        iterator.remove();
                        isValid = false;
                        break;
                    }
                    BigDecimal valueBig = new BigDecimal(valueStr);
                    if (valueBig.scale() > 10) {
                        label = ExternalConfigUtil.getResoureString(ctx, "label62");
                        format5 = MessageFormat.format(label, index, fieldName, valueStr);
                        this.assembleUnvalidData(format5, ctx);
                        iterator.remove();
                        isValid = false;
                        break;
                    }
                    if ((valueBig = valueBig.setScale(10)).precision() <= 28) continue;
                    label = ExternalConfigUtil.getResoureString(ctx, "label63");
                    format5 = MessageFormat.format(label, index, fieldName, valueStr);
                    this.assembleUnvalidData(format5, ctx);
                    iterator.remove();
                    isValid = false;
                    break;
                }
                if (valueStr.length() <= 50) continue;
                String label = ExternalConfigUtil.getResoureString(ctx, "label64");
                format4 = MessageFormat.format(label, index, fieldName, valueStr);
                this.assembleUnvalidData(format4, ctx);
                iterator.remove();
                isValid = false;
                break;
            }
            if (!isValid) continue;
            List<String> requiredFields = configInfo.getRequiredFields();
            stringObjectMap2 = requiredFields.iterator();
            while (stringObjectMap2.hasNext()) {
                String requiredField = (String)stringObjectMap2.next();
                if (!itemNameIndexMapper.containsKey(requiredField)) {
                    String label = ExternalConfigUtil.getResoureString(ctx, "label46");
                    format = MessageFormat.format(label, index, requiredField);
                    this.assembleUnvalidData(format, ctx);
                    iterator.remove();
                    isValid = false;
                    break;
                }
                Map stringObjectMap3 = (Map)itemList.get((Integer)itemNameIndexMapper.get(requiredField));
                if (!CmpStrUtil.isNullOrEmpty(stringObjectMap3.get("value"))) continue;
                String label = ExternalConfigUtil.getResoureString(ctx, "label65");
                String format6 = MessageFormat.format(label, index, requiredField);
                this.assembleUnvalidData(format6, ctx);
                iterator.remove();
                isValid = false;
                break;
            }
            if (!isValid) continue;
            Map<String, StructureInfo> structureMap = configInfo.getStructureMap();
            Map<String, CoreBaseInfo> baseDataIdMapper = configInfo.getBaseDataIdMapper();
            Set<Map.Entry<String, StructureInfo>> entries = structureMap.entrySet();
            for (Map.Entry<String, StructureInfo> next : entries) {
                StructureInfo structureInfo = next.getValue();
                String entity = structureInfo.getEntity();
                List<StructureColumn> columns = structureInfo.getColumns();
                StringBuilder baseDataCacheKey = new StringBuilder(structureInfo.getEntity());
                EntityViewInfo queryBaseDataView = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                queryBaseDataView.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                StringBuilder msgBuilder = new StringBuilder("[");
                boolean isAppendCondition = false;
                for (StructureColumn column : columns) {
                    String name = column.getName();
                    String number = column.getNumber();
                    if (!itemNameIndexMapper.containsKey(name)) continue;
                    Map stringObjectMap4 = (Map)itemList.get((Integer)itemNameIndexMapper.get(name));
                    Object fieldValueObj = stringObjectMap4.get("value");
                    baseDataCacheKey.append("_").append(fieldValueObj);
                    if (CmpStrUtil.isNullOrEmpty(fieldValueObj)) continue;
                    if (isAppendCondition) {
                        msgBuilder.append(", ");
                    }
                    if (column.isEnum()) {
                        String enumSource = column.getEnumSource();
                        fieldValueObj = EntityUtil.getEnumByAlias((String)enumSource, fieldValueObj);
                    }
                    filter.appendFilterItem(number, fieldValueObj);
                    msgBuilder.append(name).append(":").append(fieldValueObj);
                    isAppendCondition = true;
                }
                if (baseDataIdMapper.containsKey(baseDataCacheKey)) continue;
                msgBuilder.append("]");
                queryBaseDataView.setFilter(filter);
                try {
                    if (!isAppendCondition) continue;
                    ICoreBase bizInterface = EntityUtil.getBizInterface((Context)ctx, (String)entity);
                    CoreBaseCollection collection = bizInterface.getCollection(queryBaseDataView);
                    CoreBaseInfo baseData = null;
                    if (collection.isEmpty()) {
                        String label = ExternalConfigUtil.getResoureString(ctx, "label47");
                        String format7 = MessageFormat.format(label, index, msgBuilder.toString());
                        this.assembleUnvalidData(format7, ctx);
                        iterator.remove();
                    } else {
                        baseData = collection.get(0);
                    }
                    baseDataIdMapper.put(baseDataCacheKey.toString(), baseData);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    String label = ExternalConfigUtil.getResoureString(ctx, "label48");
                    String format8 = MessageFormat.format(label, index, structureInfo.getNumber());
                    this.assembleUnvalidData(format8, ctx);
                    iterator.remove();
                }
            }
        }
    }

    private static boolean isNumber(String v) {
        return Pattern.matches("^[\\d]+[\\.([\\d]*)]*$", v);
    }

    protected void saveData(Context ctx, List<Map<String, Object>> dataList) throws EASBizException, BOSException {
        Iterator<Map<String, Object>> iterator = dataList.iterator();
        HashMap datas = Maps.newHashMap();
        while (iterator.hasNext()) {
            Map<String, Object> dataMap = iterator.next();
            String schemeNumber2 = dataMap.get("scheme").toString();
            ConfigInfo configInfo = this.schemeMap.get(schemeNumber2);
            CoreBaseCollection dataCollection = datas.containsKey(schemeNumber2) ? (CoreBaseCollection)datas.get(schemeNumber2) : new CoreBaseCollection();
            CoreBaseInfo dataBaseInfo = this.assembleSaveCoreBase(ctx, dataMap, configInfo);
            dataCollection.add(dataBaseInfo);
            datas.put(schemeNumber2, dataCollection);
        }
        datas.forEach((schemeNumber, collection) -> {
            try {
                ConfigInfo configInfo = this.schemeMap.get(schemeNumber);
                String entity = configInfo.getEntity();
                ICoreBase bizInterface = EntityUtil.getBizInterface((Context)ctx, (String)entity);
                IObjectPK[] pks = bizInterface.saveBatchData(collection);
                HashMap ids = Maps.newHashMap();
                for (int i = 0; i < pks.length; ++i) {
                    ids.put(pks[i].toString(), Integer.parseInt(collection.get(i).get("index").toString()));
                }
                this.savedDataIds.put(configInfo.getConfigId(), ids);
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
            catch (EASBizException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected CoreBaseInfo assembleSaveCoreBase(Context ctx, Map<String, Object> dataMap, ConfigInfo configInfo) throws BOSException {
        String effectDate = dataMap.get("effectDate").toString();
        String entity = configInfo.getEntity();
        CoreBaseInfo dataBaseInfo = EntityUtil.createBlankCoreObject((Context)ctx, (String)entity);
        dataBaseInfo.put("effectDate", (Object)this.parseDate(effectDate));
        dataBaseInfo.put("dataSource", (Object)ExternalDataSource.Interface);
        dataBaseInfo.put("calState", (Object)BillEntryCalState.nocal);
        dataBaseInfo.put("index", (Object)this.getDataIndex(dataMap));
        Map description = (Map)dataMap.get("description");
        dataBaseInfo.put("description", description.get("L1"), LocaleUtils.locale_L1);
        dataBaseInfo.put("description", description.get("L2"), LocaleUtils.locale_L2);
        dataBaseInfo.put("description", description.get("L3"), LocaleUtils.locale_L3);
        Map<String, CoreBaseInfo> baseDataIdMapper = configInfo.getBaseDataIdMapper();
        Map<String, StructureInfo> structureMap = configInfo.getStructureMap();
        List itemList = (List)dataMap.get("item");
        ArrayList fieldIndex = Lists.newArrayList();
        for (Map fieldData : itemList) {
            String fieldName = fieldData.get("name").toString();
            Object value = fieldData.get("value");
            ConfigEntry entry = configInfo.getEntry(fieldName);
            String structureNumber2 = entry.getStructureNumber();
            if (StringUtils.isEmpty((String)structureNumber2)) {
                String dbName = entry.getDbName();
                if (configInfo.isFormulaEntry(fieldName)) {
                    value = null;
                }
                dataBaseInfo.put(this.getRealDbName(dbName), value);
            }
            fieldIndex.add(fieldName);
        }
        structureMap.forEach((structureNumber, structureInfo) -> {
            List<StructureColumn> columns = structureInfo.getColumns();
            StringBuilder baseDataCacheKey = new StringBuilder(structureInfo.getEntity());
            for (StructureColumn column : columns) {
                String name = column.getName();
                if (fieldIndex.indexOf(name) < 0) continue;
                Map stringObjectMap = (Map)itemList.get(fieldIndex.indexOf(name));
                Object fieldValueObj = stringObjectMap.get("value");
                baseDataCacheKey.append("_").append(fieldValueObj);
            }
            CoreBaseInfo baseData = (CoreBaseInfo)baseDataIdMapper.get(baseDataCacheKey.toString());
            String dbName = configInfo.getEntry(columns.get(0).getName()).getDbName();
            dataBaseInfo.put(this.getRealDbName(dbName), (Object)baseData);
        });
        this.setId(ctx, configInfo, dataBaseInfo);
        return dataBaseInfo;
    }

    private String getRealDbName(String dbName) {
        return dbName.startsWith("S") ? dbName : dbName.substring(2, dbName.length() - 2);
    }

    private void setId(Context ctx, ConfigInfo configInfo, CoreBaseInfo dataBaseInfo) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id,effectDate");
        entityViewInfo.setSelector(selectors);
        List<String> requiredFields = configInfo.getRequiredFields();
        FilterInfo filter = entityViewInfo.getFilter();
        if (null == filter) {
            filter = new FilterInfo();
        }
        filter.appendFilterItem("effectDate", dataBaseInfo.get("effectDate"));
        for (String field : requiredFields) {
            ConfigEntry entry = configInfo.getEntry(field);
            String dbName = entry.getDbName();
            if (dbName.startsWith("S")) {
                filter.appendFilterItem(dbName, dataBaseInfo.get(dbName));
                continue;
            }
            dbName = this.getRealDbName(dbName);
            CoreBaseInfo o = (CoreBaseInfo)dataBaseInfo.get(dbName);
            filter.appendFilterItem(dbName + ".id", (Object)o.getId().toString());
        }
        entityViewInfo.setFilter(filter);
        ICoreBase bizInterface = EntityUtil.getBizInterface((Context)ctx, (String)configInfo.getEntity());
        CoreBaseCollection collection = bizInterface.getCollection(entityViewInfo);
        if (!collection.isEmpty()) {
            dataBaseInfo.setId(collection.get(0).getId());
        }
    }

    protected void calculate(Context ctx) throws BOSException {
        IExternalDataCalculateFacade calculateFacade = ExternalDataCalculateFacadeFactory.getLocalInstance(ctx);
        CmpInSql inSqlInstance = CmpInSqlFactory.getInstance();
        String msg = ExternalConfigUtil.getResoureString(ctx, "calculateFailed");
        this.savedDataIds.forEach((configId, ids) -> {
            HashMap param = Maps.newHashMap();
            param.put("configId", configId);
            String inSql = null;
            try {
                HashSet idSet = Sets.newHashSet();
                idSet.addAll(ids.keySet());
                inSql = inSqlInstance.createInSqlBaseOnFId(ctx, idSet);
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
            String condition = "\"EXTDATA\".fid in " + inSql;
            param.put("condition", condition);
            try {
                Sheet resultSheet;
                Map calResult = calculateFacade.calculate(param);
                String uid = calResult.get("uid").toString();
                Future taskFuture = CalculatorManager2.findTaskFuture((String)uid);
                Sheet sheet = resultSheet = null == taskFuture ? null : (Sheet)taskFuture.get();
                if (null == resultSheet) {
                    return;
                }
                List errDataList = resultSheet.getErrDataList();
                for (ErrRow errRow : errDataList) {
                    String fid = errRow.getFID();
                    int index = (Integer)ids.get(fid);
                    this.assembleUnvalidData(MessageFormat.format(msg, index, errRow.getErrMsg()), ctx);
                }
            }
            catch (BOSException e) {
                throw new RuntimeException(e);
            }
            catch (EASBizException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Date parseDate(String effectDate) {
        try {
            Date date = CmpDateUtil.parseDate(effectDate);
            return date;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

