/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cache.core;

import com.kingdee.shr.compensation.cache.core.ICmpCacheSevice;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;

public class CustomCacheService
implements ICmpCacheSevice {
    private static volatile CustomCacheService instance;
    private static final int MaxCacheSize = 100;
    private Map<String, Object> cacheMap = new ConcurrentHashMap<String, Object>(100);
    private Queue<String> keyQueue = new LinkedList<String>();

    private CustomCacheService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CustomCacheService getInstance() {
        if (instance != null) return instance;
        Class<CustomCacheService> clazz = CustomCacheService.class;
        synchronized (CustomCacheService.class) {
            if (instance != null) return instance;
            instance = new CustomCacheService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void put(String key, Object value) {
        if (this.hasKey(key)) {
            this.cacheMap.remove(key);
            this.keyQueue.remove(key);
        }
        if (value == null) {
            this.cacheMap.remove(key);
            this.keyQueue.remove(key);
            return;
        }
        if (this.cacheMap.size() >= 100) {
            String pollKey = this.keyQueue.poll();
            this.cacheMap.remove(pollKey);
        }
        this.cacheMap.put(key, value);
        this.keyQueue.offer(key);
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            return null;
        }
        return this.cacheMap.get(key);
    }

    @Override
    public void clearCache() {
        this.cacheMap.clear();
        this.keyQueue.clear();
    }

    public boolean hasKey(String key) {
        return this.cacheMap.containsKey(key);
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public void delete(String key) {
    }

    @Override
    public void deleteAll() {
    }

    @Override
    public boolean contains(String key) {
        return this.cacheMap.containsKey(key);
    }
}

