/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.cache.impl;

import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.cache.annoation.CacheLevel;
import com.kingdee.shr.compensation.cache.impl.CmpCacheServiceHelper;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

@CacheLevel
public final class CmpItemCacheServiceHelper
extends CmpCacheServiceHelper {
    private static Logger logger = Logger.getLogger(CmpItemCacheServiceHelper.class);

    private CmpItemCacheServiceHelper() {
        this.setCacheImplClassName(this.getClass());
        this.setCacheObjectItemMap(new ConcurrentHashMap<String, Map<String, Object>>());
    }

    public static void putInfo(Context ctx, CmpItemInfo cmpItemInfo) {
        if (null != cmpItemInfo && null != cmpItemInfo.getId()) {
            String key = cmpItemInfo.getId().toString();
            CmpItemCacheServiceHelper.getCacheInstance().put(ctx, key, cmpItemInfo);
        }
    }

    public static CmpItemInfo getInfo(Context ctx, String key) {
        Object cacheObj = CmpItemCacheServiceHelper.getCacheInstance().get(ctx, key);
        if (cacheObj instanceof CmpItemInfo) {
            return (CmpItemInfo)cacheObj;
        }
        logger.error((Object)MessageFormat.format("CmpItemCacheServiceHelper getInfo result  is null cacheKey is :{0}", key));
        return null;
    }

    public static void deleteInfo(Context ctx, String key) {
        CmpItemCacheServiceHelper.getCacheInstance().delete(ctx, key);
    }

    public static CmpCacheServiceHelper getCacheInstance() {
        return new CmpItemCacheServiceHelper();
    }

    public static void deleteCollection(Context ctx, CmpItemCollection coll) {
        String key = null;
        CmpItemInfo cmpItemInfo = null;
        if (null != coll && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                cmpItemInfo = coll.get(i);
                if (null == cmpItemInfo || null == cmpItemInfo.getId()) continue;
                key = cmpItemInfo.getId().toString();
                CmpItemCacheServiceHelper.deleteInfo(ctx, key);
            }
        }
    }
}

